<?php

/* -----------------------------------------------------------------
 * 	ID:						cseov3_product_shipping.php
 * 	Letzter Stand:			v3.3
 * 	zuletzt geaendert von:	akausch
 * 	Datum:					2014/04/08
 *
 * 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * --------------------------------------------------------------- */

class cseov3_product_shipping
{

    var $title, $output;

    function __construct()
    {

		define('MODULE_CSEO_PRODUCT_SHIPPING_TITLE', 'cseov3_product_shipping');
		define('MODULE_CSEO_PRODUCT_SHIPPING_DESC', 'Produkt Shipping-Migration für commerce:seo v3');
		define('MODULE_CSEO_PRODUCT_SHIPPING_STATUS_TITLE', 'Status');
		define('MODULE_CSEO_PRODUCT_SHIPPING_STATUS_DESC', 'Status an/aus');
		define('MODULE_CSEO_PRODUCT_SHIPPING_SORT_ORDER_TITLE', 'Sortierung');
		define('MODULE_CSEO_PRODUCT_SHIPPING_SORT_ORDER_DESC', 'Reihenfolge');

		$this->code = 'cseov3_product_shipping';
        $this->version = '3';

		$this->title = MODULE_CSEO_PRODUCT_SHIPPING_TITLE;
		$this->description = MODULE_CSEO_PRODUCT_SHIPPING_DESC;
		$this->sort_order = defined('MODULE_CSEO_PRODUCT_SHIPPING_SORT_ORDER') ? MODULE_CSEO_PRODUCT_SHIPPING_SORT_ORDER : '0';
		$this->enabled = defined('MODULE_CSEO_PRODUCT_SHIPPING_STATUS') ? ((MODULE_CSEO_PRODUCT_SHIPPING_STATUS == 'true') ? true : false) : false;
        $this->output = [];
    }

    function process()
    {
        global $order, $xtPrice;
    }

    function check()
    {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_PRODUCT_SHIPPING_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function keys()
    {
        return array('MODULE_CSEO_PRODUCT_SHIPPING_STATUS', 'MODULE_CSEO_PRODUCT_SHIPPING_SORT_ORDER');
    }

    function install()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_PRODUCT_SHIPPING'");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_CSEO_PRODUCT_SHIPPING_STATUS', 'true', '6', '1','', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_PRODUCT_SHIPPING_SORT_ORDER', '1','6', '2', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_PRODUCT_SHIPPING', 'true','6', '3', now())");

        xtc_db_query("UPDATE products SET nc_ultra_shipping_costs = products_shipping_costs;");


    }

    function remove()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_PRODUCT_SHIPPING'");
        xtc_db_query("TRUNCATE TABLE `gm_prd_img_alt`");
    }

}
