<?php

/* -----------------------------------------------------------------
 * 	ID:						cseov3_tag_migration.php
 * 	Letzter Stand:			v2.5
 * 	zuletzt geaendert von:	akausch
 * 	Datum:					2014/04/08
 *
 * 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * --------------------------------------------------------------- */

class cseov3_tag_migration
{

    var $title, $output;

    function __construct()
    {

		define('MODULE_CSEO_TAG_MIG_V1_TITLE', 'cseov3_tag_migration');
		define('MODULE_CSEO_TAG_MIG_V1_DESC', 'Tag-Migration für commerce:seo v3');
		define('MODULE_CSEO_TAG_MIG_V1_STATUS_TITLE', 'Status');
		define('MODULE_CSEO_TAG_MIG_V1_STATUS_DESC', 'Status an/aus');
		define('MODULE_CSEO_TAG_MIG_V1_SORT_ORDER_TITLE', 'Sortierung');
		define('MODULE_CSEO_TAG_MIG_V1_SORT_ORDER_DESC', 'Reihenfolge');

		$this->code = 'cseov3_tag_migration';
        $this->version = '3.7';

		$this->title = MODULE_CSEO_TAG_MIG_V1_TITLE;
		$this->description = MODULE_CSEO_TAG_MIG_V1_DESC;
		$this->sort_order = defined('MODULE_CSEO_TAG_MIG_V1_SORT_ORDER') ? MODULE_CSEO_TAG_MIG_V1_SORT_ORDER : '0';
		$this->enabled = defined('MODULE_CSEO_TAG_MIG_V1_STATUS') ? ((MODULE_CSEO_TAG_MIG_V1_STATUS == 'true') ? true : false) : false;
        $this->output = [];
    }

    function process()
    {
        global $order, $xtPrice;
    }

    function check()
    {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_TAG_MIG_V1_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function keys()
    {
        return array('MODULE_CSEO_TAG_MIG_V1_STATUS', 'MODULE_CSEO_TAG_MIG_V1_SORT_ORDER');
    }

    function install()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_TAG_MIG_V1'");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_CSEO_TAG_MIG_V1_STATUS', 'true', '6', '1','', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_TAG_MIG_V1_SORT_ORDER', '1','6', '2', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_TAG_MIG_V1', 'true','6', '3', now())");

        if (!table_exists('tag_to_tagproduct')) {
            xtc_db_query("
				CREATE TABLE tag_to_tagproduct (
				  id int(11) NOT NULL auto_increment,
				  tag_id int(11) NOT NULL,
				  products_id int(10) NOT NULL DEFAULT '0',
				  PRIMARY KEY (id),
				  KEY tag_id (tag_id),
				  KEY products_id (products_id)
				) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
				");
        }
        if (!table_exists('tag_description')) {
            xtc_db_query("
				CREATE TABLE `tag_description` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`tag_id` int(11) NOT NULL,
				`language_id` int(11) NOT NULL,
				`tag_name` varchar(64) NOT NULL,
				`tag_heading_title` varchar(255) NOT NULL,
				`tag_description` text NOT NULL,
				`tag_description_taeser` text NOT NULL,
				`tag_description_footer` text NOT NULL,
				`tag_meta_title` varchar(128) NOT NULL,
				`tag_meta_description` varchar(255) NOT NULL,
				`tag_meta_keywords` varchar(255) NOT NULL,
				`slider_set` int(11) NOT NULL DEFAULT '0',
				`teaser_set` int(11) NOT NULL DEFAULT '0',
				`gm_url_keywords` varchar(255) NOT NULL DEFAULT '',
				PRIMARY KEY (`id`),
				KEY `tag_id` (`tag_id`),
				KEY `idx_name` (`tag_name`),
				FULLTEXT KEY `tag_name` (`tag_name`),
				FULLTEXT KEY `tag_description` (`tag_description`),
				FULLTEXT KEY `tag_description_footer` (`tag_description_footer`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8;
");
        }
        $check_query = xtc_db_query("SELECT id FROM tag_to_product;");
        if (xtc_db_num_rows($check_query) > 0) {
            $check_des_query = xtc_db_query("SELECT id FROM tag_description;");
            if (xtc_db_num_rows($check_des_query) == 0) {
                xtc_db_query("INSERT INTO tag_description (tag_id, language_id, tag_name) SELECT id, lID, tag FROM tag_to_product;");
                // xtc_db_query("DELETE FROM tag_description
                // WHERE EXISTS (
                // SELECT id
                // FROM tag_to_product AS dup
                // WHERE tag_description.tag_name = dup.tag
                // AND tag_description.language_id = dup.lID
                // AND tag_description.tag_id < dup.id
                // );");

                if (table_exists('tag_tmp_desc')) {
                    xtc_db_query("DROP TABLE `tag_tmp_desc`;");
                }

                xtc_db_query("CREATE TABLE tag_tmp_desc AS SELECT * FROM tag_description GROUP BY tag_name, language_id;");

                xtc_db_query("TRUNCATE TABLE `tag_description`;");
                xtc_db_query("INSERT INTO tag_description (id, tag_id, language_id, tag_name) SELECT id, tag_id, language_id, tag_name FROM tag_tmp_desc;;");
                // xtc_db_query("RENAME TABLE tag_tmp_desc TO tag_description;");

                if (table_exists('tag_tmp')) {
                    xtc_db_query("DROP TABLE `tag_tmp`;");
                }

                xtc_db_query("
					CREATE TABLE tag_tmp (
					  id int(11) NOT NULL auto_increment,
					  tag_id int(11) NOT NULL,
					  products_id int(10) NOT NULL DEFAULT '0',
					  newtagid int(11) NOT NULL,
					  tag_name varchar(64) NOT NULL,
					  language_id int(11) NOT NULL,
					  PRIMARY KEY (id),
					  KEY tag_id (tag_id)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8;");

                xtc_db_query("INSERT INTO tag_tmp (tag_id, products_id, tag_name, language_id) SELECT id, pID, tag, lID FROM tag_to_product;");
                xtc_db_query("UPDATE tag_tmp SET newtagid = (SELECT tag_id FROM tag_description WHERE tag_description.tag_name = tag_tmp.tag_name);");

                xtc_db_query("INSERT INTO tag_to_tagproduct (tag_id, products_id, language_id) SELECT newtagid, products_id, language_id FROM tag_tmp;");

                if (table_exists('tag_tmp_desc')) {
                    xtc_db_query("DROP TABLE `tag_tmp_desc`;");
                }
                if (table_exists('tag_tmp')) {
                    xtc_db_query("DROP TABLE `tag_tmp`;");
                }

                // NOCH OFFEN
                // Vorher noch mal die IDs klatt ziehen!!!!!!!
                // xtc_db_query("DELETE FROM tag_to_product WHERE NOT EXISTS (SELECT * FROM tag_description WHERE tag_to_product.id = tag_id);");
                // xtc_db_query("DELETE FROM tag_to_tagproduct WHERE NOT EXISTS (SELECT * FROM tag_description WHERE tag_to_tagproduct.tag_id = tag_id);");
                // xtc_db_query("ALTER TABLE tag_to_product DROP pID, DROP lID, DROP tag;");
            }
        }
    }

    function remove()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_TAG_MIG_V1'");
        xtc_db_query("TRUNCATE TABLE `tag_to_tagproduct`");
        xtc_db_query("TRUNCATE TABLE `tag_description`");
        if (table_exists('tag_tmp')) {
            xtc_db_query("DROP TABLE `tag_tmp`;");
        }
    }

}
