<?php

/* -----------------------------------------------------------------
 * 	ID:						cseov3_old_url_migration.php
 * 	Letzter Stand:			v2.5
 * 	zuletzt geaendert von:	akausch
 * 	Datum:					2014/04/08
 *
 * 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * --------------------------------------------------------------- */

class cseov3_old_url_migration
{

    var $title, $output;

    function __construct()
    {

		define('MODULE_CSEO_OLDURL_MIG_TITLE', 'cseov3_old_url_migration');
		define('MODULE_CSEO_OLDURL_MIG_DESC', 'Orginal URL-Migration von v2next für commerce:seo v3.4');
		define('MODULE_CSEO_OLDURL_MIG_STATUS_TITLE', 'Status');
		define('MODULE_CSEO_OLDURL_MIG_STATUS_DESC', 'Status an/aus');
		define('MODULE_CSEO_OLDURL_MIG_SORT_ORDER_TITLE', 'Sortierung');
		define('MODULE_CSEO_OLDURL_MIG_SORT_ORDER_DESC', 'Reihenfolge');

		$this->code = 'cseov3_old_url_migration';
        $this->version = '3.5';

		$this->title = MODULE_CSEO_OLDURL_MIG_TITLE;
		$this->description = MODULE_CSEO_OLDURL_MIG_DESC;
		$this->sort_order = defined('MODULE_CSEO_OLDURL_MIG_SORT_ORDER') ? MODULE_CSEO_OLDURL_MIG_SORT_ORDER : '0';
		$this->enabled = defined('MODULE_CSEO_OLDURL_MIG_STATUS') ? ((MODULE_CSEO_OLDURL_MIG_STATUS == 'true') ? true : false) : false;
        $this->output = [];
    }

    function process()
    {
        global $order, $xtPrice;
    }

    function check()
    {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_OLDURL_MIG_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function keys()
    {
        return array('MODULE_CSEO_OLDURL_MIG_STATUS', 'MODULE_CSEO_OLDURL_MIG_SORT_ORDER');
    }

    function install()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_OLDURL_MIG'");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_CSEO_OLDURL_MIG_STATUS', 'true', '6', '1','', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_OLDURL_MIG_SORT_ORDER', '1','6', '2', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_OLDURL_MIG', 'true','6', '3', now())");

        $check_query = xtc_db_query("SELECT * FROM `commerce_seo_url` WHERE `categories_id` IS NOT NULL;");

        if (xtc_db_num_rows($check_query)) {
            while ($url_rewrite = xtc_db_fetch_array($check_query)) {
                $language_id = xtc_db_fetch_array(xtc_db_query("SELECT code FROM languages WHERE languages_id = " . $url_rewrite['language_id'] . ";"));
                $url_rewrite_url_text = substr($url_rewrite['url_text'], 0, -1);
                @xtc_db_query("INSERT INTO url_rewrites 
					(content_id, 
					content_type, 
					language_id, 
					rewrite_url, 
					target_url)
				VALUES
					(" . $url_rewrite['categories_id'] . ", 
					'category', 
					" . $url_rewrite['language_id'] . ", 
					'" . $url_rewrite_url_text . "', 
					'index.php?cat=" . $url_rewrite['categories_id'] . "&language=" . $language_id['code'] . "')
				;");

            }
        }
        $prod_query = xtc_db_query("SELECT products_id, language_id, url_text FROM `products_description`;");

        if (xtc_db_num_rows($prod_query)) {
            while ($url_rewrite = xtc_db_fetch_array($prod_query)) {
                $language_id = xtc_db_fetch_array(xtc_db_query("SELECT code FROM languages WHERE languages_id = " . $url_rewrite['language_id'] . ";"));
                $new_url_prod = str_replace('.html', '', $url_rewrite['url_text']);
                @xtc_db_query("INSERT INTO url_rewrites 
					(content_id, 
					content_type, 
					language_id, 
					rewrite_url, 
					target_url)
				VALUES
					(" . $url_rewrite['products_id'] . ", 
					'product', 
					" . $url_rewrite['language_id'] . ", 
					'" . $new_url_prod . "', 
					'product_info.php?products_id=" . $url_rewrite['products_id'] . "&language=" . $language_id['code'] . "')
				;");

            }
        }

    }

    function remove()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_OLDURL_MIG'");
    }

}
