<?php

/* -----------------------------------------------------------------
 * 	ID:						cseov3_image_migration.php
 * 	Letzter Stand:			v2.5
 * 	zuletzt geaendert von:	akausch
 * 	Datum:					2014/04/08
 *
 * 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * --------------------------------------------------------------- */

class cseov3_image_migration
{

    var $title, $output;

    function __construct()
    {

		define('MODULE_CSEO_IMAGETAG_MIG_V1_TITLE', 'cseov3_image_migration');
		define('MODULE_CSEO_IMAGETAG_MIG_V1_DESC', 'Image ALT-Tag-Migration für commerce:seo v3');
		define('MODULE_CSEO_IMAGETAG_MIG_V1_STATUS_TITLE', 'Status');
		define('MODULE_CSEO_IMAGETAG_MIG_V1_STATUS_DESC', 'Status an/aus');
		define('MODULE_CSEO_IMAGETAG_MIG_V1_SORT_ORDER_TITLE', 'Sortierung');
		define('MODULE_CSEO_IMAGETAG_MIG_V1_SORT_ORDER_DESC', 'Reihenfolge');

		$this->code = 'cseov3_image_migration';
        $this->version = '3';

		$this->title = MODULE_CSEO_IMAGETAG_MIG_V1_TITLE;
		$this->description = MODULE_CSEO_IMAGETAG_MIG_V1_DESC;
		$this->sort_order = defined('MODULE_CSEO_IMAGETAG_MIG_V1_SORT_ORDER') ? MODULE_CSEO_IMAGETAG_MIG_V1_SORT_ORDER : '0';
		$this->enabled = defined('MODULE_CSEO_IMAGETAG_MIG_V1_STATUS') ? ((MODULE_CSEO_IMAGETAG_MIG_V1_STATUS == 'true') ? true : false) : false;
        $this->output = [];
    }

    function process()
    {
        global $order, $xtPrice;
    }

    function check()
    {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_IMAGETAG_MIG_V1_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function keys()
    {
        return array('MODULE_CSEO_IMAGETAG_MIG_V1_STATUS', 'MODULE_CSEO_IMAGETAG_MIG_V1_SORT_ORDER');
    }

    function install()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_IMAGETAG_MIG_V1'");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_CSEO_IMAGETAG_MIG_V1_STATUS', 'true', '6', '1','', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_IMAGETAG_MIG_V1_SORT_ORDER', '1','6', '2', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) VALUES ('MODULE_CSEO_IMAGETAG_MIG_V1', 'true','6', '3', now())");

        if (!table_exists('gm_prd_img_alt')) {
            xtc_db_query("
			CREATE TABLE `gm_prd_img_alt` (
			  `img_alt_id` int(11) NOT NULL auto_increment,
			  `image_id` int(11) NOT NULL default '0',
			  `products_id` int(11) NOT NULL,
			  `language_id` int(11) NOT NULL default '1',
			  `gm_alt_text` varchar(255) default NULL,
			  PRIMARY KEY  (`img_alt_id`),
			  UNIQUE KEY `image_id` (`image_id`,`products_id`,`language_id`),
			  KEY `image_id2` (`image_id`,`language_id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
		");
        }

        $check_query = xtc_db_query("SELECT * FROM gm_prd_img_alt;");
        if (xtc_db_num_rows($check_query) == 0) {
            $lang_other = xtc_db_query("SELECT languages_id FROM languages;");
            if (xtc_db_num_rows($lang_other) > 0) {
                while ($other_lang = xtc_db_fetch_array($lang_other)) {
                    $language_id = $other_lang['languages_id'];
                    xtc_db_query("INSERT INTO gm_prd_img_alt (image_id, products_id, language_id, gm_alt_text) SELECT image_id, products_id, " . $language_id . " , alt_langID_" . $language_id . " FROM products_images;");
                    xtc_db_query("UPDATE products_description SET gm_alt_text = products_img_alt;");
                }
            }
        }

    }

    function remove()
    {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_CSEO_IMAGETAG_MIG_V1'");
        xtc_db_query("TRUNCATE TABLE `gm_prd_img_alt`");
    }

}
