<?php
/* -----------------------------------------------------------------
 * 	$Id: paypal_profile.php 1548 2016-04-06 13:03:10Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	modified eCommerce Shopsoftware
 * 	http://www.modified-shop.org
 * 	Copyright (c) 2009 - 2013 [www.modified-shop.org]
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

require('includes/application_top.php');

require_once(DIR_FS_EXTERNAL.'paypal/classes/PayPalAdmin.php');
$paypal = new PayPalAdmin();

if (isset($_GET['action'])) {
  switch ($_GET['action']) {
    case 'delete':
      $paypal->delete_profile($_GET['id']);      
      xtc_redirect(xtc_href_link('paypal_profile.php'));
      break;

    case 'update':
      $paypal->update_profile($_POST['config']);      
      xtc_redirect(xtc_href_link('paypal_profile.php'));
      break;

    case 'insert':
      $paypal->create_profile($_POST['config']);      
      xtc_redirect(xtc_href_link('paypal_profile.php'));
      break;
  }
}

$locale_code_array = array(
  array('id' => 'DE', 'text' => 'DE'),
  array('id' => 'AU', 'text' => 'AU'),
  array('id' => 'AT', 'text' => 'AT'),
  array('id' => 'BE', 'text' => 'BE'),
  array('id' => 'BR', 'text' => 'BR'),
  array('id' => 'CA', 'text' => 'CA'),
  array('id' => 'CH', 'text' => 'CH'),
  array('id' => 'CN', 'text' => 'CN'),
  array('id' => 'ES', 'text' => 'ES'),
  array('id' => 'FR', 'text' => 'FR'),
  array('id' => 'GB', 'text' => 'GB'),
  array('id' => 'IT', 'text' => 'IT'),
  array('id' => 'NL', 'text' => 'NL'),
  array('id' => 'PL', 'text' => 'PL'),
  array('id' => 'PT', 'text' => 'PT'),
  array('id' => 'RU', 'text' => 'RU'),
  array('id' => 'US', 'text' => 'US'),
);

$status_array = array(
  array('id' => '1', 'text' => YES),
  array('id' => '0', 'text' => NO),
); 

$landingpage_array = array(
  array('id' => 'Login', 'text' => 'Login'),
  array('id' => 'Payment', 'text' => 'Payment'),
); 

require_once(DIR_WS_INCLUDES.'header.php');
?>
<table class="table table-striped table-bordered">
	<tr>
		<th colspan="5"><?php echo TEXT_PAYPAL_CONFIG_HEADING_TITLE; ?></th>
	</tr>
	<tr>
          <?php
            if (!isset($_GET['action'])) {
              echo '<div class="pageHeading flt-l" style="margin: 3px 40px;"><a class="button" href="'.xtc_href_link('paypal_profile.php', 'action=new').'">'.BUTTON_INSERT.'</a></div>';
            }
		echo '<td><a href="'.xtc_href_link('paypal_config.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_CONFIG.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_profile.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_PROFILE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_webhook.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_WEBHOOK.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_module.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_MODULE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_payment.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_TRANSACTIONS.'</a></td>';
          ?>
		  </tr>
</table>
<table class="table table-striped table-bordered">
	<?php
	  if (isset($_GET['action']) && $_GET['action'] == 'edit') {
		$list = $paypal->get_profile($_GET['id']);
	  
		echo xtc_draw_form('config', 'paypal_profile.php', xtc_get_all_get_params(array('action')).'action=update');

		for ($i=0, $n=count($list); $i<$n; $i++) {
		  echo xtc_draw_hidden_field('config[id]', $list[$i]['id']);
		  ?>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_STATUS; ?></td>
			  <td><?php echo draw_on_off_selection('config[status]', $status_array, $list[$i]['status']); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_STATUS_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_NAME; ?></td>
			  <td><?php echo xtc_draw_input_field('config[name]', $list[$i]['name'], 'style="width: 300px;"'); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_NAME_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_BRAND; ?></td>
			  <td><?php echo xtc_draw_input_field('config[presentation][brand_name]', $list[$i]['presentation']['brand_name'], 'style="width: 300px;"'); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_BRAND_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOGO; ?></td>
			  <td><?php echo xtc_draw_input_field('config[presentation][logo_image]', $list[$i]['presentation']['logo_image'], 'style="width: 300px;"'); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOGO_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOCALE; ?></td>
			  <td><?php echo xtc_draw_pull_down_menu('config[presentation][locale_code]', $locale_code_array, $list[$i]['presentation']['locale_code']); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOCALE_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_PAGE; ?></td>
			  <td><?php echo xtc_draw_pull_down_menu('config[flow_config][landing_page_type]', $landingpage_array, $list[$i]['flow_config']['landing_page_type']); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_PAGE_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_ADDRESS; ?></td>
			  <td><?php echo draw_on_off_selection('config[input_fields][address_override]', $status_array, ($list[$i]['input_fields']['address_override'] == '1' ? false : true)); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_ADDRESS_INFO; ?></td>
			</tr>
			<tr>
			  <td colspan="3">
				<a class="btn btn-default btn-sm" href="<?php echo xtc_href_link('paypal_profile.php'); ?>"><?php echo BUTTON_CANCEL; ?></a>
				<input type="submit" class="btn btn-success btn-sm" name="submit" value="<?php echo BUTTON_UPDATE; ?>">
			  </td>
			</tr>
		 <?php
		}
	  
	  } elseif (isset($_GET['action']) && $_GET['action'] == 'new') {

		echo xtc_draw_form('config', 'paypal_profile.php', xtc_get_all_get_params(array('action')).'action=insert');
		?>
		  <tr>
			<td><?php echo TEXT_PAYPAL_PROFILE_NAME; ?></td>
			<td><?php echo xtc_draw_input_field('config[name]', '', 'style="width: 300px;"'); ?></td>
			<td><?php echo TEXT_PAYPAL_PROFILE_NAME_INFO; ?></td>
		  </tr>
		  <tr>
			<td><?php echo TEXT_PAYPAL_PROFILE_BRAND; ?></td>
			<td><?php echo xtc_draw_input_field('config[presentation][brand_name]', '', 'style="width: 300px;"'); ?></td>
			<td><?php echo TEXT_PAYPAL_PROFILE_BRAND_INFO; ?></td>
		  </tr>
		  <tr>
			<td><?php echo TEXT_PAYPAL_PROFILE_LOGO; ?></td>
			<td><?php echo xtc_draw_input_field('config[presentation][logo_image]', '', 'style="width: 300px;"'); ?></td>
			<td><?php echo TEXT_PAYPAL_PROFILE_LOGO_INFO; ?></td>
		  </tr>
		  <tr>
			<td><?php echo TEXT_PAYPAL_PROFILE_LOCALE; ?></td>
			<td><?php echo xtc_draw_pull_down_menu('config[presentation][locale_code]', $locale_code_array, strtoupper(DEFAULT_LANGUAGE)); ?></td>
			<td><?php echo TEXT_PAYPAL_PROFILE_LOCALE_INFO; ?></td>
		  </tr>
		  <tr>
			<td><?php echo TEXT_PAYPAL_PROFILE_PAGE; ?></td>
			<td><?php echo xtc_draw_pull_down_menu('config[flow_config][landing_page_type]', $landingpage_array, ''); ?></td>
			<td><?php echo TEXT_PAYPAL_PROFILE_PAGE_INFO; ?></td>
		  </tr>
		  <tr>
			<td><?php echo TEXT_PAYPAL_PROFILE_ADDRESS; ?></td>
			<td><?php echo draw_on_off_selection('config[input_fields][address_override]', $status_array, false); ?></td>
			<td><?php echo TEXT_PAYPAL_PROFILE_ADDRESS_INFO; ?></td>
		  </tr>
		  <tr>
			<td colspan="3">
			  <a class="btn btn-default btn-sm" href="<?php echo xtc_href_link('paypal_profile.php'); ?>"><?php echo BUTTON_CANCEL; ?></a>
			  <input type="submit" class="btn btn-success btn-sm" name="submit" value="<?php echo BUTTON_SAVE; ?>">
			</td>
		  </tr>
		<?php
	
	  } else {
		$list = $paypal->list_profile();
	  
		for ($i=0, $n=count($list); $i<$n; $i++) {
		  ?>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_STATUS; ?></td>
			  <td><?php echo (($list[$i]['status'] == '1') ? YES : NO); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_STATUS_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_NAME; ?></td>
			  <td><?php echo $list[$i]['name']; ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_NAME_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_BRAND; ?></td>
			  <td><?php echo $list[$i]['presentation']['brand_name']; ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_BRAND_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOGO; ?></td>
			  <td><?php echo (($list[$i]['presentation']['logo_image'] != '') ? '<img src="'.$list[$i]['presentation']['logo_image'].'" style="max-width: 280px;" />' : ''); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOGO_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOCALE; ?></td>
			  <td><?php echo $list[$i]['presentation']['locale_code']; ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_LOCALE_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_PAGE; ?></td>
			  <td><?php echo $list[$i]['flow_config']['landing_page_type']; ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_PAGE_INFO; ?></td>
			</tr>
			<tr>
			  <td><?php echo TEXT_PAYPAL_PROFILE_ADDRESS; ?></td>
			  <td><?php echo (($list[$i]['input_fields']['address_override'] == '0') ? YES : NO); ?></td>
			  <td><?php echo TEXT_PAYPAL_PROFILE_ADDRESS_INFO; ?></td>
			</tr>
			<tr>
			  <td colspan="3">
				<a class="btn btn-success btn-sm" href="<?php echo xtc_href_link('paypal_profile.php', 'action=edit&id='.$list[$i]['id']); ?>"><?php echo BUTTON_EDIT; ?></a>
				<a class="btn btn-danger btn-sm" href="<?php echo xtc_href_link('paypal_profile.php', 'action=delete&id='.$list[$i]['id']); ?>"><?php echo BUTTON_DELETE; ?></a>
			  </td>
			</tr>
		  <?php
		}
		if (count($list) < 1) {
		  echo '<div class="info_message">'.TEXT_PAYPAL_PROFILE_INFO.'</div>';
		}
	  }
	?>
	</table>
<?php 
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');