<?php

/* -----------------------------------------------------------------
 * 	ID:						$Id: module_system.php 1253 2016-01-23 02:02:47Z akausch $
 * 	Letzter Stand:			$Revision: 1253 $
 * 	zuletzt geГ¤ndert von: 	$Author: akausch $
 * 	Datum:					$Date: 2016-01-23 03:02:47 +0100 (Sa, 23 Jan 2016) $
 *
 * 	commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 *
 * 	Copyright (c) since 2010 commerce:SEO
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 *
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

require_once('includes/application_top.php');
$smarty = new Smarty;
$module_type = 'system';
$module_directory = DIR_WS_MODULES . 'cseo/';
$module_key = 'MODULE_UPDATE_INSTALLED';
$file_extension = '.php';
if (isset($_GET['error'])) {
    $map = 'error';
    if ($_GET['kind'] == 'success') {
        $map = 'success';
    }
    $messageStack->add($_GET['error'], $map);
}
$formlink = FILENAME_MODULE_SYSTEM;
if (isset($_GET['action'])) {
    switch ($_GET['action']) {
        case 'image_processing_do':
            $class = basename($_GET['module']);
            include_once($module_directory . $class . $file_extension);
            if ($class == 'cseo_image_processing_all' || $class == 'cseo_image_processing_popup' || $class == 'cseo_image_processing_info' || $class == 'cseo_image_processing_mini' || $class == 'cseo_image_processing_thumb') {
                $module = new $class;
                $module->process($file, $_GET['start']);
                $formlink = xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class . '&start=' . $limit . '&count=' . $count . '&action=image_processing_do' . '&max=' . $_GET['max'] . '&miss=' . $_GET['miss']);
            } elseif ($class == "commerce_seo_url") {
                $module = new $class;
                $module->process($_GET['start']);
                $formlink = xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class . '&start=' . $limit . '&count=' . $_count . '&action=image_processing_do' . '&max=' . $_GET['max']);
            }
            break;
        case 'save':
            if (is_array($_POST['configuration'])) {
                if (count($_POST['configuration'])) {
                    while (list($key, $value) = each($_POST['configuration'])) {
                        xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value = '" . $value . "' WHERE configuration_key = '" . $key . "'");
                        if (strpos($key, 'FILE') !== false)
                            $file = $value;
                    }
                }
            }
            $class = basename($_GET['module']);
            include_once($module_directory . $class . $file_extension);
            if (isset($_POST['process']) && $_POST['process'] == 'image_processing_do') {
                xtc_redirect(xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class . '&start=0' . '&count=' . $count . '&action=image_processing_do' . '&max=' . $_POST['max_images'] . '&miss=' . $_POST['only_missing_images']));
            } else {
                $module = new $class;
                $module->process($file);
                xtc_redirect(xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class));
            }
            break;

        case 'install':
        case 'remove':
            $file_extension = substr(basename($_SERVER['SCRIPT_NAME']), strrpos(basename($_SERVER['SCRIPT_NAME']), '.'));
            $class = basename($_GET['module']);
            if (file_exists($module_directory . $class . $file_extension)) {
                include_once($module_directory . $class . $file_extension);
                $module = new $class;
                if ($_GET['action'] == 'install') {
                    $module->install();
                } elseif ($_GET['action'] == 'remove') {
                    $module->remove();
                }
            }
            xtc_redirect(xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class));
            break;
    }
}
require_once(DIR_WS_INCLUDES . 'header.php');
// $smarty->assign('FORM', '<form name="img_continue" id="img_continue" action="' . $formlink . '" method="POST"></form>');
// if ($selbstaufruf != '') {
// $smarty->assign('selbstaufruf', $selbstaufruf);
// }
echo '<form name="img_continue" id="img_continue" action="' . $formlink . '" method="POST"></form>';
if ($selbstaufruf != '') {
    echo $selbstaufruf;
}
$file_extension = substr(basename($_SERVER['SCRIPT_NAME']), strrpos(basename($_SERVER['SCRIPT_NAME']), '.'));
$directory_array = array();
if ($dir = @dir($module_directory)) {
    while ($file = $dir->read()) {
        if (!is_dir($module_directory . $file)) {
            if (substr($file, strrpos($file, '.')) == $file_extension) {
                $directory_array[] = $file;
            }
        }
    }
    sort($directory_array);
    $dir->close();
}
$installed_modules = array();
$modules_list_array = array();
for ($i = 0, $n = sizeof($directory_array); $i < $n; $i++) {
    $file = $directory_array[$i];
    include_once($module_directory . $file);
    $class = substr($file, 0, strrpos($file, '.'));
    if (xtc_class_exists($class)) {
        $module = new $class;
        if ($module->check() > 0) {
            if ($module->sort_order > 0) {
                $installed_modules[$module->sort_order] = $file;
            } else {
                $installed_modules[] = $file;
            }
        }
        if (((!$_GET['module']) || ($_GET['module'] == $class)) && (!$mInfo)) {
            $module_info = array('code' => $module->code,
                'title' => $module->title,
                'description' => $module->description,
                'status' => $module->check());
            $module_keys = $module->keys();
            $keys_extra = array();
            for ($j = 0, $k = sizeof($module_keys); $j < $k; $j++) {
                $key_value = xtc_db_fetch_array(xtc_db_query("SELECT configuration_key,configuration_value, use_function, set_function FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $module_keys[$j] . "';"));
                if ($key_value['configuration_key'] != '') {
                    $keys_extra[$module_keys[$j]]['title'] = constant(strtoupper($key_value['configuration_key'] . '_TITLE'));
                }
                $keys_extra[$module_keys[$j]]['value'] = $key_value['configuration_value'];
                if ($key_value['configuration_key'] != '') {
                    $keys_extra[$module_keys[$j]]['description'] = constant(strtoupper($key_value['configuration_key'] . '_DESC'));
                }
                $keys_extra[$module_keys[$j]]['use_function'] = $key_value['use_function'];
                $keys_extra[$module_keys[$j]]['set_function'] = $key_value['set_function'];
            }
            $module_info['keys'] = $keys_extra;
            $mInfo = new objectInfo($module_info);
        }
        if ((is_object($mInfo)) && ($class == $mInfo->code)) {
            $tractive = true;
            $trlink = xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class . '&action=edit');
            $action = 'active';
        } else {
            $tractive = false;
            $trlink = xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class);
            $action = xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $class);
        }

        $modules_list_array[$i] = array(
            'tractive' => $tractive,
            'trlink' => $trlink,
            'title' => $module->title,
            'check' => ($module->check() == 1 ? true : false),
            'action' => $action,
        );
    }
}

$smarty->assign('modules_list_array', $modules_list_array);

ksort($installed_modules);
$check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $module_key . "';");
if (xtc_db_num_rows($check_query)) {
    $check = xtc_db_fetch_array($check_query);
    if ($check['configuration_value'] != implode(';', $installed_modules)) {
        xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value = '" . implode(';', $installed_modules) . "', last_modified = now() WHERE configuration_key = '" . $module_key . "';");
    }
} else {
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) VALUES ( '" . $module_key . "', '" . implode(';', $installed_modules) . "','6', '0', now());");
}

$heading = array();
$contents = array();
switch ($_GET['action']) {
    case 'edit':
        $keys = '';
        reset($mInfo->keys);
        while (list($key, $value) = each($mInfo->keys)) {
            $keys .= '<br><b>' . $value['title'] . '</b><br>';
            $keys .= $value['description'] . '<br>';
            if ($value['set_function']) {
                eval('$keys .= ' . $value['set_function'] . "'" . $value['value'] . "', '" . $key . "');");
            } else {
                $keys .= xtc_draw_input_field('configuration[' . $key . ']', $value['value']);
            }
            $keys .= '<br><br>';
        }
        $keys = substr($keys, 0, strrpos($keys, '<br><br>'));
        $heading[] = array('text' => '<b>' . $mInfo->title . '</b>');
        $class = substr($file, 0, strrpos($file, '.'));
        $module = new $_GET['module'];
        $contents = array('form' => xtc_draw_form('modules', FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $_GET['module'] . '&action=save', 'post'));
        $contents[] = array('text' => $keys);
        $contents[] = $module->display();
        break;

    default:
        $heading[] = array('text' => '<b>' . $mInfo->title . '</b>');
        if ($mInfo->status == '1') {
            $keys = '';
            reset($mInfo->keys);
            while (list(, $value) = each($mInfo->keys)) {
                $keys .= '<b>' . $value['title'] . '</b><br>';
                if ($value['use_function']) {
                    $use_function = $value['use_function'];
                    if (preg_match('/->/', $use_function)) {
                        $class_method = explode('->', $use_function);
                        if (!is_object(${$class_method[0]})) {
                            include_once(DIR_WS_CLASSES . $class_method[0] . '.php');
                            ${$class_method[0]} = new $class_method[0]();
                        }
                        $keys .= xtc_call_function($class_method[1], $value['value'], ${$class_method[0]});
                    } else {
                        $keys .= xtc_call_function($use_function, $value['value']);
                    }
                } else {
                    if (strlen($value['value']) > 30) {
                        $keys .= substr($value['value'], 0, 30) . ' ...';
                    } else {
                        $keys .= $value['value'];
                    }
                }
                $keys .= '<br><br>';
            }
            $keys = substr($keys, 0, strrpos($keys, '<br><br>'));
            $contents[] = array('align' => 'center', 'text' => '<a class="btn btn-danger btn-sm" href="' . xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $mInfo->code . '&action=remove') . '">' . BUTTON_MODULE_REMOVE . '</a> <a class="btn btn-info btn-sm" href="' . xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $mInfo->code . '&action=edit') . '">' . BUTTON_START . '</a>');
            $contents[] = array('text' => '<br>' . $mInfo->description);
            $contents[] = array('text' => '<br>' . $keys);
        } else {
            $contents[] = array('align' => 'center', 'text' => '<a class="btn btn-info btn-sm" href="' . xtc_href_link(FILENAME_MODULE_SYSTEM, 'set=' . $_GET['set'] . '&module=' . $mInfo->code . '&action=install') . '">' . BUTTON_MODULE_INSTALL . '</a>');
            $contents[] = array('text' => '<br>' . $mInfo->description);
        }
        break;
}

if ((xtc_not_null($heading)) && (xtc_not_null($contents))) {
    $box = new box;
    $smarty->assign('SITE_BOX', $box->infoBox($heading, $contents));
    if ($_GET['action'] == 'image_processing_do') {
        $smarty->assign('infotext', $infotext);
    }
    if (isset($_GET['infotext'])) {
        $smarty->assign('infotext_success', urldecode($_GET['infotext']));
    }
}


$smarty->assign('MODULE_DIRECTORY', ' admin/' . $module_directory);
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('logo_path', HTTP_SERVER . DIR_WS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/img/');
$smarty->caching = false;
$smarty->template_dir = DIR_FS_CATALOG . 'admin/templates/';
$smarty->compile_dir = DIR_FS_CATALOG . 'admin/templates_c';
$smarty->display(CURRENT_ADMIN_TEMPLATE . '/module/module_system.html');

require_once(DIR_WS_INCLUDES . 'footer.php');
require_once(DIR_WS_INCLUDES . 'application_bottom.php');
