<?php
/* -----------------------------------------------------------------
 * 	$Id: paypal_payment.php 1564 2016-05-24 08:20:44Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	modified eCommerce Shopsoftware
 * 	http://www.modified-shop.org
 * 	Copyright (c) 2009 - 2013 [www.modified-shop.org]
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

require('includes/application_top.php');
require_once(DIR_FS_EXTERNAL.'paypal/classes/PayPalInfo.php');
$paypal = new PayPalInfo('paypal');

//display per page
$cfg_max_display_results_key = 'MAX_DISPLAY_PAYPAL_PAYMENTS_RESULTS';
$page_max_display_results = xtc_cfg_save_max_display_results($cfg_max_display_results_key);
$page_max_display_results = (($page_max_display_results > 20) ? '20' : $page_max_display_results);

require (DIR_WS_INCLUDES.'header.php');
?>
<table class="table table-striped table-bordered">
  <tr>
	<th colspan="5"><?php echo TEXT_PAYPAL_PAYMENT_HEADING_TITLE; ?></th>
	  <?php
	echo '<td><a href="'.xtc_href_link('paypal_config.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_CONFIG.'</a></td>';
	echo '<td><a href="'.xtc_href_link('paypal_profile.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_PROFILE.'</a></td>';
	echo '<td><a href="'.xtc_href_link('paypal_webhook.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_WEBHOOK.'</a></td>';
	echo '<td><a href="'.xtc_href_link('paypal_module.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_MODULE.'</a></td>';
	echo '<td><a href="'.xtc_href_link('paypal_payment.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_TRANSACTIONS.'</a></td>';
	  ?>
	</tr>
</table>
<?php
$list = $paypal->get_payments($page_max_display_results, ((isset($_GET['page']) && $_GET['page'] > 0) ? ($_GET['page'] * $page_max_display_results) : 0));
if (count($list) > 0) {
?>              
<table class="table table-striped table-bordered">
	  <tr>
		<td><?php echo TABLE_HEADING_ORDER; ?></td>
		<td><?php echo TABLE_HEADING_NAME; ?></td>
		<td><?php echo TABLE_HEADING_EMAIL; ?></td>
		<td rowspan="2"><?php echo TABLE_HEADING_INTENT; ?></td>
		<td rowspan="2"><?php echo TABLE_HEADING_STATUS; ?></td>
	  </tr>
	  <tr>
		<td><?php echo TABLE_HEADING_DATE; ?></td>
		<td><?php echo TABLE_HEADING_ID; ?></td>
		<td class="dataTableHeadingContent txta-r"><?php echo TABLE_HEADING_TOTAL; ?></td>
	  </tr>
	  <?php
	  for ($i=0, $n=count($list); $i<$n; $i++) {
		?>
		  <tr>
			<td><?php echo (($list[$i]['orders_id'] != '') ? '<a href="'.xtc_href_link(FILENAME_ORDERS, 'action=edit&oID='.$list[$i]['orders_id']).'"><b>'.$list[$i]['orders_id'].'</b></a>' : 'n/a'); ?></td>
			<td><b><?php echo $list[$i]['address']['name']; ?></b></td>
			<td><b><?php echo $list[$i]['email_address']; ?></b></td>
			<td><b><?php echo $list[$i]['intent']; ?></b></td>
			<td><b><?php echo $list[$i]['state']; ?></b></td>
		  </tr>
		<?php
		for ($t=0, $x=count($list[$i]['transactions']); $t<$x; $t++) {
		  for ($r=0, $z=count($list[$i]['transactions'][$t]['relatedResource']); $r<$z; $r++) {
			?>
			  <tr>
				<td><?php echo xtc_datetime_short($list[$i]['transactions'][$t]['relatedResource'][$r]['date']); ?></td>
				<td><?php echo $list[$i]['transactions'][$t]['relatedResource'][$r]['id']; ?></td>
				<td><?php echo format_price($list[$i]['transactions'][$t]['relatedResource'][$r]['total'], 1, $list[$i]['transactions'][$t]['relatedResource'][$r]['currency'], 0, 0); ?></td>
				<td><?php echo $list[$i]['transactions'][$t]['relatedResource'][$r]['type']; ?></td>
				<td><?php echo $list[$i]['transactions'][$t]['relatedResource'][$r]['state']; ?></td>
			  </tr>
			<?php
		  }
		}
	  }
	  ?>
	  <tr>
		<td colspan="5">
		  <?php
		  if (isset($_GET['page']) && $_GET['page'] > 0) {
			echo '<a class="button flt-l" href="'.xtc_href_link('paypal_payment.php', 'page='.($_GET['page'] - 1)).'">&laquo;</a>';
		  }
		  if (!isset($_GET['page']) || count($list) == $page_max_display_results) {
			echo '<a class="button flt-r" href="'.xtc_href_link('paypal_payment.php', 'page='.((isset($_GET['page'])) ? ($_GET['page'] + 1) : 1)).'">&raquo;</a>';
		  }
		  ?>
		</td>
	  </tr>
	  <tr>
		<td colspan="5">
		  <?php echo draw_input_per_page('paypal_payment.php', $cfg_max_display_results_key, $page_max_display_results); ?>
		</td>
	  </tr>
</table>
<?php
} else {
  echo '<div class="info_message">'.TEXT_PAYPAL_PAYMENT_INFO.'</div>';
} 
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
