<?php
/*
$Id: ot_pn_sofortueberweisung_fee.php,v 1.2 2006/02/01 09:30:16 md Exp $

XT-Commerce - community made shopping
http://www.xt-commerce.com
-----------------------------------------------------------------------------------------
based on:
Copyright (c) 2002 osCommerce - Marco Falcini - MARCUS - <www.oscommercedev.com>

Released under the GNU General Public License
-----------------------------------------------------------------------------------------
*/


class ot_pn_sofortueberweisung_fee {
	var $title, $output;

	function ot_pn_sofortueberweisung_fee() {
		global $xtPrice;
		$this->code = 'ot_pn_sofortueberweisung_fee';
		$this->title = MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_TITLE;
		$this->description = MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_DESCRIPTION;
		$this->enabled = ((MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_STATUS == 'true') ? true : false);
		$this->sort_order = MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_SORT_ORDER;
		$this->output = array();
		
		if(MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_CUSTOMER_STATUS != '' && !in_array($_SESSION['customers_status']['customers_status_id'], explode(',', MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_CUSTOMER_STATUS) ) ) {
			$this->enabled = false;
		}
	}

	function process() {
		global $order, $currencies, $xtPrice;

		if (MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_STATUS == 'true') {
			//check if payment method is pn_sofortueberweisung. If yes, add fee.
			if ($_SESSION['payment'] == 'pn_sofortueberweisung') {

				$tax = xtc_get_tax_rate(MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_TAX_CLASS, $order->delivery['country']['id'], $order->delivery['zone_id']);
				$tax_description = xtc_get_tax_description(MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_TAX_CLASS, $order->delivery['country']['id'], $order->delivery['zone_id']);

				
				$order_total = $order->info['total'];
				if(!$_SESSION['customers_status']['customers_status_show_price_tax']) {
					$order_total += $order->info['tax'];
				}
				if(MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_CALC_TYPE == 'Reverse') {
					$cc_fee =  $xtPrice->xtcFormat( ($order_total + MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_FLAT)/ (1 - MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE/100) - $order_total, false);
				} else {
					$cc_fee =  $xtPrice->xtcFormat(((MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE/100) * $order_total) + MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_FLAT, false);
				}
//				$order->info['total'];
//				$order->info['total'] += $cc_fee;
				
				if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1) {
					$order->info['tax'] += xtc_calculate_tax($cc_fee, $tax);
					$order->info['tax_groups'][TAX_ADD_TAX . "$tax_description"] += xtc_calculate_tax($cc_fee, $tax);
					$order->info['total'] += $cc_fee;
				}

				if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {

					$order->info['tax'] += xtc_calculate_tax($cc_fee, $tax);
					$order->info['tax_groups'][TAX_NO_TAX . "$tax_description"] += xtc_calculate_tax($cc_fee, $tax);
					$order->info['subtotal'] += $cc_fee;
					$order->info['total'] += $cc_fee;
				}

				if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] != 1) {
					$order->info['subtotal'] += $cc_fee;
					$order->info['total'] += $cc_fee;
				}
				
				if(MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_SHOW_RATE == 'true') {
					$this->output[] = array('title' => $this->title . ' (' . ((MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE) ? MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE . ' %'  : '') . ( (MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE && MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_FLAT) ? ' + ' : '' ) . ((MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_FLAT) ? $xtPrice->xtcFormat(MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_FLAT, true) : '') . '):',
					'text' =>  $xtPrice->xtcFormat($cc_fee, true),
					'value' => $cc_fee);
				} else {
					$this->output[] = array('title' => $this->title . ':',
					'text' =>  $xtPrice->xtcFormat($cc_fee, true),
					'value' => $cc_fee);
				}
			}
		}
	}

	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}

		return $this->_check;
	}

	function keys() {
		return array('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_STATUS', 'MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_SORT_ORDER', 'MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE', 'MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_FLAT','MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_CALC_TYPE', 'MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_SHOW_RATE', 'MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_CUSTOMER_STATUS', 'MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_TAX_CLASS');
	}

	function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_STATUS', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_SHOW_RATE', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_CALC_TYPE', 'Reverse', '6', '1','xtc_cfg_select_option(array(\'Reverse\', \'Normal\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_SORT_ORDER', '38',  '6', '2', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE', '3.4', '6', '3', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_FLAT', '0.35', '6', '4', now())");
		
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_CUSTOMER_STATUS', '3', '6', '5', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_ORDER_TOTAL_PN_SOFORTUEBERWEISUNG_FEE_TAX_CLASS', '0','6', '6', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
		
	}


	function remove() {
		xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	}
}
?>