<?php
/* -----------------------------------------------------------------
 * 	$Id: categories_specials.php 420 2013-06-19 18:04:39Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

function showSpecialsBox() {
    if (isset($_GET['pID'])) {
        $specials_query = xtc_db_query("SELECT 
							p.products_tax_class_id,
							p.products_id,
							p.products_price,
							pd.products_name,
							s.*
							FROM " . TABLE_PRODUCTS . " p
							LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd ON(p.products_id = pd.products_id)
							LEFT JOIN " . TABLE_SPECIALS . " s ON(p.products_id = s.products_id)
							WHERE pd.language_id = '" . (int) $_SESSION['languages_id'] . "'
							AND s.products_id = '" . (int) $_GET['pID'] . "';");
        if (xtc_db_num_rows($specials_query) > 0) {
            $special = xtc_db_fetch_array($specials_query);
            $sInfo = new objectInfo($special);
        }
    }

    $price = $sInfo->products_price;
    $new_price = $sInfo->specials_new_products_price;

    if (PRICE_IS_BRUTTO == 'true') {
        $price_netto = xtc_round($price, PRICE_PRECISION);
        $new_price_netto = xtc_round($new_price, PRICE_PRECISION);
        $price = ($price * (xtc_get_tax_rate($sInfo->products_tax_class_id) + 100) / 100);
        $new_price = ($new_price * (xtc_get_tax_rate($sInfo->products_tax_class_id) + 100) / 100);
    }

    $price = xtc_round($price, PRICE_PRECISION);
    $new_price = xtc_round($new_price, PRICE_PRECISION);

    if (isset($_GET['pID']) && xtc_db_num_rows($specials_query) > 0 && $sInfo->expires_date != 0) {
        $expires_date = substr($sInfo->expires_date, 0, 4) . "-" .
                substr($sInfo->expires_date, 5, 2) . "-" .
                substr($sInfo->expires_date, 8, 2);
    } else {
        $expires_date = "";
    }
    ($sInfo->status == 1) ? $status = 'checked="checked"' : $status = '';

    echo xtc_draw_hidden_field('specials_action', ((isset($_GET['pID']) && xtc_db_num_rows($specials_query, true) > 0) ? "update" : "insert"));
    if (isset($_GET['pID']) && xtc_db_num_rows($specials_query) > 0) {
        echo xtc_draw_hidden_field('specials_id', $sInfo->specials_id);
	}
    ?>

    <table width="100%" border="0" cellpadding="3" cellspacing="0">
        <tr>
            <td class="main"><?php echo TEXT_STATUS; ?></td>
            <td class="main"><?php echo xtc_draw_selection_field('specials_status', 'checkbox', '1', $sInfo->status == 1 ? true : false); ?></td>
        </tr>
        <tr>
            <td class="main" width="50%"><?php echo TEXT_SPECIALS_SPECIAL_PRICE; ?></td>
            <td class="main" width="50%"><?php echo xtc_draw_input_field('specials_price', $new_price, 'style="width: 135px"'); ?> (<?php echo TEXT_NETTO . $new_price_netto;?>) </td>
        </tr>
        <tr>
            <td class="main">&nbsp; </td>
            <td class="main"><?php if (isset($_GET['pID']) && xtc_db_num_rows($specials_query) > 0) { ?>
                    <input type="checkbox" name="specials_delete" value="true" id="input_specials_delete"	onclick="if (this.checked == true)
                                return confirm('<?php echo TEXT_INFO_DELETE_INTRO; ?>');"style="vertical-align:middle;"/>
                    <label for="input_specials_delete"><?php echo TEXT_INFO_HEADING_DELETE_SPECIALS; ?></label>        
                <?php } ?>
			</td>
        </tr>
        <tr>
            <td class="main"><?php echo TEXT_SPECIALS_SPECIAL_QUANTITY; ?>&nbsp;</td>
            <td class="main"><?php echo xtc_draw_input_field('specials_quantity', $sInfo->specials_quantity, 'style="width: 135px"'); ?> </td>
        </tr>
        <?php if (isset($_GET['pID']) and xtc_db_num_rows($specials_query, true) > 0) { ?>
            <tr>
                <td class="main"><?php echo TEXT_INFO_DATE_ADDED; ?></td>
                <td class="main"><?php echo xtc_date_short($sInfo->specials_date_added); ?></td>
            </tr>
            <tr>
                <td class="main"><?php echo TEXT_INFO_LAST_MODIFIED; ?></td>
                <td class="main"><?php echo xtc_date_short($sInfo->specials_last_modified); ?></td>
            </tr>
        <?php } ?>
        <tr>
            <td class="main"><?php echo TEXT_SPECIALS_EXPIRES_DATE; ?></td>
            <td class="main">
                <input type="text" name="specials_expires" class="datepickers" value="<?php echo ($expires_date != '00.00.0000' ? $expires_date : ''); ?>" />
            </td>
        </tr>
        <tr>
            <td colspan="2" class="main" style="padding:3px; background: #dfdfdf;">
                <?php echo TEXT_SPECIALS_PRICE_TIP; ?>
            </td>
        </tr>
    </table>
<?php
}

function saveSpecialsData($products_id) {
    if ($_POST['specials_action'] == "insert" && isset($_POST['specials_price']) && !empty($_POST['specials_price'])) {
		$specials_price = xtc_db_prepare_input($_POST['specials_price']);
		$specials_expires = xtc_db_prepare_input($_POST['specials_expires']);
        if (!isset($_POST['specials_quantity']) || empty($_POST['specials_quantity'])) {
            $_POST['specials_quantity'] = 0;
		}
        if (PRICE_IS_BRUTTO == 'true' && substr($specials_price, -1) != '%') {
            $tax = xtc_db_fetch_array(xtc_db_query("SELECT tr.tax_rate FROM " . TABLE_TAX_RATES . " tr, " . TABLE_PRODUCTS . " p  WHERE tr.tax_class_id = p. products_tax_class_id AND p.products_id = '" . $_POST['products_id'] . "';"));
            $specials_price = ($specials_price / ($tax['tax_rate'] + 100) * 100);
        } elseif (substr($specials_price, -1) == '%') {
            $new_special_insert = xtc_db_fetch_array(xtc_db_query("SELECT products_id,products_tax_class_id, products_price FROM " . TABLE_PRODUCTS . " where products_id = '" . $products_id . "';"));
            $products_price = $new_special_insert['products_price'];
            $specials_price = ($products_price - (($specials_price / 100) * $products_price));
        }
        $expires_date = '';
        if ($specials_expires) {
            $expires_date = str_replace("-", "", $specials_expires);
        }
        xtc_db_query("INSERT INTO 
				" . TABLE_SPECIALS . " 
				(products_id, 
				specials_quantity, 
				specials_new_products_price, 
				specials_date_added, 
				expires_date, 
				status
				) VALUES (
				'" . $products_id . "', 
				'" . (int) $_POST['specials_quantity'] . "', 
				'" . $specials_price . "', 
				now(), 
				'" . $expires_date . "', 
				'1'
				)");
    } elseif ($_POST['specials_action'] == "update" && isset($_POST['specials_price']) && isset($_POST['specials_quantity'])) {
        $specials_quantity = xtc_db_input($_POST['specials_quantity']);
        $specials_price = xtc_db_prepare_input($_POST['specials_price']);
        $specials_expires = xtc_db_prepare_input($_POST['specials_expires']);
        $products_price = xtc_db_prepare_input($_POST['products_price']);
		if (PRICE_IS_BRUTTO == 'true' && substr($specials_price, -1) != '%') {
            $tax = xtc_db_fetch_array(xtc_db_query("SELECT tr.tax_rate FROM " . TABLE_TAX_RATES . " tr, " . TABLE_PRODUCTS . " p  WHERE tr.tax_class_id = p. products_tax_class_id  AND p.products_id = '" . $products_id . "';"));
            $specials_price = ($specials_price / ($tax[tax_rate] + 100) * 100);
        } elseif (PRICE_IS_BRUTTO == 'true' && substr($specials_price, -1) == '%') {
			$specials_price = ($products_price - (($specials_price / 100) * $products_price));
            $tax = xtc_db_fetch_array(xtc_db_query("SELECT tr.tax_rate FROM " . TABLE_TAX_RATES . " tr, " . TABLE_PRODUCTS . " p  WHERE tr.tax_class_id = p. products_tax_class_id  AND p.products_id = '" . $products_id . "';"));
            $specials_price = ($specials_price / ($tax[tax_rate] + 100) * 100);
        } elseif (substr($specials_price, -1) == '%') {
			$specials_price = ($products_price - (($specials_price / 100) * $products_price));
			
		}
        $expires_date = 'NULL';
        if ($specials_expires && $_POST['specials_status'] == 1) {
            $expires_date = str_replace("-", "", $specials_expires);
            $expires_date = "'" . $expires_date . "'";
        }
        xtc_db_query("UPDATE " . TABLE_SPECIALS . " 
						SET specials_quantity = '" . $specials_quantity . "', 
							specials_new_products_price = '" . $specials_price . "', 
							specials_last_modified = now(), 
							expires_date = " . $expires_date . ",
							status =  '" . xtc_db_input($_POST['specials_status']) . "'                           
						WHERE specials_id = '" . xtc_db_input($_POST['specials_id']) . "'");
    }

    if (isset($_POST['specials_delete'])) {
        xtc_db_query("DELETE FROM " . TABLE_SPECIALS . " WHERE specials_id = '" . xtc_db_input($_POST['specials_id']) . "'");
    }
}
