<?php

/* -----------------------------------------------------------------
 * 	$Id: blog.php 1506 2015-12-28 10:56:07Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include ('includes/application_top.php');
$blogobject = new blog();
$coo_text_mgr = new LanguageTextManager('blog', $_SESSION['languages_id']);
$smarty = new Smarty;
require (DIR_FS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/source/boxes.php');

if (SOCIAL == 'ja') {
    $shareurl = (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . $_SERVER['REQUEST_URI'];
    $obj = new shareCount($shareurl);  //Use your website or URL
    if (TWITTER_URL != '') {
        $smarty->assign('TWITTER_COUNT', $obj->get_tweets($shareurl));
        $smarty->assign('TWITTER_ACCOUNT', TWITTER_ACCOUNT);
        $smarty->assign('TWITTER_ON', 'true');
    }
    if (FACEBOOK_URL != '') {
        $smarty->assign('FACEBOOK_COUNT', $obj->get_fb($shareurl));
        $smarty->assign('FACEBOOK_ON', 'true');
    }
    if (GOOGLEPLUS_URL != '') {
        $smarty->assign('GOOGLE_COUNT', $obj->get_plusones($shareurl));
        $smarty->assign('GOOGLE_ON', 'true');
    }
    if (PINTEREST_URL != '') {
        $smarty->assign('PINTEREST_COUNT', $obj->get_pinterest($shareurl));
        $smarty->assign('PINTEREST_ON', 'true');
    }
    $smarty->assign('SHARE_URL', $shareurl);
    $smarty->assign('SHARE_IMAGE', (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG . DIR_WS_INFO_IMAGES . $product->data['products_image']);
}

if (isset($_GET['action']) && $_GET['action'] == 'process') {
    $url = xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input($_GET['blog_cat']) . '&blog_item=' . ($_GET['blog_item']));
    $antispam_query = $blogobject->getAntiSpam($_POST['antispamid']);
    $error = false;
    if (mb_strtolower($antispam_query['answer'], 'UTF-8') != mb_strtolower($_POST["codeanwser"], 'UTF-8') && BLOG_CAPTCHA == 'ja') {
        $error = true;
    }
}

if ($error == true) {
    $smarty->assign('ERROR_MSG', SECURITY_CODE_ERROR);
}

if (!isset($_GET['blog_cat']) && !isset($_GET['blog_item'])) {
    //Slider
    $slider_smarty = new smarty;
    $slider_smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
    $coo_slider = cseohookfactory::create_object('SliderManager');
    $t_view_html = $coo_slider->proceed('1', 'blogstart');
    if (is_array($t_view_html)) {
        foreach ($t_view_html AS $t_key => $t_value) {
            $slider_smarty->assign($t_key, $t_value);
        }
    }
    if (!CacheCheck()) {
        $slider_smarty->caching = false;
        $slider_content = $slider_smarty->fetch(cseo_get_usermod('base/module/slider_content.html', USE_TEMPLATE_DEVMODE));
    } else {
        $slider_smarty->caching = true;
        $slider_smarty->cache_lifetime = CACHE_LIFETIME;
        $slider_smarty->cache_modified_check = CACHE_CHECK;
        $cache_id = $_SESSION['language'] . $_SESSION['currency'] . $_SESSION['customer_id'] . 'slider';
        $slider_content = $slider_smarty->fetch(cseo_get_usermod('base/module/slider_content.html', USE_TEMPLATE_DEVMODE), $cache_id);
    }
    $smarty->assign('slider_content', $slider_content);
    $breadcrumb->add('Blog', xtc_href_link(FILENAME_BLOG));
    require_once (DIR_WS_INCLUDES . 'header.php');
    if (GROUP_CHECK == 'true') {
        $group_data = xtc_db_fetch_array(xtc_db_query("SELECT group_ids FROM blog_start WHERE group_ids LIKE '%c_" . (int) $_SESSION['customers_status']['customers_status_id'] . "_group%';"));
        if ($group_data != '') {
            $coo_startblog = cseohookfactory::create_object('IS_Blogstart');
            $t_view_html = $coo_startblog->proceed();
        } else {
            xtc_redirect(FILENAME_DEFAULT);
        }
    } else {
        $coo_startblog = cseohookfactory::create_object('IS_Blogstart');
        $t_view_html = $coo_startblog->proceed();
    }
    if (is_array($t_view_html)) {
        foreach ($t_view_html AS $t_key => $t_value) {
            $smarty->assign($t_key, $t_value);
        }
    }
    $smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
    $smarty->assign('language', $_SESSION['language']);
    $smarty->assign('txt', $coo_text_mgr->v_section_content_array['blog']);
    if (!CacheCheck()) {
        $smarty->caching = false;
        $main_content = $smarty->fetch(cseo_get_usermod('base/module/start_blog.html', USE_TEMPLATE_DEVMODE));
    } else {
        $smarty->caching = true;
        $smarty->cache_lifetime = CACHE_LIFETIME;
        $smarty->cache_modified_check = CACHE_CHECK;
        $cache_id = $_SESSION['language'] . $_SESSION['customers_status']['customers_status_name'] . $_SESSION['currency'] . 'blogstart';
        $main_content = $smarty->fetch(cseo_get_usermod('base/module/start_blog.html', USE_TEMPLATE_DEVMODE), $cache_id);
    }
} else {
    include (DIR_WS_MODULES . 'blog_comments.php');
    $group_check = '';
    if (GROUP_CHECK == 'true') {
        $group_check = "AND group_ids LIKE '%c_" . (int) $_SESSION['customers_status']['customers_status_id'] . "_group%'";
    }
    if (isset($_GET['action']) && $_GET['action'] == 'process') {
        $url = xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input($_GET['blog_cat']) . '&blog_item=' . ($_GET['blog_item']));
        if ($_SESSION['customer_id'] != '') {
            $customer_values = xtc_db_fetch_array(xtc_db_query("SELECT customers_firstname, customers_lastname FROM " . TABLE_CUSTOMERS . " WHERE customers_id = '" . (int) $_SESSION['customer_id'] . "';"));
            $customer_name = addslashes($customer_values['customers_firstname']) . ' ' . addslashes($customer_values['customers_lastname']);
        } else {
            $customer_name = TEXT_GUEST;
        }
        if (BLOG_RATE == 'ja') {
            $rating = $_POST['rating'];
        } else {
            $rating = '5';
        }
    }

    if ($_GET['blog_cat'] == '') {
        $blog = xtc_db_fetch_array(xtc_db_query("SELECT categories_id FROM blog_items WHERE item_id = '" . xtc_db_input($_GET['blog_item']) . "' AND language_id = '" . (int) $_SESSION['languages_id'] . "' GROUP BY categories_id;"));
        $_GET['blog_cat'] = $blog['categories_id'];
    }

    if (isset($_GET['blog_cat']) && is_numeric($_GET['blog_cat'])) {
        $getCatName = xtc_db_fetch_array(xtc_db_query("SELECT titel
													FROM " . TABLE_BLOG_CATEGORIES . "
													WHERE categories_id = '" . xtc_db_input($_GET['blog_cat']) . "'
													AND language_id = '" . (int) $_SESSION['languages_id'] . "' GROUP BY categories_id;"));

        $smarty->assign('cat_name', $getCatName['titel']);
        $breadcrumb->add($getCatName['titel'], xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input($_GET['blog_cat'])));
    }

// Wird Kategorie aufgerufen?
    if ((isset($_GET['blog_cat']) && is_numeric($_GET['blog_cat'])) && (!isset($_GET['blog_item'])) && !isset($_GET['blog_year'])) {
        //Slider
        $slider_smarty = new smarty;
        $slider_smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
        $coo_slider = cseohookfactory::create_object('SliderManager');
        $t_view_html = $coo_slider->proceed($_GET['blog_cat'], 'blogcat');
        if (is_array($t_view_html)) {
            foreach ($t_view_html AS $t_key => $t_value) {
                $slider_smarty->assign($t_key, $t_value);
            }
        }
        if (!CacheCheck()) {
            $slider_smarty->caching = false;
            $slider_content = $slider_smarty->fetch(cseo_get_usermod('base/module/slider_content.html', USE_TEMPLATE_DEVMODE));
        } else {
            $slider_smarty->caching = true;
            $slider_smarty->cache_lifetime = CACHE_LIFETIME;
            $slider_smarty->cache_modified_check = CACHE_CHECK;
            $cache_id = $_SESSION['language'] . $_SESSION['currency'] . $_SESSION['customer_id'] . (int) $_GET['blog_cat'] . 'slider';
            $slider_content = $slider_smarty->fetch(cseo_get_usermod('base/module/slider_content.html', USE_TEMPLATE_DEVMODE), $cache_id);
        }
        $smarty->assign('slider_content', $slider_content);
        if (GROUP_CHECK == 'true') {
            $group_data = xtc_db_fetch_array(xtc_db_query("SELECT group_ids FROM " . TABLE_BLOG_CATEGORIES . " WHERE group_ids LIKE '%c_" . (int) $_SESSION['customers_status']['customers_status_id'] . "_group%' AND categories_id = '" . (int) $_GET['blog_cat'] . "' "));
            if ($group_data != '') {
                
            } else {
                xtc_redirect(FILENAME_DEFAULT);
            }
        }
        $blogcat_data = xtc_db_fetch_array(xtc_db_query("SELECT categories_id, titel, description, itemsortart, itemsort
						  FROM " . TABLE_BLOG_CATEGORIES . " 
						  WHERE status = 2 
						  AND language_id = '" . (int) $_SESSION['languages_id'] . "'
						  AND categories_id = '" . (int) $_GET['blog_cat'] . "' 
						  " . $group_check . "
						  GROUP BY categories_id;"));

        if ($blogcat_data['itemsortart'] == 1) {
            if ($blogcat_data['itemsort'] == 1) {
                $order_by = ' ORDER BY position ASC';
            } elseif ($blogcat_data['itemsort'] == 2) {
                $order_by = ' ORDER BY date2 ASC';
            } elseif ($blogcat_data['itemsort'] == 3) {
                $order_by = ' ORDER BY datestart ASC';
            } elseif ($blogcat_data['itemsort'] == 4) {
                $order_by = ' ORDER BY title ASC';
            } elseif ($blogcat_data['itemsort'] == 5) {
                $order_by = ' ORDER BY date_update ASC';
            }
        } else {
            if ($blogcat_data['itemsort'] == 1) {
                $order_by = ' ORDER BY position DESC';
            } elseif ($blogcat_data['itemsort'] == 2) {
                $order_by = ' ORDER BY date2 DESC';
            } elseif ($blogcat_data['itemsort'] == 3) {
                $order_by = ' ORDER BY datestart DESC';
            } elseif ($blogcat_data['itemsort'] == 4) {
                $order_by = ' ORDER BY title DESC';
            } elseif ($blogcat_data['itemsort'] == 5) {
                $order_by = ' ORDER BY date_update DESC';
            }
        }

        $smarty->assign('cat_description', $blogcat_data['description']);
        $smarty->assign('blog_cat_name', $blogcat_data['titel']);

        $select_blogkat_slide_query = xtc_db_query("SELECT * FROM " . TABLE_BLOG_CATIMG . " WHERE cat_id = '" . (int) $_GET['blog_cat'] . "' ORDER BY image_nr;");
        $i = 1;
        while ($select_blogkat_slide = xtc_db_fetch_array($select_blogkat_slide_query)) {
            $blogslide[$i] = array(
                'IMAGENR' => $select_blogkat_slide['image_nr'],
                'image_large' => $select_blogkat_slide['image']
            );
            $i++;
        }
        $smarty->assign('IMAES_SLIDER', $blogslide);

        $select_blogsubcat_query = xtc_db_query("SELECT *
						  FROM " . TABLE_BLOG_CATEGORIES . " 
						  WHERE status = 2 
						  AND language_id = '" . (int) $_SESSION['languages_id'] . "'
						  AND parent_id = '" . (int) $_GET['blog_cat'] . "' " . $group_check . " 
			");

        while ($blogcat = xtc_db_fetch_array($select_blogsubcat_query)) {
            $t_blog_url = xtc_href_link(FILENAME_BLOG, 'blog_cat=' . $blogcat['categories_id']);
            $blogcat_array[$blogc] = array(
                'CATEGORIE_ID' => $blogcat['categories_id'],
                'CATEGORIE_TITLE' => $blogcat['titel'],
                'CATEGORIE_LINK' => $t_blog_url,
                'ITEMS' => '',
                'URL' => $t_blog_url);

            $select_items_query = xtc_db_query("SELECT *
                                                  FROM " . TABLE_BLOG_ITEMS . " 
                                                  WHERE status = 2  
                                                  AND categories_id = '" . (int) $blogcat['categories_id'] . "' 
                                                  AND language_id = '" . (int) $_SESSION['languages_id'] . "' " . $group_check . " 
												  GROUP BY item_id 
												  " . $order_by . ";");

            while ($select_items = xtc_db_fetch_array($select_items_query)) {
                $t_item_url = xtc_href_link(FILENAME_BLOG, 'blog_cat=' . (int) $_GET['blog_cat'] . '&blog_item=' . $select_items['item_id']);
				if($select_items['calender'] != '0'){
					$mdate = $select_items['datestart'];
				}else{
					$mdate = $select_items['date2'];
				}
                list($blog_jahr_list, $monat_raw,$blog_tag_list) = explode("-", $mdate);
                $blog_monat_list = strftime('%b', mktime(0, 0, 0, $monat_raw, $blog_tag_list, $blog_jahr_list));
                $blogcat_array[$blogc]['ITEMS'][$item] = array('title' => $select_items['title'],
                    'name' => $select_items['name'],
                    'blog_image' => $select_items['blog_image'],
                    'shortdesc' => $select_items['shortdesc'],
                    'date' => $select_items['date'],
                    'tag' => $blog_tag_list,
                    'monat' => $blog_monat_list,
                    'jahr' => $blog_jahr_list,
                    'date_update' => $select_items['date_update'],
                    'blog_link' => $t_item_url);
                $item++;
            }
            $blogc++;
        }
		
        $smarty->assign('blog_subcats', $blogcat_array);
        $smarty->assign('BLOG', true);

        $items = array();
        $select_myitems_query = xtc_db_query("SELECT *
                                                  FROM " . TABLE_BLOG_ITEMS . " 
                                                  WHERE status = 2  
                                                  AND categories_id = '" . (int) $_GET['blog_cat'] . "' 
                                                  AND language_id = '" . (int) $_SESSION['languages_id'] . "' " . $group_check . " 
												  GROUP BY item_id 
												  " . $order_by . ";");

        while ($select_items = xtc_db_fetch_array($select_myitems_query)) {
            $previewimage = '';
            if ($select_items['blog_image'] != '') {
                $previewimage = xtc_image('images/blog_image/thumbnail_images/' . $select_items['blog_image'], $select_items['name'], $select_items['title']);
                if (!file_exists(DIR_WS_IMAGES . 'blog_image/thumbnail_images/' . $select_items['blog_image'])) {
                    $previewimage = xtc_image(DIR_WS_IMAGES . 'blog_image/original_images/no_img_big.jpg', $select_items['name']);
                }
            }
				if($select_items['calender'] != '0'){
					$mdate = $select_items['datestart'];
				}else{
					$mdate = $select_items['date2'];
				}			
            list($blog_jahr_list, $monat_raw,$blog_tag_list) = explode("-", $mdate);
            $blog_monat_list = strftime('%b', mktime(0, 0, 0, $monat_raw, $blog_tag_list, $blog_jahr_list));
            $t_item_url = xtc_href_link(FILENAME_BLOG, 'blog_cat=' . (int) $_GET['blog_cat'] . '&blog_item=' . $select_items['item_id']);

            $items[] = array('title' => $select_items['title'],
                'name' => $select_items['name'],
                'shortdesc' => $select_items['shortdesc'],
                'image' => $previewimage,
                'date' => $select_items['date'],
                'tag' => $blog_tag_list,
                'monat' => $blog_monat_list,
                'jahr' => $blog_jahr_list,
                'date_update' => $select_items['date_update'],
                'blog_link' => $t_item_url);
        }

        $smarty->assign('blog_items', $items);
        $smarty->assign('BLOG', true);
    } elseif ((isset($_GET['blog_cat']) && is_numeric($_GET['blog_cat'])) && (isset($_GET['blog_item']) && is_numeric($_GET['blog_item']))) {
        //Slider
        $slider_smarty = new smarty;
        $slider_smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
        $coo_slider = cseohookfactory::create_object('SliderManager');
        $t_view_html = $coo_slider->proceed($_GET['blog_item'], 'blogitem');
        if (is_array($t_view_html)) {
            foreach ($t_view_html AS $t_key => $t_value) {
                $slider_smarty->assign($t_key, $t_value);
            }
        }
        if (!CacheCheck()) {
            $slider_smarty->caching = false;
            $slider_content = $slider_smarty->fetch(cseo_get_usermod('base/module/slider_content.html', USE_TEMPLATE_DEVMODE));
        } else {
            $slider_smarty->caching = true;
            $slider_smarty->cache_lifetime = CACHE_LIFETIME;
            $slider_smarty->cache_modified_check = CACHE_CHECK;
            $cache_id = $_SESSION['language'] . $_SESSION['currency'] . $_SESSION['customer_id'] . (int) $_GET['blog_item'] . 'slider';
            $slider_content = $slider_smarty->fetch(cseo_get_usermod('base/module/slider_content.html', USE_TEMPLATE_DEVMODE), $cache_id);
        }
        $smarty->assign('slider_content', $slider_content);
        if (GROUP_CHECK == 'true') {
            $group_data = xtc_db_fetch_array(xtc_db_query("SELECT group_ids FROM " . TABLE_BLOG_ITEMS . " WHERE group_ids LIKE '%c_" . (int) $_SESSION['customers_status']['customers_status_id'] . "_group%' AND categories_id = '" . $_GET['blog_item'] . "';"));
            if ($group_data != '') {
                
            } else {
                xtc_redirect(FILENAME_DEFAULT);
            }
        }
        xtDBquery("UPDATE " . TABLE_BLOG_ITEMS . " SET item_viewed = item_viewed+1 WHERE item_id = '" . xtc_db_input((int) $_GET['blog_item']) . "' AND language_id = '" . (int) $_SESSION['languages_id'] . "';");

        $select_item = xtc_db_fetch_array(xtc_db_query("SELECT *
										FROM " . TABLE_BLOG_ITEMS . "
										WHERE status = '2'
										AND item_id = '" . xtc_db_input($_GET['blog_item']) . "'
										AND categories_id = '" . xtc_db_input($_GET['blog_cat']) . "'
										" . $group_check . "
										AND language_id = '" . (int) $_SESSION['languages_id'] . "'
										GROUP BY item_id;"));

        $breadcrumb->add($select_item['name'], xtc_href_link(FILENAME_BLOG, 'blog_cat=' . xtc_db_input($_GET['blog_cat']) . '&blog_item=' . xtc_db_input($select_item['item_id'])));
        if (COMMENTS == 'ja') {
            xtDBquery("UPDATE " . TABLE_BLOG_COMMENT . " SET comment_read = comment_read+1 WHERE blog_id = '" . xtc_db_input($_GET['blog_item']) . "' AND comment_status = '1';");
            include (DIR_WS_MODULES . 'blog_comments.php');
        }

		if($select_items['calender'] != ''){
				$mdate = $select_item['datestart'];
		}else{
				$mdate = $select_item['date2'];
		}			
		list($blog_jahr_list, $monat_raw,$blog_tag_list) = explode("-", $mdate);
        $blog_monat_list = strftime('%b', mktime(0, 0, 0, $monat_raw, $blog_tag_list, $blog_jahr_list));
        $desc = $select_item['description'];
        $desc = preg_replace('/##(\w+)/', '<a href="' . xtc_href_link('hashtag/\1') . '">#\1</a>', $desc);

        $blog_monat = $monats_name[$monat_raw];
        $smarty->assign('TAG', $blog_tag_list);
        $smarty->assign('MONAT', $blog_monat_list);
        $smarty->assign('JAHR', $blog_jahr_list);
        $smarty->assign('NAME', $select_item['name']);
        $smarty->assign('TITEL', $select_item['title']);
        $smarty->assign('TEXT', $desc);
        $smarty->assign('img_path', 'templates/' . CURRENT_TEMPLATE . '/img/bookmark/');

        $myblocks = array();
        $myblocks_query1 = xtc_db_query("SELECT * FROM " . TABLE_BLOG_ITEMTEXT . " WHERE item_id = " . (int) $_GET['blog_item'] . " AND language_id = '" . (int) $_SESSION['languages_id'] . "' GROUP BY item_id;");
        $i = 1;
        while ($mytext = xtc_db_fetch_array($myblocks_query1)) {
            $myblocks[$i]['position'] .= $mytext['position'];
            $myblocks[$i]['typ'] .= 'Textarea';
            $myblocks[$i]['tblock_id'] .= $mytext['tblock_id'];
            $myblocks[$i]['description'] .= $mytext['description'];
            $i++;
        }

        $myblocks_query2 = xtc_db_query("SELECT slid_id, position, width, height, floating  FROM " . TABLE_BLOG_ITEMIMG . " WHERE item_id = " . (int) $_GET['blog_item'] . " GROUP BY item_id;");
        while ($mytext = xtc_db_fetch_array($myblocks_query2)) {
            $myblocks[$i]['position'] .= $mytext['position'];
            $myblocks[$i]['typ'] .= 'SlideShow';
            $myblocks[$i]['tblock_id'] .= $mytext['slid_id'];
            $myblocks[$i]['width'] .= $mytext['width'];
            $myblocks[$i]['height'] .= $mytext['height'];
            $myblocks[$i]['floating'] .= $mytext['floating'];

            $myblocks_query8 = xtc_db_query("SELECT * FROM " . TABLE_BLOG_ITEMIMG . " WHERE item_id = " . (int) $_GET['blog_item'] . " AND slid_id = " . (int) $mytext['slid_id'] . ";");
            $e = 1;
            while ($mytext2 = xtc_db_fetch_array($myblocks_query8)) {
                if ($mytext2['image'] == '') {
                    $mytext['image'] = 'noimage.gif';
                }
                $myblocks[$i]['description'][$e]['image'] .= $mytext2['image'];
                $e++;
            }
            $i++;
        }
        $smarty->assign('mycount', $mycount);

        $myblocks_query3 = xtc_db_query("SELECT * FROM " . TABLE_BLOG_ITEMKAT . " WHERE item_id = " . (int) $_GET['blog_item'] . " AND language_id = '" . (int) $_SESSION['languages_id'] . "' GROUP BY item_id;");
        while ($mytext = xtc_db_fetch_array($myblocks_query3)) {
            require 'includes/modules/products_cat_main.php';
            $myblocks[$i]['position'] .= $mytext['position'];
            $myblocks[$i]['typ'] .= 'Kategorie';
            $myblocks[$i]['tblock_id'] .= $mytext['kat_id'];
            $myblocks[$i]['description'] .= $main_kcatend;
            $i++;
        }

        $myblocks_query4 = xtc_db_query("SELECT * FROM " . TABLE_BLOG_ITEMART . " WHERE item_id = " . (int) $_GET['blog_item'] . " AND language_id = '" . (int) $_SESSION['languages_id'] . "' GROUP BY item_id;");
        while ($mytext = xtc_db_fetch_array($myblocks_query4)) {
            require 'includes/modules/products_blog_main.php';
            $myblocks[$i]['position'] .= $mytext['position'];
            $myblocks[$i]['typ'] .= 'Artikel';
            $myblocks[$i]['tblock_id'] .= $mytext['art_id'];
            $myblocks[$i]['description'] .= $new_main_content;
            $i++;
        }

        $myblocks_query5 = xtc_db_query("SELECT * FROM " . TABLE_BLOG_ITEMITEM . " WHERE item_id = " . (int) $_GET['blog_item'] . " AND language_id = '" . (int) $_SESSION['languages_id'] . "' GROUP BY item_id;");
        while ($mytext = xtc_db_fetch_array($myblocks_query5)) {
            require 'includes/modules/products_item_main.php';
            $myblocks[$i]['position'] .= $mytext['position'];
            $myblocks[$i]['typ'] .= 'Blogbeitrag';
            $myblocks[$i]['tblock_id'] .= $mytext['bitem_id'];
            $myblocks[$i]['description'] .= $itemmodule;
            $i++;
        }

        if ($myblocks != '') {
            $myblocks = $blogobject->array_sort($myblocks, 'position', SORT_ASC);
            $smarty->assign('BLOECKE', $myblocks);
            $smarty->assign('myitem', (int) $_GET['blog_item']);
        }

        $smarty->caching = false;
    }
    require_once (DIR_WS_INCLUDES . 'header.php');

    $smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
    $smarty->assign('txt', $coo_text_mgr->v_section_content_array['blog']);
    $smarty->assign('language', $_SESSION['language']);

    $cseo_blog = cseohookfactory::create_object('BlogExtender');
    $cseo_blog->proceed();
    $cseo_extender_result_array = $cseo_blog->get_response();
    if (is_array($cseo_extender_result_array)) {
        foreach ($cseo_extender_result_array AS $t_key => $t_value) {
            $smarty->assign($t_key, $t_value);
        }
    }
    if (!CacheCheck()) {
        $smarty->caching = false;
		if (file_exists('templates/'.CURRENT_TEMPLATE.'/module/blog.html')) {
			$main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE.'/module/blog.html', USE_TEMPLATE_DEVMODE));
		}else{
			$main_content = $smarty->fetch(cseo_get_usermod('base/module/blog.html', USE_TEMPLATE_DEVMODE));
		}
    } else {
        $smarty->caching = true;
        $smarty->cache_lifetime = CACHE_LIFETIME;
        $smarty->cache_modified_check = CACHE_CHECK;
        $cache_id = $_GET['blog_cat'] . $_GET['blog_item'] . $_SESSION['language'] . $_SESSION['customers_status']['customers_status_name'] . $_SESSION['currency'] . 'blogicl';
		if (file_exists('templates/'.CURRENT_TEMPLATE.'/module/blog.html')) {
			$main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE.'/module/blog.html', USE_TEMPLATE_DEVMODE, $cache_id));
		}else{
			$main_content = $smarty->fetch(cseo_get_usermod('base/module/blog.html', USE_TEMPLATE_DEVMODE, $cache_id));
		}
    }
}

$smarty->loadFilter('output', 'note');
$smarty->loadFilter('output', 'trimwhitespace');

$smarty->assign('main_content', $main_content);
$smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));

include ('includes/application_bottom.php');
