<?php
#########################################################
#                                                       #
#  CC / CREDIT CARD 3d secure payment method class      #
#  This module is used for real time processing of      #
#  Credit card data of customers on 3d secure mode.     #
#                                                       #
#  Copyright (c) 2009-2010 Novalnet AG                  #
#                                                       #
#  Released under the GNU General Public License        #
#  novalnet_cc_pci module Created By Dixon Rajdaniel    #
#  This free contribution made by request.              #
#  If you have found this script usefull a small        #
#  recommendation as well as a comment on merchant form #
#  would be greatly appreciated.                        #
#                                                       #
#  Version : novalnet_cc_pci.php 1.0.0 2010-06-16       #
#                                                       #
#########################################################


class novalnet_cc_pci {
  var $code;
  var $title;
  var $description;
  var $enabled;
  var $is_ajax = false;

  function novalnet_cc_pci() {
    global $order;

    $this->code         = 'novalnet_cc_pci';
    $this->title        = MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_TITLE;
    $this->public_title = MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_PUBLIC_TITLE;
    $this->description  = MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_DESCRIPTION;
    $this->sort_order   = MODULE_PAYMENT_NOVALNET_CC_PCI_SORT_ORDER;
    $this->enabled      = ((MODULE_PAYMENT_NOVALNET_CC_PCI_STATUS == 'True') ? true : false);
    $this->proxy        = MODULE_PAYMENT_NOVALNET_CC_PCI_PROXY;
	
	if (CHECKOUT_AJAX_STAT=='true') { $this->is_ajax = true; }

    if ((int)MODULE_PAYMENT_NOVALNET_CC_PCI_ORDER_STATUS_ID > 0) {
      $this->order_status = MODULE_PAYMENT_NOVALNET_CC_PCI_ORDER_STATUS_ID;
    }

    if (is_object($order)) $this->update_status();
    $this->form_action_url = 'https://payport.novalnet.de/pci_payport';
    if($_POST['session']) {
      #$this->debug2($_POST['tid'].", ".$_POST['status'].", ".$_POST['session'].", ".$_COOKIE['XTCsid'], $filename='cc_pci.txt', $debug = true);
      $this->checkSecurity();
    }
  }
  
  ### calculate zone matches and flag settings to determine whether this module should display to customers or not ###
  function update_status() {
    global $order;

    if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_NOVALNET_CC_PCI_ZONE > 0) ) {
      $check_flag = false;
      $check_query = xtc_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_NOVALNET_CC_PCI_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = xtc_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

      if ($check_flag == false) {
        $this->enabled = false;
      }
    }
  }
  
  ### JS validation which does error-checking of data-entry if this module is selected for use ###
  ### the fields to be cheked are (Bank Owner, Bank Account Number and Bank Code Lengths)      ###
  ### currently this function is not in use ###
  // @return string
  function javascript_validation() {
    return false;
  }
 
  ### Builds set of input fields for collecting Bankdetail info ###
  // @return array
  function selection() {
    global $xtPrice, $order, $HTTP_POST_VARS, $_POST;

    $onFocus = '';
    if(count($HTTP_POST_VARS)==0 || $HTTP_POST_VARS=='') $HTTP_POST_VARS = $_POST;

    $selection = array('id' => $this->code,
                       'module' => $this->public_title,
                        'fields' => array(array())
                      );

    if(function_exists(get_percent))
    {
        $selection['module_cost'] = $GLOBALS['ot_payment']->get_percent($this->code);
    }

    return $selection;
  }

  ### Precheck to Evaluate the Bank Datas ###
  function pre_confirmation_check($vars) {
	
    $error = '';

    if (defined('MODULE_PAYMENT_NOVALNET_CC_PCI_MANUAL_CHECK_LIMIT') and MODULE_PAYMENT_NOVALNET_CC_PCI_MANUAL_CHECK_LIMIT){
      if ( (!defined('MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID2') or !MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID2 or preg_match('/[^\d]/', MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID2)) or (!defined('MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID2') or !MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID2 or preg_match('/[^\d]/', MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID2))){
          $error = 'Product-ID2 and/or Tariff-ID2 missing';
      }
    }

    if(!MODULE_PAYMENT_NOVALNET_CC_PCI_VENDOR_ID || !MODULE_PAYMENT_NOVALNET_CC_PCI_AUTH_CODE || !MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID || !MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID)
    {
      $error = MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_JS_NN_MISSING;
    }

    if($error!='') {
      $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode(utf8_encode($error));
	  if ($this->is_ajax) {
			$_SESSION['checkout_payment_error'] = $payment_error_return;
		} else {
			xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
		}
    }
  }

  ### Display Information on the Checkout Confirmation Page ###
  // @return array
  function confirmation() {
    global $HTTP_POST_VARS, $_POST, $order;

    if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
      $total = $order->info['total'] + $order->info['tax'];
    } else {
      $total = $order->info['total'];
    }
    $_SESSION['nn_total_cc_pci'] = sprintf('%.2f', $total);

    if(count($HTTP_POST_VARS)==0 || $HTTP_POST_VARS=='') $HTTP_POST_VARS = $_POST;

    return $confirmation;
  }
//This is user defined function used for getting order amount in cents with tax
  public function findTotalAmount(){
		global $order;
		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
		  $total = $order->info['total'] + $order->info['tax'];
		} else {
		  $total = $order->info['total'];
		}
		if (preg_match('/[^\d\.]/', $total) or !$total){
			### $amount contains some unallowed chars or empty ###
			$err                      = 'amount ('.$total.') is empty or has a wrong format';
			$payment_error_return     = 'payment_error='.$this->code.'&error='.utf8_encode($err);
			if ($this->is_ajax) {
				$_SESSION['checkout_payment_error'] = $payment_error_return;
			} else {
				xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
			}
		}
		$amount = sprintf('%0.2f', $total);
		$amount = preg_replace('/^0+/', '', $amount);
		$amount = str_replace('.', '', $amount);
	return $amount;
  }
  ### Build the data and actions to process when the "Submit" button is pressed on the order-confirmation screen. ###
  ### These are hidden fields on the checkout confirmation page ###
  // @return string
  function process_button() {
    global $order, $currencies, $customer_id;

    #Get the required additional customer details from DB
    $customer_query = xtc_db_query("SELECT customers_gender, customers_dob, customers_fax FROM ". TABLE_CUSTOMERS . " WHERE customers_id='". (int)$customer_id ."'");
    $customer = xtc_db_fetch_array($customer_query);

    list($customer['customers_dob'], $extra) = explode(' ', $customer['customers_dob']);

    $amount = $this->findTotalAmount();
    
    $product_id = MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID;
    $tariff_id = MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID;
    $manual_check_limit = trim(MODULE_PAYMENT_NOVALNET_CC_PCI_MANUAL_CHECK_LIMIT);
    $manual_check_limit = str_replace(',', '', $manual_check_limit);
    $manual_check_limit = str_replace('.', '', $manual_check_limit);

    if($manual_check_limit && $amount>=$manual_check_limit)
    {
      $product_id = MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID2;
      $tariff_id = MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID2;
    }

    $user_ip = $this->getRealIpAddr();
	
	if($this->is_ajax) 
		$checkout_url = xtc_href_link(FILENAME_CHECKOUT, '', 'SSL');
	else 
		$checkout_url = xtc_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL');

    if(strstr($checkout_url, '?'))
    {
      $checkout_url = str_replace(' ', '', $checkout_url);
      if(substr($checkout_url,-1)=='?')$error_url = $checkout_url.'payment_error=novalnet_cc_pci&error=$ERROR_MESSAGE ($STATUS)';
      else $error_url = $checkout_url.'&payment_error=novalnet_cc_pci&error=$ERROR_MESSAGE ($STATUS)';
    }
    else $error_url = $checkout_url.'?payment_error=novalnet_cc_pci&error=$ERROR_MESSAGE ($STATUS)';

    $test_mode = (strtolower(MODULE_PAYMENT_NOVALNET_CC_PCI_TEST_MODE) == 'true' or MODULE_PAYMENT_NOVALNET_CC_PCI_TEST_MODE == '1')? 1: 0;

    $process_button_string = xtc_draw_hidden_field('vendor_id', MODULE_PAYMENT_NOVALNET_CC_PCI_VENDOR_ID) .
       xtc_draw_hidden_field('product_id', $product_id) .
       xtc_draw_hidden_field('payment_id', '6') .
       xtc_draw_hidden_field('tariff_id', $tariff_id) .
       xtc_draw_hidden_field('vendor_authcode', MODULE_PAYMENT_NOVALNET_CC_PCI_AUTH_CODE) .
       xtc_draw_hidden_field('currency', $order->info['currency']) .
       xtc_draw_hidden_field('amount', $amount) .
       xtc_draw_hidden_field('gender', 'u') .
       xtc_draw_hidden_field('firstname', $this->html_to_utf8($order->customer['firstname'])) .
       xtc_draw_hidden_field('lastname', $this->html_to_utf8($order->customer['lastname'])) .
       xtc_draw_hidden_field('email', $order->customer['email_address']) .
       xtc_draw_hidden_field('street', $this->html_to_utf8($order->customer['street_address'])) .
       #xtc_draw_hidden_field('house_no', '2') .
       xtc_draw_hidden_field('search_in_street', '1') .
       xtc_draw_hidden_field('city', $this->html_to_utf8($order->customer['city'])) .
       xtc_draw_hidden_field('zip', $order->customer['postcode']) .
       xtc_draw_hidden_field('country_code', $order->customer['country']['iso_code_2']) .
       xtc_draw_hidden_field('lang', MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_LANG) .
       xtc_draw_hidden_field('remote_ip', $user_ip) .
       xtc_draw_hidden_field('tel', $order->customer['telephone']) .
       xtc_draw_hidden_field('fax', $customer['customers_fax']) .
       xtc_draw_hidden_field('birthday', $customer['customers_dob']) .
       xtc_draw_hidden_field('session', $_COOKIE['XTCsid']) .
       xtc_draw_hidden_field('return_url', xtc_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')) .
       #xtc_draw_hidden_field('return_url', xtc_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL')) .
       xtc_draw_hidden_field('return_method', 'POST') .
       xtc_draw_hidden_field('error_return_url', $error_url) .
       xtc_draw_hidden_field('test_mode', $test_mode) .
       xtc_draw_hidden_field('error_return_method', 'POST');

    return $process_button_string;
  }

  ### Insert the Novalnet Transaction ID in DB ###
  function before_process() {
    global $_POST, $order;
    
    $test_mode = (strtolower(MODULE_PAYMENT_NOVALNET_CC_PCI_TEST_MODE) == 'true' or MODULE_PAYMENT_NOVALNET_CC_PCI_TEST_MODE == '1')? 1: 0;
	if ($test_mode){
		$order->info['comments'] .= MODULE_PAYMENT_NOVALNET_CC_PCI_TEST_ORDER_MESSAGE;
	}	
	$order->info['comments'] .= MODULE_PAYMENT_NOVALNET_CC_PCI_TID_MESSAGE.$_POST['tid'];
  }

  function isPublicIP($value)
  {
        if(!$value || count(explode('.',$value))!=4) return false;
        return !preg_match('~^((0|10|172\.16|192\.168|169\.254|255|127\.0)\.)~', $value);
  }

  ### get the real Ip Adress of the User ###
  function getRealIpAddr()
  {
        if($this->isPublicIP($_SERVER['HTTP_X_FORWARDED_FOR'])) return $_SERVER['HTTP_X_FORWARDED_FOR'];
        if($iplist=explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']))
        {
            if($this->isPublicIP($iplist[0])) return $iplist[0];
        }
        if ($this->isPublicIP($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
        if ($this->isPublicIP($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
        if ($this->isPublicIP($_SERVER['HTTP_FORWARDED_FOR']) ) return $_SERVER['HTTP_FORWARDED_FOR'];

        return $_SERVER['REMOTE_ADDR'];
  }

  ### replace the Special German Charectors ###
  function ReplaceSpecialGermanChars($string)
  {
     $what = array("ä", "ö", "ü", "Ä", "Ö", "Ü", "ß");
     $how = array("ae", "oe", "ue", "Ae", "Oe", "Ue", "ss");

     $string = str_replace($was, $wie, $string);

     return $string;
  }

 ### Send the order detail to Novalnet ###
  function after_process() {
    global $order, $insert_id;

    if ($this->order_status){
      xtc_db_query("UPDATE ".TABLE_ORDERS." SET orders_status='".$this->order_status."' WHERE orders_id='".$insert_id."'");
    }

	  /*
    $product_id = MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID;
    $tariff_id = MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID;

    ### Pass the Order Reference to paygate ##
    $url = 'https://payport.novalnet.de/paygate.jsp';

    $status = '';
    if($_SESSION['nn_tid_ccpci'])
    {  
      $urlparam = 'vendor='.MODULE_PAYMENT_NOVALNET_CC_PCI_VENDOR_ID.'&product='.$product_id.'&key=6&tariff='.$tariff_id;
      $urlparam .= '&auth_code='.MODULE_PAYMENT_NOVALNET_CC_PCI_AUTH_CODE.'&status=100&tid='.$_SESSION['nn_tid_ccpci'].'&reference=BNR-'.$insert_id.'&vwz2='.MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_ORDERNO.''.$insert_id.'&vwz3='.MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_ORDERDATE.''.date('Y-m-d H:i:s');
      list($errno, $errmsg, $data) = $this->perform_https_request($url, $urlparam);
    }
    else
    {
      
    }

    if($errno or $errmsg) {
      ### Payment Gateway Error ###
      $order->info['comments'] .= '. func perform_https_request returned Errorno : '.$errno.', Error Message : '.$errmsg;
      $payment_error_return = 'payment_error=' . $this->code . '&error=' .$errmsg. '('.$errno.')';
      xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
    }

    $_SESSION['nn_tid_ccpci'] = '';
    */
    #print "$customer_id, $insert_id"; exit;
    ### Implement here the Emailversand and further functions, incase if you want to send a own email ###

    return false;
  }

  ### Used to display error message details ###
  // @return array
  function get_error() {
    global $HTTP_GET_VARS, $_GET;
    if(count($HTTP_GET_VARS)==0 || $HTTP_GET_VARS=='') $HTTP_GET_VARS = $_GET;

    #$error = array('title' => MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_ERROR,
    #               'error' => stripslashes(urldecode($HTTP_GET_VARS['error'])));
    #print $HTTP_GET_VARS['error']; exit;
    $error = array('title' => MODULE_PAYMENT_NOVALNET_CC_PCI_TEXT_ERROR, 'error' => stripslashes(utf8_decode($HTTP_GET_VARS['error'])));

    return $error;
  }

  ### Check to see whether module is installed ###
  // @return boolean
  function check() {
    if (!isset($this->_check)) {
      $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_NOVALNET_CC_PCI_STATUS'");
      $this->_check = xtc_db_num_rows($check_query);
    }
    return $this->_check;
  }

  ### Install the payment module and its configuration settings ###
  function install() {

    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_ALLOWED', '', '6', '0', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_TEST_MODE', 'True', '6', '2', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_VENDOR_ID', '', '6', '3', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_AUTH_CODE', '', '6', '4', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID', '', '6', '5', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID', '', '6', '6', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_MANUAL_CHECK_LIMIT', '', '6', '7', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID2', '', '6', '8', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID2', '', '6', '9', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_BOOK_REF', '', '6', '10', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_SORT_ORDER', '0', '6', '11', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_ORDER_STATUS_ID', '0', '6', '12', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_ZONE', '0', '6', '13', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
    xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_NOVALNET_CC_PCI_PROXY', '', '6', '14', now())");
  }
   
  ### Remove the module and all its settings ###
  function remove() {
    xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }

  ### Internal list of configuration keys used for configuration of the module ###
  // @return array
  function keys() {
    return array('MODULE_PAYMENT_NOVALNET_CC_PCI_ALLOWED', 'MODULE_PAYMENT_NOVALNET_CC_PCI_STATUS', 'MODULE_PAYMENT_NOVALNET_CC_PCI_TEST_MODE', 'MODULE_PAYMENT_NOVALNET_CC_PCI_VENDOR_ID', 'MODULE_PAYMENT_NOVALNET_CC_PCI_AUTH_CODE', 'MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID', 'MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID', 'MODULE_PAYMENT_NOVALNET_CC_PCI_MANUAL_CHECK_LIMIT', 'MODULE_PAYMENT_NOVALNET_CC_PCI_PRODUCT_ID2', 'MODULE_PAYMENT_NOVALNET_CC_PCI_TARIFF_ID2', 'MODULE_PAYMENT_NOVALNET_CC_PCI_BOOK_REF', 'MODULE_PAYMENT_NOVALNET_CC_PCI_SORT_ORDER', 'MODULE_PAYMENT_NOVALNET_CC_PCI_ORDER_STATUS_ID', 'MODULE_PAYMENT_NOVALNET_CC_PCI_ZONE', 'MODULE_PAYMENT_NOVALNET_CC_PCI_PROXY');
  }

	function html_to_utf8 ($data)
	{
		return preg_replace("/\\&\\#([0-9]{3,10})\\;/e", '$this->_html_to_utf8("\\1")', $data);
	}

	function _html_to_utf8 ($data)
	{
		if ($data > 127)
		{
			$i = 5;
			while (($i--) > 0)
			{
				if ($data != ($a = $data % ($p = pow(64, $i))))
				{
					$ret = chr(base_convert(str_pad(str_repeat(1, $i + 1), 8, "0"), 2, 10) + (($data - $a) / $p));
					for ($i; $i > 0; $i--)
						$ret .= chr(128 + ((($data % pow(64, $i)) - ($data % ($p = pow(64, $i - 1)))) / $p));
					break;
				}
			}
		}
		else
		{
			$ret = "&#$data;";
		}
		return $ret;
	}

	### Realtime accesspoint for communication to the Novalnet paygate ###
  function perform_https_request($nn_url, $urlparam)
  {
      $debug = 0;#set it to 1 if you want to activate the debug mode

      if($debug) print "<BR>perform_https_request: $nn_url<BR>\n\r\n";
      if($debug) print "perform_https_request: $urlparam<BR>\n\r\n";

      ## some prerquisites for the connection
      $ch = curl_init($nn_url);
      curl_setopt($ch, CURLOPT_POST, 1);  // a non-zero parameter tells the library to do a regular HTTP post.
      curl_setopt($ch, CURLOPT_POSTFIELDS, $urlparam);  // add POST fields
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);  // don't allow redirects
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);  // decomment it if you want to have effective ssl checking
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  // decomment it if you want to have effective ssl checking
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  // return into a variable
      curl_setopt($ch, CURLOPT_TIMEOUT, 240);  // maximum time, in seconds, that you'll allow the CURL functions to take
      if ($this->proxy) {curl_setopt($ch, CURLOPT_PROXY, $this->proxy); }

      ## establish connection
      $data = curl_exec($ch);
      $data = $this->ReplaceSpecialGermanChars($data);

      ## determine if there were some problems on cURL execution
      $errno = curl_errno($ch);
      $errmsg = curl_error($ch);

      ###bug fix for PHP 4.1.0/4.1.2 (curl_errno() returns high negative value in case of successful termination)
      if($errno < 0) $errno = 0;
      ##bug fix for PHP 4.1.0/4.1.2

      if($debug)
      {
        print_r(curl_getinfo($ch));
        echo "\n<BR><BR>\n\n\nperform_https_request: cURL error number:" . $errno . "\n<BR>\n\n";
        echo "\n\n\nperform_https_request: cURL error:" . $errmsg . "\n<BR>\n\n";
      }

      #close connection
      curl_close($ch);

      ## read and return data from novalnet paygate
      if($debug) print "<BR>\n\n" . $data . "\n<BR>\n\n";

      return array ($errno, $errmsg, $data);
  }

  function debug2($object, $filename, $debug = false) {
    if (!$debug){return;}
    $fh = fopen("/tmp/$filename", 'a+');
      fwrite($fh, date('Y-m-d H:i:s').' '.print_r($object, true));
    fwrite($fh, "<hr />\n");
    fclose($fh);
  }

  function checkSecurity() {
    global $_POST, $order, $insert_id; 
   
    if(strlen(trim($_POST['tid']))==17 && $_POST['status']==100 && $_POST['session']==$_COOKIE['XTCsid']) 
    {
      #xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL'));
    }
    else
    {
      $err                      = $_POST['status_desc']." (".$_POST['status'].")";
      #'session missing or returned session is wrong';
      $order->info['comments'] .= '. Novalnet Error Message : '.$err;
      $payment_error_return     = 'payment_error='.$this->code.'&error='.utf8_encode($err);
	  if ($this->is_ajax) {
			xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, $payment_error_return, 'SSL', true, false));
		} else {
			xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
		}
     // xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
    }
  }
}
/*
flow of functions:
selection              -> $order-info['total'] wrong, cause shipping_cost is net
pre_confirmation_check -> $order-info['total'] wrong, cause shipping_cost is net
confirmation           -> $order-info['total'] right, cause shipping_cost is gross
process_button         -> $order-info['total'] right, cause shipping_cost is gross
before_process         -> $order-info['total'] wrong, cause shipping_cost is net
after_process          -> $order-info['total'] right, cause shipping_cost is gross
---------------
flow of url/path:
/xtcommerce/account.php
/xtcommerce/account_history_info.php
/xtcommerce/address_book.php
/xtcommerce/checkout_shipping.php
/xtcommerce/checkout_shipping.php
/xtcommerce/checkout_payment.php
/xtcommerce/checkout_confirmation.php
*/

?>
