<?php

/*
	$Id: checkout.php,v 1.1 2010/09/08 11:00:22 akausch Exp $
*/

// AJAX CHECKOUT PROCESS
include ('includes/application_top.php');
// create smarty elements
$smarty = new Smarty;
// create checkout object
require (DIR_WS_CLASSES . 'checkout.php');
$checkout = new Checkout;
// include boxes

if ($mobile_template == 'False') {
	require (DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/source/boxes.php');
} else {
	require (DIR_FS_CATALOG.'templates/'.CURRENT_MOBILE_TEMPLATE.'/source/boxes.php');
}
// required functions
require_once (DIR_FS_INC.'xtc_address_label.inc.php');
require_once (DIR_FS_INC.'xtc_get_address_format_id.inc.php');
require_once (DIR_FS_INC.'xtc_check_stock.inc.php');
require_once (DIR_FS_INC.'xtc_count_shipping_modules.inc.php');

require_once(DIR_WS_CLASSES . 'order_total.php');
require_once(DIR_WS_CLASSES . 'order.php');

// Is it an ajax request?
$is_xajax = (strlen($_POST['xajax']) > 4 || strlen($_POST['xjxfun']) > 4 || strlen($_GET['xajax']) > 4 || strlen($_GET['xjxfun']) > 4);

if (!$is_xajax) $_SESSION['cot_gv'] = false;
if (!$is_xajax && $_SESSION['payment'] == 'no_payment') unset($_SESSION['payment']);
if (!$is_xajax) unset($_SESSION['stat_luupws']);

// check if checkout is allowed
if ($_SESSION['allow_checkout'] == 'false')
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
	
// if the customer is not logged on, redirect them to the login page
if (!isset ($_SESSION['customer_id']) && !$is_xajax) {
	if (ACCOUNT_OPTIONS == 'guest') {
		xtc_redirect(xtc_href_link(FILENAME_CREATE_GUEST_ACCOUNT, '', 'SSL'));
	} else {
		xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
	}
}

// if there is nothing in the customers cart, redirect them to the shopping cart page
if ($_SESSION['cart']->count_contents() < 1 && !$is_xajax) {
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

// if no shipping destination address was selected, use the customers own address as default
if (!isset ($_SESSION['sendto'])) {
	$_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
} else {
	// verify the selected shipping address
	$check_address_query = xtc_db_query("select count(*) as total from ".TABLE_ADDRESS_BOOK." where customers_id = '".(int) $_SESSION['customer_id']."' and address_book_id = '".(int) $_SESSION['sendto']."'");
	$check_address = xtc_db_fetch_array($check_address_query);

	if ($check_address['total'] != '1') {
		$_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
		if (isset ($_SESSION['shipping']))
			unset ($_SESSION['shipping']);
	}
}

// if no billing destination address was selected, use the customers own address as default
if (!isset ($_SESSION['billto'])) {
	$_SESSION['billto'] = $_SESSION['customer_default_address_id'];
} else {
	// verify the selected billing address
	$check_address_query = xtc_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int) $_SESSION['customer_id'] . "' and address_book_id = '" . (int) $_SESSION['billto'] . "'");
	$check_address = xtc_db_fetch_array($check_address_query);

	if ($check_address['total'] != '1') {
		$_SESSION['billto'] = $_SESSION['customer_default_address_id'];
		if (isset ($_SESSION['payment']))
			unset ($_SESSION['payment']);
	}
}

if (!isset ($_SESSION['sendto']) || $_SESSION['sendto'] == "") {
	$_SESSION['sendto'] = $_SESSION['billto'];
}
$order = new order;
if ($order->delivery['country']['iso_code_2'] != '') {
	$_SESSION['delivery_zone'] = $order->delivery['country']['iso_code_2'];
}

// Bugifx - lb - 05.05.2011
if (isset ($_SESSION['credit_covers'])) {
        $_SESSION['payment'] = 'no_payment'; // GV Code Start/End ICW added for CREDIT CLASS
}
// load the selected payment module
require_once(DIR_WS_CLASSES . 'payment.php');
if (!$is_xajax)	{
	if (isset ($_SESSION['credit_covers'])) {
		$_SESSION['payment'] = 'no_payment'; // GV Code Start/End ICW added for CREDIT CLASS
	}	
	$order_total_modules = new order_total;
	require_once(DIR_WS_CLASSES.'shipping.php');
	$shipping_modules = new shipping;
	//$checkout->getShippingBlock($xtPrice);	
	//$order = new order;
	$payment_modules = new payment;
	
	// SHOW PAYMENT ERROR
	if (isset ($_GET['payment_error']) && is_object(${ $_GET['payment_error'] }) && ($error = ${$_GET['payment_error']}->get_error())) {
		$smarty->assign('error', htmlspecialchars($error['error']));
	} elseif (isset($_GET['error_c'])) {
          $smarty->assign('error', htmlspecialchars(defined($_GET['error_c']) ? constant($_GET['error_c']) : $_GET['error_c']));
    }
}
// register a random ID in the session to check throughout the checkout procedure
// against alterations in the shopping cart contents
$_SESSION['cartID'] = $_SESSION['cart']->cartID;

$virtual = $checkout->isVirtual();

$total_weight = $_SESSION['cart']->show_weight();
$total_count = $_SESSION['cart']->count_contents();

// load all enabled shipping modules
if (!$is_xajax) {
	$free_shipping = $checkout->isFreeShipping($order, $xtPrice);
	if ($free_shipping) {
		include (DIR_WS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_shipping.php');
	}
	$quotes = $shipping_modules->quote();
}
if (!$is_xajax) $payment_modules->update_status();

// Stock Check
$any_out_of_stock = false;
if (STOCK_CHECK == 'true') {
	for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
		if (xtc_check_stock($order->products[$i]['id'], $order->products[$i]['qty']))
			$any_out_of_stock = true;
	}
	// Out of Stock
	if ((STOCK_ALLOW_CHECKOUT != 'true') && ($any_out_of_stock == true))
		xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

// OUTPUT
$breadcrumb->add(NAVBAR_TITLE_1_CHECKOUT);
require (DIR_WS_INCLUDES.'header.php');

$module_smarty = new Smarty;

// PAYMENT STUFF
if ($order->info['total'] <= 0) {
	$gv_cover = 'true';
}

$cot_gv_stat = $_SESSION['cot_gv'] ? 1 : 0;

// Disable payment/shipping modules
if (!empty($_SESSION['shipping']['id']) && $_SESSION['shipping']['id'] != 'selfpickup_selfpickup' && !$is_xajax) {
	if (is_object($GLOBALS['cash'])) $GLOBALS['cash']->enabled = false;
}
if (!empty($_SESSION['shipping']['id']) && $_SESSION['shipping']['id'] == 'selfpickup_selfpickup' && !$is_xajax) {
	if (is_object($GLOBALS['cod'])) $GLOBALS['cod']->enabled = false;
}

// SHIPPING STUFF
if (!$is_xajax) $shipping_block = $checkout->getShippingBlock($xtPrice);
if(in_array('productsshipping.php', $check) || sizeof($check) <= 1)
	$smarty->assign('ONE_SHIPPING', ' dn');
$order = new order;
if (!$is_xajax) $payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);
$check = explode(';', MODULE_PAYMENT_INSTALLED);
if(sizeof($check) <= 1)
	$smarty->assign('ONE_PAYMENT', ' dn');

if (!$is_xajax) {
	$order = new order;
	$order_total_modules = new order_total();
	$order_total_modules->collect_posts();
	$order_total_modules->pre_confirmation_check();
	$order_total_modules->process();
	if (ACTIVATE_GIFT_SYSTEM == 'true') {
		$module_gift = $order_total_modules->credit_selection();
	}
}
// Which modules should be opened?
$smarty->assign('SHOW_STAT_PAYMENT_ADDRESS', $checkout->getStat('payment_address'));
$smarty->assign('SHOW_STAT_SHIPPING_ADDRESS', $checkout->getStat('shipping_address'));
$smarty->assign('SHOW_STAT_PAYMENT_MODULES', $checkout->getStat('payment_modules'));
$smarty->assign('SHOW_STAT_SHIPPING_MODULES', $checkout->getStat('shipping_modules'));
$smarty->assign('SHOW_STAT_COMMENTS', $checkout->getStat('comments'));
$smarty->assign('SHOW_STAT_PRODUCTS', $checkout->getStat('products'));
$smarty->assign('SHOW_STAT_AGB', $checkout->getStat('agb'));
$smarty->assign('SHOW_STAT_DSG', $checkout->getStat('dsg'));
$smarty->assign('SHOW_STAT_REVOCATION', $checkout->getStat('revocation'));

// FORM
$smarty->assign('FORM_ACTION', xtc_draw_form('checkout', $checkout->getFormUrl(), 'post', 'onSubmit="return checkout();"'));
$smarty->assign('FORM_END', '</form>');

// IP
$smarty->assign('CUSTOMERS_IP', $checkout->getIp());

// SHIPPING MODULES
$no_shippings = xtc_not_null(MODULE_SHIPPING_INSTALLED) ? 0 : 1;
$smarty->assign('NO_SHIPPINGS', $no_shippings);
$smarty->assign('FORM_ACTION_SHIPPING_MODULES', xtc_draw_form('form_shipping_modules', '', 'post', ''));
$smarty->assign('SHIPPING_BLOCK', $shipping_block);
$smarty->assign('BUTTON_SAVE_SHIPPING_MODULE', $checkout->getSaveModuleButton('shipping'));
$smarty->assign('FREE_SHIPPING', $free_shipping ? 1 : 0);
$smarty->assign('FREE_SHIPPING_DESCRIPTION', sprintf(FREE_SHIPPING_DESCRIPTION, $xtPrice->xtcFormat(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER, true, 0, true)).xtc_draw_hidden_field('shipping', 'free_free'));
$smarty->assign('FREE_SHIPPING_ICON', $quotes[$i]['icon']);


// PAYMENT MODULES
$no_payments = xtc_not_null(MODULE_PAYMENT_INSTALLED) ? 0 : 1;
$smarty->assign('NO_PAYMENTS', $no_payments);
$smarty->assign('FORM_ACTION_PAYMENT_MODULES', xtc_draw_form('form_payment_modules', '', 'post', ''));
$smarty->assign('PAYMENT_BLOCK', $payment_block);
$smarty->assign('GV_COVER', $gv_cover);
$smarty->assign('module_gift', $module_gift);
$smarty->assign('BUTTON_SAVE_PAYMENT_MODULE', $checkout->getSaveModuleButton('payment'));


// SHIPPING ADDRESS
$smarty->assign('VIRTUAL', $virtual);
$smarty->assign('TEXT_VIRTUAL', CHECKOUT_TEXT_VIRTUAL);
$smarty->assign('BUTTON_EDIT_SHIPPING_ADDRESS', $checkout->getEditAddressButton('shipping'));
$smarty->assign('BUTTON_BACK_SHIPPING_ADDRESS', $checkout->getBackButton('shipping'));
$smarty->assign('BUTTON_SAVE_SHIPPING_ADDRESS', $checkout->getSaveAddressButton('shipping'));
$smarty->assign('SHIPPING_ADDRESS_LABEL', xtc_address_label($_SESSION['customer_id'], $_SESSION['sendto'], true, ' ', '<br />'));
$smarty->assign('FORM_ACTION_SHIPPING_ADDRESS', xtc_draw_form('form_shipping_address', '', 'post', ''));

// PAYMENT ADDRESS
$smarty->assign('BUTTON_EDIT_PAYMENT_ADDRESS', $checkout->getEditAddressButton('payment'));
$smarty->assign('BUTTON_BACK_PAYMENT_ADDRESS', $checkout->getBackButton('payment'));
$smarty->assign('BUTTON_SAVE_PAYMENT_ADDRESS', $checkout->getSaveAddressButton('payment'));
$smarty->assign('PAYMENT_ADDRESS_LABEL', xtc_address_label($_SESSION['customer_id'], $_SESSION['billto'], true, ' ', '<br />'));
$smarty->assign('FORM_ACTION_PAYMENT_ADDRESS', xtc_draw_form('form_payment_address', '', 'post', ''));

// BOTH
require (DIR_WS_MODULES.'checkout_new_address.php');
$smarty->assign('ADDRESS_NEW_POSSIBLE', $checkout->newAddressPossible());

// PRODUCTS
$smarty->assign('PRODUCTS_BLOCK', $checkout->getProducts());
$smarty->assign('PRODUCTS_HOW_MUCH', $_SESSION['cart']->count_contents());

// COMMENTS
$smarty->assign('COMMENTS', xtc_draw_textarea_field('comments', 'soft', '60', '4', $_SESSION['comments'], 'style="width:99.8%"') . xtc_draw_hidden_field('comments_added', 'YES'));

// AGB
$smarty->assign('AGB',$checkout->getAGB('text'));
$smarty->assign('AGB_link',$checkout->getAGB('link'));
$smarty->assign('AGB_checkbox',$checkout->getAGB('checkbox'));
$smarty->assign('AGB_stat',$checkout->getAGB('stat'));
if (CHECKOUT_CHECKBOX_AGB == 'true') {
$smarty->assign('AGB_CHECKBOX','true');
}

// REVOCATION
$smarty->assign('REVOCATION',$checkout->getRevocation('text'));
$smarty->assign('REVOCATION_link',$checkout->getRevocation('link'));
$smarty->assign('REVOCATION_stat',$checkout->getRevocation('stat'));
$smarty->assign('REVOCATION_checkbox',$checkout->getRevocation('checkbox'));
if (CHECKOUT_CHECKBOX_REVOCATION == 'true') {
$smarty->assign('REVOCATION_CHECKBOX','true');
}

// Datenschutz
$smarty->assign('DSG',$checkout->getDSG('text'));
$smarty->assign('DSG_link',$checkout->getDSG('link'));
$smarty->assign('DSG_stat',$checkout->getDSG('stat'));
$smarty->assign('DSG_checkbox',$checkout->getDSG('checkbox'));
if (CHECKOUT_CHECKBOX_DSG == 'true') {
$smarty->assign('DSG_CHECKBOX','true');
}

// HIDDEN
$smarty->assign('HIDDEN_XAJAX',xtc_draw_hidden_field('checkout_xajax','1'));
if (is_object($GLOBALS[$_SESSION['payment']])) 	$smarty->assign('HIDDEN_PAYMENT',$GLOBALS[$_SESSION['payment']]->process_button());

// BUTTONS
$smarty->assign('BUTTON_ORDER','<a href="javascript:void(0)">'.xtc_image_button('button_confirm_order.gif',IMAGE_BUTTON_CONFIRM_ORDER,'onclick="checkout();"').'</a>');
$smarty->assign('BUTTON_ORDER_BACK','<a href="javascript:void(0)">'.xtc_image_button('button_back.gif',IMAGE_BUTTON_BACK,'onclick="javascript:history.back();"').'</a>');

// TOTAL
if (!$is_xajax) 
	$smarty->assign('ORDER_TOTAL',$checkout->getTotalBlock($order, $order_total_modules, $xtPrice));

// MAIN
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
if ($mobile_template == 'False') {
	$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/checkout.html');
} else {
	$main_content = $smarty->fetch(CURRENT_MOBILE_TEMPLATE.'/module/checkout.html');
}

$smarty->assign('main_content', $main_content);
$smarty->caching = 0;
if (!defined(RM))
	$smarty->load_filter('output', 'note');
	
if ($mobile_template == 'False') {
	$smarty->display(CURRENT_TEMPLATE.'/index.html');
} else {
	$smarty->display(CURRENT_MOBILE_TEMPLATE.'/index.html');
}	
include ('includes/application_bottom.php');
?>