<?php
/* -----------------------------------------------------------------------------------------
   $Id: wlp.php

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce / 2006 DITH-Software
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com
   (c) 2003         nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   (c) 2006 DITH-Software

   Anpassungen 20.01.2009
   Markus Mueller | www.connect-the-web.de | info@connect-the-web.de

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
defined( '_VALID_XTC' ) or die( 'Direct Access to this location is not allowed.' );

define('MODULE_WLP_TEXT_DESCRIPTION', 'Export - Wir-lieben-Preise.de <br>(PIPE | getrennt)');
define('MODULE_WLP_TEXT_TITLE', 'Wir-lieben-Preise.de - TXT V1.1');
define('MODULE_WLP_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_WLP_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis export/)');
define('MODULE_WLP_STATUS_DESC','Modulstatus');
define('MODULE_WLP_STATUS_TITLE','Status');
define('MODULE_WLP_CURRENCY_TITLE','W&auml;hrung');
define('MODULE_WLP_CURRENCY_DESC','Welche W&auml;hrung soll exportiert werden?');
define('EXPORT_YES','Nur Herunterladen');
define('EXPORT_NO','Am Server speichern');
define('MODULE_WLP_DELIVERY_COST_TITLE','<hr noshade><b>Versandkosten:</b>');
define('MODULE_WLP_DELIVERY_COST_DESC','Lassen Sie das Feld leer, wenn Sie die automatische Versandkostenanzeige in Ihrem Kundenkonto bei wir-lieben-preise.de aktiviert haben, ansonsten geben Sie hier die <b>Versandkosten als Bruttobetrag inkl. Steuer</b> ein (Format: Dezimaltrenner ist PUNKT), die f&uuml;r alle Artikel gelten soll. Die Eingabe von <b>0.00</b> bedeutet <b>versandkostenfrei</b>');
define('CURRENCY','<hr noshade><b>W&auml;hrung:</b>');
define('CURRENCY_DESC','W&auml;hrung in der Exportdatei');
define('EXPORT','Bitte den Sicherungsprozess AUF KEINEN FALL unterbrechen. Dieser kann einige Minuten in Anspruch nehmen.');
define('EXPORT_TYPE','<hr noshade><b>Speicherart:</b>');
define('EXPORT_STATUS_TYPE_WLP','<hr noshade><b>Kundengruppe:</b>');
define('EXPORT_STATUS_WLP','Bitte w&auml;hlen Sie die Kundengruppe, die die Basis f&uuml;r Produkte und den Preis bildet:</b>');
define('CAMPAIGNS','<hr noshade><b>Kampagnen:</b>');
define('CAMPAIGNS_DESC','Mit Kampagne zur Nachverfolgung verbinden.');

  class wlp {
    var $code, $title, $description, $enabled;

    function wlp() {
      global $order;

      $this->code = 'wlp';
      $this->img = 'images/export/wirliebenpreise.gif';
      $this->title = MODULE_WLP_TEXT_TITLE;
      $this->description = MODULE_WLP_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_WLP_SORT_ORDER;
      $this->enabled = ((MODULE_WLP_STATUS == 'True') ? true : false);
      }

    function process($file) {

    @xtc_set_time_limit(0);
    require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');

    //Kundengruppenpreise ermitteln
    $xtPrice = new xtcPrice($_POST['currencies'],$_POST['status']);

		if ($_POST['sumaurl'] == 'directurl') {
			require_once(DIR_FS_CATALOG.'inc/commerce_seo.inc.php');
			$CommerceSeo = new CommerceSeo();
		}			
	
   //Versandkosten, formattiert mit WР Т‘hrungsumrechnung
   if (isset($_POST['dlv']))
      {
      if (is_numeric($_POST['dlv']))
         {
         $deliverycost   = number_format ($xtPrice->xtcCalculateCurr($_POST['dlv']), 2, '.', '');
         }
      }

    //SQL
    $sql_query = " SELECT DISTINCT
                          pd.products_name,
                          pd.products_description,
                          p.products_price,
                          p.products_id,
                          p.products_image,
                          p.products_tax_class_id,
                          m.manufacturers_name
                          FROM
                          ".TABLE_PRODUCTS." p LEFT JOIN ".TABLE_MANUFACTURERS ." m ON p.manufacturers_id = m.manufacturers_id,
                          ".TABLE_PRODUCTS_DESCRIPTION." pd,
                          ".TABLE_PRODUCTS_TO_CATEGORIES." ptc,
                          ".TABLE_CATEGORIES." c
                          WHERE
                          p.products_id = ptc.products_id
                          AND
                          ptc.categories_id = c.categories_id
                          AND
                          p.products_status = '1'
                          AND
                          p.products_price > 0
                          AND
                          p.products_id = pd.products_id
                          AND
                          pd.language_id = '".$_SESSION['languages_id']."'
                          AND
                          c.categories_status = '1'
                          AND
                          p.products_fsk18 = '0' ";

                  if (GROUP_CHECK == 'true')
                     {
                     $group_check = "and p.group_permission_".$_POST['status']."=1 ";
                     }


                $sql_query.= $group_check." GROUP BY p.products_id";
                //                 echo $sql_query;

                $export_query =xtc_db_query($sql_query);


        while ($products = xtc_db_fetch_array($export_query))
              {
              $products_price = $xtPrice->xtcGetPrice($products['products_id'],
                                     false,
                                     1,
                                     $products['products_tax_class_id'],
                                     '');

              //Remove trash from description
              $products_description = $this->rem_trash($products['products_description'], "2");

              //Remove trash from name
              $products_name = $this->rem_trash(htmlentities(strip_tags($products['products_name'])), "2");

              //get products image
              if (!empty($products['products_image']))
                 {
                 $image = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_POPUP_IMAGES .$products['products_image'];
                 }
                 else {
                      $image = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_POPUP_IMAGES .'no_pic.jpg';
                      }


			if ($_POST['sumaurl'] == 'directurl') {
				$productURL = $CommerceSeo->getProductLink(xtc_product_link($products['products_id'], $products['products_name']),$connection,$_SESSION['languages_id']);
				if ($_POST['campaign']<>'') {
					$productURL .= '?'.$_POST['campaign'];
				}
			} else {
				$productURL = HTTP_CATALOG_SERVER . DIR_WS_CATALOG . 'product_info.php?'.xtc_product_link($products['products_id'], $products['products_name']);
				 if (!empty($_POST['campaign'])) {
                 $productURL.= '&'.$_POST['campaign'];
                 }
			}

             //get manufacturer
              if (empty($products['manufacturers_name']))
                 {
                 $manufacturer = '-';
                 }
                 else {
                      $manufacturer = $this->rem_trash($products['manufacturers_name'], "1");
                      }


            //create content
            if ($products_price>0)
               {

              $schema .=  $productURL  . "|" .
                          substr($products_name, 0, 255) . "|".
                          $products_description ."|".
                          $image ."|" .
                          number_format ($products_price, 2, '.', '') ."|" .
                          substr($manufacturer, 0, 255);


               if (isset ($deliverycost) && is_numeric($deliverycost))
                  {
                  $schema .= "|". $deliverycost ;
                  }

               $schema.=  "\n";

              } //Ende if Products_price > 0

            }


    // create File
    $fp = fopen(DIR_FS_DOCUMENT_ROOT.'export/' . $file, "w+");
    fputs($fp, $schema);
    fclose($fp);


    switch ($_POST['export']) {
        case 'yes':
            // send File to Browser
            $extension = substr($file, -3);
            $fp = fopen(DIR_FS_DOCUMENT_ROOT.'export/' . $file,"rb");
            $buffer = fread($fp, filesize(DIR_FS_DOCUMENT_ROOT.'export/' . $file));
            fclose($fp);
            header('Content-type: application/x-octet-stream');
            header('Content-disposition: attachment; filename=' . $file);
            echo $buffer;
            exit;

        break;
        }

    }

    function display() {

    $customers_statuses_array = xtc_get_customers_statuses();

    // build Currency Select
    $curr='';
    $currencies=xtc_db_query("SELECT code FROM ".TABLE_CURRENCIES);
    while ($currencies_data=xtc_db_fetch_array($currencies)) {
     $curr.=xtc_draw_radio_field('currencies', $currencies_data['code'],true).$currencies_data['code'].'<br>';
    }

    $campaign_array = array(array('id' => '', 'text' => TEXT_NONE));
        $campaign_query = xtc_db_query("select campaigns_name, campaigns_refID from ".TABLE_CAMPAIGNS." order by campaigns_id");
        while ($campaign = xtc_db_fetch_array($campaign_query)) {
        $campaign_array[] = array ('id' => 'refID='.$campaign['campaigns_refID'], 'text' => $campaign['campaigns_name'],);
        }

    return array('text' =>
                        EXPORT_STATUS_TYPE_WLP.'<br>'.
                        EXPORT_STATUS_WLP.'<br>'.
                        xtc_draw_pull_down_menu('status',$customers_statuses_array, '1').'<br>'.
                        CURRENCY.'<br>'.
                        CURRENCY_DESC.'<br>'.
                        $curr.
                        MODULE_WLP_DELIVERY_COST_TITLE.'<br>'.
                        xtc_draw_input_field('dlv', '').'<br>'.
                        MODULE_WLP_DELIVERY_COST_DESC.'<br>'.
                        CAMPAIGNS.'<br>'.
                        CAMPAIGNS_DESC.'<br>'.
                        xtc_draw_pull_down_menu('campaign',$campaign_array).'<br>'.
						'<b>'.MODULE_GOOGLEBASE_SUMAURL_TITLE.'</b><br />'.
						MODULE_GOOGLEBASE_SUMAURL_DESC.'<br />'.
						xtc_draw_radio_field('sumaurl', 'original',false).'keine SEO-URL<br />'.
						xtc_draw_radio_field('sumaurl', 'directurl',true).'commerceSEO-URL<br />'.							
                        EXPORT_TYPE.'<br>'.
                        EXPORT.'<br>'.
                        xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br>'.
                        xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br>'.
                        '<br>' . xtc_button(BUTTON_EXPORT) .
                        xtc_button_link(BUTTON_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=wlp')) . '<hr noshade>' .
                        '&raquo; <a href="'.HTTP_CATALOG_SERVER . DIR_WS_CATALOG.'export/'.MODULE_WLP_FILE.'" style="font-weight:bold">Standardlink zur Exportdatei</a><br>'.
                        '<br/><br />Dateistand: <br />wlp.php V1.1 vom 21.01.2009<br>erstellt/angepasst durch <br>::connect the web | Markus MРЎРЉller<br /><br /><a href="http://www.connect-the-web.de/alle-xt-Commerce-xtc-module.146.0.html" target="_blank"><b>Weitere Module von ::connect-the-web</b></a>');
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_WLP_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_WLP_FILE', 'wlp.txt',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_WLP_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_WLP_STATUS','MODULE_WLP_FILE');
    }


        function rem_trash($TextIn, $Modus) {
        /*
         Auslagerung und Anpassung durch DITH-Software / Thomas Huhn am 09.08.2006
         Р’В© DITH-Software
         KOntakt: Information@dith.de
         Diese Datei darf - sofern diese Information erhalten bleibt - uneingeschrР Т‘nkt weitergegeben werden.
         Wer Spenden mРЎвЂ chte darf das gerne per PayPal an Thomas.Huhn@dith.de tun *lol*
        */

            $Text = strip_tags($TextIn);

     switch ($Modus) {

             case 1:    // alles soll weg
            $Text = str_replace("<br>"," ",$Text);
            $Text = str_replace("<br />"," ",$Text);
            $Text = str_replace(";",", ",$Text);
            $Text = str_replace("'",", ",$Text);
            $Text = str_replace("\n"," ",$Text);
            $Text = str_replace("\r"," ",$Text);
            $Text = str_replace(" | "," ",$Text);
            $Text = str_replace("\v"," ",$Text);
            $Text = str_replace("\\n"," ",$Text);
            $Text = str_replace("\\r"," ",$Text);
            // Kein Break, also auch den Rest erledigen

            case 2:   // Nicht alles lРЎвЂ schen
            $Text = str_replace("\n","<br>",$Text);
            $Text = str_replace("\r","<br>",$Text);
            $Text = str_replace("&quot,", chr(34),$Text);
            $Text = str_replace("&quot;", chr(34),$Text);
            $Text = str_replace("\\n","<br>",$Text);
            $Text = str_replace("\\r","<br>",$Text);
            $Text = str_replace("|",", ",$Text);
            $Text = str_replace("&nbsp,"," ",$Text);
            $Text = str_replace("&nbsp;"," ",$Text);
            $Text = str_replace("&amp,","&",$Text);
            $Text = str_replace("&amp;","&",$Text);
            $Text = str_replace("РІР‚С›","",$Text);

            // Umlaute
            $Text = str_replace("& uuml","РЎРЉ",$Text);
            $Text = str_replace("& Auml","Р вЂќ",$Text);
            $Text = str_replace("& Uuml","Р В¬",$Text);
            $Text = str_replace("& auml","Р Т‘",$Text);
            $Text = str_replace("& Ouml","Р В¦",$Text);
            $Text = str_replace("& ouml","РЎвЂ ",$Text);
            $Text = str_replace("&uuml;","РЎРЉ",$Text);
            $Text = str_replace("&auml;","Р Т‘",$Text);
            $Text = str_replace("&ouml;","РЎвЂ ",$Text);
            $Text = str_replace("&auml,","Р Т‘",$Text);
            $Text = str_replace("&uuml,","РЎРЉ",$Text);
            $Text = str_replace("&ouml,","РЎвЂ ",$Text);
            $Text = str_replace("&Auml,","Р вЂќ",$Text);
            $Text = str_replace("&Uuml,","Р В¬",$Text);
            $Text = str_replace("&Ouml,","Р В¦",$Text);
            $Text = str_replace("&szlig;","Р Р‡",$Text);




            // Wenn Umlaute drin bleiben sollen dann diesen Block hier
            // mit /* und */ komplett auskommentieren
            /*
            $Text = str_replace("Р Т‘","ae",$Text);
            $Text = str_replace("РЎРЉ","ue",$Text);
            $Text = str_replace("РЎвЂ ","oe",$Text);
            $Text = str_replace("Р Р‡","ss",$Text);
            $Text = str_replace("Р вЂќ","Ae",$Text);
            $Text = str_replace("Р В¬","Ue",$Text);
            $Text = str_replace("Р В¦","Oe",$Text);
            */

            // bischen aufrР Т‘umen
            $Text = str_replace("<br><br>","<br>",$Text);
            $Text = str_replace("<br><br>","<br>",$Text);     // *lol*
            $Text = str_replace(",,",",",$Text);
            $Text = str_replace(chr(13)," ",$Text);
            $Text = substr($Text, 0, 65536);
            break;
            }


        return $Text;

        }

  }
?>