<?php
/*-----------------------------------------------------------------
* 	$Id: tagcloud.php 27 2015-03-02 21:04:30Z akausch $
* 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/

$box_smarty = new smarty;
require_once (DIR_WS_CLASSES . 'class.tagcloud.php');
if(!CacheCheck()) {
	$box_smarty->caching = false;
	$cache_id = '';
} else {
	$box_smarty->caching = true;
	$box_smarty->cache_lifetime=CACHE_LIFETIME;
	$box_smarty->cache_modified_check=CACHE_CHECK;
	$cache_id = $_SESSION['language'].$_SESSION['tag_box'].'tagcloud';
}

if(!$box_smarty->isCached(CURRENT_TEMPLATE.'/boxes/box_tagcloud.html', $cache_id) || !$cache){
	// $data_query = xtc_db_query("SELECT tag, count(tag) AS tag_anzahl, p.products_status
								// FROM tag_to_product 
								// JOIN ".TABLE_PRODUCTS." AS p ON(p.products_id = pID AND p.products_status = '1')
								// WHERE lID = '".(int)$_SESSION['languages_id']."'
								// GROUP BY tag
								// ORDER BY rand()
								// LIMIT ".MAX_DISPLAY_TAGS_RESULTS."");

	if(xtc_db_num_rows($data_query)) {
		$tag_array = array();
		while($data = xtc_db_fetch_array($data_query)) {
			if(!empty($data)) {
				$tag_array[$data['tag']] = $data['tag_anzahl'];
			}
		}
	}
	if(is_array($tag_array)) {
		$tag_cloud = printTagCloud($tag_array);
	}
	if ($tag_cloud != '')	{
		$box_smarty->assign('box_name', getBoxName('tagcloud'));
		$box_smarty->assign('box_class_name', getBoxCSSName('tagcloud'));
		$box_smarty->assign('BOX_CONTENT', $tag_cloud);
		$box_smarty->assign('language', $_SESSION['language']);
		$box_smarty->assign('html_tpl_path', CURRENT_TEMPLATE.'/html');
		if (file_exists('templates/'.CURRENT_TEMPLATE.'/boxes/box.html')) {
			$box_content = $box_smarty->fetch(CURRENT_TEMPLATE.'/boxes/box.html', $cache_id);
		}else{
			$box_content = $box_smarty->fetch('base/boxes/box.html', $cache_id);
		}
	}
}
