<?php

/* -----------------------------------------------------------------
 * 	$Id: rma_step3.php 1154 2014-07-21 12:28:05Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2006 Created by Southbridge.de
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include ('includes/application_top.php');
require_once(DIR_FS_INC . 'cseo_rma.inc.php');
$smarty = new Smarty;
require(DIR_FS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/source/boxes.php');
$breadcrumb->add(NAVBAR_TITLE_RMA, xtc_href_link(FILENAME_RMA_STEP3, '', 'SSL'));
require_once(DIR_WS_INCLUDES . 'header.php');

if (RMA_MODUL_ON == 'true') {
    $process = false;

    if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
        $process = true;
        $cust_id = xtc_db_prepare_input($_SESSION['customer_id']);
        $orderid = xtc_db_prepare_input($_POST['order_id']);
        $products_id = xtc_db_prepare_input($_POST['products_id']);
        $products_ean = xtc_db_prepare_input($_POST['products_ean']);
        $error_msg = xtc_db_prepare_input($_POST['error_msg']);
        $error_msg = strip_tags($error_msg);
        // prüft ob escaping aktiv ist
        if (get_magic_quotes_gpc() == 0) {
            $error_msg = addslashes($error_msg);
        }
        $reason = xtc_db_prepare_input($_POST['reason_id']);
        $sql_fields = " ";
        $sql_values = " ";
        $error = false;

        if (RMA_CHOOSE_PRODUCTS_OBLIGATION == 'true') {
            if ($products_id == '0') {
                $error = true;
                $messageStack->add('orders', ENTRY_RMA_PRODUCTS);
            }
        }

        if (RMA_ERROR_MESSAGE_SHOW == 'true') {
            if ($error_msg == '') {
                $error = true;
                $messageStack->add('orders', ENTRY_RMA_ERROR_MESSAGE);
            }
            if (strlen($error_msg) < ENTRY_RMA_ERROR_MESSAGE_MIN_LENGTH) {
                $error = true;
                $messageStack->add('orders', ENTRY_RMA_ERROR_MESSAGE_LENGTH);
            }
        }

        if (RMA_PRODUCTS_EAN_SHOW == 'true') {
            if (RMA_PRODUCTS_EAN_OBLIGATION == 'true' && $products_ean == '') {
                $error = true;
                $messageStack->add('orders', ENTRY_RMA_PRODUCTS_EAN);
            }
        }

        if (RMA_CHOOSE_REASON_OBLIGATION == 'true') {
            if ($reason == '0') {
                $error = true;
                $messageStack->add('orders', ENTRY_RMA_REASON);
            }
        }

        if (xtc_db_prepare_input($_POST['pickup'])) {
            $sql_fields .= " , pickup ";
            $sql_values .= " , " . xtc_db_prepare_input($_POST['pickup']) . " ";
        }

        if (xtc_db_prepare_input($_POST['cost_estimate'])) {
            $sql_fields .= " , cost_estimate ";
            $sql_values .= " , " . xtc_db_prepare_input($_POST['cost_estimate']) . " ";
        }

        if (xtc_db_prepare_input($_POST['shipping_time'])) {
            $sql_fields .= " , shipping_time ";
            $sql_values .= " ,  '" . xtc_db_prepare_input($_POST['shipping_time']) . "' ";
        }

        if ($error == false) {
            xtc_db_query("INSERT INTO " . TABLE_RMA . " (customers_id, orders_id, products_id, products_ean, reason_id, description, rma_date " . $sql_fields . "  ) VALUES (" . $cust_id . "," . $orderid . "," . $products_id . ",'" . $products_ean . "', '" . $reason . "','" . $error_msg . "', now() " . $sql_values . ")");
            $customers = xtc_db_fetch_array(xtc_db_query("SELECT customers_firstname,customers_lastname,customers_email_address FROM " . TABLE_CUSTOMERS . " WHERE customers_id = '" . $cust_id . "';"));
            $product = xtc_db_fetch_array(xtc_db_query("SELECT products_name FROM " . TABLE_PRODUCTS_DESCRIPTION . " WHERE products_id = '" . $products_id . "' AND language_id = '" . (int) $_SESSION['languages_id'] . "';"));
            $customers_name = $customers['customers_firstname'] . ' ' . $customers['customers_lastname'];

            $smarty->assign('CUSTOMER_ID', $cust_id);
            $smarty->assign('CUSTOMER_NAME', $customers_name);
            $smarty->assign('CUSTOMER_EMAIL', $customers['customers_email_address']);
            $smarty->assign('CUSTOMER_ORDER_ID', $orderid);
            $smarty->assign('CUSTOMER_ORDER_PRODUCT_ID', $products_id);
            $smarty->assign('CUSTOMER_ORDER_PRODUCT_NAME', $product['products_name']);
            $smarty->assign('CUSTOMER_REASON', sb_get_reason($reason));
            $smarty->assign('CUSTOMER_ERROR', $error_msg);

            // mail an admin senden 
            $smarty->caching = false;
            require_once(DIR_FS_INC . 'cseo_get_mail_body.inc.php');
            $html_mail = $smarty->fetch('html:new_rma');
            $html_mail .= $signatur_html;
            $txt_mail = $smarty->fetch('txt:new_rma');
            $txt_mail .= $signatur_text;
            require_once(DIR_FS_INC . 'cseo_get_mail_data.inc.php');
            $mail_data = cseo_get_mail_data('new_rma');

            $from_name = str_replace('{$shop_besitzer}', STORE_OWNER, $mail_data['EMAIL_ADDRESS_NAME']);
            $from_name = str_replace('{$shop_name}', STORE_NAME, $from_name);

            xtc_php_mail($mail_data['EMAIL_ADDRESS'], $from_name, $mail_data['EMAIL_ADDRESS'], $mail_data['EMAIL_ADDRESS_NAME'], $mail_data['EMAIL_FORWARD'], $mail_data['EMAIL_ADDRESS'], $mail_data['EMAIL_ADDRESS_NAME'], '', '', $mail_data['EMAIL_SUBJECT'], $html_mail, $txt_mail, true);
            $smarty->assign('success', '1');
            $smarty->assign('RMA_OVERVIEW', '<a href="' . xtc_href_link(FILENAME_RMA_STEP2) . '">' . RMA_OVERVIEW_TEXT . '</a>');
        }
    }

    if ($messageStack->size('orders') > 0) {
        $smarty->assign('error', $messageStack->output('orders'));
    }

    if (isset($_SESSION['customer_id'])) {
        $order_id = xtc_db_prepare_input($_POST['order_id']);
        $smarty->assign('FORM_ACTION', xtc_draw_form('orders', xtc_href_link(FILENAME_RMA_STEP3, '', 'SSL'), 'post', 'onsubmit="return check_form(orders);"') . xtc_draw_hidden_field('action', 'process'));
        $smarty->assign('ORDER_ID', xtc_draw_hidden_field('order_id', $order_id));
        $smarty->assign('CHOOSE_PRODUCTS_ID', sb_get_rma_products($order_id, array('name' => 'products_id', 'text' => '&nbsp;' . (RMA_CHOOSE_PRODUCTS_OBLIGATION == 'true' ? '<span class="inputRequirement">*</span>' : ''))));
        $smarty->assign('CHOOSE_REASON', sb_get_rma_reasons(array('name' => 'reason_id', 'text' => '&nbsp;' . (RMA_CHOOSE_REASON_OBLIGATION == 'true' ? '<span class="inputRequirement">*</span>' : ''))));
        if (RMA_PICK_UP_SHOW == 'true') {
            $smarty->assign('PICK_UP', '1');
            $smarty->assign('PICK_UP_YES', xtc_draw_radio_field('pickup', '1'));
            $smarty->assign('PICK_UP_NO', xtc_draw_radio_field('pickup', '0'));
        }
        if (RMA_COST_ESTIMATE_SHOW == 'true') {
            $smarty->assign('COST_ESTIMATE', '1');
            $smarty->assign('COST_ESTIMATE_YES', xtc_draw_radio_field('cost_estimate', '1'));
            $smarty->assign('COST_ESTIMATE_NO', xtc_draw_radio_field('cost_estimate', '0'));
        }
        $smarty->assign('SHIPPING_TIME', xtc_draw_input_field('shipping_time'));
        $smarty->assign('BUTTON_SUBMIT', xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
        $smarty->assign('FORM_END', '</form>');

        if (RMA_ERROR_MESSAGE_SHOW == 'true') {
            $smarty->assign('ERROR_MESSAGE', xtc_draw_textarea_field('error_msg', 'soft', 7, 7));
        }
        if (RMA_PRODUCTS_EAN_SHOW == 'true') {
            $smarty->assign('EAN', xtc_draw_input_fieldNote(array('name' => 'products_ean', 'text' => '&nbsp;' . (RMA_PRODUCTS_EAN_OBLIGATION == 'true' ? '<span class="inputRequirement">*</span>' : ''))));
        }
        $smarty->assign('language', $_SESSION['language']);
        $smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
        $smarty->caching = false;
		if (file_exists('templates/'.CURRENT_TEMPLATE.'/module/rma_step3.html')) {
			$main_content = $smarty->fetch(cseo_get_usermod(CURRENT_TEMPLATE.'/module/rma_step3.html', USE_TEMPLATE_DEVMODE));
		}else{
			$main_content = $smarty->fetch(cseo_get_usermod('base/module/rma_step3.html', USE_TEMPLATE_DEVMODE));
		}
        $smarty->assign('main_content', $main_content);
    }
}
$smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
$smarty->assign('language', $_SESSION['language']);
$smarty->loadFilter('output', 'note');
$smarty->loadFilter('output', 'trimwhitespace');
$smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));
include ('includes/application_bottom.php');
