<?php
/*-----------------------------------------------------------------
* 	$Id: pdf_bill.php 1250 2014-10-24 07:02:27Z akausch $
* 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/
/*******************************************************************************
* FPDF                                                                         *
*                                                                              *
* Version: 1.6                                                                 *
* Date:    2008-08-03                                                          *
* Author:  Olivier PLATHEY                                                     *
*******************************************************************************/



require_once('class.pdf.php');

define('FPDF_FONTPATH','font/');

$sprach_id = $_POST['pdf_language_id'];

$pdf_query = xtc_db_query("SELECT pdf_key, pdf_value FROM orders_pdf_profile WHERE languages_id = '".$sprach_id."';");
while ($pdf = xtc_db_fetch_array($pdf_query)) {
	define($pdf['pdf_key'], utf8_decode($pdf['pdf_value']));
}

$pdf_query = xtc_db_query("SELECT pdf_key, pdf_value FROM orders_pdf_profile WHERE languages_id = '0';");
while ($pdf = xtc_db_fetch_array($pdf_query)) {
	define($pdf['pdf_key'], $pdf['pdf_value']);
}

class PDF_Bill extends FPDF {
	// Raender
	var $left_margin = LAYOUT_LEFT_MARGIN;
	var $top_margin = LAYOUT_TOP_MARGIN;
	var $left_textoffset = LAYOUT_LEFT_TEXTOFFSET;
	var $footer_y = LAYOUT_FOOTER_Y;
	// Adressenfeld Umschlagfenster
	var $addresswindowmaxlen = LAYOUT_ADDRESSWINDOWMAXLEN;
	var $addresswindowtop = LAYOUT_ADDRESSWINDOWTOP;
	// Schriftart des PDF's
	var $fontfamily = LAYOUT_FONTFAMILY;
	// Shop-Logo
	var $logo_x = LAYOUT_LOGO_X;
	var $logo_y = LAYOUT_LOGO_Y;
	var $rechnungsdaten_x = LAYOUT_RECHNUNGSDATEN_X;
	var $rechnungsdaten_y = LAYOUT_RECHNUNGSDATEN_Y;
	var $rechnung_start = LAYOUT_RECHNUNG_START;
	var $menge_len = LAYOUT_MENGE_LEN;
	var $artikel_len = LAYOUT_ARTIKEL_LEN;
	var $artikelnr_len = LAYOUT_ARTIKELNR_LEN;
	var $einzelpreis_len = LAYOUT_EINZELPREIS_LEN;
	var $preis_len = LAYOUT_PREIS_LEN;

	function Rechnungsdaten($kundennummer, $best_nr, $ust_id, $rech_nr, $datum, $zahlungsweise, $lieferschein, $type) {
		$this->SetX($this->rechnungsdaten_x);
		$this->SetLeftMargin($this->rechnungsdaten_x);
		$this->SetY($this->rechnungsdaten_y);

		$this->SetFont($this->fontfamily,'', 9);
		if ($kundennummer != '') {
			$this->Cell(0, 6, TEXT_PDF_KUNDENNUMMER.': '.$kundennummer, 0, 1);
		}
		if ($best_nr != '') {
			if (file_exists('includes/modules/order_create_credit.php')) {
				$order_status = xtc_db_fetch_array(xtc_db_query("SELECT orders_status FROM " . TABLE_ORDERS . " WHERE orders_id = '$best_nr'"));
				if ($order_status['orders_status'] != ORDER_STATUS_STORNO) {
					$this->Cell(0, 6, TEXT_PDF_BESTELLNUMMER.': '.$best_nr, 0, 1);
				}
			} else {
				$this->Cell(0, 6, TEXT_PDF_BESTELLNUMMER.': '.$best_nr, 0, 1);
			}
		}
		$this->Cell(0, 6, TEXT_PDF_DATUM.': '.$datum, 0, 1);
		if($zahlungsweise != '')
			$this->Cell(0, 6, TEXT_PDF_ZAHLUNGSWEISE.': '.html_entity_decode($zahlungsweise), 0, 1);
			
		if(!PDF_LIEFERSCHEIN) {
			if ($ust_id != '') {
				$this->Cell(0, 6, TEXT_PDF_USTID.': '.$ust_id, 0, 1);
			}
			if (file_exists('includes/modules/order_create_credit.php')) {
				$order_status = xtc_db_fetch_array(xtc_db_query("SELECT orders_status FROM " . TABLE_ORDERS . " WHERE orders_id = '$best_nr'"));
				if ($order_status['orders_status'] == ORDER_STATUS_STORNO) {
					$this->Cell(0, 6, TEXT_PDF_GUTSCHRIFTNR.': '.$rech_nr, 0, 1);
				} else {
					$this->Cell(0, 6, TEXT_PDF_RECHNUNGSNUMMER.': '.$rech_nr, 0, 1);
				}
			} else {
				$this->Cell(0, 6, TEXT_PDF_RECHNUNGSNUMMER.': '.$rech_nr, 0, 1);
			}
		} else {
			$this->Cell(0, 6, TEXT_PDF_LIEFERSCHEIN.': '.$best_nr, 0, 1);
		}
	}

	function RechnungStart($rech_nr, $best_nr, $kundenname, $geschlecht, $lieferschein, $type) {
		$this->SetX($this->left_textoffset);
		$this->SetLeftMargin($this->left_textoffset);
		$this->SetY($this->rechnung_start);

		$this->SetFont($this->fontfamily, 'B', 16);
		if (file_exists('includes/modules/order_create_credit.php')) {
			$order_status = xtc_db_fetch_array(xtc_db_query("SELECT orders_status FROM " . TABLE_ORDERS . " WHERE orders_id = '$best_nr'"));
			if ($order_status['orders_status'] == ORDER_STATUS_STORNO) {
				$this->Cell(0, 6, !PDF_LIEFERSCHEIN ? TEXT_PDF_GUTSCHRIFT.' '.$rech_nr : TEXT_PDF_LIEFERSCHEIN, 0, 1);
			} else {
				$this->Cell(0, 6, !PDF_LIEFERSCHEIN ? TEXT_PDF_RECHNUNG.' '.$rech_nr : TEXT_PDF_LIEFERSCHEIN, 0, 1);
			}
		} else {
				$this->Cell(0, 6, !PDF_LIEFERSCHEIN ? TEXT_PDF_RECHNUNG.' '.$rech_nr : TEXT_PDF_LIEFERSCHEIN, 0, 1);
		}
		
		$this->Ln();
		$this->SetFont($this->fontfamily, '', 9);

		switch($geschlecht) {
			case 'm':
				$message = TEXT_PDF_DANKE_MANN;
				break;
			case 'f':
				$message = TEXT_PDF_DANKE_FRAU;
				break;
			case 'u':
			default:
				$message = TEXT_PDF_DANKE_UNISEX;
		}

		$this->MultiCell(0, 6, sprintf($message, $kundenname), 0);
	}

	function ListeKopf($lieferschein, $type) {
		$this->SetFont($this->fontfamily, 'B', 9);
		$this->Ln();
		if(!PDF_LIEFERSCHEIN) {
			$this->Cell($this->menge_len, 6, TEXT_PDF_MENGE.' ', 'B', 0, 'R');
			$this->Cell($this->artikel_len, 6, TEXT_PDF_ARTIKEL, 'B', 0);
			$this->Cell($this->artikelnr_len, 6, TEXT_PDF_ARTIKELNR, 'B', 0);
			$this->Cell($this->einzelpreis_len, 6, TEXT_PDF_EINZELPREIS, 'B', 0, 'R');
			$this->Cell($this->preis_len, 6, TEXT_PDF_PREIS, 'B', 0, 'R');
		} else {
			$this->Cell($this->menge_len, 6, TEXT_PDF_MENGE.' ', 'B', 0, 'R');
			$this->Cell(130, 6, TEXT_PDF_ARTIKEL, 'B', 0);
			$this->Cell($this->artikelnr_len, 6, TEXT_PDF_ARTIKELNR, 'B', 0);
		}
		$this->Ln(8);
	}

	function ListeProduktHinzu($menge, $artikel, $zusinfos, $artnr, $zusinfoartnr, $einzelpreis, $preis, $lieferschein, $type) {

		$this->SetFont($this->fontfamily,'', 9);

		$parts = preg_split("/[\s]+/", $artikel, -1, PREG_SPLIT_DELIM_CAPTURE); // Artikelbeschreibung splitten
		$line = 0;

		foreach($parts as $part) {
			if($this->GetStringWidth($newtext.$part) < $this->artikel_len) {
				$newtext .= $lastpart.$part.' ';
				$lastpart = "";
			} else {
				if(!PDF_LIEFERSCHEIN) {
					if($line == 0)
						$this->Cell($this->menge_len, 4, $menge.' x ', 0, 0, 'R');
					else
						$this->Cell($this->menge_len, 4, '', 0, 'R');

					$this->Cell($this->artikel_len, 4, $newtext, 0);

					if($line == 0) {
						$this->SetFont($this->fontfamily,'', 9);
						$this->Cell($this->artikelnr_len, 4, utf8_decode($artnr), 0, 0, '');
						$this->SetFont($this->fontfamily,'', 9);
						$this->Cell($this->einzelpreis_len, 4, $einzelpreis, 0, 0, 'R');
						$this->Cell($this->preis_len, 4, $preis, 0, 0, 'R');
					} else {
						$this->SetFont($this->fontfamily,'', 9);
						$this->Cell($this->artikelnr_len, 4, '', 0);
						$this->SetFont($this->fontfamily,'', 9);
						$this->Cell($this->einzelpreis_len, 4, '', 0);
						$this->Cell($this->preis_len, 4, '', 0);
					}
				} else {
					if($line == 0)
						$this->Cell(20, 4, $menge.' x ', 0, 0, 'R');
					else
						$this->Cell(20, 4, '', 0, 'R');

					$this->Cell(130, 4, $newtext, 0);

					if($line == 0) {
						$this->Cell($this->artikelnr_len, 4, utf8_decode($artnr), 0, 0, '');
					} else {
						$this->Cell($this->artikelnr_len, 4, '', 0);
					}
				}
				$this->Ln();
				$newtext = "";
				$lastpart = $part.' ';
				$line++;
			}
		}

		if($newtext) {
			if(!PDF_LIEFERSCHEIN) {
				if($line == 0)
					$this->Cell($this->menge_len, 4, $menge.'x ', 0, 0, 'R');
				else
					$this->Cell($this->menge_len, 4, '', 0);

				$this->Cell($this->artikel_len, 4, $newtext, 0);

				if($line == 0) {
					$this->SetFont($this->fontfamily,'', 9);
					$this->Cell($this->artikelnr_len, 4, utf8_decode($artnr), 0, 0, '');
					$this->SetFont($this->fontfamily,'', 9);
					$this->Cell($this->einzelpreis_len, 4, $einzelpreis, 0, 0, 'R');
					$this->Cell($this->preis_len, 4, $preis, 0, 0, 'R');
				} else {
					$this->Cell($this->artikelnr_len, 4, '', 0);
					$this->Cell($this->einzelpreis_len, 4, '', 0);
					$this->Cell($this->preis_len, 4, '', 0);
				}
			} else {
				if($line == 0)
					$this->Cell(18, 4, $menge.'x', 0, 0, 'R');
				else
					$this->Cell(18, 4, '', 0, 0, 'R');

				$this->Cell(130, 4, $newtext, '', 0);

				if($line == 0) {
					$this->Cell(28, 4, utf8_decode($artnr), 0, 0, 'L');
				} else {
					$this->Cell(28, 4, '', 0, 'L');
				}
			}
			$this->Ln();
		}

		if($zusinfos) {
			$this->SetFont($this->fontfamily, 'I', 9);

			$zusinfos_arr = split("\n", $zusinfos);
			$zusinfoartnr_arr = split("\n", $zusinfoartnr);

			if (!PDF_LIEFERSCHEIN) {
				for($i = 0; $i < count($zusinfos_arr); $i++) {
					$this->Cell($this->menge_len, 5, '', 0, 0, '');
					$this->Cell($this->artikel_len, 5, $zusinfos_arr[$i], 0, 0, '');

					if($i < count($zusinfoartnr_arr)) {
						$this->Cell($this->artikelnr_len, 5, $zusinfoartnr_arr[$i], 0, 0, '');
					}
					$this->Ln();
				}			
			} else {
				for($i = 0; $i < count($zusinfos_arr); $i++) {
					$this->Cell($this->menge_len, 5, '', 0, 0, '');
					$this->Cell($this->artikel_len, 5, $zusinfos_arr[$i], 0, 0, '');
					$this->Cell(30, 6, '', 0);

					if($i < count($zusinfoartnr_arr)) {
						$this->Cell(20, 6, '', 0);
						$this->Cell($this->artikelnr_len, 5, $zusinfoartnr_arr[$i], 0, 0, '');
						$this->Cell(30, 6, '', 0);
					}
					$this->Ln();
				}
			}
		}
		$this->Ln(2);
	}

	function Betrag($orderdata, $lieferschein, $type) {
		$this->SetFont($this->fontfamily, '', 9);

		$this->Cell($this->menge_len + $this->artikel_len + $this->einzelpreis_len + $this->artikelnr_len + $this->preis_len, 6, '', 'T');
		$this->Ln(2);

		foreach($orderdata as $info) {
			$text = $info['text'];
			$info['title'] = str_replace("::", ":", $info['title']);

			if(strpos($text, "<b>") !== FALSE) {
				$this->SetFont($this->fontfamily, 'B', 9);

				$text = strip_tags($text);
				$info['title'] = strip_tags($info['title']);

				if($info['class'] == 'ot_total') {
					$this->Ln(2);

					$sum_len = 25;

					$this->Cell($this->menge_len + $this->artikel_len + $this->einzelpreis_len + $this->artikelnr_len - $sum_len, 1, "", '', 0);
					$this->Cell($this->preis_len + $sum_len - 1, 1, "", 'T', 1);
					$this->Cell($this->menge_len + $this->artikel_len + $this->einzelpreis_len + $this->artikelnr_len - $sum_len, 1, "", '', 0);
					$this->Cell($this->preis_len + $sum_len - 1, 1, "", 'T', 1);
				}
			} else if(strpos($text, "<font") !== FALSE) {
				$text = strip_tags($text);
				$this->SetTextColor(205,0,0);
			} else {
				$info['title'] = strip_tags($info['title']);
				$text = strip_tags($text);
				$this->SetFont($this->fontfamily, '', 9);
				$this->SetTextColor(0,0,0);
			}
			if($info['class'] == 'ot_total')
				$this->SetFont($this->fontfamily, 'B', 9);
			else
				$this->SetFont($this->fontfamily, '', 9);

			$this->Cell($this->menge_len + $this->artikel_len + $this->einzelpreis_len + $this->artikelnr_len, 6, html_entity_decode($info['title']), 0, 0, 'R');
			$this->Cell($this->preis_len, 6, $text, 0, 1, 'R');
		}
	}

	function Kommentar($comment, $method, $lieferschein, $type) {
		if(!$comment)
			return;

		if(!PDF_LIEFERSCHEIN) {
			$this->Ln(10);
			$this->SetFont($this->fontfamily, 'B', 9);
			$this->Cell($this->preis_len, 10, TEXT_PDF_KOMMENTAR, 0, 1);

			$this->SetFont($this->fontfamily, '', 9);
			$this->MultiCell(0, 3, utf8_decode($comment));
		}
	}
	
	function Invoice($invoiceinfo) {
		// Kundenadresse ausgeben
		if(!PDF_LIEFERSCHEIN) {
			$this->Ln(2);
			$this->SetFont($this->fontfamily, 'B', 9);
			$this->Cell($this->preis_len, 10, TEXT_PDF_INVOICE, 0, 1);
			$this->SetFont($this->fontfamily, '', 9);
			$this->MultiCell(0, 5, $invoiceinfo);
		}

	}
	
	function LieferAdresse($lieferadresse) {
		// Kundenadresse ausgeben
		if(!PDF_LIEFERSCHEIN) {
			$this->Ln(2);
			$this->SetFont($this->fontfamily, 'B', 9);
			$this->Cell($this->preis_len, 10, TEXT_PDF_LIFERADRESSE, 0, 1);
			$this->SetFont($this->fontfamily, '', 9);
			$this->MultiCell(0, 1, $lieferadresse);
		}

	}

	function RechnungEnde($type = '', $method) {
		if(!PDF_LIEFERSCHEIN) {
			$text = TEXT_PDF_SCHLUSSTEXT;
		} else {
			$text = str_replace('#vm#', $method, TEXT_PDF_DELIVERY_SCHLUSSTEXT);
		}
		$this->Ln(2);
		$this->SetFont($this->fontfamily, '', 9);
		$this->MultiCell(0, 5, $text);
	}

	function Footer() {
		if (TEXT_PDF_ANSCHRIFT != '' || TEXT_PDF_KONTAKT != '' || TEXT_PDF_BANK != '' || TEXT_PDF_GESCHAEFT != '') {
			$this->SetFont($this->fontfamily,'',8);
			$this->SetTextColor(128);
			$left = $this->PutInfoBlock(0, TEXT_PDF_ANSCHRIFT, $this->footer_y);
			$left = $this->PutInfoBlock($left, TEXT_PDF_KONTAKT, $this->footer_y);
			$left = $this->PutInfoBlock($left, TEXT_PDF_BANK, $this->footer_y);
			$left = $this->PutInfoBlock($left, TEXT_PDF_GESCHAEFT, $this->footer_y);

			$this->Line(5, 297.0/2.0, 8, 297.0/2.0);
		}
	}

	function Init($title) {
		$this->SetAutoPageBreak(true, abs($this->footer_y) + 10);
		$this->SetCreator(STORE_NAME . ' &copy; ' . date("Y"));
		$this->AliasNbPages();
		$this->AddPage();
		$this->SetFillColor(230,230,230);
		$this->SetDisplayMode('fullwidth');
		$this->SetTitle($title);
	}

	function Header() {
		$this->SetFont($this->fontfamily,'' ,9);

		$this->SetX($this->left_margin);
		$this->SetLeftMargin($this->left_margin);

		// Ausgabe des Headertextes
		$this->Cell(0, 4, TEXT_PDF_HEADER, 0, 1);
		// Schiebe die Zeile auf die Anfangsposition
		$this->SetY($this->top_margin);
		// Ausgabe der Seitenzahl in grau, kursiv und kleiner
		$this->SetTextColor(128);
		$this->SetFont('Arial','I',8);
		$this->Cell(0, 4, TEXT_PDF_SEITE.' '.$this->PageNo().' '.TEXT_PDF_SEITE_VON.' {nb}', 0, 0, 'R');

		// die nachfolgenden Seiten der Abstand vom Header
		$this->Ln();
		$this->Ln();
	}

	function maxlen($strings) {
		$max = 0;
		for ($i = 0; $i < count($strings); $i++) {
			if($this->GetStringWidth($strings[$i]) > $max)
				$max = $this->GetStringWidth($strings[$i]);
		}
		return $max + 6;
	}

	function PutInfoBlock($left, $body, $y) {
		$this->SetFont($this->fontfamily,'',8);

		$this->SetY($y);

		$body_arr = explode("\n", $body);
		$maxlen = $this->maxlen($body_arr);

		$this->SetLeftMargin($left + $this->left_margin);
		$this->SetX($left + $this->left_margin);

		$this->MultiCell($maxlen, 4, $body, 'T');

		return $left + $maxlen;
	}

	function Adresse($kundenadresse, $geschaeftsadresse) {
		// Kundenadresse ausgeben
		$this->SetX($this->left_textoffset + 5);
		$this->SetLeftMargin($this->left_textoffset);

		$this->SetY($this->addresswindowtop + 7);

		$this->SetFont($this->fontfamily,'',11); // normal
		$this->MultiCell($this->addresswindowmaxlen, 4, $kundenadresse);

		// Shopadresse ausgeben
		$this->SetX($this->left_textoffset);
		$this->SetLeftMargin($this->left_textoffset);

		$this->SetY($this->addresswindowtop);

		$this->SetFont($this->fontfamily,'',6); // klein
		$this->Cell($this->addresswindowmaxlen, 4, $geschaeftsadresse);

	}


	function Logo($pfad) {
		$size = getimagesize($pfad);
		$this->Image($pfad, $this->logo_x, $this->logo_y, $size[0] / (int)LAYOUT_LOGO_DPI * 25.4);
	}
}
