<?php

/* -----------------------------------------------------------------
 * 	$Id: xajax.googletax.php 559 2013-08-19 14:07:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */
defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

/* Google Taxonomie */
$xajax->registerFunction('get_next_cat');
$xajax->registerFunction('reset_cat');
$xajax->registerFunction('get_new_dropdown');


include(DIR_WS_CLASSES . 'class.google_taxonomy.php');
$google = new googleTaxonomy();

function get_new_dropdown($lang) {
    global $google;
    $ajax = new xajaxResponse();
    // $ajax->alert('val: '."\n".$lang);
    $c = '<table width="100%" border="0" id="selection" cellpadding="4">
			<tr>
				<td class="google_cat" id="sub_select_'.$lang.'" width="1">
					' . xtc_draw_pull_down_menu('google_'.$lang, $google->get_dropdown_data('', $lang), '', 'onchange="xajax_get_next_cat(this.value, \'\', \''.$lang.'\')" style="width:380px" class="selections"') . '
				</td>
			</tr>
		</table>';

    $ajax->assign('google_taxonomy_'.$lang, 'innerHTML', $c);
    $ajax->append('google_taxonomy_'.$lang, 'innerHTML', '<input type="hidden" name="" value="" id="short_path_'.$lang.'" />');
    $ajax->script('$("#GOOGLE_MERCHANT_"'.$lang.').width(\'90%\')');

    return $ajax;
}

function get_next_cat($value = '', $parent = '', $lang) {
    $ajax = new xajaxResponse();
	// $ajax->alert('val: '."\n".$lang);
    if (!empty($parent)) {
        $path = explode('|', $parent);
        $path[] = $value;
    } else {
        $path[] = $value;
	}
    if (sizeof($path) == 1) {
        $c .= '<tr><td width="1">' . drop_down('', $value, true, $lang) . xtc_draw_hidden_field('path_0', $value) . '</td></tr>' . "\n";
        $c .= '<tr><td width="2">' . drop_down($value, '', false, $lang) . '</td></tr>' . "\n";
    } else {
        $long = implode(' > ', $path);
        for ($i = 0; $i < sizeof($path); $i++) {
            $np .= ($i > 0 && $path[$i - 1] != '' ? ' > ' : '') . $path[$i - 1];
            $c .= '<tr><td width="1">' . drop_down(substr($np, strlen($path[$i - 1])), $path[$i], true, $lang) . '</td></tr>' . "\n";
        }
        if (drop_down($long, '', $id)) {
            $c .= '<tr><td width="1">' . drop_down($long, '', $id, $lang) . '</td></tr>' . "\n";
        }
    }
    $j .= '$("#short_path_"'.$lang.').val("' . implode('|', $path) . '");';
    $j .= '$("#GOOGLE_MERCHANT_"'.$lang.').val("' . implode(' > ', $path) . '");';
    $ajax->script($j);
    $ajax->assign('selection', 'innerHTML', $c);
    return $ajax;
}

function drop_down($value = '', $default = '', $read_only = false, $lang) {
    global $google;
	// $ajax = new xajaxResponse();
	// $ajax->alert('val: '."\n".$lang);
    $data = $google->get_dropdown_data($value, $lang);
    if (!empty($data)) {
        $d = xtc_draw_pull_down_menu('', $data, $default, ($read_only ? 'disabled="" ' : '') . 'onchange="xajax_get_next_cat(this.value, $(\'#short_path_'.$lang.'\').val(), \''.$lang.'\')" style="width:380px"');
        return $d;
    }
    return false;
}

/* Google Taxonomie END */
