<?php

/* -----------------------------------------------------------------
 * 	$Id: rma_step2.php 1003 2014-05-05 15:19:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2006 Created by Southbridge.de
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include('includes/application_top.php');
require_once(DIR_FS_INC . 'cseo_rma.inc.php');
require_once(DIR_FS_INC . 'xtc_date_short.inc.php');

$smarty = new Smarty;
require (DIR_FS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/source/boxes.php');
$breadcrumb->add(NAVBAR_TITLE_RMA, xtc_href_link(FILENAME_RMA_STEP2, '', 'SSL'));

require_once (DIR_WS_INCLUDES . 'header.php');

if (RMA_MODUL_ON == 'true') {
    if (isset($_SESSION['customer_id'])) {
        $orders_query = xtc_db_query("SELECT orders_id, DATE_FORMAT(date_purchased , '%d.%m.%Y') AS DATE FROM " . TABLE_ORDERS . "  WHERE customers_id = '" . (int) $_SESSION['customer_id'] . "' ORDER BY orders_id DESC;");
        while ($orders = xtc_db_fetch_array($orders_query)) {
            $order_ids[] = array(
                'id' => $orders['orders_id'],
                'text' => RMA_NUMBER . $orders['orders_id'] . RMA_TEXT_FROM . $orders['DATE']);
        }
        $smarty->assign('FORM_ACTION', xtc_draw_form('orders', xtc_href_link(FILENAME_RMA_STEP3, '', 'SSL'), 'post'));
        $smarty->assign('CHOOSE_ORDER_ID', xtc_draw_pull_down_menu('order_id', $order_ids, '', 'style="width:200px;"'));
        $smarty->assign('BUTTON_SUBMIT', xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
        $smarty->assign('FORM_END', '</form>');
        $rma_overview_array = array();
        $rma_query = xtc_db_query("SELECT rma_id, rma_date, rma_status_id FROM " . TABLE_RMA . " WHERE customers_id = '" . (int) $_SESSION['customer_id'] . "' ORDER BY rma_id DESC;");
        while ($rma_overview = xtc_db_fetch_array($rma_query)) {
            $rma_overview_array[] = array(
                'RMA_ID' => $rma_overview['rma_id'],
                'RMA_DATE' => xtc_date_short($rma_overview['rma_date']),
                'RMA_STATUS' => sb_get_status($rma_overview['rma_status_id']),
                'RMA_ACTION' => '<a href="' . xtc_href_link(FILENAME_RMA_STEP3, 'rma_id=' . $rma_overview['rma_id'], 'SSL') . '">' . RMA_TEXT_SHOW . '</a>');
        }
        $smarty->assign('rma_content', $rma_overview_array);
    }
    $smarty->assign('language', $_SESSION['language']);
    $smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
    $smarty->caching = false;
    $main_content = $smarty->fetch(cseo_get_usermod('base/module/rma_step2.html', USE_TEMPLATE_DEVMODE));
    $smarty->assign('main_content', $main_content);
}
$smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
$smarty->assign('language', $_SESSION['language']);
$smarty->loadFilter('output', 'note');
$smarty->loadFilter('output', 'trimwhitespace');
$smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));
include ('includes/application_bottom.php');
