<?php
/* -----------------------------------------------------------------------------------------
$Id: product.php 2 2011-02-17 13:35:25Z akausch $

commerce:SEO - ein Projekt von Webdesign Erfurt
http://www.commerce-seo.de

Copyright (c) 2010 commerce:SEO
-----------------------------------------------------------------------------------------
based on:
(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
(c) 2002-2003 osCommerce(Coding Standards); www.oscommerce.com
(c) 2005 XT-Commerce www.xt-commerce.com

Released under the GNU General Public License
---------------------------------------------------------------------------------------*/

class product {

	function product($pID = 0) {
		$this->pID = $pID;
		$this->useStandardImage=true;
		$this->standardImage='no_img.jpg';
		if ($pID = 0) {
			$this->isProduct = false;
			return;
		}

		$product_query = xtDBquery("SELECT
											*
										FROM
											".TABLE_PRODUCTS." AS p 
											JOIN ".TABLE_PRODUCTS_DESCRIPTION." AS pd ON (p.products_status = '1' AND pd.products_id = p.products_id AND pd.language_id = '".(int)$_SESSION['languages_id']."')
										AND
											p.products_id = '".$this->pID."'
										".$this->groupCheck().$this->fsk18()."");

		if(!xtc_db_num_rows($product_query, true))
			$this->isProduct = false;
		else {
			$this->isProduct = true;
			$this->data = xtc_db_fetch_array($product_query, true);
		}
	}

	/**
	 * Liefert das SQL Statement für FSK 18 Produkte
	 * @author siekiera
	 * @return sql
	 */

 
	 
	function fsk18() {
		if($_SESSION['customers_status']['customers_fsk18_display'] == '0')
			return $fsk_lock = ' and p.products_fsk18!=1';
	}

	/**
	 * Liefert das SQL Statement für den GruppenCheck
	 * @author siekiera
	 * @return sql
	 */

	function groupCheck() {
		if(GROUP_CHECK == 'true')
			return " and p.group_permission_".$_SESSION['customers_status']['customers_status_id']."=1 ";
	}

	/**
	 Query for tag cloud
	 **/
	function getTagCloud() {
		$products_tags_query = xtDBquery("SELECT
												tag
											FROM
												tag_to_product
											WHERE
												pID='".$this->pID."'
											AND
												lID = '".(int) $_SESSION['languages_id']."'
												ORDER BY tag ASC");
		if (xtc_db_num_rows($products_tags_query, true) > 0){
			while ($products_tags = xtc_db_fetch_array($products_tags_query, true)){
				$tags[] = array('tagcloud'=>'<a class="product_info_tag" href="'.xtc_href_link('tag/'.urlencode($products_tags['tag'])).'">'.$products_tags['tag'].'</a>');
			}
			return $tags;
		} else
			return;
	}

	/**
	 Query for attributes count
	 **/
	function getAttributesCount() {
		$products_attributes_query = xtDBquery("SELECT
													count(*) as total 
												FROM
													".TABLE_PRODUCTS_OPTIONS." popt, 
													".TABLE_PRODUCTS_ATTRIBUTES." patrib 
												WHERE 
													patrib.products_id='".$this->pID."' 
												AND
													patrib.options_id = popt.products_options_id 
												AND 
												popt.language_id = '".(int) $_SESSION['languages_id']."'");
												
		$products_attributes = xtc_db_fetch_array($products_attributes_query, true);
		return $products_attributes['total'];
	}

	/**
	 Query for reviews count
	 **/
	function getReviewsCount() {
		$reviews_query = xtDBquery("select count(*) as total from ".TABLE_REVIEWS." r, ".TABLE_REVIEWS_DESCRIPTION." rd where r.products_id = '".$this->pID."' and r.reviews_status = '1' and r.reviews_id = rd.reviews_id and rd.languages_id = '".$_SESSION['languages_id']."' and rd.reviews_text !=''");
		$reviews = xtc_db_fetch_array($reviews_query, true);
		return $reviews['total'];
	}

	/**
	 Select reviews
	 **/
	function getReviews() {
		$data_reviews = array ();
		$reviews_query = xtDBquery("select
	                                 r.reviews_rating,
	                                 r.reviews_id,
	                                 r.customers_name,
	                                 r.date_added,
	                                 r.last_modified,
	                                 r.reviews_read,
	                                 rd.reviews_text
	                                 from ".TABLE_REVIEWS." r,
	                                 ".TABLE_REVIEWS_DESCRIPTION." rd
	                                 where r.products_id = '".$this->pID."'
	                                 and r.reviews_id = rd.reviews_id
									 and r.reviews_status = '1'
	                                 and rd.languages_id = '".$_SESSION['languages_id']."'
	                                 order by reviews_id DESC");
		if (xtc_db_num_rows($reviews_query, true)) {
			$row = 0;
			$data_reviews = array ();
			while ($reviews = xtc_db_fetch_array($reviews_query, true)) {
				$row ++;
				$data_reviews[] = array ('AUTHOR' => $reviews['customers_name'], 'DATE' => xtc_date_short($reviews['date_added']), 'RATING' => xtc_image('templates/'.CURRENT_TEMPLATE.'/img/stars_'.$reviews['reviews_rating'].'.gif', sprintf(TEXT_OF_5_STARS, $reviews['reviews_rating'])), 'TEXT' => $reviews['reviews_text']);
				if ($row == PRODUCT_REVIEWS_VIEW)
					break;
			}
		}
		return $data_reviews;
	}

	/**
	 return model if set, else return name
	 **/
	function getBreadcrumbModel() {
		if ($this->data['products_name'] != "")
			return $this->data['products_name'];
		return $this->data['products_model'];
	}

	/**
	 Also purchased products related to current
	 **/
	function getAlsoPurchased() {
		global $xtPrice;

		$module_content = array ();

		$group_check = "";
		if (GROUP_CHECK == 'true') {
			$group_check = " and p.group_permission_".$_SESSION['customers_status']['customers_status_id']."=1 ";
		}

		$orders_query = xtDBquery("select
                          p.products_fsk18,
                          p.products_id,
						  p.products_quantity,
                          p.products_price,
                          p.products_tax_class_id,
                          p.products_image,
                          pd.products_img_alt,
                          pd.products_name,
                          p.products_vpe,
						  p.products_vpe_status,
						  p.products_vpe_value,
                          pd.products_short_description 
						  FROM 
						  ".TABLE_ORDERS_PRODUCTS." opa, 
						  ".TABLE_ORDERS_PRODUCTS." opb, 
						  ".TABLE_ORDERS." o, 
						  ".TABLE_PRODUCTS." p, 
						  ".TABLE_PRODUCTS_DESCRIPTION." pd
                          where opa.products_id = '".$this->pID."'
                          and opa.orders_id = opb.orders_id
                          and opb.products_id != '".$this->pID."'
                          and opb.products_id = p.products_id
                          and opb.orders_id = o.orders_id
                          and p.products_status = '1'
                          and pd.language_id = '".(int) $_SESSION['languages_id']."'
                          and opb.products_id = pd.products_id
                          ".$this->groupCheck().$this->fsk18()."
                          group by p.products_id order by o.date_purchased desc limit ".MAX_DISPLAY_ALSO_PURCHASED);
		$row=0;
		while ($orders = xtc_db_fetch_array($orders_query, true)) { $row++;
			$module_content[] = $this->buildDataArray($orders,'thumbnail','also_purchased',$row);
		}
		return $module_content;
	}

	/**
	  Cross selling
	 **/
	function getCrossSells() {
		$cs_groups = "SELECT products_xsell_grp_name_id FROM ".TABLE_PRODUCTS_XSELL." WHERE products_id = '".$this->pID."' GROUP BY products_xsell_grp_name_id";
		$cs_groups = xtDBquery($cs_groups);
		$cross_sell_data = array ();
		if (xtc_db_num_rows($cs_groups, true)>0) {
		while ($cross_sells = xtc_db_fetch_array($cs_groups, true)) {
			$cross_query = "select p.products_fsk18,
								p.products_tax_class_id,
								p.products_id,
								p.products_model,
								p.products_weight,
								p.manufacturers_id,
								p.products_vpe,
								p.products_quantity,
								p.products_image,
								pd.products_img_alt,
								pd.products_name,
								pd.products_short_description,
								p.products_fsk18,p.products_price,p.products_vpe,
								p.products_vpe_status,
								p.products_vpe_value,
								xp.sort_order 
								FROM 
								".TABLE_PRODUCTS_XSELL." xp, 
								".TABLE_PRODUCTS." p, 
								".TABLE_PRODUCTS_DESCRIPTION." pd
                                where xp.products_id = '".$this->pID."'
                                and xp.xsell_id = p.products_id ".$this->groupCheck().$this->fsk18()."
                                and p.products_id = pd.products_id
                                and xp.products_xsell_grp_name_id='".$cross_sells['products_xsell_grp_name_id']."'
                                and pd.language_id = '".$_SESSION['languages_id']."'
                                and p.products_status = '1'
                                order by xp.sort_order asc";

			$cross_query = xtDBquery($cross_query);
			if (xtc_db_num_rows($cross_query, true) > 0)
				$cross_sell_data[$cross_sells['products_xsell_grp_name_id']] = array ('GROUP' => xtc_get_cross_sell_name($cross_sells['products_xsell_grp_name_id']), 'PRODUCTS' => array ());
			$row = 0;
			while ($xsell = xtc_db_fetch_array($cross_query, true)) { $row++;
				$cross_sell_data[$cross_sells['products_xsell_grp_name_id']]['PRODUCTS'][] = $this->buildDataArray($xsell,'thumbnail','cross_selling',$row);
			}
		}
		return $cross_sell_data;
		}
	}

	/**
	 Reverse cross sells
	 **/
	 function getReverseCrossSells() {
		$cross_query = xtDBquery("SELECT
										p.products_tax_class_id,
										p.products_id,
										p.products_model,
										p.products_weight,
										p.manufacturers_id,
										p.products_quantity,
										p.products_image,
										pd.products_img_alt,
										pd.products_name,
										pd.products_short_description,
										p.products_fsk18,
										p.products_price,
										p.products_vpe,
										p.products_vpe_status,
										p.products_vpe_value,
                                		xp.sort_order
                                	FROM
                                		".TABLE_PRODUCTS_XSELL." xp,
                                		".TABLE_PRODUCTS." p,
                                		".TABLE_PRODUCTS_DESCRIPTION." pd
                               		WHERE
                               			xp.xsell_id = '".$this->pID."'
                               		AND
                               			xp.products_id = p.products_id
                               			".$this->groupCheck().$this->fsk18()."
                               		AND
                               			p.products_id = pd.products_id
                               		AND
                               			pd.language_id = '".$_SESSION['languages_id']."'
                               		AND
                               			p.products_status = '1'
                               		ORDER BY
                               			xp.sort_order asc");
		$i = 0;
		while ($xsell = xtc_db_fetch_array($cross_query, true)) { $i++;
			$cross_sell_data[] = $this->buildDataArray($xsell,'thumbnail','reverse_cross_selling',$i);
		}
		return $cross_sell_data;
	}

	/**
	 Zuletzt angesehen
	**/
	function getLastViewed() {
		if(MAX_DISPLAY_LAST_VIEWED != 0) {
			if(isset($_SESSION['tracking']['products_history'][0])) {
				$product_ids = array_reverse($_SESSION['tracking']['products_history']);
				$row = 0;
				for($i = 0; $i < sizeof($product_ids); $i++) {
					if($product_ids[$i] != $this->pID) {
						$row++;
						$last_viewed_query = xtDBquery("SELECT
																p.products_id,
																p.products_tax_class_id,
																p.products_quantity,
																p.products_image,
																pd.products_img_alt,
																pd.products_name,
																pd.products_description,
																pd.products_short_description, 
																pd.products_zusatz_description, 
																p.products_price,
																p.products_vpe,
																p.products_vpe_status,
																p.products_vpe_value
															FROM
																".TABLE_PRODUCTS." AS p
															LEFT JOIN
																 ".TABLE_PRODUCTS_DESCRIPTION." AS pd ON (pd.language_id = '".$_SESSION['languages_id']."')
															AND
																p.products_status = '1'
															AND
																 pd.products_id = '".(int)$product_ids[$i]."'
															AND
																p.products_id = '".(int)$product_ids[$i]."'");

						$last_viewed_data[] = $this->buildDataArray(xtc_db_fetch_array($last_viewed_query), 'thumbnail', 'last_viewed_detail', $row);
						if($row == MAX_DISPLAY_LAST_VIEWED)
							break;
					}
				}
				if(is_array($last_viewed_data))
					return $last_viewed_data;
			}
		}
	}


	/**
		Staffelpreise
	**/
	function getGraduated() {
		global $xtPrice;

		if($_SESSION['customers_status']['customers_status_id'] == '0')
			$gruppe = '1';
		else
			$gruppe = (int)$_SESSION['customers_status']['customers_status_id'];

		$staffel_query = xtDBquery("SELECT
											quantity,
											personal_offer
										FROM
											".TABLE_PERSONAL_OFFERS_BY.$gruppe."
										WHERE
											products_id = '".$this->pID."'
										ORDER BY 
											quantity ASC");
		$discount = $xtPrice->xtcCheckDiscount($this->pID);
		$staffel = array ();
		while ($staffel_values = xtc_db_fetch_array($staffel_query, true))
			$staffel[] = array ('stk' => $staffel_values['quantity'], 'price' => $staffel_values['personal_offer']);

		$staffel_data = array ();
		for ($i = 0, $n = sizeof($staffel); $i < $n; $i ++) {
			if ($staffel[$i]['stk'] == 1) {
				$quantity = $staffel[$i]['stk'];
				if ($staffel[$i +1]['stk'] != '')
					$quantity = $staffel[$i]['stk'].'-'. ($staffel[$i +1]['stk'] - 1);
			} else {
				$quantity = ' > '.$staffel[$i]['stk'];
				if ($staffel[$i +1]['stk'] != '')
					$quantity = $staffel[$i]['stk'].'-'. ($staffel[$i +1]['stk'] - 1);
			}
			$vpe = '';
			if ($this->data['products_vpe_status'] == 1 && $this->data['products_vpe_value'] != 0.0 && $staffel[$i]['price'] > 0) {
				$vpe = $staffel[$i]['price'] - $staffel[$i]['price'] / 100 * $discount;
				$vpe = $vpe * (1 / $product_info['products_vpe_value']);
				$vpe = $xtPrice->xtcFormat($vpe, true, $this->data['products_tax_class_id']).TXT_PER.xtc_get_vpe_name($this->data['products_vpe']);
			}
			$staffel_data[$i] = array(	'QUANTITY' => $quantity, 
										'VPE' => $vpe, 
										'PRICE' => $xtPrice->xtcFormat($staffel[$i]['price'] - $staffel[$i]['price'] / 100 * $discount, true, $this->data['products_tax_class_id']));
		}
		return $staffel_data;
	}

	/**
	  valid flag
	 **/
	function isProduct() {
		return $this->isProduct;
	}

	function getBuyNowButton($id, $name) {
		global $PHP_SELF;
		if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True')
			return '<a title="'.TEXT_BUY.TEXT_NOW.'" href="'.xtc_href_link($_REQUEST['linkurl'], 'action=buy_now&BUYproducts_id='.$id.'&'.xtc_get_all_get_params(array ('action', 'cat', 'cPath')), 'NONSSL').'">'.xtc_image_button('button_buy_now.gif',((CSS_BUTTON_ACTIVE=='true')?TEXT_BUTTON_BUY_NOW:TEXT_BUY.$name.TEXT_NOW)).'</a>';
		else
			return '<a title="'.TEXT_BUY.TEXT_NOW.'" href="'.xtc_href_link(basename($PHP_SELF), 'action=buy_now&BUYproducts_id='.$id.'&'.xtc_get_all_get_params(array ('action')), 'NONSSL').'">'.xtc_image_button('button_buy_now.gif',((CSS_BUTTON_ACTIVE=='true')?TEXT_BUTTON_BUY_NOW:TEXT_BUY.$name.TEXT_NOW)).'</a>';
	}

	function getWishlistButton($id, $name) {
		global $PHP_SELF;
		if(MODULE_COMMERCE_SEO_INDEX_STATUS == 'True')
			return '<a title="'.$name.TEXT_NOW_TO_WISHLIST.'" href="'.xtc_href_link($_REQUEST['linkurl'], 'action=wishlist&products_id='.$id.'&'.xtc_get_all_get_params(array ('action')), 'NONSSL').'">'.xtc_image_button('button_to_wish_list.gif',((CSS_BUTTON_ACTIVE=='true')?TEXT_TO_WISHLIST:$name.TEXT_NOW_TO_WISHLIST)).'</a>';
		else
			return '<a title="'.$name.TEXT_NOW_TO_WISHLIST.'" href="'.xtc_href_link(basename($PHP_SELF), 'action=wishlist&products_id='.$id.'&'.xtc_get_all_get_params(array ('action')), 'NONSSL').'">'.xtc_image_button('button_to_wish_list.gif',((CSS_BUTTON_ACTIVE=='true')?TEXT_TO_WISHLIST:$name.TEXT_NOW_TO_WISHLIST)).'</a>';
	}

	function getVPEtext($product, $price) {
		global $xtPrice;

		require_once (DIR_FS_INC.'xtc_get_vpe_name.inc.php');

		if (!is_array($product))
			$product = $this->data;

		if ($product['products_vpe_status'] == 1 && $product['products_vpe_value'] != 0.0 && $price > 0) {
			return $xtPrice->xtcFormat($price * (1 / $product['products_vpe_value']), true).TXT_PER.xtc_get_vpe_name($product['products_vpe']);
		}
		return;
	}

	/**
		Build Data Array
	**/
	function buildDataArray(&$array, $image = 'thumbnail', $site = '', $count = '1') {
		global $xtPrice,$main;
		if ($_SESSION['site'] != '')
		$site=$_SESSION['site'];

#echo $site;		
		$options = xtc_db_fetch_array(xtDBquery("SELECT 
														list_name, 
														col, 
														p_img, 
														p_name, 
														p_price, 
														b_details, 
														b_order, 
														b_wishlist, 
														p_reviews, 
														p_stockimg, 
														p_vpe, 
														p_model, 
														p_manu_img, 
														p_manu_name, 
														p_short_desc, 
														p_short_desc_lenght, 
														p_long_desc, 
														p_long_desc_lenght, 
														list_type 
													FROM 
														products_listings 
													WHERE 
														list_name = '".$site."' "));

		switch($options['col']) {
			case 2:
				$col_width = 'w474p';
				break;
			case 3:
				$col_width = 'w303p';
				break;
			case 4:
				$col_width = 'w223p';
				break;
			default:
				$col_width = 'w98p';
				break;
		}

		if((int)$count % (int)$options['col'] == 0) $col_class = 'last_li ';
		else $col_class = '';

		if((int)$options['col'] == 1) { 
			$col_special_class = 'only_one';
			$_SESSION['col_special_class'] = $col_special_class;
		} else {
			$col_special_class = 'gallery_item';
			$_SESSION['col_special_class'] = '';
		}

		$tax_rate = $xtPrice->TAX[$array['products_tax_class_id']];

		if((int)$options['p_price'] == 1) {
			$products_price = $xtPrice->xtcGetPrice($array['products_id'], true, 1, $array['products_tax_class_id'], $array['products_price'], 1, $options['list_type']);
			if(PRICE_AS_IMAGE == 'true')
				$price = $products_price;
			else
				$price = $products_price['formated'];
 		}

		if ($_SESSION['customers_status']['customers_status_show_price'] != '0') {
			if ($_SESSION['customers_status']['customers_fsk18'] == '1') {
				if ($array['products_fsk18'] == '0') {
					$buy_now = $this->getBuyNowButton($array['products_id'], $array['products_name']);
					$wishlist = $this->getWishlistButton($array['products_id'], $array['products_name']);
				}
			} else {
				$buy_now = $this->getBuyNowButton($array['products_id'], $array['products_name']);
				$wishlist = $this->getWishlistButton($array['products_id'], $array['products_name']);
			}
		}

		$shipping_status_name = $main->getShippingStatusName($array['products_shippingtime']);
		$shipping_status_image = $main->getShippingStatusImage($array['products_shippingtime']);

		if(PRODUCT_LISTING_MANU_IMG == 'true' && ($options['p_manu_img'] == 1)) {
			// Hersteller ermitteln
			$manufacturer_query = xtDBquery("SELECT
													m.manufacturers_id,
													m.manufacturers_name,
													m.manufacturers_image,
													mi.manufacturers_url,
													mi.manufacturers_description
												FROM
													" . TABLE_MANUFACTURERS . " m,
													" . TABLE_MANUFACTURERS_INFO . " mi
												WHERE 
													m.manufacturers_id = '".$array['manufacturers_id']."'
												AND 
													m.manufacturers_id = mi.manufacturers_id
												AND	
													mi.languages_id = '".(int)$_SESSION['languages_id']."'");
			$manufacturer = xtc_db_fetch_array($manufacturer_query,true);

			if(!empty($manufacturer['manufacturers_image']))
				$manufacturer_image = DIR_WS_IMAGES . $manufacturer['manufacturers_image'];
		}
		if(PRODUCT_LISTING_MANU_NAME == 'true'&& ($options['p_manu_name'] == 1)) {
			if(!empty($manufacturer['manufacturers_url']))
				$manufacturer_url = xtc_href_link(FILENAME_REDIRECT,'action=manufacturer&'.xtc_manufacturer_link($manufacturer['manufacturers_id'],$manufacturer['manufacturers_name']));
			if(!empty($manufacturer['manufacturers_name'])) {
				$manufacturer_name = $manufacturer['manufacturers_name'];
				$manufacturers_description = $manufacturer['manufacturers_description'];
			}
		}

		if($options['p_reviews'] == 1) {
			$reviews_query = xtDBquery("SELECT 
											reviews_id,count(reviews_rating) AS anzahl, 
											reviews_rating 
											FROM 
												".TABLE_REVIEWS." 
											WHERE 
												products_id = '".$array['products_id']."' 
											AND 
												reviews_status = '1' 
											GROUP BY products_id 
											ORDER BY reviews_rating DESC");
			$reviews_anzahl = xtc_db_num_rows($reviews_query);

			$reviews_text_query = "select r.reviews_id, 
							left(rd.reviews_text, 200) as reviews_text, 
							r.reviews_rating, 
							r.date_added, 
							p.products_id, 
							pd.products_name, 
							p.products_image, 
							r.customers_name 
							from ".TABLE_REVIEWS." r, 
							".TABLE_REVIEWS_DESCRIPTION." rd, 
							".TABLE_PRODUCTS." p, 
							".TABLE_PRODUCTS_DESCRIPTION." pd 
							where p.products_status = '1' 
							and p.products_id = '".$array['products_id']."' 
							and rd.reviews_id = r.reviews_id 
							and r.products_id = '".$array['products_id']."'
							and pd.products_id = '".$array['products_id']."' 
							and pd.language_id = '".(int) $_SESSION['languages_id']."' 
							and rd.languages_id = '".(int) $_SESSION['languages_id']."' 
							ORDER BY r.reviews_id DESC LIMIT 5";

							
			$reviews_fetch = xtDBquery($reviews_text_query);
			while($reviews = xtc_db_fetch_array($reviews_fetch)) {
				$reviews_text_alt = htmlspecialchars($reviews['reviews_text']);
			}
			
			$reviews_average_query = xtDBquery("SELECT (avg(reviews_rating) / 5 * 100) AS average_rating FROM " . TABLE_REVIEWS . " WHERE products_id = '" . $array['products_id'] . "'");
	        $reviews_average = xtc_db_fetch_array($reviews_average_query);

			if($reviews_anzahl > 0) {
				$reviews = xtc_db_fetch_array($reviews_query);
				$reviews_img = '
						<span class="fs85 product_listing_review_count" align="center">
							(<a href="'.xtc_href_link(FILENAME_REVIEWS,'show_pid='.$array['products_id']).'"';

				if ($_SESSION['customers_status']['customers_status_read_reviews'] != 0) {
					$reviews_img .= ' class="tooltip" title="'.$reviews_text_alt.'"';
				}
				$reviews_img .= '>'.$reviews['anzahl'].'</a>)';
				$reviews_img .= '<img class="al" src="templates/'.CURRENT_TEMPLATE.'/img/stars_'.$reviews['reviews_rating'].'.gif" alt="'.TEXT_OF_.$reviews['reviews_rating']._STARS.'" />';
				$reviews_img .= ' &Oslash; '.number_format($reviews_average['average_rating'], 2).'%</span>';
			}
		}

		if(PRODUCT_LISTING_VPE == 'true' && ($options['p_vpe'] == 1)) {
			$products_price = $xtPrice->xtcGetPrice($array['products_id'], false, 0, $array['products_tax_class_id'], $array['products_price']);
			$vpe = $this->getVPEtext($array, $products_price);
		}
		if(PRODUCT_LISTING_MODEL == 'true' && ($options['p_model'] == 1))
			$model = $array['products_model'];
		if($options['p_stockimg'] == 1) {
			require_once (DIR_FS_INC.'cseo_get_stock_img.inc.php');
			$stock_img = cseo_get_stock_img($array['products_quantity']);
		}
		if($options['b_details'] == 1)
			$button_details = '<a title="'.$array['products_name'].'" href="'.xtc_href_link(FILENAME_PRODUCT_INFO, xtc_product_link($array['products_id'], $array['products_name'])).'">'.xtc_image_button('button_details.gif', 'Details').'</a>';

		require_once (DIR_FS_INC.'cseo_truncate.inc.php');
		if($options['p_short_desc'] == 1)
			$description = cseo_truncate($array['products_short_description'], $options['p_short_desc_lenght']);
		elseif($options['p_long_desc'] == 1)
			$description = cseo_truncate($array['products_description'], $options['p_long_desc_lenght']);
		else
			$description = '';
		
		#Bilder und Links Title mit Mehrwert
		if ($array['products_short_description'] != '' && $array['products_img_alt'] == '') {
			$description_img_alt = cseo_truncate(strip_tags($array['products_short_description']), 35);
		} elseif ($array['products_img_alt'] != '') {
			$description_img_alt = $array['products_img_alt'];
		} else {
			$description_img_alt = cseo_truncate(strip_tags($array['products_description']), 35);
		}
		$description_title_alt = cseo_truncate(strip_tags($array['products_description']), 35);

		if($options['p_img']==1) {
			$img = $this->productImage($array['products_image'], $image);
		} else
			$img = '';

		require_once(DIR_FS_INC.'xtc_date_short.inc.php');
/*
//Auszeichnung neue Produkte und Angebote
		if (MAX_DISPLAY_NEW_PRODUCTS_DAYS != '0') {
			$date_new_products = date("Y.m.d", mktime(1, 1, 1, date(m), date(d) - MAX_DISPLAY_NEW_PRODUCTS_DAYS, date(Y)));
			$days = " AND products_date_added > '".$date_new_products."' ";
		}
		
		$disp_new_prod_query = xtDBquery("SELECT
	                                           products_id, 
											   products_date_added
	                                           FROM ".TABLE_PRODUCTS." 
	                                           WHERE products_status = 1
	                                           AND products_id ='".$array['products_id']."'
	                                           ".$days."
	                                           LIMIT ".MAX_RANDOM_SELECT_NEW);
	
		$disp_new_prod = xtc_db_fetch_array($disp_new_prod_query,true);
		if ($disp_new_prod['products_date_added'] != '') {
			$prod_is_new = 'true';
		} else {
			$prod_is_new = 'false';
		}
		$disp_top_prod_query = xtDBquery("SELECT
	                                           specials_id, 
											   products_id
	                                           FROM ".TABLE_SPECIALS." 
	                                           WHERE status = 1
	                                           AND products_id ='".$array['products_id']."'");
	
		$disp_top_prod = xtc_db_fetch_array($disp_top_prod_query,true);
		if ($disp_top_prod['specials_id'] != '') {
			$prod_is_top = 'true';
		} else {
			$prod_is_top = 'false';
		}	
*/

		
		return array (
				'PRODUCTS_NAME' => (($options['p_name'] == 1)?htmlentities($array['products_name'], ENT_COMPAT,charset_mapper($_SESSION['language_charset'])):''),
				'COUNT' => $count,
				'COL_WIDTH' => $col_width,
				'COL_CLASS' => $col_class,
				'COL_SPECIAL' => $col_special_class,
				'PRODUCTS_ID'=>$array['products_id'],
				'PRODUCTS_VPE' => $vpe,
				'PRODUCTS_IMAGE' => $img,
				'PRODUCTS_IMAGE_DIMENSION' => cseo_get_img_size($this->productImage($array['products_image'], $image)),
				'PRODUCTS_IMAGE_ALT' => $description_img_alt,
				'PRODUCTS_NAME_ALT' => $description_title_alt,
				'PRODUCTS_LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, xtc_product_link($array['products_id'], $array['products_name'])),
				'PRODUCTS_PRICE' => $price,
				'PRODUCTS_MANUFACTURER_IMG' => $manufacturer_image,
				'PRODUCTS_MANUFACTURER_URL' => $manufacturer_url,
				'PRODUCTS_MANUFACTURER_NAME' => $manufacturer_name,
				'PRODUCTS_MANUFACTURERS_DESCRIPTION' => $manufacturers_description,
				'PRODUCTS_MODEL' => $model,
				'PRODUCTS_WEIGHT' => $array['products_weight'],
				'PRODUCTS_REVIEWS' => $reviews_img,
				'PRODUCTS_STOCK_IMG' => $stock_img,
				'PRODUCTS_TAX_INFO' => $main->getTaxInfo($tax_rate),
				'PRODUCTS_SHIPPING_LINK' => $main->getShippingLink(),
				'PRODUCTS_BUTTON_BUY_NOW' => (($options['b_order']==1)?$buy_now:''),
				'PRODUCTS_BUTTON_WISHLIST' => (($options['b_wishlist']==1)?$wishlist:''),
				'PRODUCTS_BUTTON_DETAILS' => $button_details,
				'PRODUCTS_SHIPPING_NAME'=>$shipping_status_name,
				'PRODUCTS_SHIPPING_IMAGE'=>$shipping_status_image,
				'PRODUCTS_EXPIRES' => $array['expires_date'],
				'PRODUCTS_DATE' => xtc_date_short($array['products_date_available']),
				'PRODUCTS_CATEGORY_URL'=>$array['cat_url'],
				'PRODUCTS_DESCRIPTION' => $description, 
#				'PRODUCTS_NEW' => $prod_is_new, 
#				'PRODUCTS_TOP' => $prod_is_top,
				'PRODUCTS_FSK18' => $array['products_fsk18']);
		}


	function productImage($name, $type) {

		switch ($type) {
			case 'info' :
				$path = DIR_WS_INFO_IMAGES;
				break;
			case 'thumbnail' :
				$path = DIR_WS_THUMBNAIL_IMAGES;
				break;
			case 'popup' :
				$path = DIR_WS_POPUP_IMAGES;
				break;
		}

		if ($name == '') {
			if ($this->useStandardImage == 'true' && $this->standardImage != '')
				return $path.$this->standardImage;
		} else {
			// check if image exists
			if (!file_exists($path.$name)) {
				if ($this->useStandardImage == 'true' && $this->standardImage != '')
					$name = $this->standardImage;
			}
			return $path.$name;
		}
	}

}
?>