<?php
/*

Released under the GNU General Public License

*/

class tollzipzones {
    var $code, $title, $description, $enabled, $num_zones, $surcharge_factor;

    // class constructor:w

    function tollzipzones() {
        $this->code = 'tollzipzones';
        $this->title = MODULE_SHIPPING_TOLLZIPZONES_TEXT_TITLE;
        $this->description = MODULE_SHIPPING_TOLLZIPZONES_TEXT_DESCRIPTION;
        $this->icon = '';
        $this->enabled = MODULE_SHIPPING_TOLLZIPZONES_STATUS;
        $this->sort_order = MODULE_SHIPPING_TOLLZIPZONES_SORT_ORDER;
        $this->tax_class = MODULE_SHIPPING_TOLLZIPZONES_TAX_CLASS;
    }

    // class methods

    function quote($method = '') {
        global $order, $cart, $shipping_weight, $shipping_num_boxes;
	if ($_SESSION['cart']->weight >=5) {
        $zip = $order->delivery['postcode'];
        $country = $order->delivery['country']['iso_code_2'];
        if ( $zip == '' ){
            // Something is wrong, we didn't find any zone
            $this->quotes['error'] = MODULE_SHIPPING_TOLLZIPZONES_NO_ZIPCODE_FOUND;
            return $this->quotes;
        }

        $lmt = "SELECT * FROM toll_zones WHERE t_postcode<='$zip' AND t_postcode2>='$zip' AND t_country='$country'";

        $lResult = xtc_db_query($lmt); // run the query
        if (xtc_db_num_rows($lResult) == 0) {
            $this->enabled = false;
            return $this->enabled;
        }
        $lec = xtc_db_fetch_array($lResult); // get the first row of the result
        $limit_id = $lec['t_limit'];

        $zop = MODULE_SHIPPING_TOLLZIPZONES_LOW_ORDER_TOTAL . ' ' . $lec['t_limit'] . ' EUR';

        // Selber Order Total checken
        $order_total = $_SESSION['cart']->show_total();
        if ($order_total < $limit_id) {
            // Betrag zu gering fuer Anlieferung
            $this->quotes['error'] = $zop;
            return $this->quotes;
        }

        $zap = MODULE_SHIPPING_TOLLZIPZONES_TEXT_DESCRIPTION . ' ' . $zip . ' - ' . $shipping_weight . MODULE_SHIPPING_TOLLZIPZONES_TEXT_UNITS;
        $zone_id = $lec['t_zone'];

        if ( $zone_id == '' ){
            $this->enabled = false;
            return $this->enabled;
        }
        $hit = false;
        $tz_cost = $lec['t_rate'];
        $tz_table = split("[:,]" , $tz_cost);
        for ($i=0; $i<sizeof($tz_table); $i+=2) {
            if ($shipping_weight <= $tz_table[$i]) {
                $shipping = $tz_table[$i+1] + MODULE_SHIPPING_TOLLZIPZONES_HANDLING;
                $hit = true;
                break;
            }
        }

        if (!$hit) {
            $this->enabled = false;
            return false;
        }

        $this->quotes = array('id' => $this->code,
        'module' => MODULE_SHIPPING_TOLLZIPZONES_TEXT_TITLE,
        'methods' => array(array('id' => $this_code,
        'title' => $zap,
        'cost' => $shipping)));
        if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_TOLLZIPZONES_INVALID_ZONE;
        if ($this->tax_class > 0) {
            $this->quotes['tax'] = xtc_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
        }
        return $this->quotes;
    } else {
		$this->enabled = false;
	}
	
	}

    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_TOLLZIPZONES_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function install() {
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) VALUES ('MODULE_SHIPPING_TOLLZIPZONES_STATUS', 'true', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_TOLLZIPZONES_HANDLING', '0', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_TOLLZIPZONES_ALLOWED', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_TOLLZIPZONES_SORT_ORDER', '0', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_SHIPPING_TOLLZIPZONES_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
    }

    function remove() {
        $keys = '';
        $keys_array = $this->keys();
        for ($i=0; $i<sizeof($keys_array); $i++) {
            $keys .= "'" . $keys_array[$i] . "',";
        }
        $keys = substr($keys, 0, -1);
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
    }

    function keys() {
        $keys = array(
        'MODULE_SHIPPING_TOLLZIPZONES_STATUS','MODULE_SHIPPING_TOLLZIPZONES_HANDLING','MODULE_SHIPPING_TOLLZIPZONES_SORT_ORDER','MODULE_SHIPPING_TOLLZIPZONES_ALLOWED', 'MODULE_SHIPPING_TOLLZIPZONES_TAX_CLASS');
        return $keys;
    }
}
?>