<?php
/*-----------------------------------------------------------------
* 	$Id: xajax.cseofunctions.php 573 2013-08-22 06:31:36Z akausch $
* 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/
$xajax->registerFunction("ListingPrice");

function ListingPrice($attrid, $optionid, $prodid) {
	$product = new product($prodid);
	$price = new xtcPrice($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
	
	$objResponse = new xajaxResponse();
	// $objResponse->alert('val: '."\n".$attrid.'-'.$optionid.'-'.$prodid);
	$attr_price = xtc_db_fetch_array(xtDBquery("SELECT DISTINCT
													pd.*,
													p.*
												FROM
													".TABLE_PRODUCTS_ATTRIBUTES." p
												LEFT JOIN
													".TABLE_PRODUCTS." pd ON(pd.products_id = p.products_id)
												WHERE
													p.products_id = '".$prodid."'
												AND
													p.options_id = '".$optionid."'
												AND
													p.options_values_id = '".$attrid."'"));	
	
	//Stock
	if ($attr_price['attributes_stock'] != '') {
		require_once(DIR_FS_INC . 'cseo_get_stock_img.inc.php');
		$qtyattr = $attr_price['attributes_stock'];
		if ($qtyattr > STOCK_WARNING_RED) {
			$objResponse->assign('verfuegbar'.$prodid, 'innerHTML', cseo_get_stock_img($qtyattr).' Lieferzeit: 2-3 Werktage');
		} elseif ($qtyattr <= STOCK_WARNING_RED) {
			$objResponse->assign('verfuegbar'.$prodid, 'innerHTML', cseo_get_stock_img($qtyattr).' Lieferzeit: Auf Anfrage');
		}
	}
	//Stock END	
	
	if ($attr_price['options_values_price'] > 0) {
		$price_single = $price->xtcGetPrice($prodid, false, 0, 0, $product->data['products_price']);
		$price_attrib_single = $attr_price['options_values_price'];
		if ($attr_price['price_prefix'] == '+') {
			$price_sum =  $price_attrib_single + $price_single;
		} elseif ($attr_price['price_prefix'] == '=') {
			$price_sum =  $price_attrib_single;
		} else {
			$price_sum =  $price_single - $price_attrib_single;
		}
		$price_sum =  $price->xtcAddTax($price_sum, $price->TAX[$product->data['products_tax_class_id']]);
		$price_sum =  $price->xtcFormat($price_sum, true);
		$objResponse->assign('p'.$prodid, 'innerHTML', $price_sum);
	} else {
		$price_single = $price->xtcGetPrice($prodid, true, 0, $product->data['products_tax_class_id'], $product->data['products_price']);
		$objResponse->assign('p'.$prodid, 'innerHTML', $price_single);
	}
	
	return $objResponse;
}
