<?php

/* -----------------------------------------------------------------
 * 	$Id: main_blog.php 914 2014-03-27 22:35:29Z sbraeutig $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de http://www.indiv-style.de
 * H&S eCom 
 * @author little Pit(S.B.)
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */


$module_smarty = new Smarty;
$items = array();
$module_smarty->assign('tpl_path', 'templates/' . CURRENT_TEMPLATE . '/');

if (BLOG_MAIN_SORT == 'random') {
	$sortierung = 'rand() DESC';
} elseif (BLOG_MAIN_SORT == 'latest') {
	$sortierung = 'id DESC';
} else {
	$sortierung = 'id ASC';
}

if (MAIN_BLOG_MAXVALUE > 0) {
	$limit = MAIN_BLOG_MAXVALUE;
} else {
	$limit = '3';
}
// Abfrage der einzelnen Blogbeitraege aller Kategorien
$select_items_query = xtc_db_query("SELECT 
										* 
									FROM 
										" . TABLE_BLOG_ITEMS . " 
									WHERE 
										status = '2' 
									AND 
										language_id = '" . (int) $_SESSION['languages_id'] . "'
									ORDER BY " . $sortierung . " LIMIT " . $limit . ";");
while ($select_items = xtc_db_fetch_array($select_items_query)) {

	if ($select_items['shortdesc'] != '') {
		$desc = $select_items['shortdesc'];
	} else {
		$desc = cseo_truncate($select_items['description'], $select_items['lenght']);
	}
	$desc = preg_replace('/##(\w+)/', '<a href="' . xtc_href_link('hashtag/\1') . '">#\1</a>', $desc);
	$monats_name = array('01' => JAN, '02' => FEB, '03' => MRZ, '04' => APR, '05' => MAI, '06' => JUN, '07' => JUL, '08' => AUG, '09' => SEP, '10' => OKT, '11' => NOV, '12' => DEZ);

	list($blog_tag_list, $monat_raw, $blog_jahr_list) = explode(".", $select_items['date']);
	$blog_monat_list = strftime('%b', mktime(0, 0, 0, $monat_raw, $blog_tag_list, $blog_jahr_list));

	$items[] = array('title' => $select_items['title'],
		'name' => $select_items['name'],
		'description' => $desc,
		'date' => $select_items['date'],
		'tag' => $blog_tag_list,
		'monat' => $blog_monat_list,
		'jahr' => $blog_jahr_list,
		'blog_link' => xtc_href_link(FILENAME_BLOG, 'blog_cat=' . (int) $select_items['categories_id'] . '&blog_item=' . (int) $select_items['item_id']));
}


if (sizeof($items) >= 1) {
	$module_smarty->assign('language', $_SESSION['language']);
	$module_smarty->assign('blog_items', $items);
	$module_smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);

	// set cache ID
	if (!CacheCheck()) {
		$module_smarty->caching = false;
		$module = $module_smarty->fetch(cseo_get_usermod('base/module/main_blog.html', USE_TEMPLATE_DEVMODE));
	} else {
		$module_smarty->caching = true;
		$module_smarty->cache_lifetime = CACHE_LIFETIME;
		$module_smarty->cache_modified_check = CACHE_CHECK;
		$cache_id = $new_products_category_id . $_SESSION['language'] . $_SESSION['customers_status']['customers_status_name'] . $_SESSION['currency'];
		$module = $module_smarty->fetch(cseo_get_usermod('base/module/main_blog.html', USE_TEMPLATE_DEVMODE), $cache_id);
	}
	$default_smarty->assign('MODULE_main_blog', $module);
}
