<?php
/* -----------------------------------------------------------------
 * 	$Id: shipping_tracking.php 872 2014-03-21 14:46:30Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

require('includes/application_top.php');

switch ($_GET['action']) {
    case 'insert':
    case 'save':
        $shipping_tracking_id = xtc_db_prepare_input($_GET['oID']);

        $languages = xtc_get_languages();
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $shipping_tracking_name_array = $_POST['shipping_tracking_name'];
            $shipping_tracking_url_array = $_POST['shipping_tracking_url'];
            $shipping_tracking_text_array = $_POST['shipping_tracking_text'];
            $language_id = $languages[$i]['id'];

            $sql_data_array = array('shipping_tracking_name' => xtc_db_prepare_input($shipping_tracking_name_array[$language_id]),
									'shipping_tracking_url' => xtc_db_prepare_input($shipping_tracking_url_array[$language_id]),
									'shipping_tracking_text' => xtc_db_prepare_input($shipping_tracking_text_array[$language_id])
			);

            if ($_GET['action'] == 'insert') {
                if (!xtc_not_null($shipping_tracking_id)) {
                    $next_id = xtc_db_fetch_array(xtc_db_query("SELECT max(shipping_tracking_id) AS shipping_tracking_id FROM " . TABLE_SHIPPING_TRACKING . ";"));
                    $shipping_tracking_id = $next_id['shipping_tracking_id'] + 1;
                }

                $insert_sql_data = array('shipping_tracking_id' => $shipping_tracking_id,
                    'language_id' => $language_id);
                $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                xtc_db_perform(TABLE_SHIPPING_TRACKING, $sql_data_array);
            } elseif ($_GET['action'] == 'save') {
                xtc_db_perform(TABLE_SHIPPING_TRACKING, $sql_data_array, 'update', "shipping_tracking_id = '" . xtc_db_input($shipping_tracking_id) . "' and language_id = '" . $language_id . "'");
            }
        }


        if ($_POST['default'] == 'on') {
            xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value = '" . xtc_db_input($shipping_tracking_id) . "' WHERE configuration_key = 'DEFAULT_SHIPPING_TRACKING_ID';");
        }

        xtc_redirect(xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $shipping_tracking_id));
        break;

    case 'deleteconfirm':
        $oID = xtc_db_prepare_input($_GET['oID']);
        $shipping_tracking = xtc_db_fetch_array(xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'DEFAULT_SHIPPING_TRACKING_ID';"));

        if ($shipping_tracking['configuration_value'] == $oID) {
            xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value = '' WHERE configuration_key = 'DEFAULT_SHIPPING_TRACKING_ID'");
        }

        xtc_db_query("DELETE FROM " . TABLE_SHIPPING_TRACKING . " WHERE shipping_tracking_id = '" . xtc_db_input($oID) . "';");
        xtc_redirect(xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page']));
        break;

    case 'delete':
        $oID = xtc_db_prepare_input($_GET['oID']);

        $remove_status = true;
        if ($oID == DEFAULT_SHIPPING_TRACKING_ID) {
            $remove_status = false;
            $messageStack->add(ERROR_REMOVE_DEFAULT_SHIPPING_STATUS, 'error');
        } else {
            
        }
        break;
}

require_once(DIR_WS_INCLUDES . 'header.php');
?>
<table class="table_pageHeading" border="0" width="100%" cellspacing="0" cellpadding="0">
	<tr>
		<td class="pageHeading">
			<?php echo HEADING_TITLE_TRACKING; ?>
		</td>
	</tr>
</table>

<table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td valign="top"><table width="100%" cellspacing="0" cellpadding="0" class="dataTable">
					<tr class="dataTableHeadingRow">
						<th class="dataTableHeadingContent" width="1"><?php echo TABLE_HEADING_SHIPPING_TRACKING_NAME; ?></th>
						<th class="dataTableHeadingContent" width="100%"><?php echo TABLE_HEADING_SHIPPING_TRACKING_URL; ?></th>
						<th class="dataTableHeadingContent last" align="right"><?php echo TABLE_HEADING_ACTION; ?></th>
					</tr>
					<?php
					$shipping_tracking_query_raw = "SELECT * FROM " . TABLE_SHIPPING_TRACKING . " WHERE language_id = '" . (int)$_SESSION['languages_id'] . "' ORDER BY shipping_tracking_id";
					$shipping_tracking_split = new splitPageResults($_GET['page'], '20', $shipping_tracking_query_raw, $shipping_tracking_query_numrows);
					$shipping_tracking_query = xtc_db_query($shipping_tracking_query_raw);
					$i = 1;
					while ($shipping_tracking = xtc_db_fetch_array($shipping_tracking_query)) {
						if (((!$_GET['oID']) || ($_GET['oID'] == $shipping_tracking['shipping_tracking_id'])) && (!$oInfo) && (substr($_GET['action'], 0, 3) != 'new')) {
							$oInfo = new objectInfo($shipping_tracking);
						}
						if ((is_object($oInfo)) && ($shipping_tracking['shipping_tracking_id'] == $oInfo->shipping_tracking_id)) {
							echo '<tr class="dataTableRowSelected" onclick="document.location.href=\'' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $oInfo->shipping_tracking_id . '&action=edit') . '\'">' . "\n";
						} else {
							echo '<tr class="' . (($i % 2 == 0) ? 'dataTableRow' : 'dataWhite') . '" onclick="document.location.href=\'' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $shipping_tracking['shipping_tracking_id']) . '\'">' . "\n";
						}

						if (DEFAULT_SHIPPING_TRACKING_ID == $shipping_tracking['shipping_tracking_id']) {
							echo '<td class="dataTableContent"><b>' . $shipping_tracking['shipping_tracking_name'] . ' (' . TEXT_DEFAULT . ')</b></td>' . "\n";
							echo '<td class="dataTableContent" align="center">';
							if ($shipping_tracking['shipping_tracking_url'] != '') {
								echo 'OK';
							} else {
								echo '-';
							}
							echo '</td>';
						} else {

							echo '<td class="dataTableContent">' . $shipping_tracking['shipping_tracking_name'] . '</td>' . "\n";
							echo '<td class="dataTableContent last" align="center">';
							if ($shipping_tracking['shipping_tracking_url'] != '') {
								echo 'OK';
							} else {
								echo '-';
							}
							echo '</td>';
						}
						?>
						<td class="dataTableContent" align="right">
						<?php if ((is_object($oInfo)) && ($shipping_tracking['shipping_tracking_id'] == $oInfo->shipping_tracking_id)) {
						echo xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', '');
					} else {
						echo '<a href="' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $shipping_tracking['shipping_tracking_id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>';
					} ?>&nbsp;
					</td>
					<?php
					$i++;
					}
					?>
					</tr>
				</table>
				<table border="0" width="100%" cellspacing="0" cellpadding="2">
					<tr>
						<td class="smallText" valign="top"><?php echo $shipping_tracking_split->display_count($shipping_tracking_query_numrows, '20', $_GET['page'], TEXT_DISPLAY_NUMBER_OF_SHIPPING_STATUS); ?></td>
						<td class="smallText" align="right"><?php echo $shipping_tracking_split->display_links($shipping_tracking_query_numrows, '20', MAX_DISPLAY_PAGE_LINKS, $_GET['page']); ?></td>
					</tr>
					<?php
					if (substr($_GET['action'], 0, 3) != 'new') {
						?>
						<tr>
							<td colspan="2" align="right"><?php echo '<a class="button" href="' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&action=new') . '">' . BUTTON_INSERT . '</a>'; ?></td>
						</tr>
				<?php
			}
			?>
				</table>
			</td>
			<?php
			$heading = array();
			$contents = array();
			switch ($_GET['action']) {
				case 'new':
					$heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_NEW_SHIPPING_STATUS . '</b>');

					$contents = array('form' => xtc_draw_form('status', FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&action=insert', 'post', 'enctype="multipart/form-data"'));
					$contents[] = array('text' => TEXT_INFO_INSERT_INTRO);

					$shipping_tracking_inputs_string = '';
					$shipping_tracking_url_string = '';
					$shipping_tracking_text_string = '';
					$languages = xtc_get_languages();
					for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
						$shipping_tracking_inputs_string .= '<br />' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image']) . '&nbsp;' . xtc_draw_input_field('shipping_tracking_name[' . $languages[$i]['id'] . ']');
						$shipping_tracking_url_string .= '<br />' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image']) . '&nbsp;' . xtc_draw_textarea_field('shipping_tracking_url[' . $languages[$i]['id'] . ']', 'soft', '60', '5', '');
						$shipping_tracking_text_string .= '<br />' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image']) . '&nbsp;' . xtc_draw_textarea_field('shipping_tracking_text[' . $languages[$i]['id'] . ']', 'soft', '60', '5', '');
					}
					$contents[] = array('text' => '<br />' . TEXT_INFO_SHIPPING_STATUS_NAME . $shipping_tracking_inputs_string);
					$contents[] = array('text' => '<br />' . TEXT_INFO_SHIPPING_TRACKING_URL . $shipping_tracking_url_string);
					$contents[] = array('text' => '<br />' . TEXT_INFO_SHIPPING_TRACKING_TEXT . $shipping_tracking_text_string);
					$contents[] = array('text' => '<br />' . xtc_draw_checkbox_field('default') . ' ' . TEXT_SET_DEFAULT);
					$contents[] = array('align' => 'center', 'text' => '<br /><input type="submit" class="button" value="' . BUTTON_INSERT . '"/> <a class="button" href="' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page']) . '">' . BUTTON_CANCEL . '</a>');
					break;

				case 'edit':
					$heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_EDIT_SHIPPING_STATUS . '</b>');

					$contents = array('form' => xtc_draw_form('status', FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $oInfo->shipping_tracking_id . '&action=save', 'post', 'enctype="multipart/form-data"'));
					$contents[] = array('text' => TEXT_INFO_EDIT_INTRO);

					$shipping_tracking_inputs_string = '';
					$shipping_tracking_url_string = '';
					$shipping_tracking_text_string = '';
					$languages = xtc_get_languages();
					for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
						$shipping_tracking_inputs_string .= '<br />' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image']) . '&nbsp;' . xtc_draw_input_field('shipping_tracking_name[' . $languages[$i]['id'] . ']', xtc_get_shipping_tracking_name($oInfo->shipping_tracking_id, $languages[$i]['id']));
						$shipping_tracking_url_string .= '<br />' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image']) . '&nbsp;' . xtc_draw_textarea_field('shipping_tracking_url[' . $languages[$i]['id'] . ']', 'soft', '60', '5', xtc_get_shipping_tracking_url($oInfo->shipping_tracking_id, $languages[$i]['id']));
						$shipping_tracking_text_string .= '<br />' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image']) . '&nbsp;' . xtc_draw_textarea_field('shipping_tracking_text[' . $languages[$i]['id'] . ']', 'soft', '60', '5', xtc_get_shipping_tracking_text($oInfo->shipping_tracking_id, $languages[$i]['id']));
					}
					$contents[] = array('text' => '<br />' . TEXT_INFO_SHIPPING_STATUS_NAME . $shipping_tracking_inputs_string);
					$contents[] = array('text' => '<br />' . TEXT_INFO_SHIPPING_TRACKING_URL . $shipping_tracking_url_string);
					$contents[] = array('text' => '<br />' . TEXT_INFO_SHIPPING_TRACKING_TEXT . $shipping_tracking_text_string);
					if (DEFAULT_SHIPPING_TRACKING_ID != $oInfo->shipping_tracking_id)
						$contents[] = array('text' => '<br />' . xtc_draw_checkbox_field('default') . ' ' . TEXT_SET_DEFAULT);
					$contents[] = array('align' => 'center', 'text' => '<br /><input type="submit" class="button" value="' . BUTTON_UPDATE . '"/> <a class="button" href="' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $oInfo->shipping_tracking_id) . '">' . BUTTON_CANCEL . '</a>');
					break;

				case 'delete':
					$heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_SHIPPING_STATUS . '</b>');

					$contents = array('form' => xtc_draw_form('status', FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $oInfo->shipping_tracking_id . '&action=deleteconfirm'));
					$contents[] = array('text' => TEXT_INFO_DELETE_INTRO);
					$contents[] = array('text' => '<br /><b>' . $oInfo->shipping_tracking_name . '</b>');
					if ($remove_status)
						$contents[] = array('align' => 'center', 'text' => '<br /><input type="submit" class="button" value="' . BUTTON_DELETE . '"/> <a class="button" href="' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $oInfo->shipping_tracking_id) . '">' . BUTTON_CANCEL . '</a>');
					break;

				default:
					if (is_object($oInfo)) {
						$heading[] = array('text' => '<b>' . $oInfo->shipping_tracking_name . '</b>');

						$contents[] = array('align' => 'center', 'text' => '<br /><a class="button" href="' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $oInfo->shipping_tracking_id . '&action=edit') . '">' . BUTTON_EDIT . '</a> <a class="button" href="' . xtc_href_link(FILENAME_SHIPPING_TRACKING, 'page=' . $_GET['page'] . '&oID=' . $oInfo->shipping_tracking_id . '&action=delete') . '">' . BUTTON_DELETE . '</a>');

						$shipping_tracking_inputs_string = '';
						$languages = xtc_get_languages();
						for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
							$shipping_tracking_inputs_string .= '<br />' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image']) . '&nbsp;' . xtc_get_shipping_tracking_name($oInfo->shipping_tracking_id, $languages[$i]['id']);
						}

						$contents[] = array('text' => $shipping_tracking_inputs_string);
					}
					break;
			}

			if ((xtc_not_null($heading)) && (xtc_not_null($contents))) {
				echo '            <td width="25%" class="border" valign="top">' . "\n";

				$box = new box;
				echo $box->infoBox($heading, $contents);

				echo '            </td>' . "\n";
			}
			?>
		</tr>
	</table>

<?php

require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
