<?php

/* -----------------------------------------------------------------
 * 	$Id: blog_rss.php 957 2014-04-09 21:28:24Z sbraeutig $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include ('includes/application_top.php');

$Title = "Blog RSS Feed von " . STORE_NAME;
$logo_url = HTTP_SERVER . DIR_WS_CATALOG . "templates/" . CURRENT_TEMPLATE . "/img/logo.gif";

$Description = "Neue Blog Einträge von " . STORE_NAME;
$copyright = STORE_NAME;
$category = "Beiträge";
$date = date("r");

$SiteLink = HTTP_SERVER . DIR_WS_CATALOG;

header("Content-Type: text/xml");
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
echo "<rss version=\"2.0\">\n\n";
echo "\t<channel>\n";
echo "\t\t<title>$Title</title>\n";
echo "\t\t<link>$SiteLink</link>\n";
echo "\t\t<description>$Description</description>\n";
echo "\t\t<language>de-de</language>\n";
echo "\t\t<copyright>$copyright</copyright>\n";
echo "\t\t<pubDate>$date</pubDate>\n";

echo "\t\t<image>\n\t\t\t<url>" . $logo_url . "</url>\n\t\t\t<title>Shoplogo</title>\n\t\t\t<link>" . $SiteLink . "</link>\n\t\t</image>\n\n";

$days = date("d.m.Y", mktime(1, 1, 1, date(m), date(d) - 30, date(Y)));

$query = xtc_db_query("SELECT name, item_id, categories_id, description, date FROM " . TABLE_BLOG_ITEMS . " WHERE status = 2 AND language_id = '" . $_SESSION['languages_id'] . "' AND '" . $days . "' ORDER BY id DESC");

while ($listing = xtc_db_fetch_array($query, true)) {
	 $image = xtc_db_fetch_array(xtc_db_query("select image from blog_item_images where item_id = ".$listing['item_id']." AND image_nr = 1 LIMIT 1 "));
	 if($image['image'] == ''){
		 $image_link = HTTP_SERVER . '/images/blog_image/original_images/no_img_big.jpg';
	 }else{
		 $image_link = HTTP_SERVER . '/images/blog_image/popup_images/' . $image['image'];
	 }
	 echo $listing['item_id'];
    $link = xtc_href_link(FILENAME_BLOG, 'blog_cat=' . $listing['categories_id'] . '&blog_item=' . $listing['item_id'], 'NONSSL', false);

    $blog_name = $listing['name'];
    $blog_name = str_replace("&", "&amp;", $blog_name);
    $blog_name = str_replace("\n", " ", $blog_name);

    echo "\t\t<item>\n";
    echo "\t\t\t<pubDate>" . $listing['date'] . "</pubDate>\n";
    echo "\t\t\t<category>" . $category . "</category>\n";
    echo "\t\t\t<title>" . $blog_name .$image_link. "</title>\n";
    echo "\t\t\t<link>" . $link . "</link>\n";
    echo "\t\t\t<guid>" . $link . "</guid>\n";
    echo "\t\t\t<description><![CDATA[" . $listing['description'] . "\t\t\t\n\n<img src='" . $image_link . "' />]]></description>\n";
    echo "\t\t</item>\n\n";
}

echo "\t</channel>\n";
echo "</rss>";