<?php
/*******************************************************************************
 *  Copyright 2010 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at: http://aws.amazon.com/apache2.0
 *  This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 *  CONDITIONS OF ANY KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations under the License.
 * *****************************************************************************
 */


/**
 *  @see CheckoutByAmazon_Service_Model
 */
require_once ('CheckoutByAmazon/Service/Model.php');  

    

/**
 * CheckoutByAmazon_Service_Model_PromotionList
 * 
 * Properties:
 * <ul>
 * 
 * <li>Promotion: CheckoutByAmazon_Service_Model_Promotion</li>
 *
 * </ul>
 */ 
class CheckoutByAmazon_Service_Model_PromotionList extends CheckoutByAmazon_Service_Model
{


    /**
     * Construct new CheckoutByAmazon_Service_Model_PromotionList
     * 
     * @param mixed $data DOMElement or Associative Array to construct from. 
     * 
     * Valid properties:
     * <ul>
     * 
     * <li>Promotion: CheckoutByAmazon_Service_Model_Promotion</li>
     *
     * </ul>
     */
    public function __construct($data = null)
    {
        $this->_fields = array (
        'Promotion' => array('FieldValue' => array(), 'FieldType' => array('CheckoutByAmazon_Service_Model_Promotion')),
        );
        parent::__construct($data);
    }

        /**
     * Gets the value of the Promotion.
     * 
     * @return array of Promotion Promotion
     */
    public function getPromotion() 
    {
        return $this->_fields['Promotion']['FieldValue'];
    }

    /**
     * Sets the value of the Promotion.
     * 
     * @param mixed Promotion or an array of Promotion Promotion
     * @return this instance
     */
    public function setPromotion($promotion) 
    {
        if (!$this->_isNumericArray($promotion)) {
            $promotion =  array ($promotion);    
        }
        $this->_fields['Promotion']['FieldValue'] = $promotion;
        return $this;
    }


    /**
     * Sets single or multiple values of Promotion list via variable number of arguments. 
     * For example, to set the list with two elements, simply pass two values as arguments to this function
     * <code>withPromotion($promotion1, $promotion2)</code>
     * 
     * @param Promotion  $promotionArgs one or more Promotion
     * @return CheckoutByAmazon_Service_Model_PromotionList  instance
     */
    public function withPromotion($promotionArgs)
    {
        foreach (func_get_args() as $promotion) {
            $this->_fields['Promotion']['FieldValue'][] = $promotion;
        }
        return $this;
    }   



    /**
     * Checks if Promotion list is non-empty
     * 
     * @return bool true if Promotion list is non-empty
     */
    public function isSetPromotion()
    {
        return count ($this->_fields['Promotion']['FieldValue']) > 0;
    }




}