<?php

/* --------------------------------------------------------------
  CheckoutByAmazon PaymentModul V1.2.1
  checkout_amazon.php 2011-10-28

  Ruhrmedia GmbH & Co. KG
  http://www.RuhrMedia.de
  Copyright (c) 2011 Ruhrmedia GmbH & Co. KG

  alkim media
  http://www.alkim.de

  Released under the GNU General Public License
  --------------------------------------------------------------
 */

define('MODULE_PAYMENT_RMAMAZON_TEXT_DESCRIPTION', 'Amazon Payments Checkout');

class rmamazon {

    var $code, $title, $description, $enabled;

    function rmamazon() {
        global $order;

        $this->group_id = 777;
        $this->code = 'rmamazon';
        $this->title = '<img src="../CheckoutByAmazon/logo.gif" border="0" alt="CBA Logo" />Amazon Payments';

        $this->sort_order = MODULE_PAYMENT_RMAMAZON_SORT_ORDER;
        $this->enabled = ((MODULE_PAYMENT_RMAMAZON_STATUS == 'True') ? true : false);
        $this->info = MODULE_PAYMENT_RMAMAZON_TEXT_DESCRIPTION;

        $check = xtc_db_num_rows(xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_group_id = '" . $this->group_id . "' LIMIT 1"));
        if ($check == 0) {
            $this->description = MODULE_PAYMENT_RMAMAZON_TEXT_DESCRIPTION;
        } else {
            $this->description = MODULE_PAYMENT_RMAMAZON_TEXT_DESCRIPTION . '<br/><br/><a href="configuration.php?gID=' . $this->group_id . '" class="button">Zur Konfiguration</a><br/>';
        }
    }

    function update_status() {
        global $order;

        return $this->enabled;
    }

    function javascript_validation() {
        return false;
    }

    function selection() {
        return false;
    }

    function pre_confirmation_check() {
        return false;
    }

    function confirmation() {
        return false;
    }

    function process_button() {
        return false;
    }

    function before_process() {
        return false;
    }

    function after_process() {
        
    }

    function get_error() {
        return false;
    }

    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_RMAMAZON_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function install() {
        xtc_db_query("CREATE TABLE IF NOT EXISTS `amz_storno` (
                                `id` int(11) NOT NULL AUTO_INCREMENT,
                                `orders_id` int(11) NOT NULL,
                                `orders_products_id` int(11) NOT NULL,
                                `is_shipping` tinyint(1) NOT NULL,
                                `price` decimal(10,2) NOT NULL,
                                `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
                                PRIMARY KEY (`id`)
                                ) AUTO_INCREMENT=1 ;");

        $result = xtc_db_query("show columns from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " like 'products_attributes_id'");
        if (xtc_db_num_rows($result) == 0) {
            xtc_db_query("ALTER TABLE `orders_products_attributes` ADD `products_attributes_id` INT( 11 ) NOT NULL ;");
        }
        $result = xtc_db_query("show columns from " . TABLE_ORDERS_PRODUCTS . " like 'AmazonOrderItemCode'");
        if (xtc_db_num_rows($result) == 0) {
            xtc_db_query("ALTER TABLE `orders_products` ADD `AmazonOrderItemCode` VARCHAR( 255 ) NOT NULL ;");
        }
        $result = xtc_db_query("show columns from " . TABLE_ORDERS_PRODUCTS . " like 'AmazonShippingCosts'");
        if (xtc_db_num_rows($result) == 0) {
            xtc_db_query("ALTER TABLE `orders_products` ADD `AmazonShippingCosts` DECIMAL( 10, 2 ) NOT NULL ;");
        }
        $result = xtc_db_query("show columns from " . TABLE_ORDERS_PRODUCTS . " like 'AmazonCoupon'");
        if (xtc_db_num_rows($result) == 0) {
            xtc_db_query("ALTER TABLE `orders_products` ADD `AmazonCoupon` DECIMAL( 10, 2 ) NOT NULL ;");
        }
        xtc_db_query("ALTER TABLE `" . TABLE_ORDERS_STATUS . "` CHANGE `orders_status_name` `orders_status_name` VARCHAR( 64 )");

        if (xtc_db_num_rows(xtc_db_query("SELECT orders_status_id FROM " . TABLE_ORDERS_STATUS . " WHERE orders_status_id = '77' LIMIT 1")) == 0) {
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('77','1','Amazon Payments - benachrichtigt')");
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('77','2','Amazon Payments - benachrichtigt')");
        }
        if (xtc_db_num_rows(xtc_db_query("SELECT orders_status_id FROM " . TABLE_ORDERS_STATUS . " WHERE orders_status_id = '78' LIMIT 1")) == 0) {
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('78','1','Amazon Payments - warten auf Zahlung')");
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('78','2','Amazon Payments - warten auf Zahlung')");
        }
        if (xtc_db_num_rows(xtc_db_query("SELECT orders_status_id FROM " . TABLE_ORDERS_STATUS . " WHERE orders_status_id = '79' LIMIT 1")) == 0) {
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('79','1','Amazon Payments - Zahlung eingegangen')");
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('79','2','Amazon Payments - Zahlung eingegangen')");
        }
        if (xtc_db_num_rows(xtc_db_query("SELECT orders_status_id FROM " . TABLE_ORDERS_STATUS . " WHERE orders_status_id = '80' LIMIT 1")) == 0) {
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('80','1','Amazon Payments - Versendet')");
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('80','2','Amazon Payments - Versendet')");
        }
        if (xtc_db_num_rows(xtc_db_query("SELECT orders_status_id FROM " . TABLE_ORDERS_STATUS . " WHERE orders_status_id = '81' LIMIT 1")) == 0) {
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('81','1','Amazon Payments - Storniert')");
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) VALUES ('81','2','Amazon Payments - Storniert')");
        }
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_STATUS', 'True',  '" . $this->group_id . "', '1', '', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_SORT_ORDER', '0',  '" . $this->group_id . "', '2', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_ALLOWED', 'DE',  '" . $this->group_id . "', '2', now())");

        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_MERCHANTID', '',  '" . $this->group_id . "', '3', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_MERCHANTTOKEN', '',  '" . $this->group_id . "', '9', now())");

        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_ACCESKEY', '',  '" . $this->group_id . "', '4', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_SECRETKEY', '',  '" . $this->group_id . "', '5', now())");

        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_MODE', 'sandbox',  '" . $this->group_id . "', '7', now())");

        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_ORDER_STATUS_NOTIFIED', '77',  '" . $this->group_id . "', '20', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_ORDER_STATUS_OK', '78',  '" . $this->group_id . "', '21', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_ORDER_STATUS_PAYED', '79',  '" . $this->group_id . "', '22', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_ORDER_STATUS_SHIPPED', '80',  '" . $this->group_id . "', '23', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_ORDER_STATUS_STORNO', '81',  '" . $this->group_id . "', '24', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");

        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_SENDMAILS', 'False',  '" . $this->group_id . "', '10', '', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_RMAMAZON_MAIL', '',  '" . $this->group_id . "', '11', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_SENDUSERMAIL', 'False',  '" . $this->group_id . "', '40', '', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_ALLOW_GUESTS', 'True',  '" . $this->group_id . "', '41', '', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_RMAMAZON_SHOW_ORDERID', 'True',  '" . $this->group_id . "', '42', '', now())");

        xtc_db_query("INSERT INTO `configuration_group` (`configuration_group_id`, `configuration_group_title`, `configuration_group_description`, `sort_order`, `visible`) VALUES (" . $this->group_id . ", 'Amazon Payments', '', NULL, 1)");

        $result = xtc_db_query("show columns from " . TABLE_ORDERS . " like 'amazon_order_id'");
        if (xtc_db_num_rows($result) == 0) {
            xtc_db_query("ALTER TABLE `" . TABLE_ORDERS . "` ADD `amazon_order_id` VARCHAR( 255 )");
        }
        $result2 = xtc_db_query("show columns from " . TABLE_ORDERS . " like 'amazon_contract_id'");
        if (xtc_db_num_rows($result2) == 0) {
            xtc_db_query("ALTER TABLE `" . TABLE_ORDERS . "` ADD `amazon_contract_id` VARCHAR( 255 )");
        }
    }

    function remove() {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where  configuration_group_id = '" . $this->group_id . "'");
        xtc_db_query("delete from `configuration_group` where configuration_group_id = '" . $this->group_id . "'");
    }

    function keys() {
        return array('MODULE_PAYMENT_RMAMAZON_STATUS', 'MODULE_PAYMENT_RMAMAZON_SORT_ORDER');
    }

}

