<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */


/**
 * Get Report List  Sample
 */

include_once ('.config.inc.php'); 

$reports = new MarketplaceWebService_MWSReportsClient();

//Uncomment the following if you need to pass them as arguments
// $availableToDate = new DateTime("2011-09-21");
// $availableFromDate = new DateTime("2011-08-01");

$nextToken = "";

echo "==========================================================================================================" . PHP_EOL;
echo "Getting the ReportId's for the reports that finished processing!" . PHP_EOL;
echo "==========================================================================================================" . PHP_EOL;

//List of the ReportRequestId's that have finished processing
$reportRequestIdList = array('Id' => array());
array_push($reportRequestIdList['Id'],"4352199682");
array_push($reportRequestIdList['Id'],"4348985000");
array_push($reportRequestIdList['Id'],"4343082316");

$feedSubmissionInfoList = array();
$getFeedSubmissionListResult = $reports->getAllReportsList($reportRequestIdList, null, 0, null, null);
$reportInfoList = array_merge($reportInfoList,$getReportListResult->getReportInfoList());

//Checking if there are any more results, if so they are also added to the ArrayList
if ($getReportListResult->getHasNext())
{
	$getReportListByNextTokenResult = new MarketplaceWebService_Model_GetReportListByNextTokenResult();
	$nextToken = $getReportListResult->getNextToken();
	do
	{
		$getReportListByNextTokenResult = $reports->getReportListByNextToken($nextToken);
		$reportInfoList = array_merge($reportInfoList,$getReportListByNextTokenResult.getReportInfoList());
		echo "Size of list: " + count($reportInfoList) . PHP_EOL;
		$nextToken = $getReportListByNextTokenResult.getNextToken();
	} while ($getReportListByNextTokenResult->getHasNext());
}

echo "The total no. of ReportId's is : " + count($reportInfoList) . PHP_EOL;
echo "The ReportId's are :" . PHP_EOL;
foreach ($reportInfoList as $reportInfo)
{
	echo $reportInfo->getReportId() .PHP_EOL;
}

?>
