<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */

/**
 * Get Feed Submission List  Sample
 */

include_once ('.config.inc.php'); 

$feeds = new MarketplaceWebService_MWSFeedsClient();

//Uncomment the following if you need to pass them as arguments
// $availableToDate = new DateTime("2011-09-21");
// $availableFromDate = new DateTime("2011-08-01");

$nextToken = "";

echo "==========================================================================================================" . PHP_EOL;
echo "Getting the processing status for the given FeedSubmissionID's!" . PHP_EOL;
echo "==========================================================================================================" . PHP_EOL;

//List of the ReportRequestId's that have finished processing
$feedSubmissionIdList = array('Id' => array());
array_push($feedSubmissionIdList['Id'],"4504604142");
array_push($feedSubmissionIdList['Id'],"4504604364");
array_push($feedSubmissionIdList['Id'],"4504605280");

$feedSubmissionInfoList = array();
$getFeedSubmissionListResult = $feeds->getFeedSubmissionList($feedSubmissionIdList, null, null, null, null, null);
$feedSubmissionInfoList = array_merge($feedSubmissionInfoList,$getFeedSubmissionListResult->getFeedSubmissionInfoList());

//Checking if there are any more results, if so they are also added to the ArrayList
if ($getFeedSubmissionListResult->getHasNext())
{
	$getFeedSubmissionListByNextTokenResult = new MarketplaceWebService_Model_GetFeedSubmissionListByNextTokenResult();
	$nextToken = $getFeedSubmissionListResult->getNextToken();
	do
	{
		$getFeedSubmissionListByNextTokenResult = $feeds->getFeedSubmissionListByNextToken($nextToken);
		$feedSubmissionInfoList = array_merge($feedSubmissionInfoList,$getFeedSubmissionListByNextTokenResult.getFeedSubmissionInfoList());
		echo "Size of list: " + count($feedSubmissionInfoList) . PHP_EOL;
		$nextToken = $getFeedSubmissionListByNextTokenResult.getNextToken();
	} while ($getFeedSubmissionListByNextTokenResult->getHasNext());
}

echo "The total no. of FeedSubmissionID's is : " + count($feedSubmissionInfoList) . PHP_EOL;
echo "The status for each FeedSubmissionID's  is :" . PHP_EOL;
foreach ($feedSubmissionInfoList as $feedSubmissionInfo)
{
	echo $feedSubmissionInfo->getFeedSubmissionId() . " :: " . $feedSubmissionInfo->getFeedProcessingStatus() .PHP_EOL;
}

?>