<?php

/* --------------------------------------------------------------
  CheckoutByAmazon PaymentModul V1.2.1
  checkout_amazon.php 2011-10-28

  Ruhrmedia GmbH & Co. KG
  http://www.RuhrMedia.de
  Copyright (c) 2011 Ruhrmedia GmbH & Co. KG

  alkim media
  http://www.alkim.de

  Released under the GNU General Public License
  --------------------------------------------------------------
 */
?><?php

include ('includes/application_top.php');
include_once ('CheckoutByAmazon/.config.inc.php');
include_once ('CheckoutByAmazon/functions.php');

// include_once ('CheckoutByAmazon/Service/Client.php');
// include_once ('CheckoutByAmazon/Service/Model/GetPurchaseContractRequest.php');


function prepareMoneyInfo($str) {
    // return mb_convert_encoding($str, "UTF-8", "ISO-8859-15");
    return $str; /* return mb_convert_encoding($str, "UTF-8", "ISO-8859-15"); */
}

// Service initialisieren
if (MODULE_PAYMENT_RMAMAZON_MODE == 'live') {
    $config = array('ServiceURL' => 'https://payments.amazon.de/cba/api/purchasecontract/');
} else {
    $config = array('ServiceURL' => 'https://payments-sandbox.amazon.de/cba/api/purchasecontract/');
}

$service = new CheckoutByAmazon_Service_Client(AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY, $config);

$_SESSION['payment'] = 'rmamazon';

$request = new CheckoutByAmazon_Service_Model_GetPurchaseContractRequest(
        array('PurchaseContractId' => ($_SESSION['amazon_id'])));
$amazon_address = invokeGetPurchaseContract($service, $request);
if ($amazon_address == false) {
    echo "Fehler";
}
$iso_code = (string) $amazon_address->GetPurchaseContractResult->PurchaseContract->Destinations->Destination->PhysicalDestinationAttributes->ShippingAddress->CountryCode;
$_SESSION['delivery_zone'] = $iso_code;
$c1_query = xtc_db_query("SELECT * FROM " . TABLE_COUNTRIES . " WHERE countries_iso_code_2 = '" . $iso_code . "' LIMIT 1");
$c1_result = xtc_db_fetch_array($c1_query);
$c2_query = xtc_db_query("SELECT * FROM " . TABLE_ZONES . " WHERE zone_country_id = '" . $c1_result['countries_id'] . "' LIMIT 1");
$c2_result = xtc_db_fetch_array($c2_query);
$order->delivery['country_id'] = $c1_result['countries_id'];
$order->delivery['country']['id'] = $c1_result['countries_id'];
$_SESSION['AMZ_COUNTRY_ID'] = $c1_result['countries_id'];
$order->delivery['country']['title'] = $c1_result['countries_name'];
$order->delivery['zone_id'] = $c2_result['zone_id'];
$_SESSION['AMZ_ZONE_ID'] = $c2_result['zone_id'];

$sLeft = prepareMoneyInfo($xtPrice->currencies[$xtPrice->actualCurr]['symbol_left']);
$sRight = prepareMoneyInfo($xtPrice->currencies[$xtPrice->actualCurr]['symbol_right']);

if (isset($_GET['cba_select_shipping']) && $_GET['cba_select_shipping'] != '') {
    $cba_shipping = explode('|', $_GET['cba_select_shipping']);
    $cba_shipping[0] = round((float) $cba_shipping[0], 2);
    $cost = $cba_shipping[0];
    if ($cba_shipping[2] > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 1) {
        $cost = round((float) $cba_shipping[0] / (100 + $cba_shipping[2]) * 100, 2);
    }
    $_SESSION['shipping'] = array('id' => $cba_shipping[1] . '_' . $cba_shipping[1], 'title' => 'Versandauswahl per AmazonCheckout', 'cost' => $cost);
}
// Order Object initialisieren
require (DIR_WS_CLASSES . 'class.order.php');
$order = new order();

// register a random ID in the session to check throughout the checkout procedure
// against alterations in the shopping cart contents
$_SESSION['cartID'] = $_SESSION['cart']->cartID;

$allowed_ot_modules = array(
    'ot_payment', 'ot_loworderfee', 'ot_gv', 'ot_discount', 'ot_coupon', 'ot_cod_fee', 'ot_tax'
);


if ($_GET['handleraction'] == 'setsession') {
    $_SESSION['amazon_id'] = $_GET['amazon_id'];
}

if ($_GET['handleraction'] == 'products') {

    $total = 0;

    // MwSt Fix start
    $zones_query = xtDBquery("SELECT tax_class_id as class FROM " . TABLE_TAX_CLASS);
    while ($zones_data = xtc_db_fetch_array($zones_query, true)) {

        // calculate tax based on shipping or deliverey country (for downloads)
        if (isset($_SESSION['AMZ_COUNTRY_ID']) && isset($_SESSION['AMZ_ZONE_ID'])) {

            $xtPrice->TAX[$zones_data['class']] = xtc_get_tax_rate($zones_data['class'], $_SESSION['AMZ_COUNTRY_ID'], $_SESSION['AMZ_ZONE_ID']);
        } else {
            $xtPrice->TAX[$zones_data['class']] = xtc_get_tax_rate($zones_data['class']);
        }
    }
    $tax_infos = $_SESSION['cart']->show_tax();
    // MwSt Fix end

    if ($_SESSION['cart']->count_contents() > 0) {
        $products = $_SESSION['cart']->get_products();

        for ($i = 0, $n = sizeof($products); $i < $n; $i++) {
            if (isset($products[$i]['attributes'])) {
                while (list ($option, $value) = each($products[$i]['attributes'])) {
                    $hidden_options .= xtc_draw_hidden_field('id[' . $products[$i]['id'] . '][' . $option . ']', $value);
                    $attributes = xtc_db_query("select popt.products_options_name,
											   poval.products_options_values_name,
											   pa.options_values_price,
											   pa.price_prefix,
											   pa.attributes_stock,
											   pa.products_attributes_id,
											   pa.attributes_model
										from " . TABLE_PRODUCTS_OPTIONS . " popt,
											 " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval,
											 " . TABLE_PRODUCTS_ATTRIBUTES . " pa
												where pa.products_id = '" . $products[$i]['id'] . "'
												and pa.options_id = '" . $option . "'
												and pa.options_id = popt.products_options_id
												and pa.options_values_id = '" . $value . "'
												and pa.options_values_id = poval.products_options_values_id
												and popt.language_id = '" . (int) $_SESSION['languages_id'] . "'
												and poval.language_id = '" . (int) $_SESSION['languages_id'] . "'");
                    $attributes_values = xtc_db_fetch_array($attributes);
                    $products[$i][$option]['products_options_name'] = $attributes_values['products_options_name'];
                    $products[$i][$option]['options_values_id'] = $value;
                    $products[$i][$option]['products_options_values_name'] = $attributes_values['products_options_values_name'];
                    $products[$i][$option]['options_values_price'] = $attributes_values['options_values_price'];
                    $products[$i][$option]['price_prefix'] = $attributes_values['price_prefix'];
                    $products[$i][$option]['weight_prefix'] = $attributes_values['weight_prefix'];
                    $products[$i][$option]['options_values_weight'] = $attributes_values['options_values_weight'];
                    $products[$i][$option]['attributes_stock'] = $attributes_values['attributes_stock'];
                    $products[$i][$option]['products_attributes_id'] = $attributes_values['products_attributes_id'];
                    $products[$i][$option]['attributes_model'] = $attributes_values['attributes_model'];
                }
            }
        }


        $products_in_cart = array();
        $qty = 0;
        for ($i = 0, $n = sizeof($products); $i < $n; $i++) {

            $attribs = array();
            $attributes_exist = ((isset($products[$i]['attributes'])) ? 1 : 0);
            if ($attributes_exist == 1) {
                reset($products[$i]['attributes']);
                while (list ($option, $value) = each($products[$i]['attributes'])) {
                    if ($products[$i][$option]['products_options_name'] != '')
                        $attribs[] = htmlentities($products[$i][$option]['products_options_name'] . ': ' . $products[$i][$option]['products_options_values_name']);
                }
            }
            if (sizeof($attribs) > 0) {
                $attribs = '<div class="amzAttr">' . join('<br />', $attribs) . '</div>';
            } else {
                $attribs = '';
            }

            $qty += $products[$i]['quantity'];

            $descs = xtc_db_fetch_array(xtc_db_query("SELECT products_short_description, products_description FROM products_description WHERE products_id = '" . (int) $products[$i]['id'] . "' AND language_id = '" . $_SESSION['languages_id'] . "'"));
            $desc = substr(trim(strip_tags($descs['products_short_description'])), 0, 50) . '...';
            if ($desc == '...')
                $desc = substr(trim(strip_tags($descs['products_description'])), 0, 50) . '...';

            $productRes = xtc_db_fetch_array(xtc_db_query("SELECT products_image FROM products WHERE products_id = '" . (int) $products[$i]['id'] . "'"));

            $image = '';
            if ($productRes['products_image'] != '') {
                $image = DIR_WS_THUMBNAIL_IMAGES . $productRes['products_image'];
            }

            $products_in_cart[] = array('QTY' => (int) $products[$i]['quantity'],
                'LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, xtc_product_link($products[$i]['id'], $products[$i]['name'])),
                'NAME' => $products[$i]['name'],
                'ATTRIBS' => $attribs,
                'DESC' => $desc,
                'IMAGE' => $image,
                'SINGLEPRICE' => $xtPrice->xtcFormat($products[$i]['price'], true),
                'PRICE' => $xtPrice->xtcFormat($products[$i]['price'] * round($products[$i]['quantity'], 0), true));
            $total = $total + ($products[$i]['price'] * round($products[$i]['quantity'], 0));
        }
        if (sizeof($products_in_cart > 0)) {
            echo '<div class="cba_item_price">';
            echo '<strong><span class="priceSpalte">' . AMZ_TOTAL_PRICE . '</span><span class="priceSpalte">' . AMZ_SINGLE_PRICE . '</span><div class="cba_clearer"></div></strong>';
            echo '</div>';
            foreach ($products_in_cart as $key => $p) {
                echo '<div class="cba_item_list' . ($key % 2 == 0 ? '' : '_odd') . '">
				    <div class="cba_item_img">' . ($p['IMAGE'] != '' ? '<img src="' . $p['IMAGE'] . '" />' : '') . '</div>
				    <div class="cba_item_qty">' . $p['QTY'] . ' x </div>
					  <div class="cba_item_title">
						<a href="' . $p['LINK'] . '">' . $p['NAME'] . '</a>
						' . $p['ATTRIBS'] . ' <br /> ' . $p['DESC'] . '
					  </div>
					  <div class="cba_item_price"><span class="priceSpalte">' . trim(prepareMoneyInfo($p['PRICE'])) . '</span><span class="priceSpalte">' . prepareMoneyInfo($p['SINGLEPRICE']) . '</span><div class="cba_clearer"></div></div>
            </div>';
            }
        }
    }

    echo '<div class="cba_cart_value">' . AMZ_TOTAL . ': ' . prepareMoneyInfo($xtPrice->xtcFormat($total, true)) . '</div>';
    echo '<input type="hidden" name="cba_products_total" id="cba_products_total" value="' . $total . '" /> ';
}

if ($_GET['handleraction'] == 'shipping') {
    // MwSt Fix start
    $zones_query = xtDBquery("SELECT tax_class_id as class FROM " . TABLE_TAX_CLASS);
    while ($zones_data = xtc_db_fetch_array($zones_query, true)) {

        // calculate tax based on shipping or deliverey country (for downloads)
        if (isset($_SESSION['AMZ_COUNTRY_ID']) && isset($_SESSION['AMZ_ZONE_ID'])) {

            $xtPrice->TAX[$zones_data['class']] = xtc_get_tax_rate($zones_data['class'], $_SESSION['AMZ_COUNTRY_ID'], $_SESSION['AMZ_ZONE_ID']);
        } else {
            $xtPrice->TAX[$zones_data['class']] = xtc_get_tax_rate($zones_data['class']);
        }
    }

    $total_weight = $_SESSION['cart']->show_weight();
    $total_count = $_SESSION['cart']->count_contents();


    // Adressen holen
    $request = new CheckoutByAmazon_Service_Model_GetPurchaseContractRequest(
            array('PurchaseContractId' => $_GET['amazon_id']));
    $amazon_address = invokeGetPurchaseContract($service, $request);
    if ($amazon_address == false) {
        echo "Fehler";
    }
    $iso_code = (string) $amazon_address->GetPurchaseContractResult->PurchaseContract->Destinations->Destination->PhysicalDestinationAttributes->ShippingAddress->CountryCode;
    $order->delivery['country']['iso_code_2'] = $iso_code;

    $eu = array('BE', 'GR', 'CZ', 'DK', 'DE', 'EE', 'IE', 'ES', 'FR', 'IT', 'CY', 'LV', 'LT', 'LU', 'HU', 'MT', 'NL', 'AT', 'PL', 'PT', 'SI', 'SK', 'FI', 'SE', 'GB');
    if (constant(MODULE_PAYMENT_ . "RMAMAZON" . _ALLOWED) != '') {
        $unallowed_zones = explode(',', constant(MODULE_PAYMENT_ . "RMAMAZON" . _ALLOWED));
        if (!in_array($iso_code, $unallowed_zones)) {
            echo "<script> $('#amazon_button').hide(); </script>";
            echo '<script> $("#paymenthinweis").show(); </script>';
        } else {
            echo '<script> $("#paymenthinweis").hide(); </script>';
            if (!in_array($iso_code, $eu)) {
                echo '<script> $("#zollhinweis").show(); </script>';
            } else {
                echo '<script> $("#zollhinweis").hide(); </script>';
            }
        }
    }

    $_SESSION['delivery_zone'] = $iso_code;
    $c1_query = xtc_db_query("SELECT * FROM " . TABLE_COUNTRIES . " WHERE  countries_iso_code_2 = '" . $iso_code . "' LIMIT 1");
    $c1_result = xtc_db_fetch_array($c1_query);
    $c2_query = xtc_db_query("SELECT * FROM " . TABLE_ZONES . " WHERE  zone_country_id = '" . $c1_result['countries_id'] . "' LIMIT 1");
    $c2_result = xtc_db_fetch_array($c2_query);
    $order->delivery['country_id'] = $c1_result['countries_id'];
    $order->delivery['country']['id'] = $c1_result['countries_id'];
    $order->delivery['country']['title'] = $c1_result['countries_name'];
    $order->delivery['zone_id'] = $c2_result['zone_id'];
    $order->delivery['postcode'] = (string) $amazon_address->GetPurchaseContractResult->PurchaseContract->Destinations->Destination->PhysicalDestinationAttributes->ShippingAddress->PostalCode;

    // MwSt Fix start
    $_SESSION['AMZ_COUNTRY_ID'] = $c1_result['countries_id'];
    $_SESSION['AMZ_ZONE_ID'] = $c2_result['zone_id'];
    $_SESSION['customer_country_id'] = $c1_result['countries_id'];
    // MwSt Fix end
    // load all enabled shipping modules
    require (DIR_WS_CLASSES . 'shipping.php');
    $shipping_modules = new shipping;


    if (defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING') && (MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true')) {

        switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
            case 'national' :
                if ($order->delivery['country_id'] == STORE_COUNTRY)
                    $pass = true;
                break;
            case 'international' :
                if ($order->delivery['country_id'] != STORE_COUNTRY)
                    $pass = true;
                break;
            case 'both' :
                $pass = true;
                break;
            default :
                $pass = false;
                break;
        }
        $free_shipping = false;
        if (($pass == true) && ($order->info['total'] - $order->info['shipping_cost'] >= $xtPrice->xtcFormat(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER, false, 0, true))) {
            $free_shipping = true;
            include (DIR_WS_LANGUAGES . $_SESSION['language'] . '/modules/order_total/ot_shipping.php');
        }
    } else {
        $free_shipping = false;
    }

    if ($free_shipping == true) {
        echo '<input type="hidden" name="cba_allow_shipping" id="cba_allow_shipping" value="1" />';
        echo '<input type="hidden" name="cba_select_shipping" id="free" value="0|free" />';
        echo '<div style="font-size:10px;">' . FREE_SHIPPING_AT . ' ' . $sLeft . ' ' . number_format(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER, 2, ',', '.') . ' ' . $sRight . '</div>';
    } else {

        $quotes = $shipping_modules->quote();

        $count = 0;

        if (sizeof($quotes > 0)) {
            foreach ($quotes as $sh) {
                if (!isset($sh['error'])) {
                    if (isset($sh['methods'])) {

                        $count++;
                        if ($count == 1) {
                            $select_string = ' checked ';
                            $order->delivery['country']['id'] = $_SESSION['AMZ_COUNTRY_ID'];
                            $order->delivery['zone_id'] = $_SESSION['AMZ_ZONE_ID'];
                            $_SESSION['shipping'] = array('id' => $mid . '_' . $mid, 'title' => 'Versandauswahl per AmazonCheckout', 'cost' => $sh['methods'][0]['cost']);
                        } else {
                            $select_string = '';
                        }
                        $tax_info = '';
                        if ($sh['tax'] > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
                            $tax_info = sprintf(TAX_INFO_INCL, $sh['tax'] . ' %') . ': ' . $sLeft . number_format($sh['methods'][0]['cost'] / 100 * $sh['tax'], 2) . ' ' . $sRight;
                            $sh['methods'][0]['cost'] = xtc_add_tax($sh['methods'][0]['cost'], $sh['tax']);
                        }
                        // excl tax + tax at checkout
                        if ($sh['tax'] > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
                            $tax_info = sprintf(TAX_INFO_ADD, $sh['tax'] . ' %') . ': ' . $sLeft . number_format($sh['methods'][0]['cost'] / 100 * $sh['tax'], 2) . ' ' . $sRight;
                        }
                        // excl tax
                        if ($sh['tax'] > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 0) {
                            $tax_info = sprintf(TAX_INFO_EXCL, $sh['tax'] . ' %') . ': ' . $sLeft . number_format($sh['methods'][0]['cost'] / 100 * $sh['tax'], 2) . ' ' . $sRight;
                        }

                        $mid = $sh['methods'][0]['id'];
                        echo '<div style="float:left; width:20px;"><input ' . $select_string . ' type="radio" onchange="update_total()" name="cba_select_shipping" id="' . $mid . '" value="' . $sh['methods'][0]['cost'] . '|' . $mid . '|' . $sh['tax'] . '" /></div>';
                        echo '<div style="margin: 3px; font-size:10px; float:left; width: 340px;">';
                        echo $sh['methods'][0]['title'] . '(' . $sLeft . number_format($sh['methods'][0]['cost'], 2) . ' ' . $sRight . ')';
                        if ($tax_info != '') {
                            #echo '<br />'.$tax_info;
                        }
                        echo '</div>';
                        echo '<div style="clear:both;"></div>';
                    }
                } else {
                    echo '<div style="float:left; width:20px;">&nbsp;</div>';
                    echo '<div style="margin: 3px; font-size:10px; float:left; width: 340px;">';
                    echo $sh['module'] . '&nbsp;(' . $sh['error'] . ')';
                    echo '</div>';
                    echo '<div style="clear:both;"></div>';
                }
            }
        }
        // Keine gültigen Versandmethoden
        if ($count == 0) {
            echo '<input type="hidden" name="cba_allow_shipping" id="cba_allow_shipping" value="0" />';
            echo '<div>' . NO_SHIPPING_TO_ADDRESS . '</div>';
            echo "<script> $('#amazon_button').hide(); </script>";
        } else {
            echo '<input type="hidden" name="cba_allow_shipping" id="cba_allow_shipping" value="1" />';
        }
    }
}

if ($_GET['handleraction'] == 'cot_gv_setter') {
    if ($_GET['cot_gv'] == '1') {
        $_SESSION['cot_gv_amazon'] = true;
        echo '1';
    } else {
        unset($_SESSION['cot_gv_amazon']);
        echo '0';
    }
}

if ($_GET['handleraction'] == 'ordertotals') {
    if (isset($_SESSION['cot_gv_amazon']) && $_SESSION['cot_gv_amazon'] == true) {
        $_SESSION['cot_gv'] = true;
    } else {
        unset($_SESSION['cot_gv']);
    }
    $order->delivery['country']['id'] = $_SESSION['AMZ_COUNTRY_ID'];
    $order->delivery['zone_id'] = $_SESSION['AMZ_ZONE_ID'];

    $cba_shipping = explode('|', $_GET['cba_select_shipping']);
    $cba_shipping[0] = round((float) $cba_shipping[0], 2);
    $cost = $cba_shipping[0];
    if ($cba_shipping[2] > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 1) {
        $cost = round((float) $cba_shipping[0] / (100 + $cba_shipping[2]) * 100, 2);
    }
    $_SESSION['shipping'] = array('id' => $cba_shipping[1] . '_' . $cba_shipping[1], 'title' => 'Versandauswahl per AmazonCheckout', 'cost' => $cost);
    require_once (DIR_WS_CLASSES . 'shipping.php');
    $shipping_modules = new shipping($_SESSION['shipping']);

    $quote = $shipping_modules->quote($cba_shipping[1], $cba_shipping[1]);
    if ($quote[0]['tax'] > 0) {
        if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1)
            $order->info['shipping_cost'] = $cba_shipping[0];
        else
            $order->info['shipping_cost'] = ($cba_shipping[0] / ((100 + $quote[0]['tax'])) * 100);
    }
    else
        $order->info['shipping_cost'] = $cba_shipping[0];
    require_once (DIR_WS_CLASSES . 'order_total.php');
    $order_total_modules = new order_total();
    $order_totals = $order_total_modules->process();

    $rabatt = 0;
    $i = 0;

    if (sizeof($order_totals) > 0) {
        foreach ($order_totals as $ot) {
            if (in_array($ot['code'], $allowed_ot_modules)) {
                echo '<div class="cba_item_title">' . $ot['title'] . '</div><div class="cba_item_price"> ' . prepareMoneyInfo($ot['text']) . '</div>';
                if ($ot['code'] == 'ot_coupon' || $ot['code'] == 'ot_gv') {
                    $rabatt = $rabatt - $ot['value'];
                } elseif ($ot['code'] == 'ot_tax' && $_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
                    $rabatt = $rabatt;
                } elseif ($ot['code'] == 'ot_tax' && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
                    $rabatt = $rabatt + $ot['value'];
                } else {
                    $rabatt = $rabatt + $ot['value'];
                }

                $i++;
            }
        }

        $rabatt = round($rabatt, 2);

        if ($i == 0) {
            echo '<div class="cba_item_title">' . NO_POSITIONS . '</div>';
        }
    }

    if (ACTIVATE_GIFT_SYSTEM == 'true') {
        $creditsel = $order_total_modules->credit_selection();
        if (isset($_SESSION['cot_gv_amazon']) && $_SESSION['cot_gv_amazon'] == true) {
            $_SESSION['cot_gv'] = true;
        } else {
            unset($_SESSION['cot_gv']);
        }
        $creditsel = str_replace('submitFunction', 'submitFunctionGV', $creditsel);
        $creditsel = str_replace(array('nowrap="nowrap"', 'nowrap'), "", $creditsel);
        if (isset($_SESSION['cot_gv_amazon']) && $_SESSION['cot_gv_amazon'] == true) {
            $creditsel = str_replace('type="checkbox"', 'type="checkbox" checked="checked"', $creditsel);
        }
        echo $creditsel;
    }
    echo '<input type="hidden" name="cba_select_totals" id="cba_select_totals" value="' . $rabatt . '" />';
}
