<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */


/**
 * Order Refund Sample
 */

include_once ('.config.inc.php'); 

$feeds = new MarketplaceWebService_MWSFeedsClient();
$MWSProperties = new MarketplaceWebService_MWSProperties();

//Construct the OrderAcknowledgement Feed 

//Constructing the <Header>
$envelope = new SimpleXMLElement("<AmazonEnvelope></AmazonEnvelope>");
$envelope->Header->DocumentVersion = $MWSProperties->getDocumentVersion();
$envelope->Header->MerchantIdentifier = $MWSProperties->getMerchantToken();

//Assiging the MessageType
$envelope->MessageType = "OrderAdjustment";


//Fist <Message> block
$envelope->Message[0] ->MessageID = 1;
$envelope->Message[0] ->OrderAdjustment->AmazonOrderID = "105-8151474-6236244";
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->AmazonOrderItemCode = "1111111";
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->AdjustmentReason = MarketplaceWebService_Model_AdjustmentReason::CustomerReturn;

//Refunding Principal
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->ItemPriceAdjustments->Component[0]->Type = MarketplaceWebService_Model_BuyerPriceType::Principal;
$amount = $envelope->Message[0] ->OrderAdjustment->AdjustedItem->ItemPriceAdjustments->Component[0]->addChild('Amount',"2.00");
$amount->addAttribute('currency','USD');

//Refunding Tax
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->ItemPriceAdjustments->Component[1]->Type = MarketplaceWebService_Model_BuyerPriceType::Tax;
$amount = $envelope->Message[0] ->OrderAdjustment->AdjustedItem->ItemPriceAdjustments->Component[1]->addChild('Amount',"0.20");
$amount->addAttribute('currency','USD');

//Refunding Shipping
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->ItemPriceAdjustments->Component[2]->Type = MarketplaceWebService_Model_BuyerPriceType::Shipping;
$amount = $envelope->Message[0] ->OrderAdjustment->AdjustedItem->ItemPriceAdjustments->Component[2]->addChild('Amount',"1.00");
$amount->addAttribute('currency','USD');

//Promotion Adjustments
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->PromotionAdjustments->PromotionClaimCode = "ABC123";
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->PromotionAdjustments->MerchantPromotionID = "12345678";
$envelope->Message[0] ->OrderAdjustment->AdjustedItem->PromotionAdjustments->Component->Type = MarketplaceWebService_Model_BuyerPriceType::Principal;
$amount = $envelope->Message[0] ->OrderAdjustment->AdjustedItem->PromotionAdjustments->Component->addChild('Amount',"-2.00");  //'-' signifies charging the buyer
$amount->addAttribute('currency','USD');


//Pass the constructed SimpleXML object to acknowledgeOrder function of MWSFeedsClient 
//alongwith the location of the directory where the feed has to be stored.Please note that the directory
//should exist with the relevant permissions.
$feedSubmissionId = $feeds->refundOrder($envelope, "./tmp");

echo "The OrderAdjustment feed has been submitted with FeedSubmissionID: " . $feedSubmissionId . " !" .PHP_EOL;

?>
