<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */

/**
 * Order Acknowledgement Sample
 */

include_once ('.config.inc.php'); 

$feeds = new MarketplaceWebService_MWSFeedsClient();
$MWSProperties = new MarketplaceWebService_MWSProperties();

//Construct the OrderAcknowledgement Feed 

//Constructing the <Header>
$envelope = new SimpleXMLElement("<AmazonEnvelope></AmazonEnvelope>");
$envelope->Header->DocumentVersion = $MWSProperties->getDocumentVersion();
$envelope->Header->MerchantIdentifier = $MWSProperties->getMerchantToken();

//Assiging the MessageType
$envelope->MessageType = "OrderAcknowledgement";


//Fist <Message> block
$envelope->Message[0] ->MessageID = 1;
$envelope->Message[0] ->OrderAcknowledgement->AmazonOrderID = "105-8151474-6236244";
$envelope->Message[0] ->OrderAcknowledgement->MerchantOrderID = "1111111";
$envelope->Message[0] ->OrderAcknowledgement->StatusCode = "Success";

//Second <Message> block
$envelope->Message[1] ->MessageID = 2;
$envelope->Message[1] ->OrderAcknowledgement->AmazonOrderID = "002-9741754-1106628";
$envelope->Message[1] ->OrderAcknowledgement->StatusCode = "Success";
$envelope->Message[1] ->OrderAcknowledgement->Item->AmazonOrderItemCode = "111111";
$envelope->Message[1] ->OrderAcknowledgement->Item->MerchantOrderItemID = "111111";

//Pass the constructed SimpleXML object to acknowledgeOrder function of MWSFeedsClient 
//alongwith the location of the directory where the feed has to be stored.Please note that the directory
//should exist with the relevant permissions.
$feedSubmissionId = $feeds->acknowledgeOrder($envelope, "./tmp");

echo "The OrderAcknowledgment feed has been submitted with FeedSubmissionID: " . $feedSubmissionId . " !" .PHP_EOL;

?>
