<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */


/**
 * Get Report  Sample
 */

include_once ('.config.inc.php'); 

//List of reports to be downloaded
$reportIdList = array();
array_push($reportIdList,"4577405853");
array_push($reportIdList, "4571197413");
array_push($reportIdList, "4560643163");


$reports = new MarketplaceWebService_MWSReportsClient();

//Set the path to the file where the processing status of the feeds is to be stored. Please note that the directory
//should exist with the relevant permissions.
$reportDirPath = "./tmp";

foreach ($reportIdList as $reportId)
{
	//Download the Processing Report for each feedsubmission id and store it in <FeedSubmissionID>_processing_report file
	//at $feedDirPath location
	$filePath = $reportDirPath . "/" . $reportId . "_report";
	$fileHandle = fopen($filePath,"w");
	$reports->getReport($reportId, $fileHandle);
	fclose($fileHandle);
	
}

echo "The Reports for the given ReportID's have been downloaded to the given path at " . $reportDirPath . " !" . PHP_EOL;


?>
