<?php

/* -----------------------------------------------------------------
 * 	$Id: sepa.php 849 2014-02-10 14:01:15Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
  based on
  sepa.php 2014-01-23 gm
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2014 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

require_once(DIR_FS_INC . 'cseo_htmlentities_wrapper.inc.php');
require_once(DIR_FS_CATALOG . 'includes/classes/class.sepa_account_check.php');

class sepa {

    var $code, $title, $description, $enabled, $gm_check_blz;

    function sepa() {
        global $order;

        $this->code = 'sepa';
        $this->title = MODULE_PAYMENT_SEPA_TEXT_TITLE;
        $this->description = MODULE_PAYMENT_SEPA_TEXT_DESCRIPTION;
        $this->sort_order = MODULE_PAYMENT_SEPA_SORT_ORDER;
        $this->min_order = MODULE_PAYMENT_SEPA_MIN_ORDER;
        $this->enabled = ((MODULE_PAYMENT_SEPA_STATUS == 'True') ? true : false);
        $this->info = MODULE_PAYMENT_SEPA_TEXT_INFO;
        if ((int) MODULE_PAYMENT_SEPA_ORDER_STATUS_ID > 0) {
            $this->order_status = MODULE_PAYMENT_SEPA_ORDER_STATUS_ID;
        }
        if (is_object($order)) {
            $this->update_status();
        }

        if ($_POST['sepa_fax'] == "on") {
            $this->email_footer = MODULE_PAYMENT_SEPA_TEXT_EMAIL_FOOTER;
        }
    }

    function update_status() {
        global $order;

        $order_check = xtc_db_fetch_array(xtc_db_query("SELECT count(*) AS count FROM " . TABLE_ORDERS . " WHERE customers_id = '" . (int) $_SESSION['customer_id'] . "';"));

        if ($order_check['count'] < MODULE_PAYMENT_SEPA_MIN_ORDER) {
            $check_flag = false;
            $this->enabled = false;
        } else {
            $check_flag = true;

            if (($this->enabled == true) && ((int) MODULE_PAYMENT_SEPA_ZONE > 0)) {
                $check_flag = false;
                $check_query = xtc_db_query("SELECT zone_id FROM " . TABLE_ZONES_TO_GEO_ZONES . " WHERE geo_zone_id = '" . MODULE_PAYMENT_SEPA_ZONE . "' AND zone_country_id = '" . (int) $order->billing['country']['id'] . "' ORDER BY zone_id;");
                while ($check = xtc_db_fetch_array($check_query)) {
                    if ($check['zone_id'] < 1) {
                        $check_flag = true;
                        break;
                    } elseif ($check['zone_id'] == $order->billing['zone_id']) {
                        $check_flag = true;
                        break;
                    }
                }
            }
            if ($check_flag == false) {
                $this->enabled = false;
            }
        }
    }

    function javascript_validation() {
        $js = '';
        return $js;
    }

    function selection() {
        global $order;

        $t_sepa_owner = $order->billing['firstname'] . ' ' . $order->billing['lastname'];
        if (trim($_SESSION['sepa_owner']) != '') {
            $t_sepa_owner = $_SESSION['sepa_owner'];
        }

        $t_sepa_iban = '';
        if (trim($_SESSION['sepa_iban']) != '') {
            $t_sepa_iban = $_SESSION['sepa_iban'];
        }

        $t_sepa_bic = '';
        if (trim($_SESSION['sepa_bic']) != '') {
            $t_sepa_bic = $_SESSION['sepa_bic'];
        }

        $t_sepa_bankname = '';
        if (trim($_SESSION['sepa_bankname']) != '') {
            $t_sepa_bankname = $_SESSION['sepa_bankname'];
        }

        $selection = array('id' => $this->code,
            'module' => $this->title,
            'description' => $this->info,
            'fields' => array(
                array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_OWNER,
                    'field' => xtc_draw_input_field('sepa_owner', htmlentities_wrapper($t_sepa_owner))),
                array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_IBAN,
                    'field' => xtc_draw_input_field('sepa_iban', htmlentities_wrapper($t_sepa_iban), 'maxlength="32"')),
                array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_BIC,
                    'field' => xtc_draw_input_field('sepa_bic', htmlentities_wrapper($t_sepa_bic), 'maxlength="11"')),
                array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_NAME,
                    'field' => xtc_draw_input_field('sepa_bankname', htmlentities_wrapper($t_sepa_bankname), 'maxlength="32"')),
                array('title' => '',
                    'field' => xtc_draw_hidden_field('recheckok', htmlentities_wrapper($_GET['recheckok'])))
        ));

        if (MODULE_PAYMENT_SEPA_FAX_CONFIRMATION == 'true') {
            $selection['fields'][] = array('title' => MODULE_PAYMENT_SEPA_TEXT_NOTE,
                'field' => '<div>' . MODULE_PAYMENT_SEPA_TEXT_NOTE2 . '<a href="' . MODULE_PAYMENT_SEPA_URL_NOTE . '" target="_blank"><b>' . MODULE_PAYMENT_SEPA_TEXT_NOTE3 . '</b></a>' . MODULE_PAYMENT_SEPA_TEXT_NOTE4 . '</div>');
            $selection['fields'][] = array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_FAX,
                'field' => xtc_draw_checkbox_field('sepa_fax', 'on'));
        }

        return $selection;
    }

    function pre_confirmation_check($vars = '') {
        if (is_array($vars) && !empty($vars)) {
            $data_arr = $vars;
            $is_ajax = true;
        } else {
            $data_arr = $_POST;
        }
        if ($data_arr['sepa_fax'] == false) {
            $_SESSION['sepa_owner'] = $data_arr['sepa_owner'];
            $_SESSION['sepa_bic'] = $data_arr['sepa_bic'];
            $_SESSION['sepa_iban'] = $data_arr['sepa_iban'];
            $_SESSION['sepa_bankname'] = $data_arr['sepa_bankname'];

            $sepa_validation = new SepaAccountCheck();
            $sepa_result = $sepa_validation->CheckAccount($data_arr['sepa_owner'], $data_arr['sepa_iban'], $data_arr['sepa_bic'], $data_arr['sepa_bankname']);

            switch ($sepa_result) {
                case 0: // payment o.k.
                    $error = 'O.K.';
                    $recheckok = 'false';
                    break;
                case 1: // number & blz not ok (BLZValidation)
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_1;
                    $recheckok = 'false';
                    break;
                case 2: // account number has no calculation method (BLZValidation)
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_2;
                    $recheckok = 'true';
                    break;
                case 3: // No calculation method implemented (BLZValidation)
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_3;
                    $recheckok = 'true';
                    break;
                case 4: // Number cannot be checked (BLZValidation)
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_4;
                    $recheckok = 'true';
                    break;
                case 5: // BLZ not found (BLZValidation)					
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_5;
                    $recheckok = 'false'; // Set "true" if you have not the latest BLZ table!
                    break;
                // CUSTOM ERRORS
                case 10: // no account holder
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_10;
                    $recheckok = 'false';
                    break;
                case 11: // no iban
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_11;
                    $recheckok = 'false';
                    break;
                case 12: // no iban check digits
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_12;
                    $recheckok = 'false';
                    break;
                case 13: // incorrect iban
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_13;
                    $recheckok = 'false';
                    break;
                case 14: // no bic
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_14;
                    $recheckok = 'false';
                    break;
                case 15: // incorrect bic
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_15;
                    $recheckok = 'false';
                    break;
                case 16: // no bankname
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_16;
                    $recheckok = 'false';
                    break;
                case 128: // Internal error
                    $error = 'Internal error, please check again to process your payment';
                    $recheckok = 'true';
                    break;
                default:
                    $error = MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR_4;
                    $recheckok = 'true';
                    break;
            }

            if ($sepa_result > 0 && $data_arr['recheckok'] != 'true') {
                $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&recheckok=' . $recheckok;
                if (CHECKOUT_AJAX_STAT == 'true') {
                    $_SESSION['checkout_payment_error'] = $payment_error_return;
                } else {
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
                }
            }

            $this->sepa_owner = $sepa_validation->owner;
            $this->sepa_iban = $sepa_validation->iban;
            $this->sepa_bic = $sepa_validation->bic;
            $this->sepa_bankname = $sepa_validation->bankname;
            $this->sepa_prz = $sepa_validation->prz;
            $this->sepa_status = $sepa_result;
        }
    }

    function confirmation() {
        if (!$_POST['sepa_owner'] == '') {
            $confirmation = array('title' => $this->title,
                'fields' => array(array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_OWNER,
                        'field' => $this->sepa_owner),
                    array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_IBAN,
                        'field' => $this->sepa_iban),
                    array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_BIC,
                        'field' => $this->sepa_bic),
                    array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_NAME,
                        'field' => $this->sepa_bankname)
            ));
        }

        if ($_POST['sepa_fax'] == "on") {
            $confirmation = array('fields' => array(array('title' => MODULE_PAYMENT_SEPA_TEXT_BANK_FAX)));
            $this->sepa_fax = "on";
        }

        return $confirmation;
    }

    function process_button() {
        global $_POST;

        $process_button_string = xtc_draw_hidden_field('sepa_bic', $this->sepa_bic) .
                xtc_draw_hidden_field('sepa_bankname', $this->sepa_bankname) .
                xtc_draw_hidden_field('sepa_iban', $this->sepa_iban) .
                xtc_draw_hidden_field('sepa_owner', $this->sepa_owner) .
                xtc_draw_hidden_field('sepa_status', $this->sepa_status) .
                xtc_draw_hidden_field('sepa_prz', $this->sepa_prz) .
                xtc_draw_hidden_field('sepa_fax', $this->sepa_fax);

        return $process_button_string;
    }

    function before_process() {
        return false;
    }

    function after_process() {
        global $insert_id, $_POST;
        $sepa_bic = xtc_db_input($_POST['sepa_bic']);
        $sepa_bankname = xtc_db_input($_POST['sepa_bankname']);
        $sepa_iban = xtc_db_input($_POST['sepa_iban']);
        $sepa_owner = xtc_db_input($_POST['sepa_owner']);
        xtc_db_query("
	      	INSERT INTO sepa (
	      		orders_id, 
	      		sepa_bic, 
	      		sepa_bankname, 
	      		sepa_iban, 
	      		sepa_owner, 
	      		sepa_status, 
	      		sepa_prz
	      	)
	      	VALUES (
	      		'" . $insert_id . "', 
	      		'" . base64_encode($sepa_bic . SALT_KEY) . "', 
	      		'" . base64_encode($sepa_bankname . SALT_KEY) . "', 
	      		'" . base64_encode($sepa_iban . SALT_KEY) . "', 
	      		'" . base64_encode($sepa_owner . SALT_KEY) . "', 
	      		'" . xtc_db_input($_POST['sepa_status']) . "', 
	      		'" . xtc_db_input($_POST['sepa_prz']) . "'
      		)"
        );


        if ($_POST['sepa_fax']) {
            xtc_db_query("UPDATE sepa SET sepa_fax = '" . xtc_db_input($_POST['sepa_fax']) . "' WHERE orders_id = '" . $insert_id . "';");
        }

        if ($this->order_status) {
            xtc_db_query("UPDATE " . TABLE_ORDERS . " SET orders_status='" . (int) $this->order_status . "' WHERE orders_id='" . $insert_id . "';");
        }

        unset($_SESSION['sepa_owner']);
        unset($_SESSION['sepa_bic']);
        unset($_SESSION['sepa_iban']);
        unset($_SESSION['sepa_bankname']);
    }

    function get_error() {

        $error = array(
            'title' => MODULE_PAYMENT_SEPA_TEXT_BANK_ERROR,
            'error' => stripslashes(urldecode($_GET['error']))
        );

        return $error;
    }

    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_SEPA_STATUS';");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function install() {
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SEPA_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_SEPA_ZONE', '0',  '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SEPA_ALLOWED', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SEPA_SORT_ORDER', '0', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_SEPA_ORDER_STATUS_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SEPA_FAX_CONFIRMATION', 'false',  '6', '2', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SEPA_DATABASE_BLZ', 'false', '6', '0', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SEPA_URL_NOTE', 'fax_sepa.html', '6', '0', now())");
        xtc_db_query("CREATE TABLE IF NOT EXISTS sepa (orders_id int(11) NOT NULL, sepa_owner varchar(255), sepa_iban varchar(255), sepa_bic varchar(255), sepa_bankname varchar(255), sepa_status int(11), sepa_prz char(2), sepa_fax char(2),PRIMARY KEY (`orders_id`))");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SEPA_MIN_ORDER', '0',  '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES('MODULE_PAYMENT_SEPA_DATACHECK', 'true', 6, 3, NULL, '2011-05-19 08:19:02', NULL, 'xtc_cfg_select_option(array(''true'', ''false''), ')");
    
	if (table_exists ('banktransfer_blz')) {
		xtc_db_query("DROP TABLE banktransfer_blz;");
	}
	xtc_db_query("
	CREATE TABLE banktransfer_blz (
	  blz int(10) NOT NULL default '0',
	  bankname varchar(255) NOT NULL default '',
	  prz char(2) NOT NULL default '',
	  PRIMARY KEY (blz)
	);
	");

    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10010010','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10019610','Dexia Kommunalbank Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10020200','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10020890','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10030200','Berlin-Hannoversche Hypothekenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10030400','ABK-Kreditbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10030500','Bankhaus Löbbecke','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10030600','North Channel Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10030700','Eurocity Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10033300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040000','Commerzbank Berlin (West)','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040010','Commerzbank, CC SP','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040048','Commerzbank GF-B48','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040060','Commerzbank Gf 160','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040061','Commerzbank Gf 161','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040062','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040063','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10040085','Commerzbank, Gf Web-K','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10045050','Commerzbank Service-BZ','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050000','Landesbank Berlin - Berliner Sparkasse','B8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050005','Landesbank Berlin - E 1 -','C6')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050006','Landesbank Berlin - E 2 -','D1')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050007','Landesbank Berlin - E 3 -','D4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050008','Landesbank Berlin - E 4 -','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050020','LBB S-Kreditpartner, Berlin','B8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050500','LBS Ost Berlin','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050600','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10050999','DekaBank Berlin','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10060198','Pax-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10060237','Evangelische Darlehnsgenossenschaft','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10061006','Bank für Kirche und Diakonie - KD-Bank Gf Sonder-BLZ','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10070000','Deutsche Bank Fil Berlin','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10070024','Deutsche Bank Privat und Geschäftskunden F 700','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10070100','Deutsche Bank Fil Berlin II','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10070124','Deutsche Bank Privat und Geschäftskd Berlin II','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10070848','Berliner Bank Niederlassung der Deutsche Bank PGK','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10077777','norisbank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080000','Commerzbank vormals Dresdner Bank Filiale Berlin I','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080005','Commerzbank vormals Dresdner Bank Zw A','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080006','Commerzbank vormals Dresdner Bank Zw B','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080055','Commerzbank vormals Dresdner Bank Zw 55','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080057','Commerzbank vormals Dresdner Bank Gf ZW 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080085','Commerzbank vormals Dresdner Bank Gf PCC DCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080088','Commerzbank vormals Dresdner Bank IBLZ','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080089','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 6','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10080900','Commerzbank vormals Dresdner Bank Filiale Berlin III','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10089260','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10089999','Commerzbank vormals Dresdner Bank ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10090000','Berliner Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10090300','Bank für Schiffahrt (BFS) Fil d Ostfr VB Leer','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10090603','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10090900','PSD Bank Berlin-Brandenburg','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10110300','Bankhaus Dr. Masel','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10110400','Investitionsbank Berlin','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10110600','quirin bank','17')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10120100','Weberbank','94')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10120600','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10120760','UniCredit Bank - HypoVereinsbank Ndl 260 BIn','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10120800','VON ESSEN Bankgesellschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10130600','Isbank Fil Berlin','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10130800','BIW Bank','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10220500','Bank of Scotland Ndl Berlin','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10220600','Sydbank Filiale Berlin','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('10310600','Tradegate Wertpapierhandelsbank Berlin','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12016836','KfW Kreditanstalt für Wiederaufbau','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12030000','Deutsche Kreditbank Berlin','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12030900','Merck Finck & Co','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12040000','Commerzbank Berlin Ost','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12050555','NLB FinanzIT','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12060000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12070000','Deutsche Bank Ld Brandenburg','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12070070','Deutsche Bank (Gf intern)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12070088','Deutsche Bank (Gf intern)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12080000','Commerzbank vormals Dresdner Bank Filiale Berlin II','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12090640','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('12096597','Sparda-Bank Berlin','A8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13050000','Ostseesparkasse Rostock','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13051042','Sparkasse Vorpommern auf Rügen','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13061008','Volksbank Wolgast','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13061028','Volksbank Raiffeisenbank ehem VB Greifswald','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13061078','Volks- und Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13061088','Raiffeisenbank Wismar -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13061128','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13070000','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13090000','Rostocker Volks- und Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13091054','Pommersche Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('13091084','Volksbank Wismar -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14000000','Bundesbank eh Schwerin','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14051000','Sparkasse Mecklenburg-Nordwest','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14051362','Sparkasse Parchim-Lübz','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14051462','Sparkasse Schwerin -alt-','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14052000','Sparkasse Mecklenburg-Schwerin','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14061308','Volks- und Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14061438','Raiffeisen-Volksbank -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14080011','Commerzbank vormals Dresdner Bank Zw W','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('14091464','VR-Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15040068','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15050100','Müritz-Sparkasse','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15050200','Sparkasse Neubrandenburg-Demmin','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15050400','Sparkasse Uecker-Randow','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15050500','Sparkasse Vorpommern','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15051732','Sparkasse Mecklenburg-Strelitz','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15061618','Raiffeisenbank Mecklenburger Seenplatte','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15061638','Volksbank Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15061698','Raiffeisenbank Malchin','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15091674','Volksbank Demmin','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('15091704','VR-Bank Uckermark-Randow','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16000000','Bundesbank eh Potsdam','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16010300','Investitionsbank des Landes Brandenburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16050000','Mittelbrandenburgische Sparkasse in Potsdam','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16050101','Sparkasse Prignitz','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16050202','Sparkasse Ostprignitz-Ruppin','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16050500','LBS Ostdeutsche Landesbausparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16060122','Volks- und Raiffeisenbank Prignitz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16061938','Raiffeisenbank Ostprignitz-Ruppin','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16062008','VR-Bank Fläming','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16062073','Brandenburger Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('16091994','Volksbank Rathenow','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17000000','Bundesbank eh Frankfurt (Oder)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17052000','Sparkasse Barnim','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17052302','Stadtsparkasse Schwedt','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17054040','Sparkasse Märkisch-Oderland','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17055050','Sparkasse Oder-Spree','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17056060','Sparkasse Uckermark','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17062428','Raiffeisenbank-Volksbank Oder-Spree','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('17092404','VR Bank Fürstenwalde Seelow Wriezen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18000000','Bundesbank eh Cottbus','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18050000','Sparkasse Spree-Neiße','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18051000','Sparkasse Elbe-Elster','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18055000','Sparkasse Niederlausitz','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18062678','VR Bank Lausitz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18062758','VR Bank Forst','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18092684','Spreewaldbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('18092744','Volksbank Spree-Neiße','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20010020','Postbank (Giro)','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20020200','SEB Merchant Bank Hamburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20020500','Jyske Bank Fil Hamburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20020900','Signal Iduna Bauspar','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20030000','UniCredit Bank - HypoVereinsbank','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20030133','Varengold Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20030300','DONNER & REUSCHEL','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20030400','Marcard, Stein & Co Bankiers','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20030600','Sydbank Fil Hamburg','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20030700','Merck Finck & Co','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20030900','Bankhaus Wölbern & Co','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040020','Commerzbank, CC SP','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040040','Commerzbank GF RME','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040048','Commerzbank GF-H48','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040050','Commerzbank GF COC','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040060','Commerzbank Gf 260','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040061','Commerzbank Gf 261','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040062','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20040063','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20041111','comdirect bank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20041133','comdirect bank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20041144','comdirect bank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20041155','comdirect bank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20050000','HSH Nordbank Hamburg','C5')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20050550','Hamburger Sparkasse','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20060000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069111','Norderstedter Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069125','Kaltenkirchener Bank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069130','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069144','Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069177','Raiffeisenbank Südstormarn Mölln','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069232','Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069641','Raiffeisenbank Owschlag','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069780','Volksbank Ahlerstedt','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069782','Volksbank Geest','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069786','Volksbank Kehdingen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069800','Spar- und Kreditbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069812','Volksbank Fredenbeck-Oldendorf','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069815','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069861','Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069882','Raiffeisenbank Travemünde -alt-','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069965','Volksbank Winsener Marsch','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20069989','Volksbank Wulfsen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20070000','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080055','Commerzbank vormals Dresdner Bank Zw 55','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080057','Commerzbank vormals Dresdner Bank Gf ZW 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080085','Commerzbank vormals Dresdner Bank Gf PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080088','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080089','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 6','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080091','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 7','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080092','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 8','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080093','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 9','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080094','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 10','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20080095','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 11','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20089200','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20090400','Deutsche Genossenschafts-Hypothekenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20090500','netbank','81')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20090602','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20090700','Edekabank','50')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20090745','EBANK Gf Cash','50')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20090900','PSD Bank Nord','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20110022','Postbank (Spar)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20110401','Hypothekenbank Frankfurt -alt-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20110700','Bank of Tokyo-Mitsubishi UFJ, The -','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20110800','Bank of China Fil Hamburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20120000','Joh. Berenberg, Gossler & Co','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20120100','Warburg, M.M.- Bank','58')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20120200','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20120400','Deutscher Ring Bausparkasse','E0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20120600','Goyer & Göppel','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20120700','Hanseatic Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20130400','GRENKE BANK','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20130412','GRENKE BANK Asset Backed Securities','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20130600','Barclaycard Barclays Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20133300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20190003','Hamburger Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20190109','Volksbank Stormarn','48')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20190206','Volksbank Hamburg Ost-West -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20190301','Vierländer Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20190800','MKB Mittelstandskreditbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20210200','Bank Melli Iran','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20210300','Bank Saderat Iran','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20220100','DNB Bank ASA - Filiale Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20220400','Warburg, M.M. - Hypothekenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20230300','Schröder, Otto M. - Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20230600','Isbank Fil Hamburg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20230800','Max Heinr. Sutor','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20310300','Europäisch-Iranische Handelsbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20320500','Danske Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20350000','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20690500','Sparda-Bank Hamburg','D5')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730001','UniCredit Bank - HVB Settlement EAC01','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730002','UniCredit Bank - HVB Settlement EAC02','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730003','UniCredit Bank - HVB Settlement EAC03','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730004','UniCredit Bank - HVB Settlement EAC04','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730005','UniCredit Bank - HVB Settlement EAC05','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730006','UniCredit Bank - HVB Settlement EAC06','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730007','UniCredit Bank - HVB Settlement EAC07','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730008','UniCredit Bank - HVB Settlement EAC08','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730009','UniCredit Bank - HVB Settlement EAC09','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730010','UniCredit Bank - HVB Settlement EAC10','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730011','UniCredit Bank - HVB Settlement EAC11','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730012','UniCredit Bank - HVB Settlement EAC12','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730013','UniCredit Bank - HVB Settlement EAC13','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730014','UniCredit Bank - HVB Settlement EAC14','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730015','UniCredit Bank - HVB Settlement EAC15','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730016','UniCredit Bank - HVB Settlement EAC16','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730017','UniCredit Bank - HVB Settlement EAC17','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730018','UniCredit Bank - HVB Settlement EAC18','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730019','UniCredit Bank - HVB Settlement EAC19','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730020','UniCredit Bank - HVB Settlement EAC20','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730021','UniCredit Bank - HVB Settlement EAC21','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730022','UniCredit Bank - HVB Settlement EAC22','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730023','UniCredit Bank - HVB Settlement EAC23','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730024','UniCredit Bank - HVB Settlement EAC24','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730025','UniCredit Bank - HVB Settlement EAC25','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730026','UniCredit Bank - HVB Settlement EAC26','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730027','UniCredit Bank - HVB Settlement EAC27','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730028','UniCredit Bank - HVB Settlement EAC28','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730029','UniCredit Bank - HVB Settlement EAC29','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730030','UniCredit Bank - HVB Settlement EAC30','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730031','UniCredit Bank - HVB Settlement EAC31','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730032','UniCredit Bank - HVB Settlement EAC32','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730033','UniCredit Bank - HVB Settlement EAC33','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730034','UniCredit Bank - HVB Settlement EAC34','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730035','UniCredit Bank - HVB Settlement EAC35','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730036','UniCredit Bank - HVB Settlement EAC36','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730037','UniCredit Bank - HVB Settlement EAC37','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730038','UniCredit Bank - HVB Settlement EAC38','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730039','UniCredit Bank - HVB Settlement EAC39','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730040','UniCredit Bank - HVB Settlement EAC40','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730051','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730053','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20730054','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('20750000','Sparkasse Harburg-Buxtehude','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21020600','Sydbank Filiale Kiel','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21030000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21030092','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21030093','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21030094','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21030095','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21040010','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21042076','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21050000','HSH Nordbank Hamburg, Kiel','C5')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21050170','Förde Sparkasse','74')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21051275','Bordesholmer Sparkasse','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21051580','Sparkasse Kreis Plön -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21052090','Sparkasse Eckernförde -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21060237','Evangelische Darlehnsgenossenschaft','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21070020','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21080050','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21089201','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21090007','Kieler Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21090619','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21090900','PSD Bank Kiel','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21092023','Eckernförder Bank Volksbank-Raiffeisenbank','48')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21210111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21230085','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21230086','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21240040','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21241540','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21261089','Raiffeisenbank -alt-','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21261227','Raiffbk Kl-Kummerfeld -alt-','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21270020','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21280002','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21290016','VR Bank Neumünster','48')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21340010','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21352240','Sparkasse Holstein','A7')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21390008','VR Bank Ostholstein Nord-Plön','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21392218','Volksbank Eutin Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21430070','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21440045','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21450000','Sparkasse Mittelholstein Rendsburg','C2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21451205','Sparkasse Büdelsdorf -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21452030','Sparkasse Hohenwestedt','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21463603','Volksbank-Raiffeisenbank im Kreis Rendsburg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21464671','Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21480003','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21500000','Bundesbank eh Flensburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21510600','Sydbank Filiale Flensburg','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21520100','Union-Bank Flensburg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21530080','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21540060','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21565316','Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21566356','Volks- und Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21567360','Raiffeisenbank Kleinjörl -alt-','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21570011','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21580000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21630060','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21630061','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21630062','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21630063','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21661719','VR Bank Flensburg-Schleswig','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21690020','Schleswiger Volksbank, Volksbank Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21700000','Bundesbank eh Husum','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21730040','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21730042','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21730043','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21730044','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21730045','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21730046','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21740043','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21741674','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21741825','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21750000','Nord-Ostsee Sparkasse','C8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21751230','Spar- und Leihkasse zu Bredstedt -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21762550','Husumer Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21763542','VR Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21770011','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21770024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21791805','Sylter Bank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21791906','Föhr-Amrumer Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21830030','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21830032','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21830033','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21830034','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21830035','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21840078','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21841328','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21851720','Alte Marner Sparkasse -alt-','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21851830','Verbandssparkasse Meldorf -alt-','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21852310','Sparkasse Hennstedt-Wesselburen','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21860418','Raiffeisenbank Heide','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('21890022','Dithmarscher Volks- und Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22130075','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22140028','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22141028','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22141428','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22141628','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22150000','Sparkasse Elmshorn','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22151730','Stadtsparkasse Wedel','D6')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22163114','Raiffeisenbank Elbmarsch','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22180000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22181400','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22190030','Volksbank Elmshorn','48')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22191405','VR Bank Pinneberg','48')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22200000','Bundesbank eh Itzehoe','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22230020','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22230022','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22230023','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22230025','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22240073','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22250020','Sparkasse Westholstein','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22251580','Landsparkasse Schenefeld -alt-','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22260136','Raiffeisenbank -alt-','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22280000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('22290031','Volksbank Raiffeisenbank Itzehoe','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23030000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23040022','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23050000','HSH Nordbank Lübeck','C5')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23050101','Sparkasse zu Lübeck','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23051030','Sparkasse Südholstein','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23051610','Sparkasse Stormarn -alt-','A7')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23052750','Kreissparkasse Herzogtum Lauenburg','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23061220','Raiffeisenbank Leezen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23062124','Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23062807','Volks- und Raiffeisenbank Mölln -alt-','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23063129','Raiffeisenbank','33')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23064107','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23070700','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23070710','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23080040','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23089201','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23090142','Volksbank Lübeck','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('23092620','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24000000','Bundesbank eh Lüneburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24030000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24050110','Sparkasse Lüneburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24060300','Volksbank Lüneburger Heide','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24061392','Volksbank Bleckede-Dahlenburg -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24070075','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24090041','Volksbank Lüneburg -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24121000','Ritterschaftliches Kreditinstitut Stade','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24130000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24140041','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24150001','Stadtsparkasse Cuxhaven','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24151005','Sparkasse Stade-Altes Land','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24151116','Kreissparkasse Stade','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24151235','Sparkasse Rotenburg-Bremervörde','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24161594','Zevener Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24162898','Spar- u Darlehnskasse Börde Lamstedt-Hechthausen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24180000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24180001','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('24191015','Volksbank Stade-Cuxhaven','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25010030','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25010600','Deutsche Hypothekenbank','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25010700','Berlin-Hannoversche Hypothekenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25010900','Calenberger Kreditverein','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25020200','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25020600','Santander Consumer Bank','41')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25030000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25040066','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25050000','Norddeutsche Landesbank Girozentrale','27')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25050055','ZVA Norddeutsche Landesbank SH','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25050180','Sparkasse Hannover','A3')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25050299','Sparkasse Hannover -alt-','A3')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25055500','LBS-Norddeutsche Landesbausparkasse','26')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25060000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25060180','Bankhaus Hallbaum','C3')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25060701','Evangelische Kreditgenossenschaft -Filiale Hannover-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25069168','Volks- und Raiffeisenbank Leinebergland','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25069262','Raiffeisen-Volksbank Neustadt','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25069270','Volksbank Aller-Oker','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25069370','Volksbank Vechelde-Wendeburg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25069503','Volksbank Diepholz-Barnstorf','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25070066','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25070070','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25070077','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25070084','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25070086','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25080020','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25089220','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25090300','Bank für Schiffahrt (BFS) Fil d Ostfr VB Leer','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25090500','Sparda-Bank Hannover','81')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25090608','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25090900','PSD Bank','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25120510','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25151270','Stadtsparkasse Barsinghausen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25151371','Stadtsparkasse Burgdorf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25152375','Kreissparkasse Fallingbostel in Walsrode','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25152490','Stadtsparkasse Wunstorf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25190001','Hannoversche Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25193331','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25250001','Kreissparkasse Peine','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25260010','Volksbank Peine','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25400000','Bundesbank eh Hameln','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25410111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25410200','BHW Bausparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25410300','BHW Allgemeine Bausparkasse -alt-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25430000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25440047','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25450001','Stadtsparkasse Hameln','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25450110','Sparkasse Weserbergland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25451345','Stadtsparkasse Bad Pyrmont','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25451450','Sparkasse Weserbergland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25451655','Sparkasse Weserbergland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25462160','Volksbank Hameln-Stadthagen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25462680','Volksbank im Wesertal','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25470073','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25471024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25471073','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25480021','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25491273','Volksbank Aerzen -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25491744','Volksbank Bad Münder','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25541426','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25551480','Sparkasse Schaumburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25591413','Volksbank in Schaumburg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25621327','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25641302','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25650106','Sparkasse Nienburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25651325','Kreissparkasse Grafschaft Diepholz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25662540','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25663584','Volksbank Aller-Weser','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25690009','Volksbank Nienburg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25691633','Volksbank Sulingen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25700000','Bundesbank eh Celle','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25730000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25740061','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25750001','Sparkasse Celle','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25761894','Volksbank Wittingen-Klötze','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25770024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25770069','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25780022','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25791516','Volksbank Hankensbüttel-Wahrenholz','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25791635','Volksbank Südheide','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25800000','Bundesbank eh Uelzen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25840048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25841403','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25841708','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25850110','Sparkasse Uelzen Lüchow-Dannenberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25851335','Sparkasse Uelzen Lüchow-Dannenberg -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25851660','Kreissparkasse Soltau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25861395','Volksbank Dannenberg -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25861990','Volksbank Clenze-Hitzacker','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25862292','Volksbank Uelzen-Salzwedel','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25863489','Volksbank Osterburg-Lüchow-Dannenberg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25891483','Volksbank Osterburg-Lüchow-Dannenberg -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25891636','Volksbank Lüneburger Heide -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25900000','Bundesbank eh Hildesheim','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25910111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25930000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25940033','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25950001','Stadtsparkasse Hildesheim -alt-','B1')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25950130','Sparkasse Hildesheim','B1')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25970024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25970074','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25971024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25971071','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25980027','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25990011','Volksbank Hildesheim','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25991528','Volksbank Hildesheimer Börde','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('25991911','Volksbank Sarstedt -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26030000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26040030','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26050001','Sparkasse Göttingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26051260','Sparkasse Duderstadt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26051450','Kreis- und Stadtsparkasse Münden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26061291','Volksbank Mitte','48')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26061556','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26062433','VR-Bank in Südniedersachsen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26062575','Raiffeisenbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26070072','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26080024','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26090050','Volksbank Göttingen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26240039','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26250001','Kreis-Sparkasse Northeim','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26251425','Sparkasse Einbeck','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26261396','Volksbank Dassel','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26261492','Volksbank Einbeck','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26261693','Volksbank Solling','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26271424','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26271471','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26280020','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26281420','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26340056','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26341072','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26350001','Stadtsparkasse Osterode','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26351015','Sparkasse Osterode am Harz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26351445','Stadtsparkasse Bad Sachsa','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26361299','Volksbank Oberharz -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26500000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26510111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26520017','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26521703','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26522319','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26540070','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26550105','Sparkasse Osnabrück','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26551540','Kreissparkasse Bersenbrück','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26552286','Kreissparkasse Melle','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26560625','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26562490','Volksbank Bad Laer-Borgloh-Hilter-Melle','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26562694','Volksbank Wittlage -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26563960','Volksbank Bramgau-Wittlage','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26565928','Volksbank GMHütte-Hagen-Bissendorf','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26566939','Volksbank Osnabrücker Nordland','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26567943','VR-Bank im Altkreis Bersenbrück','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26570090','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26580070','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26589210','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26590025','Volksbank Osnabrück','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26600000','Bundesbank eh Lingen (Ems)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26620010','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26621413','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26640049','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26650001','Sparkasse Emsland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26660060','Volksbank Lingen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26661380','Volksbank Haselünne','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26661494','Emsländische Volksbank Meppen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26661912','Volksbank Süd-Emsland -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26662932','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26691213','Volksbank Haren Fil d Ostfriesischen VB','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26720028','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26740044','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26750001','Kreissparkasse Grafschaft Bentheim zu Nordhorn','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26760005','Raiffeisen- und Volksbank Nordhorn -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26770024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26770095','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26800000','Bundesbank eh Halberstadt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26840032','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26850001','Sparkasse Goslar/Harz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26851410','Kreissparkasse Clausthal-Zellerfeld','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26851620','Sparkasse Salzgitter','22')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26870024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26870032','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26880063','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26890019','Volksbank Nordharz','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26891484','Volksbank im Harz','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26941053','Commerzbank Wolfsburg','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26951311','Sparkasse Gifhorn-Wolfsburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26971024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26971038','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26981062','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26989221','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('26991066','Volksbank Braunschweig Wolfsburg','50')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27000000','Bundesbank eh Braunschweig','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27010200','VON ESSEN Bankgesellschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27020000','Volkswagen Bank','D8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27020001','Audi Bank Zndl d Volkswagen Bank','D8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27020003','Skoda Bank','D8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27020004','AutoEuropa Bank','D8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27020800','Seat Bank Zndl d Volkswagen Bank','D8')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27030000','UniCredit Bank - HypoVereinsbank (ex VereinWest)','68')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27032500','Bankhaus C. L. Seeliger','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27040080','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27062290','Volksbank Börßum-Hornburg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070030','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070031','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070034','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070041','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070042','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070043','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27070079','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27072524','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27072537','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27072724','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27072736','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27080060','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27089221','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27090077','Volksbank Braunschweig -alt-','50')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27090618','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27090900','PSD Bank','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27092555','Volksbank Wolfenbüttel-Salzgitter','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27131300','Bankhaus Rautenschlein','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27190082','Volksbank Helmstedt','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27240004','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27290087','Volksbank Weserbergland','47')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27893215','Vereinigte Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27893359','Volksbank Braunlage','48')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('27893760','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28020050','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28021002','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28021301','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28021504','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28021623','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28021705','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28021906','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28022015','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28022412','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28022511','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28022620','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28022822','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28023224','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28023325','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28030300','Bankhaus W. Fortmann & Söhne','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28040046','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28042865','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28050100','Landessparkasse zu Oldenburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28060228','Raiffeisenbank Oldenburg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28061410','Raiffeisenbank Wesermarsch-Süd','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28061501','Volksbank Cloppenburg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28061679','Volksbank Dammer Berge','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28061822','Volksbank Oldenburg','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28062165','Raiffeisenbank Rastede','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28062249','Volksbank Ganderkesee-Hude','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28062560','Volksbank Lohne-Mühlen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28062740','Volksbank Bookholzberg-Lemwerder','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28062913','Volksbank Bösel','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28063253','Volksbank Westerstede','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28063526','Volksbank Essen-Cappeln','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28063607','Volksbank Bakum','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28064090','VR Bank Dinklage-Steinfeld -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28064179','Volksbank Vechta','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28064241','Raiffeisen-Volksbank Varel-Nordenham','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28065061','Volksbank Löningen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28065108','VR-Bank Dinklage-Steinfeld','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28065286','Raiffeisenbank Scharrel','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28066103','Volksbank Visbek','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28066214','Volksbank Wildeshauser Geest','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28066620','Spar- und Darlehnskasse Friesoythe','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28067068','Volksbank Neuenkirchen-Vörden','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28067170','Volksbank Delmenhorst Schierbrok','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28067257','Volksbank Lastrup','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28068218','Raiffeisenbank Butjadingen-Abbehausen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069052','Raiffeisenbank Strücklingen-Idafehn','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069092','VR Bank Oldenburg Land West','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069109','Volksbank Emstek','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069128','Raiffeisenbank Garrel','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069138','VR Bank Oldenburg Land West','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069293','Volksbank Obergrafschaft -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069381','Hümmlinger Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069706','Volksbank Nordhümmling','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069755','Raiffeisenbank Oldersum','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069773','Raiffeisenbank Wiesedermeer-Wiesede-Marcardsm','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069878','Raiffeisenbank Emsland-Mitte','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069926','Volksbank Niedergrafschaft','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069930','Volksbank Langen-Gersten','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069935','Raiffeisenbank Lorup','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069955','Volksbank Uelsen','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069956','Grafschafter Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069991','Volksbank Emstal','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28069994','Volksbank Süd-Emsland','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28070057','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28090633','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28200000','Bundesbank eh Wilhelmshaven','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28220026','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28222208','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28222621','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28240023','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28250110','Sparkasse Wilhelmshaven','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28252760','Kreissparkasse Wittmund','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28262254','Volksbank Jever','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28262673','Raiffeisen-Volksbank Varel-Nordenham','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28270056','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28280012','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28290063','Volksbank Wilhelmshaven','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28291551','Volksbank Esens','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28320014','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28321816','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28350000','Sparkasse Aurich-Norden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28361592','Raiffeisen-Volksbank Fresena','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28420007','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28421030','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28440037','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28450000','Sparkasse Emden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28470091','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28500000','Bundesbank eh Leer','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28520009','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28521518','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28540034','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28550000','Sparkasse LeerWittmund','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28562297','Raiffeisen-Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28562716','Raiffeisenbank Flachsmeer','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28562863','Raiffeisenbank Moormerland','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28563749','Raiffeisenbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28570092','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28590075','Ostfriesische Volksbank Leer','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28591579','Volksbank Papenburg Fil d. Ostfries. VB Leer','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('28591654','Volksbank Westrhauderfehn','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29010400','Deutsche Schiffsbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29020000','Bankhaus Neelmeyer','45')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29020100','KBC Bank Deutschland','18')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29020200','NordFinanz Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29020400','Deutsche Factoring Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29030400','Bankhaus Carl F. Plump & CO','C4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29040090','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29050000','Bremer Landesbank','29')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29050101','Sparkasse Bremen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29070050','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29070051','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29070052','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29070058','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29070059','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29080010','Commerzbank vormals Bremer Bank (Dresdner Bank)','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29089210','Commerzbank vormals Bremer Bank (Dresdner Bank) ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29090605','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29090900','PSD Bank Nord','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29121731','Oldenburgische Landesbank AG','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29151700','Kreissparkasse Syke','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29152300','Kreissparkasse Osterholz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29152550','Zweckverbandssparkasse Scheeßel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29152670','Kreissparkasse Verden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29162394','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29162453','Volksbank Schwanewede','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29162697','Volksbank Aller-Weser','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29165545','Volksbank Oyten','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29165681','Volksbank Sottrum','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29166568','Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29167624','Volksbank Syke','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29172624','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29172655','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29190024','Bremische Volksbank','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29190330','Volksbank Bremen-Nord','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29200000','Bundesbank eh Bremerhaven','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29210111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29240024','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29250000','Sparkasse Bremerhaven','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29250150','Kreissparkasse Wesermünde-Hadeln','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29262722','Volksbank Geeste-Nord','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29265747','Volksbank Bremerhaven-Cuxland','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29280011','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('29290034','Volksbank Bremerhaven-Wesermünde -alt-','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30010400','IKB Deutsche Industriebank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30010444','IKB Privatkunden - IKB Deutsche Industriebank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30010700','The Bank of Tokyo-Mitsubishi UFJ','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30020300','Santander Consumer Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30020500','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30020700','Mizuho Bank Filiale Düsseldorf','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30020900','TARGOBANK','57')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30022000','NRW.BANK','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30025500','Portigon','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30030100','S Broker Wiesbaden','56')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30030400','FXdirekt Bank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30030500','Bank11direkt','05')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30030600','ETRIS Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30030880','HSBC Trinkaus & Burkhardt','56')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30030900','Merck Finck & Co','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30040048','Commerzbank GF-D48','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30040060','Commerzbank Gf 660','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30040061','Commerzbank Gf 661','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30040062','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30040063','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30050000','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30050110','Stadtsparkasse Düsseldorf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30060010','WGZ Bank','44')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30060601','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30060992','PSD Bank Rhein-Ruhr','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30070010','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080005','Commerzbank vormals Dresdner Bank Zw 05','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080022','Commerzbank vormals Dresdner Bank Ztv 22','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080038','Commerzbank vormals Dresdner Bank Zw 38','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080041','Commerzbank vormals Dresdner Bank Zw 41','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080053','Commerzbank vormals Dresdner Bank Zw 53','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080055','Commerzbank vormals Dresdner Bank Zw 55','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080057','Commerzbank vormals Dresdner Bank Gf ZW 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080061','Commerzbank vormals Dresdner Bank Zw 61','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080074','Commerzbank vormals Dresdner Bank Zw 74','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080080','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080081','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080082','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080083','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 6','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080084','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 7','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 8','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 9','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 10','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080088','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 11','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080089','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 12','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30080095','Commerzbank vormals Dresdner Bank Zw 95','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30089300','Commerzbank vormals Dresdner Bank ITGK I','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30089302','Commerzbank vormals Dresdner Bank ITGK II','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30110300','Sumitomo Mitsui Banking Corporation','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30120500','KBC Bank Deutschland','18')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30120764','UniCredit Bank - HypoVereinsbank Ndl 450 Düs','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30130100','Demir-Halk Bank (Nederland)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30130200','GarantiBank International','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30130600','Isbank Fil Düsseldorf','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30130800','Düsseldorfer Hypothekenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30150001','Helaba Düsseldorf Gf Verrechnung FI-Dus','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30150200','Kreissparkasse Düsseldorf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30160213','Volksbank Düsseldorf Neuss','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30220190','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30330800','BIW Bank für Investments und Wertpapiere','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30351220','Stadt-Sparkasse Haan','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30520000','RCI Banque Niederlassung Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30520037','RCI Banque Direkt','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30530000','Bankhaus Werhahn','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30530500','Bank11 für Privatkunden und Handel, Neuss','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30550000','Sparkasse Neuss','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30551240','Stadtsparkasse Kaarst-Büttgen -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30560090','Volksbank Neuss -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('30560548','VR Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31000000','Bundesbank eh Mönchengladbach','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31010833','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31040015','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31050000','Stadtsparkasse Mönchengladbach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31060181','Gladbacher Bank von 1922','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31060517','Volksbank Mönchengladbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31062154','Volksbank Brüggen-Nettetal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31062553','Volksbank Schwalmtal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31070001','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31080015','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31080061','Commerzbank vormals Dresdner Bank Zw 61','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31251220','Kreissparkasse Heinsberg in Erkelenz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31261282','Volksbank Erkelenz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31263359','Raiffeisenbank Erkelenz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31460290','Volksbank Viersen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31470004','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('31470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32000000','Bundesbank eh Krefeld','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32040024','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32050000','Sparkasse Krefeld','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32051996','Sparkasse der Stadt Straelen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32060362','Volksbank Krefeld','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32061384','Volksbank an der Niers','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32061414','Volksbank Kempen-Grefrath','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32070080','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32080010','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32250050','Verbandssparkasse Goch','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32400000','Bundesbank eh Kleve, Niederrhein','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32440023','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32450000','Sparkasse Kleve','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32460422','Volksbank Kleverland','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('32470077','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33000000','Bundesbank eh Wuppertal','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33020000','akf bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33020190','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33030000','GEFA','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33040001','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33040310','Commerzbank Zw 117','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33050000','Stadtsparkasse Wuppertal','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33060098','Credit- und Volksbank Wuppertal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33060592','Sparda-Bank West','51')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33060616','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33070090','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33080001','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33080030','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33080088','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33440035','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33450000','Sparkasse Hilden-Ratingen-Velbert','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('33451220','Sparkasse Heiligenhaus -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34040049','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34050000','Stadtsparkasse Remscheid','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34051350','Sparkasse Radevormwald-Hückeswagen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34051570','Stadtsparkasse Wermelskirchen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34060094','Volksbank Remscheid-Solingen Remscheid-Lennep','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34070093','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34080031','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34240050','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34250000','Stadt-Sparkasse Solingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34270094','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('34280032','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35000000','Bundesbank eh Duisburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35020030','National-Bank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35040038','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35040085','Commerzbank, Gf Web-K','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35050000','Sparkasse Duisburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35060190','Bank für Kirche und Diakonie - KD-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35060386','Volksbank Rhein-Ruhr','40')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35060632','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35070030','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35080070','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35080088','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35080089','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35090300','Bank für Schiffahrt (BFS) Fil d Ostfr VB Leer','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35211012','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35251000','Sparkasse Dinslaken-Voerde-Hünxe','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35261248','Volksbank Dinslaken','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35450000','Sparkasse am Niederrhein','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35451460','Sparkasse Neukirchen-Vluyn -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35451775','Sparkasse Rheinberg -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35461106','Volksbank Niederrhein','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35600000','Bundesbank eh Wesel','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35640064','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35650000','Verbands-Sparkasse Wesel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35660599','Volksbank Rhein-Lippe','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35850000','Stadtsparkasse Emmerich-Rees','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('35860245','Volksbank Emmerich-Rees','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36010043','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36010200','VON ESSEN Bankgesellschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36010600','GALLINAT-BANK','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36010699','Gallinat - Bank Asset Backed Securities','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36020030','National-Bank Essen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36020186','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36020700','Hanseatic Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36033300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36036000','VALOVIS Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36040039','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36040085','Commerzbank, Gf Web-K','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36050000','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36050105','Sparkasse Essen','78')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36060192','Pax-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36060295','Bank im Bistum Essen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36060488','GENO BANK ESSEN','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36060591','Sparda-Bank West','51')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36060610','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36070050','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36080080','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK  2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36089321','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36200000','Bundesbank eh Mülheim an der Ruhr','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36210111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36220030','National-Bank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36240045','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36250000','Sparkasse Mülheim an der Ruhr','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36270048','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36280071','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36500000','Bundesbank eh Oberhausen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36520030','National-Bank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36540046','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36550000','Stadtsparkasse Oberhausen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36570049','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('36580072','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37010050','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37010600','Fortis Bank Ndl Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37011000','Deutsche Postbank Easytrade','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37013030','Deutsche Post Zahlungsdienste','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37020090','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37020200','AXA Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37020400','TOYOTA Kreditbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37020599','Bank für Sozialwirtschaft Köln Gf','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37020600','Santander Consumer Bank MG','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37020900','Ford Bank Ndl. der FCE Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37021100','Mazda Bank Niederlassung der FCE Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37021200','Volvo Auto Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37021201','Volvo Auto Bank - Direktbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37021300','Jaguar Financial Services Ndl der FCE Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37021400','Land Rover Financial Services Ndl der FCE Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37030200','Oppenheim, Sal - jr & Cie','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37030700','abcbank','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37030800','Isbank Fil Köln','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37040037','Commerzbank, CC SP','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37040044','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37040048','Commerzbank GF-K48','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37050198','Sparkasse KölnBonn','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37050299','Kreissparkasse Köln','B5')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37060120','Pax-Bank Gf MHD','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37060193','Pax-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37060590','Sparda-Bank West','51')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37060615','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37060993','PSD Bank Köln','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37062124','Bensberger Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37062365','Raiffeisenbank Frechen-Hürth','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37062600','VR Bank Bergisch Gladbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37063367','Raiffeisenbank Fischenich-Kendenich','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069101','Spar- und Darlehnskasse Aegidienberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069103','Raiffeisenbank Aldenhoven','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069125','Raiffeisenbank Kürten-Odenthal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069153','Spar- und Darlehnskasse Brachelen -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069164','Volksbank Meerbusch','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069252','Volksbank Erft','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069302','Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069303','Volksbank Gemünd-Kall -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069306','Raiffeisenbank Grevenbroich','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069322','Raiffeisenbank Gymnich','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069330','Volksbank Haaren','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069331','Raiffeisenbank von 1895 Zw Horrem -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069342','Volksbank Heimbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069354','Raiffeisenbank Selfkant Zw -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069355','Spar- und Darlehnskasse Hoengen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069381','VR-Bank Rur-Wurm','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069401','Raiffeisenbank Junkersdorf','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069405','Raiffeisenbank Kaarst','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069412','Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069427','Volksbank Dünnwald-Holweide','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069429','Volksbank Köln-Nord','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069472','Raiffeisenbk Erftstadt -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069520','VR-Bank Rhein-Sieg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069521','Raiffeisenbank Rhein-Berg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069524','Raiffeisenbank Much-Ruppichteroth','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069577','Raiffeisenbank Odenthal -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069627','Raiffeisenbank Rheinbach Voreifel','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069639','Rosbacher Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069642','Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069707','Raiffeisenbank Sankt Augustin','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069720','VR-Bank Nordeifel','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069805','Volksbank Wachtberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069833','Raiffeisenbk Wesseling -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069840','Volksbank Wipperfürth-Lindlar','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37069991','Brühler Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37070000','Deutsche Bank - Kontoservice für Kunden Sal. Oppenheim','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37070060','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080040','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080085','Commerzbank vormals Dresdner Bank Gf PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080088','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 6','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080089','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 7','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080090','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 8','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080091','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 9','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080092','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 10','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080093','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 11','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080094','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 12','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080095','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 13','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080096','Commerzbank vormals Dresdner Bank Zw 96','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080097','Commerzbank vormals Dresdner Bank Zw 97','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080098','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 14','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37080099','Commerzbank vormals Dresdner Bank Zw 99','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37089340','Commerzbank vormals Dresdner Bank ITGK I','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37089342','Commerzbank vormals Dresdner Bank ITGK II','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37160087','Kölner Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37161289','VR-Bank Rhein-Erft','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37540050','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37551020','Stadt-Sparkasse Leichlingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37551440','Sparkasse Leverkusen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37551780','Stadt-Sparkasse Langenfeld','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37560092','Volksbank Rhein-Wupper','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('37570064','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38000000','Bundesbank eh Bonn','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38010053','Postbank Zentrale','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38010700','DSL Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38010900','KfW Ndl Bonn','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38010999','KfW Ausbildungsförderung Bonn','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011000','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011001','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011002','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011003','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011004','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011005','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011006','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011007','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38011008','VÖB-ZVD Processing','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38020090','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38040007','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38050000','Sparkasse Bonn -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38051290','Stadtsparkasse Bad Honnef','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38060186','Volksbank Bonn Rhein-Sieg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38070059','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38070724','Deutsche Bank Privat und Geschäftskunden F 950','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38077724','Deutsche Bank Privat und Geschäftskunden F 950','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38080055','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38160220','VR-Bank Bonn','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38250110','Kreissparkasse Euskirchen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38260082','Volksbank Euskirchen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38440016','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38450000','Sparkasse Gummersbach-Bergneustadt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38452490','Sparkasse der Homburgischen Gemeinden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38462135','Volksbank Oberberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38470091','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38600000','Bundesbank eh Siegburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38621500','Steyler Bank','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38650000','Kreissparkasse Siegburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('38651390','Sparkasse Hennef','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39000000','Bundesbank eh Aachen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39020000','Aachener Bausparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39040013','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39050000','Sparkasse Aachen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39060180','Aachener Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39060630','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39061981','Heinsberger Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39070020','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39080005','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39080098','Commerzbank vormals Dresdner Bank Zw 98','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39080099','Commerzbank vormals Dresdner Bank Zw 99','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39160191','Pax-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39161490','Volksbank Aachen Süd','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39162980','VR-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39362254','Raiffeisen-Bank Eschweiler','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39500000','Bundesbank eh Düren','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39540052','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39550110','Sparkasse Düren','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39560201','Volksbank Düren','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39570061','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('39580041','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40000000','Bundesbank eh Münster','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40022000','NRW.BANK','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40030000','Münsterländische Bank Thie & Co','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40040028','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40050000','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40050150','Sparkasse Münsterland Ost','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40055555','LBS Westdeutsche Landesbausparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40060000','WGZ Bank','44')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40060265','DKM Darlehnskasse Münster','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40060300','WL BANK Westfälische Landschaft Bodenkreditbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40060560','Sparda-Bank Münster','85')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40060614','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40061238','Volksbank Greven','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069226','Volksbank Lette-Darup-Rorup','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069266','Volksbank Marsberg','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069283','Volksbank Schlangen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069348','Volksbank Medebach -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069362','Volksbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069363','Volksbank Schermbeck','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069371','Volksbank Thülen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069408','Volksbank Baumberge','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069462','Volksbank Sprakel','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069477','Volksbank Wulfen -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069546','Volksbank Senden','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069600','Volksbank Amelsbüren','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069601','Volksbank Ascheberg-Herbern','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069606','Volksbank Erle','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069622','Volksbank Seppenrade','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069636','Volksbank Lette -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069709','Volksbank Lembeck-Rhade','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40069716','Volksbank Südkirchen-Capelle-Nordkirchen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40070080','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40080040','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40090900','PSD Bank Westfalen-Lippe','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40150001','Helaba Düsseldorf Gf Verrechnung FI-Münster','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40153768','Verbundsparkasse Emsdetten Ochtrup','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40154006','Sparkasse Gronau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40154476','Stadtsparkasse Lengerich','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40154530','Sparkasse Westmünsterland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40154702','Stadtsparkasse Stadtlohn','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40160050','Volksbank Münster','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40163720','Volksbank Nordmünsterland -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40164024','Volksbank Gronau-Ahaus','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40164256','Volksbank Laer-Horstmar-Leer','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40164352','Volksbank Nottuln','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40164528','Volksbank Lüdinghausen-Olfen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40164618','Volksbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40164901','Volksbank Gescher','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40165366','Volksbank Selm-Bork','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40166439','Volksbank Lengerich/Lotte -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40166800','Volksbank Buldern -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40300000','Bundesbank eh Rheine','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40340030','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40350005','Stadtsparkasse Rheine','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40351060','Kreissparkasse Steinfurt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40351220','Sparkasse Steinfurt -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40361627','Volksbank Westerkappeln-Wersen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40361906','VR-Bank Kreis Steinfurt','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40363433','Volksbank Hörstel -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40370024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('40370079','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41000000','Bundesbank eh Hamm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41040018','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41041000','ZTB der Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41050095','Sparkasse Hamm','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41051605','Stadtsparkasse Werne','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41051845','Sparkasse Bergkamen-Bönen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41060120','Volksbank Hamm -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41061011','Spar- und Darlehnskasse Bockum-Hövel','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41061903','BAG Bankaktiengesellschaft','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41062215','Volksbank Bönen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41070049','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41240048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41250035','Sparkasse Beckum-Wadersloh','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41260006','Volksbank Beckum','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41261324','Volksbank Enniger-Ostenfelde-Westkirchen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41261419','Volksbank Oelde-Ennigerloh-Neubeckum','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41262501','Volksbank Ahlen-Sassenberg-Warendorf','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41262621','Vereinigte Volksbank Telgte','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41280043','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41440018','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41450075','Sparkasse Soest','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41451750','Sparkasse Werl','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41460116','Volksbank Hellweg','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41462295','Volksbank Wickede (Ruhr)','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41650001','Sparkasse Lippstadt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41651770','Sparkasse Hochsauerland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41651815','Sparkasse Erwitte-Anröchte','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41651965','Sparkasse Geseke','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41652560','Sparkasse Warstein-Rüthen -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41660124','Volksbank Lippstadt','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41661206','Volksbank Anröchte','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41661504','Volksbank Benninghausen -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41661719','Volksbank Brilon -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41662465','Volksbank Störmede','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41662557','Volksbank Warstein-Belecke -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41663335','Volksbank Hörste','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41670024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41670027','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41670028','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41670029','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('41670030','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42000000','Bundesbank eh Gelsenkirchen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42030600','Isbank Fil Gelsenkirchen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42040040','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42050001','Sparkasse Gelsenkirchen','25')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42070062','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42080082','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42260001','Volksbank Ruhr Mitte','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42450040','Stadtsparkasse Gladbeck','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42451220','Sparkasse Bottrop','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42461435','Volksbank Kirchhellen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42600000','Bundesbank eh Recklinghausen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42610112','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42640048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42650150','Sparkasse Vest Recklinghausen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42651315','Stadtsparkasse Haltern am See','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42661008','Volksbank Marl-Recklinghausen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42661330','Volksbank Haltern','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42661522','Volksbank Herten-Westerholt -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42661717','Volksbank Waltrop','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42662320','Volksbank Dorsten','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42680081','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42840005','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42850035','Stadtsparkasse Bocholt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42860003','Volksbank Bocholt','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42861239','Spar- und Darlehnskasse','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42861387','VR-Bank Westmünsterland','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42861416','Volksbank -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42861515','Volksbank Gemen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42861608','Volksbank Heiden','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42861814','Volksbank Rhede','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42862451','Volksbank Raesfeld','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42870024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('42870077','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43040036','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43050001','Sparkasse Bochum','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43051040','Sparkasse Hattingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43060129','Volksbank Bochum Witten','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43060967','GLS Gemeinschaftsbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43070061','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43080083','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('43250030','Herner Sparkasse','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44010046','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44010200','BHW Bausparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44020090','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44040037','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44040085','Commerzbank, Gf Web-K','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44050000','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44050199','Sparkasse Dortmund','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44060122','Volksbank Dortmund-Nordwest','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44060604','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44064406','Bank für Kirche und Diakonie - KD-Bank Gf Sonder-BLZ','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44070050','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44080050','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44080055','Commerzbank vormals Dresdner Bank Zw 55','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44080057','Commerzbank vormals Dresdner Bank Gf ZW 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44089320','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44090920','PSD Bank Dortmund -alt-','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44152370','Sparkasse Lünen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44152490','Stadtsparkasse Schwerte','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44160014','Dortmunder Volksbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44340037','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44350060','Sparkasse UnnaKamen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44351380','Sparkasse Kamen -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44351740','Sparkasse Fröndenberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44360002','Volksbank Unna Schwerte -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44361342','Volksbank Kamen-Werne','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44540022','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44550045','Sparkasse der Stadt Iserlohn','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44551210','Sparkasse Märkisches Sauerland Hemer-Menden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44570004','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44580070','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44580085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44750065','Sparkasse Menden -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44761312','Mendener Bank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('44761534','Volksbank im Märkischen Kreis','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45040042','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45050001','Sparkasse Hagen','02')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45051485','Stadtsparkasse Herdecke','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45060009','Märkische Bank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45061524','Volksbank Hohenlimburg','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45070002','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45080060','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45240056','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45250035','Sparkasse Witten','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45251480','Stadtsparkasse Wetter','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45251515','Stadtsparkasse Sprockhövel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45260041','Volksbank Witten -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45260475','Spar- u Kreditbank d Bundes Fr ev Gemeinden','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45261547','Volksbank Sprockhövel','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45450050','Stadtsparkasse Gevelsberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45451060','Sparkasse Ennepetal-Breckerfeld','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45451555','Städtische Sparkasse zu Schwelm','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45660029','Volksbank Altena -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45840026','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45841031','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45850005','Sparkasse Lüdenscheid','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45851020','Vereinigte Sparkasse im Märkischen Kreis','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45851665','Sparkasse Kierspe-Meinerzhagen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45860033','Volksbank Lüdenscheid -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45861434','Volksbank Kierspe','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('45861617','Volksbank Meinerzhagen -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46000000','Bundesbank eh Siegen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46040033','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46050001','Sparkasse Siegen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46051240','Sparkasse Burbach-Neunkirchen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46051733','Stadtsparkasse Freudenberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46051875','Stadtsparkasse Hilchenbach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46052855','Stadtsparkasse Schmallenberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46053480','Sparkasse Wittgenstein','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46060040','Volksbank Siegerland','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46061724','VR-Bank Freudenberg-Niederfischbach','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46062817','Volksbank Bigge-Lenne','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46063405','Volksbank Wittgenstein','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46070090','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46080010','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46240016','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46250049','Sparkasse Olpe-Drolshagen-Wenden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46251590','Sparkasse Finnentrop','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46251630','Sparkasse Attendorn-Lennestadt-Kirchhundem','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46260023','Volksbank Olpe -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46261607','Volksbank Grevenbrück','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46261822','Volksbank Olpe-Wenden-Drolshagen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46262456','Volksbank Bigge-Lenne -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46400000','Bundesbank eh Arnsberg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46441003','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46451012','Zweckverbandssparkasse Meschede','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46451250','Sparkasse Bestwig -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46461126','Volksbank Sauerland -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46462271','Spar- und Darlehnskasse Oeventrop','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46464453','Volksbank Reiste-Eslohe','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46640018','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46650005','Sparkasse Arnsberg-Sundern','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46660022','Volksbank Sauerland','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46670007','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('46670024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47200000','Bundesbank eh Paderborn','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47240047','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47250101','Sparkasse Paderborn -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47251550','Sparkasse Höxter','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47251740','Stadtsparkasse Delbrück','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47260121','Volksbank Paderborn-Höxter-Detmold','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47260234','Volksbank Elsen-Wewer-Borchen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47260307','Bank für Kirche und Caritas','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47261429','Volksbank Haaren -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47261603','Volksbank Brilon-Büren-Salzkotten','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47262626','Volksbank Westenholz','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47262703','Volksbank Delbrück-Hövelhof','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47263472','Volksbank Westerloh-Westerwiehe -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47264367','Vereinigte Volksbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47265383','Volksbank Wewelsburg-Ahden','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47267216','Volksbank Borgentreich -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47270029','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47460028','Volksbank Warburger Land -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47640051','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47650130','Sparkasse Paderborn-Detmold','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47651225','Stadtsparkasse Blomberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47670023','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47670024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47691200','Volksbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47800000','Bundesbank eh Gütersloh','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47840065','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47840080','Commerzbank Zw 80','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47850065','Sparkasse Gütersloh','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47852760','Sparkasse Rietberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47853355','Stadtsparkasse Versmold','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47853520','Kreissparkasse Wiedenbrück','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47860125','Volksbank Gütersloh','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47861317','Volksbank im Ostmünsterland','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47861518','Volksbank Harsewinkel -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47861806','Volksbank Kaunitz','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47861907','Volksbank Langenberg -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47862261','Volksbank Marienfeld -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47862447','Volksbank Rietberg','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47863373','Volksbank Versmold','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('47880031','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48020151','Bankhaus Lampe','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48021900','Bankverein Werther Zw Ndl der VB Paderborn-Höxter-Detmold','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48040035','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48050000','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48050161','Sparkasse Bielefeld','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48051580','Kreissparkasse Halle','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48060036','Bielefelder Volksbank','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48062051','Volksbank Halle/Westf','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48062466','Spar-u Darlehnskasse Schloß Holte-Stukenbrock','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070020','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070040','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070042','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070043','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070044','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070045','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070050','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48070052','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48080020','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48089350','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48091315','Volksbank Brackwede -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48250110','Sparkasse Lemgo','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48262248','Volksbank Nordlippe -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('48291490','Volksbank Bad Salzuflen','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49000000','Bundesbank eh Minden','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49040043','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49050101','Sparkasse Minden-Lübbecke','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49051065','Stadtsparkasse Rahden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49051285','Stadtsparkasse Bad Oeynhausen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49051990','Stadtsparkasse Porta Westfalica','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49060127','Volksbank Mindener Land','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49060392','Volksbank Minden','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49061298','Volksbank Bad Oeynhausen -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49061470','Volksbank Stemweder Berg -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49061510','Volksbank Eisbergen -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49070028','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49080025','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49092650','Volksbank Lübbecker Land','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49240096','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49262364','Volksbank Schnathorst','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49440043','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49450120','Sparkasse Herford','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49461323','Volksbank Enger-Spenge -alt-','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('49490070','Volksbank Bad Oeynhausen-Herford','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010060','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010200','AKBANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010517','ING-DiBa','C1')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010700','Degussa Bank','B7')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010900','Bank of America','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50010910','Bank of America, Filiale Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50012800','ALTE LEIPZIGER Bauspar','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020160','UniCredit Bank - HypoVereinsbank Ndl 427 Ffm','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020200','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020300','KBC Bank Deutschland','18')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020400','KfW Kreditanstalt für Wiederaufbau Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020500','Landwirtschaftliche Rentenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020700','Credit Europe Bank Ndl. Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020800','Intesa Sanpaolo Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50020900','COREALCREDIT BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50021000','ING Bank','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50021100','FIL Fondsbank','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50021120','FIL Fondsbank','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50023400','Bank of Beirut Ndl Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50030000','Banque PSA Finance Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50030100','HKB Bank Frankfurt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50030500','BNP PARIBAS Securities Services','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50030600','Deutsche WertpapierService Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50030700','DenizBank (Wien) Zw Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50030900','Lehman Brothers Bankhaus Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50031000','Triodos Bank Deutschland','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50033300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040033','Commerzbank Gf BRS','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040038','Commerzbank, MBP','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040040','Commerzbank Gf ZRK','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040048','Commerzbank GF-F48','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040050','Commerzbank, CC SP','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040051','Commerzbank Center Dresdner Bank Frankfurt','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040052','Commerzbank Service - BZ Frankfurt','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040060','Commerzbank Gf 460','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040061','Commerzbank Gf 461','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040062','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040063','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040075','Commerzbank Gf ZCM','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040085','Commerzbank, Gf Web-K','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040086','Commerzbank, GF Web-K CMTS','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040088','Commerzbank, INT 1','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50040099','Commerzbank INT','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50042500','Commerzbank Zw 425 - keine Auslandsbanken','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50044444','Commerzbank Vermögensverwaltung','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50047010','Commerzbank Service - BZ','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50050000','Landesbank Hessen-Thür Girozentrale','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50050201','Frankfurter Sparkasse','96')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50050222','Frankfurter Sparkasse GF 1822direkt','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50050999','DekaBank Frankfurt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50060000','DZ Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50060400','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50060411','First Cash DZ BANK Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50060412','DZ BANK Gf vK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50060413','DZ BANK Gf VK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50060414','DZ BANK Gf VK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50060500','Evangelische Kreditgenossenschaft -Filiale Frankfurt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50061741','Raiffeisenbank Oberursel','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069126','Raiffeisenbank Alzey-Land','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069146','Volksbank Grebenhain','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069187','Volksbank Egelsbach -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069241','Raiffeisenkasse Erbes-Büdesheim und Umgebung','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069345','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069455','Hüttenberger Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069464','Volksbank Inheiden-Villingen -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069477','Raiffeisenbank Kirtorf','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069693','Raiffeisenbank Bad Homburg Ndl d FrankfurterVB','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069828','Raiffeisenbank Mücke -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069842','Raiffeisen Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50069976','Volksbank Wißmar','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50070010','Deutsche Bank Filiale','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50073019','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50073024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50073081','Projektgesellschaft DB Europe','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080015','Commerzbank vormals Dresdner Bank Zw 15','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080025','Commerzbank vormals Dresdner Bank Zw 25','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080035','Commerzbank vormals Dresdner Bank Zw 35','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080055','Commerzbank vormals Dresdner Bank Zw 55','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080057','Commerzbank vormals Dresdner Bank Gf ZW 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080060','Commerzbank vormals Dresdner Bank Gf DrKW','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080061','Commerzbank vormals Dresdner Bank Gf DrKWSL','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080077','Commerzbank, GF Wüstenrot BSPK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080079','Commerzbank vormals Dresdner Bank ESOP','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080080','Commerzbank vormals Dresdner Bank Bs 80','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080082','Commerzbank vormals Dresdner Bank Gf AVB','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080086','Commerzbank vormals Dresdner Bank ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080088','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080089','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 6','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080091','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 7','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080092','Commerzbank vormals Dresdner Bank Finance and Controlling','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080099','Commerzbank vormals Dresdner Bank Zw 99','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50080300','Commerzbank vormals Dresdner Bank Private Banking Inland','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50083007','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50083838','Commerzbank vormals Dresdner Bank in Frankfurt MBP','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50089400','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50090200','VR DISKONTBANK','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50090500','Sparda-Bank Hessen','73')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50090607','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50090900','PSD Bank Hessen-Thüringen','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50092100','Spar- u Kreditbank ev-freikirchl Gemeinden','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50092200','Volksbank Main-Taunus -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50092900','Volksbank Usinger Land Ndl d Frankfurter VB','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50093000','Rüsselsheimer Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50093010','Rüsselsheimer Volksbank GAA','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50093400','Volksbank Kelsterbach Ndl d Frankfurter VB','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110200','Industrial and Commercial Bank of China','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110300','DVB Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110400','AKA Ausfuhrkredit GmbH','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110500','NATIXIS Zweigniederlassung Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110636','DTC Standard Chartered Bank Germany Branch','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110700','Frankfurter Bankgesellschaft (Deutschland)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110800','J.P. Morgan','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110801','J.P. Morgan, Internal Reference','94')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110855','J.P. Morgan','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50110900','Bank of America N.A. Military Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50120000','MainFirst Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50120100','ICICI Bank UK Ndl Frankfurt am Main','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50120383','Bethmann Bank','D9')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50120500','Credit Suisse (Deutschland)','66')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50120600','Bank of Communications Frankfurt branch','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50120900','VakifBank International Wien Zndl Frankfurt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50123400','VTB Bank (Austria), Zndl','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50130000','National Bank of Pakistan Zndl Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50130100','BethmannMaffei Bank -alt-','D9')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50130200','Oppenheim, Sal - jr & Cie','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50130300','First International Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50130400','Merck Finck & Co','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50130600','UBS Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50131000','Vietnam Joint Stock Commercial Bank for Industry and Trade','E1')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50150000','Landesbank Hessen-Thüringen Girozentrale NL. Düsseldorf','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50190000','Frankfurter Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50190300','Volksbank Höchst','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50190400','Volksbank Griesheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210111','SEB TZN Clearing','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210112','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210130','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210131','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210132','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210133','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210134','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210135','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210136','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210137','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210138','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210139','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210140','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210141','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210142','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210143','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210144','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210145','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210146','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210147','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210148','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210149','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210150','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210151','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210152','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210153','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210154','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210155','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210156','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210157','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210158','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210159','SEB TZN MB Ffm.','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210160','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210161','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210162','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210163','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210164','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210165','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210166','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210167','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210168','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210169','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210170','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210171','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210172','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210173','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210174','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210175','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210176','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210177','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210178','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210179','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210180','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210181','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210182','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210183','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210184','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210185','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210186','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210187','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210188','SEB TZN MB Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210189','SEB TZN MB Frankfurt','21')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210200','Rabobank International Frankfurt Branch','18')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210212','RaboDirect','18')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210295','Rabobank International Frankfurt Branch','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210300','Hypothekenbank Frankfurt ehem. Eurohypo','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210400','Hypothekenbank Frankfurt -alt-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210600','equinet Bank','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210800','ProCredit Bank, Frankfurt am Main','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50210900','Citigroup Global Markets Deutschland','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50220085','UBS Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50220200','Bethmann Bank (Vormals LGT Bank Deutschland)','D9')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50220500','Bank of Scotland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50220900','Hauck & Aufhäuser Privatbankiers','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50230000','ABC International Bank Frankfurt am Main','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50230100','Morgan Stanley Bank Internaional','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50230300','FCB Firmen-Credit Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50230400','The Royal Bank of Scotland Niederlassung Frankfurt','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50230600','Isbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50230700','Metzler, B. - seel Sohn & Co','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50230800','Ikano Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50250200','Deutsche Leasing Finance','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50310400','Barclays Bank Frankfurt','46')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50310455','Reiseschecks - Barclays Bank Frankfurt','46')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50310900','China Construction Bank Ndl Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50320000','VTB Bank (Deutschland)','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50320191','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50320500','Banco Santander Filiale Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50320600','Attijariwafa bank Europa ZNdl. Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50320900','Pictet & Cie (Europe) Ndl Frankfurt am Main','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50324000','ABN AMRO Bank, Frankfurt Branch','31')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50324040','ABN AMRO Bank, MoneYou','31')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50330000','State Bank of India','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50330200','MHB-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50330300','The Bank of New York Mellon','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50330500','BANQUE CHAABI DU MAROC Agentur Frankfurt Ndl. Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50330600','Bank Sepah-Iran','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50330700','Valovis Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50334400','The Bank of New York Mellon NL Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50400000','Bundesbank Zentrale','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510120','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510121','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510122','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510123','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510124','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510125','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510126','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510127','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510128','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510129','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510130','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510131','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510132','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510133','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510134','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510135','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510136','SEB TZN MB Ffm','21')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510137','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510138','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510139','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510140','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510141','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510142','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510143','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510144','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510145','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510146','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510147','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510148','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510149','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510150','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510151','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510152','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510153','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510154','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510155','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510156','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510157','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510158','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510159','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510160','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510161','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510162','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510163','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510164','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510165','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510166','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510167','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510168','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510169','SEB TZN MB Ffm','21')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510170','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510171','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510172','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510173','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510174','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510175','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510176','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510177','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510178','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510179','SEB TZN MB Ffm','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50510180','SEB TZN MB Ffm','21')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50520190','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50522222','FIDOR Bank Zndl Frankfurt am Main','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50530000','Cronbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50540028','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50550020','Städtische Sparkasse Offenbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50560102','Raiffeisenbank Offenbach/M.-Bieber','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50561315','Vereinigte Volksbank Maingau','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50570018','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50580005','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50580085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50590000','Offenbacher Volksbank -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50592200','Volksbank Dreieich','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50600000','Bundesbank eh Hanau','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50640015','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50650023','SPARKASSE HANAU','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50652124','Sparkasse Langen-Seligenstadt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50661639','VR Bank Main-Kinzig-Büdingen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50661816','Volksbank Heldenbergen Ndl d Frankfurter VB','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50662299','Raiffeisenbank Bruchköbel -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50662669','Raiffeisenbank Maintal Ndl d Frankfurter VB','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50663699','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50670009','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50670024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50680002','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50680085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50690000','Volksbank Raiffeisenbank Hanau Ndl d Frankf VB','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50691300','DZB BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50692100','Volksbank Seligenstadt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50740048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50750094','Kreissparkasse Gelnhausen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50761333','Volksbank -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50761613','Volksbank Büdingen -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50763319','Raiffeisenbank Vogelsberg -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50780006','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50790000','VR Bank Bad Orb-Gelnhausen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50793300','Birsteiner Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50794300','VR Bank Wächtersbach/Bad Soden-Salmünster -alt','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50800000','Bundesbank eh Darmstadt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50810900','Deutsche Bausparkasse Badenia (ehem. DBS Bausparkasse)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50820292','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50835800','MCE Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50840005','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50850049','Landesbank Hessen-Thür Girozentrale','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50850150','Stadt- und Kreis-Sparkasse Darmstadt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50851952','Sparkasse Odenwaldkreis','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50852553','Kreissparkasse Groß-Gerau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50852651','Sparkasse Dieburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50861393','Spar- und Darlehnskasse Zell -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50861501','Raiffeisenbank Nördliche Bergstraße','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50862311','Volksbank Gräfenhausen -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50862408','Vereinigte Volksbank Griesheim-Weiterstadt -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50862703','Volksbank Gersprenztal-Otzberg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50862835','Raiffeisenbank Schaafheim','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50862903','Volksbank Mainspitze','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50863317','Volksbank Seeheim-Jugenheim','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50863513','Volksbank Odenwald','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50863906','Volksbank Modautal Modau','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50864322','Volksbank Modau','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50864808','Volksbank Seeheim-Jugenheim','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50865224','VB Mörfelden-Walldorf Ndl d Frankfurter VB','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50865503','Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50870005','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50870024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50880050','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50880085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50880086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50890000','Volksbank Darmstadt - Südhessen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50890634','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50892500','Groß-Gerauer Volksbank -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50950068','Sparkasse Bensheim','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50951469','Sparkasse Starkenburg','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50961206','Raiffeisenbank Ried','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50961312','Raiffeisenbank Groß-Rohrheim','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50961592','Volksbank Weschnitztal','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50961685','Volksbank Überwald-Gorxheimertal','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50970004','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('50970024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51000000','Bundesbank eh Wiesbaden','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51010400','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51010800','Aareal Bank Zw L','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51020000','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51020186','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51040038','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51050015','Nassauische Sparkasse','A2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51051000','S Broker Wiesbaden','56')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51070021','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51080060','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51089410','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51090000','Wiesbadener Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51090636','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51091400','Volksbank Eltville -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51091500','Rheingauer Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51091700','vr bank Untertaunus','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51091711','Bank f Orden u Mission Zndl vr bk Untertaunus','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51140029','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51150018','Kreissparkasse Limburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51151919','Kreissparkasse Weilburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51161606','Volksbank Langendernbach','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51170010','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51170024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51180041','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51190000','Vereinigte Volksbank Limburg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51191200','Volksbank Goldner Grund','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51191800','Volksbank Schupbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51192200','Volks- und Raiffeisenbank Weilmünster -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51210600','BNP PARIBAS Ndl Frankfurt, Main','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51210700','NIBC Bank Zndl Frankfurt am Main','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51210800','Societe Generale','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51211000','NATIXIS Pfandbriefbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51220200','SEB Merchant Banking','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51220211','SEB Frankfurt SAP','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51220400','Bank Saderat Iran','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51220700','ZIRAAT BANK International','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51220800','Banco do Brasil','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51220900','Morgan Stanley Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51220910','Morgan Stanley Bank','50')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230100','Hypothekenbank Frankfurt -alt-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230400','RBS ( Deutschland ) Frankfurt am Main','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230500','Standard Chartered Bank Germany Branch, Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230502','ETC Standard Chartered Bank Germany Branch','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230555','Standard Chartered Bank Germany Branch, Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230600','Europe ARAB Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230800','Wirecard Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230801','Wirecard Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230802','Wirecard Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51230805','Wirecard Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51250000','Taunus-Sparkasse','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51300000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51310111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51340013','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51343224','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51350025','Sparkasse Gießen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51351526','Sparkasse Grünberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51352227','Sparkasse Laubach-Hungen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51361021','Volksbank Heuchelheim','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51361704','Volksbank Holzheim -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51362514','VR Bank Mücke -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51363407','Volksbank Garbenteich -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51370008','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51370024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51380040','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51380085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51390000','Volksbank Mittelhessen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51410111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51410600','Merrill Lynch International Bank Limited Zndl Frankfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51410700','Bank of China','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51410800','OnVista Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51420200','Misr Bank-Europe','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51420300','Bank Julius Bär Europe','17')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51420600','Svenska Handelsbanken Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51430300','Nordea Bank Finland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51430321','Nordea Bank Finland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51430400','Goldman Sachs','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51540037','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51550035','Sparkasse Wetzlar','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51560231','Volksbank Wetzlar-Weilburg -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51570008','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51580044','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51591300','Volksbank Brandoberndorf','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51640043','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51650045','Sparkasse Dillenburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51690000','Volksbank Dill VB und Raiffbk','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51691500','Volksbank Herborn-Eschenburg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51752267','Sparkasse Battenberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51762434','VR Bank Biedenkopf-Gladenbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51850079','Sparkasse Oberhessen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51861325','BVB Volksbank Ndl d Frankfurter Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51861403','Volksbank Butzbach','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51861616','Landbank Horlofftal','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51861806','Volksbank Ober-Mörlen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51961023','Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51961515','Spar- und Darlehnskasse Stockhausen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51961801','Volksbank Feldatal','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('51990000','Volksbank Lauterbach-Schlitz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52000000','Bundesbank eh Kassel','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52040021','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52050000','Landeskreditkasse Kassel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52050353','Kasseler Sparkasse','05')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52051373','Stadtsparkasse Borken (Hessen)','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52051555','Stadtsparkasse Felsberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52051877','Stadtsparkasse Grebenstein','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52052154','Kreissparkasse Schwalm-Eder','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52053458','Stadtsparkasse Schwalmstadt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52060000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52060208','Kurhessische Landbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52060400','Evangelische Kreditgenossenschaft Gf','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52060410','Evangelische Kreditgenossenschaft','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52061303','Raiffeisenbank Borken','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52062200','VR-Bank Chattengau','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52062601','VR-Bank Schwalm-Eder','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52063369','VR-Bank Spangenberg-Morschen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52063550','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52064156','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52065220','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52069013','Raiffeisenbank Burghaun','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52069029','Spar-u. Kredit-Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52069065','Raiffeisenbank Langenschwarz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52069103','Raiffeisenbank Trendelburg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52069149','Raiffeisenbank Volkmarsen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52069503','Raiffeisenbank Ulmbach -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52069519','Frankenberger Bank Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52070012','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52071212','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52071224','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52080080','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52090000','Kasseler Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52090611','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52240006','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52250030','Sparkasse Werra-Meißner','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52260385','VR-Bank Werra-Meißner','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52270012','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52350005','Sparkasse Waldeck-Frankenberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52360059','Waldecker Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52410300','ReiseBank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52410310','ReiseBank Gf2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52410400','Korea Exchange Bank (Deutschland)','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52410900','Maple Bank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52411000','Cash Express Gesellschaft f Finanz-u Reisedienstleistungen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52411010','Cash Express Gesellschaft f.Finanz-u.Reisedienstleistungen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52420000','Credit Agricole CIB Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52420300','SHINHAN BANK EUROPE','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52420600','Piraeus Bank Frankfurt Branch','30')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52420700','SECB Swiss Euro Clearing Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52430000','Credit Mutuel - BECM - Ndl Deutschland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('52430100','Banque Federative Credit Mutuel Ndl Deutschl','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53000000','Bundesbank eh Fulda','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53040012','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53050180','Sparkasse Fulda','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53051396','Kreissparkasse Schlüchtern','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53060180','VR Genossenschaftsbank Fulda','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53061230','VR-Bank NordRhön','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53061313','VR Bank Schlüchtern-Birstein','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53062035','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53062350','Raiffeisenbank Biebergrund-Petersberg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53064023','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53070007','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53080030','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53093200','VR Bank HessenLand','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53093255','AgrarBank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53200000','Bundesbank eh Bad Hersfeld','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53240048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53250000','Sparkasse Bad Hersfeld-Rotenburg','A6')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53260145','Raiffeisenbank Asbach-Sorga','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53261202','Bankverein Bebra','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53261342','Raiffeisenbank Werratal-Landeck','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53261700','Raiffeisenbank Aulatal -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53262073','Raiffeisenbank Haunetal','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53262455','Raiffeisenbank Ronshausen-Marksuhl','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53270012','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53280081','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53290000','VR-Bank Bad Hersfeld-Rotenburg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53340024','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53350000','Sparkasse Marburg-Biedenkopf','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53361724','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53370008','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53370024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53380042','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53381843','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('53390635','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54000000','Bundesbank eh Kaiserslautern','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54020090','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54020474','UniCredit Bank - HypoVereinsbank Ndl 697 Kais','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54030011','Service Credit Union Overseas Headquarters','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54040042','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54050110','Stadtsparkasse Kaiserslautern','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54050220','Kreissparkasse Kaiserslautern','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54051550','Kreissparkasse Kusel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54051660','Stadtsparkasse Landstuhl -alt-','B2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54051990','Sparkasse Donnersberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54061650','VR-Bank Westpfalz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54062027','Raiffeisenbank Donnersberg -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54070092','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54080021','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54090000','Volksbank Kaiserslautern-Nordwestpfalz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54091700','Volksbank Lauterecken','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54091800','VR Bank Nordwestpfalz -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54092400','Volksbank Glan-Münchweiler','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54210111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54220091','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54220576','UniCredit Bank - HypoVereinsbank Ndl 358 Pirm','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54240032','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54250010','Sparkasse Südwestpfalz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54261700','VR-Bank Südwestpfalz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54262330','Raiffeisenbank Vinningen -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54270096','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54280023','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54290000','VR-Bank Pirmasens','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54291200','Raiffeisen- u Volksbank Dahn','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54500000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54510067','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54520071','UniCredit Bank - HypoVereinsbank Ndl 650 Lu','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54520194','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54540033','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54550010','Sparkasse Vorderpfalz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54550120','Kreissparkasse Rhein-Pfalz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54561310','RV Bank Rhein-Haardt','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54570094','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54580020','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54620093','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54620574','UniCredit Bank - HypoVereinsbank Ndl 660 Ne/W','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54640035','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54651240','Sparkasse Rhein-Haardt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54661800','Raiffeisenbank Freinsheim','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54663270','Raiffeisenbank Friedelsheim-Rödersheim','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54670024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54670095','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54680022','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54690623','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54691200','VR Bank Mittelhaardt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54750010','Kreis- und Stadtsparkasse Speyer','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54760900','Evangelische Kreditgenossenschaft - Filiale Speyer-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54761411','Raiffeisenbank Schifferstadt -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54790000','Volksbank Kur- und Rheinpfalz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54820674','UniCredit Bank - HypoVereinsbank Ndl 659 LanP','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54850010','Sparkasse Südliche Weinstraße in Landau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54851440','Sparkasse Germersheim-Kandel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54861190','Raiffeisenbank Oberhaardt-Gäu -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54862390','Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54862500','VR Bank Südpfalz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('54891300','VR Bank Südliche Weinstraße','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55010400','Aareal Bank GF - BK01 -','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55010625','Aareal Bank Clearing Wiesbaden','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55010800','Investitions- und Strukturbank RP','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55020000','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55020100','Bausparkasse Mainz','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55020486','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55020600','Westdeutsche Immobilien Bank','08')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55020700','Süd-West-Kreditbank Finanzierung','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55030500','GE Capital Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55030533','GE Capital Direkt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55033300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55040022','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55050000','ZV Landesbank Baden-Württemberg','59')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55050120','Sparkasse Mainz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55060321','VR-Bank Mainz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55060417','VR-Bank Mainz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55060611','Genobank Mainz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55060831','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55061303','Budenheimer Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55061507','VR-Bank Mainz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55061907','Volksbank Rhein-Selz -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55070040','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55080044','Commerzbank, TF MZ 1','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55080065','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55080088','Commerzbank, TF MZ 2','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55090500','Sparda-Bank Südwest','90')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55091200','Volksbank Alzey-Worms','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55150098','Clearingkonto LRP-SI','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55160195','Pax-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190000','Mainzer Volksbank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190028','Mainzer Volksbank -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190050','Mainzer Volksbank -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190064','Mainzer Volksbank -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190065','Mainzer Volksbank -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190068','Mainzer Volksbank -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190088','Mainzer Volksbank -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55190094','Mainzer Volksbank -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55340041','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55350010','Sparkasse Worms-Alzey-Ried','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55361202','VR Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55362071','Volksbank Bechtheim -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('55390000','Volksbank Worms-Wonnegau -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56000000','Bundesbank eh Bad Kreuznach','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56050180','Sparkasse Rhein-Nahe','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56051790','Kreissparkasse Rhein-Hunsrück','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56061151','Raiffeisenbank Kastellaun','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56061472','Volksbank Hunsrück-Nahe','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56062227','Volksbank','40')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56062577','Vereinigte Raiffeisenkassen -alt-','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56070040','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56090000','Volksbank Rhein-Nahe-Hunsrück','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56240050','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56250030','Kreissparkasse Birkenfeld','B2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56261735','Raiffeisenbank Nahe','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56270044','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('56290000','Volksbank-Raiffeisenbank Naheland -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57020301','MKB Mittelrheinische Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57020500','Oyak Anker Bank','D7')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57020600','Debeka Bausparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57040044','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57050120','Sparkasse Koblenz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57051001','Kreissparkasse Westerwald','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57051870','Kreissparkasse Cochem-Zell -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57060000','WGZ Bank','44')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57060612','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57062675','Raiffeisenbank','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57063478','Volksbank Vallendar-Niederwerth','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57064221','Volksbank Mülheim-Kärlich','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069067','Raiffeisenbank Lutzerather Höhe','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069081','Raiffeisenbank Moselkrampen','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069144','Raiffeisenbank Kaisersesch','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069238','Raiffeisenbank Neustadt','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069257','Raiffeisenbank Untermosel','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069315','Raiffeisenbank Straßenhaus -alt-','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069361','Raiffeisenbank Welling','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069526','Raiffeisenbank Idarwald -alt-','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069727','Raiffeisenbank Irrel','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57069806','VR-Bank Hunsrück-Mosel','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57070045','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57080070','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57090000','Volksbank Koblenz Mittelrhein','64')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57090900','PSD Bank Koblenz','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57091000','Volksbank Montabaur-Höhr-Grenzhausen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57091100','Volksbank Höhr-Grenzhausen -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57092800','Volksbank Rhein-Lahn','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57263015','Raiffeisenbank Unterwesterwald','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57351030','Kreissparkasse Altenkirchen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57361476','Volksbank Gebhardshain','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57363243','Raiffeisenbank Niederfischbach -alt-','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57391200','Volksbank Daaden','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57391500','Volksbank Hamm, Sieg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57391800','Westerwald Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57400000','Bundesbank eh Neuwied','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57450120','Sparkasse Neuwied','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57460117','Volks- und Raiffeisenbank Neuwied-Linz','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57461759','Raiffeisenbank Mittelrhein','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57470047','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57650010','Kreissparkasse Mayen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57661253','Raiffeisenbank','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57662263','VR Bank Rhein-Mosel','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57751310','Kreissparkasse Ahrweiler','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57761591','Volksbank RheinAhrEifel','34')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('57762265','Raiffeisenbank Grafschaft-Wachtberg','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58500000','Bundesbank eh Trier','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58510111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58520086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58540035','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58550130','Sparkasse Trier','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58560103','Volksbank Trier','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58560294','Pax-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58561250','Volksbank Hermeskeil -alt-','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58561626','Volksbank Saarburg -alt-','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58561771','Raiffeisenbank Mehring-Leiwen','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58564788','Volksbank Hochwald-Saarburg','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58570048','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58580074','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58590900','PSD Bank Trier Ndl der PSD Bank Köln','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58650030','Kreissparkasse Bitburg-Prüm','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58651240','Kreissparkasse Vulkaneifel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58660101','Volksbank Bitburg','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58661901','Raiffeisenbank Westeifel','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58662653','Raiffeisenbank östl Südeifel','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58668818','Raiffeisenbank Neuerburg-Land -alt-','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58691500','Volksbank Eifel Mitte','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58751230','Sparkasse Mittelmosel-Eifel Mosel Hunsrück','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58760954','Vereinigte Volksbank Raiffeisenbank','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58761343','Raiffeisenbank Zeller Land','38')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58771224','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('58771242','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010011','ZVC Postbank Gf FK 11','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010012','ZVC Postbank Gf FK 12','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010013','ZVC Postbank Gf FK 13','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010014','ZVC Postbank Gf FK 14','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010015','ZVC Postbank Gf FK 15','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010016','ZVC Postbank Gf FK 16','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010017','ZVC Postbank Gf FK 17','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010018','ZVC Postbank Gf FK 18','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010019','ZVC Postbank Gf FK 19','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010020','ZVC Postbank GF FK 20','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010021','ZVC Postbank GF FK 21','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010022','ZVC Postbank GF FK 22','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010023','ZVC Postbank GF FK 23','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010024','ZVC Postbank GF FK 24','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010025','ZVC Postbank GF FK 25','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010026','ZVC Postbank GF FK 26','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010027','ZVC Postbank Gf FK 27','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010028','ZVC Postbank Gf FK 28','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010029','ZVC Postbank Gf FK 29','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010031','ZVC Postbank Gf FK 31','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010032','ZVC Postbank Gf FK 32','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010033','ZVC Postbank Gf FK 33','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010034','ZVC Postbank Gf FK 34','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010035','ZVC Postbank Gf FK 35','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010036','ZVC Postbank Gf FK 36','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010037','ZVC Postbank Gf FK 37','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010038','ZVC Postbank Gf FK 38','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010039','ZVC Postbank Gf FK 39','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010040','ZVC Postbank Gf FK 40','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010041','ZVC Postbank Gf FK 41','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010042','ZVC Postbank Gf FK 42','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010044','ZVC Postbank Gf FK 44','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010045','ZVC Postbank Gf FK 45','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010047','ZVC Postbank Gf FK 47','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010048','ZVC Postbank Gf FK 48','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010049','ZVC Postbank Gf FK 49','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010066','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59010400','Saarl Investitionskreditbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59020090','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59050000','Landesbank Saar','27')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59050101','Sparkasse Saarbrücken','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59051090','Stadtsparkasse Völklingen','21')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59052020','SKG BANK','D3')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59070000','Deutsche Bank Saarbruecken','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59070070','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59080090','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59090626','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59090900','PSD Bank RheinNeckarSaar','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59091500','Volksbank Sulzbachtal -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59091800','Volksbank Quierschied -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59092000','Vereinigte Volksbank Dillingen Dudweiler Sulzbach/Saar','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59099530','Raiffeisenkasse Wiesbach -alt-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59099550','Volksbank Nahe-Schaumberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59190000','Bank 1 Saar','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59190100','VVBS Ver. Volksbanken Saarbrücken-St Ingbert','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59190200','Volksbank Saar-West','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59251020','Kreissparkasse St. Wendel','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59252046','Sparkasse Neunkirchen','C9')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59290100','Volksbank Neunkirchen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59291000','St. Wendeler Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59291200','Volksbank Saarpfalz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59291300','Volksbank Spiesen-Elversberg -alt-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59292400','Eppelborner Volksbank -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59300000','Bundesbank eh Saarlouis','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59320087','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59350110','Kreissparkasse Saarlouis','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59351040','Sparkasse Merzig-Wadern','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59390100','Volksbank Saarlouis','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59391200','Volksbank Überherrn','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59392000','Volksbank Dillingen -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59392200','Volksbank Untere Saar','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59393000','levoBank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59450010','Kreissparkasse Saarpfalz','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59491114','VR Bank Saarpfalz','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('59491300','VR Bank Saarpfalz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60010070','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60010700','Landeskreditbank Baden-Württemberg Förderbank -alt-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60020030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60020100','Schwäbische Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60020290','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60020300','VON ESSEN Bankgesellschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60030000','Mercedes-Benz Bank','A3')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60030100','Bankhaus Bauer, Stuttgart','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60030200','Bankhaus Ellwanger & Geiger','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60030600','CreditPlus Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60030666','CreditPlus Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60030700','AKTIVBANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60030900','Isbank Fil Stuttgart','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60033000','Wüstenrot Bausparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60035810','IBM Deutschland Kreditbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60040071','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60050000','Landesbank Baden-Württemberg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60050009','ZV Landesbank Baden-Württemberg ISE','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60050101','Landesbank Baden-Württemberg/Baden-Württembergische Bank','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60060000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60060202','DZ PRIVATBANK Ndl. Stuttgart','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60060396','Untertürkheimer Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60060606','Evangelische Kreditgenossenschaft -Filiale Stuttgart-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60060893','VR-Bank Stuttgart -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60062775','Echterdinger Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60062909','Volksbank Strohgäu','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069017','Raiffeisenbank Dellmensingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069066','Raiffeisenbank Niedere Alb','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069075','Raiffeisenbank Bühlertal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069147','Raiffeisenbank Sondelfingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069158','Raiffeisenbank Steinheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069206','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069224','Genossenschaftsbank Weil im Schönbuch','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069235','Raiffeisenbank Zndl VB Nordschwarzwald -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069239','Bopfinger Bank Sechta-Ries','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069242','Raiffeisenbank Gruibingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069245','Raiffeisenbank Oberes Bühlertal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069251','Raiffeisenbank Donau-Iller','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069302','Raiffeisenbank Erlenmoos','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069303','Raiffeisenbank Bad Schussenried','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069308','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069315','Volksbank Freiberg und Umgebung','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069325','Hegnacher Bank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069336','Raiffeisenbank Maitis','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069343','Raiffeisenbank Rißtal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069346','Raiffeisenbank Ehingen-Hochsträß','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069350','Raiffeisenbank Reute-Gaisbeuren','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069355','Ehninger Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069371','Raiffbk Neukirch Ndl d Volksbank Tettnang','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069378','Volksbank Dettenhausen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069387','Dettinger Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069417','Raiffeisenbank Kirchheim-Walheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069419','Uhlbacher Bank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069420','Raiffeisenbank Mittelbiberach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069431','Raiffeisenbank Oberessendorf','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069442','Raiffeisenbank Frankenhardt-Stimpfach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069455','Raiffeisenbank Vordersteinenberg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069457','Raiffeisenbank Ottenbach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069461','Raiffeisenbank Rottumtal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069462','Winterbacher Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069463','Raiffeisenbank Geislingen-Rosenfeld','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069476','Raiffeisenbank Heidenheimer Alb','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069485','Raiffeisenbank Oberer Wald','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069505','Volksbank Murgtal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069517','Scharnhauser Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069520','Raiffeisenbank Ehingen-Hochsträß','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069527','Volksbank Brenztal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069538','Löchgauer Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069544','Raiffeisenbank Westhausen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069545','Nufringer Bank -Raiffeisen-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069553','Raiffeisenbank Aichhalden-Hardt-Sulgen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069564','Raiffeisenbank Vordere Alb','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069593','Raiffeisenbank Oberes Schlichemtal -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069595','Raiffeisenbank Schrozberg-Rot am See','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069639','Raiffeisenbank Ingersheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069648','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069669','Erligheimer Bank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069670','Raiffeisenbank Ehingen-Hochsträß','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069673','Abtsgmünder Bank -Raiffeisen-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069680','Raiffeisenbank Bretzfeld-Neuenstein','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069685','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069692','Raiffeisenbank Enzberg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069705','Raiffeisenbank Schlat -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069706','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069710','Raiffeisenbank Gammesfeld','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069714','Raiffeisenbank Kocher-Jagst','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069724','Raiffeisenbank Heroldstatt -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069727','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069738','Volksbank Freiberg und Umgebung','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069766','Volks- und Raiffeisenbank Boll -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069780','Genossenschaftsbank Grabenstetten','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069795','Volksbank Freiberg und Umgebung','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069798','Raiffeisenbank Horb','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069817','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069832','Raiffeisenbank Urbach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069842','Darmsheimer Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069858','Enztalbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069860','Federseebank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069876','Raiffeisenbank Oberes Gäu Ergenzingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069896','Volksbank Freiberg und Umgebung','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069904','VR-Bank Alb','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069905','Volksbank Remseck','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069911','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069926','Volksbank Glatten-Wittendorf -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069927','Berkheimer Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069931','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069950','Raiffeisenbank Tüngental','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069971','Raiffeisenbank Ehingen-Hochsträß','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069976','Raiffeisenbank Böllingertal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60069980','Raiffeisenbank Maselheim-Äpfingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60070070','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60080055','Commerzbank vormals Dresdner Bank Zw 55','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60080057','Commerzbank vormals Dresdner Bank Gf Zw 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60080085','Commerzbank vormals Dresdner Bank ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60080086','Commerzbank vormals Dresdner Bank Gf PCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60080087','Commerzbank vormals Dresdner Bank, PCC DC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60080088','Commerzbank vormals Dresdner Bank, PCC DC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60089450','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60090100','Volksbank Stuttgart','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60090300','Volksbank Zuffenhausen m Zndl Stammheimer VB','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60090609','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60090700','Südwestbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60090800','Sparda-Bank Baden-Württemberg','87')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60090900','PSD Bank RheinNeckarSaar','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60120050','UniCredit Bank - HypoVereinsbank Ndl 434 Stgt','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60120200','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60120500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60130100','FFS Bank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60133300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60200000','Bundesbank eh Waiblingen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60220030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60241074','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60250010','Kreissparkasse Waiblingen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60250184','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60261329','Fellbacher Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60261622','VR-Bank Weinstadt','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60261818','Raiffeisenbank Weissacher Tal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60262063','Korber Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60262693','Kerner Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60270073','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60290110','Volksbank Rems -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60291120','Volksbank Backnang','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60291510','Volksbank Winnenden -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60300000','Bundesbank eh Sindelfingen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60320030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60320291','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60340071','Commerzbank Sindelfingen','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60350130','Kreissparkasse Böblingen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60361923','Raiffeisenbank Weissach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60380002','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60390000','Vereinigte Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60390300','Volksbank Region Leonberg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60391310','Volksbank Herrenberg-Rottenburg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60391420','Volksbank Magstadt','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60400000','Bundesbank eh Ludwigsburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60410600','Wüstenrot Bank Pfandbriefbk ehe Wüstenrot Hypo','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60420000','Wüstenrot Bank Pfandbriefbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60420186','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60422000','RSB Retail+Service Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60430060','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60431061','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60440073','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60450050','Kreissparkasse Ludwigsburg','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60450193','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60460142','Volksbank Freiberg und Umgebung','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60462808','VR-Bank Asperg-Markgröningen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60470082','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60480008','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60490150','Volksbank Ludwigsburg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60491430','VR-Bank Stromberg-Neckar','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60651070','Kreissparkasse Calw -alt-','A9')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60661369','Raiffeisenbank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60661906','Raiffeisenbank Wimsheim-Mönsheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60663084','Raiffeisenbank im Kreis Calw','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60670024','Deutsche Bank Privat- und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60670070','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('60691440','Volksbank Maulbronn-Oberderdingen -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61020030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61030000','Bankhaus Gebr. Martin','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61040014','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61050000','Kreissparkasse Göppingen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61050181','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61060500','Volksbank Göppingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61070078','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61080006','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61091200','Volksbank-Raiffeisenbank Deggingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61100000','Bundesbank eh Esslingen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61120030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61120286','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61140071','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61150020','Kreissparkasse Esslingen-Nürtingen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61150185','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61161696','Volksbank Filder','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61170024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61170076','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61180004','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61190110','Volksbank Esslingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61191310','Volksbank Plochingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61220030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61240048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61261213','Raiffeisenbank Teck','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61261339','Volksbank Hohenneuffen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61262258','Genossenschaftsbank Wolfschlugen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61262345','Bernhauser Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61281007','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61290120','Volksbank Kirchheim-Nürtingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61340079','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61361722','Raiffeisenbank Rosenstein','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61361975','Raiffeisenbank Mutlangen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61370024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61370086','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61390140','Volksbank Schwäbisch Gmünd','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61391410','Volksbank Welzheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61400000','Bundesbank eh Aalen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61420086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61430000','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61440086','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61450050','Kreissparkasse Ostalb','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61450191','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61480001','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61490150','VR-Bank Aalen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('61491010','VR-Bank Ellwangen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62000000','Bundesbank eh Heilbronn','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62020000','Hoerner-Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62020100','FGA Bank Germany','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62030050','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62030058','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62030059','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62030060','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62040060','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62050000','Kreissparkasse Heilbronn','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62050181','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62061991','Volksbank Sulmtal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62062215','Volksbank Beilstein-Ilsfeld-Abstatt','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62062643','Volksbank Flein-Talheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62063263','VBU Volksbank im Unterland','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62070081','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62080012','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62090100','Volksbank Heilbronn','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62091400','Volksbank Brackenheim-Güglingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62091600','Volksbank Möckmühl-Neuenstadt','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62091800','Volksbank Hohenlohe','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62200000','Bundesbank eh Schwäbisch Hall','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62220000','Bausparkasse Schwäbisch Hall','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62230050','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62240048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62250030','Sparkasse Schwäbisch Hall-Crailsheim','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62250182','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62251550','Sparkasse Hohenlohekreis','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62280012','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62290110','VR Bank Schwäbisch Hall-Crailsheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62291020','Crailsheimer Volksbank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62361274','Creglinger Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62391010','Volksbank Bad Mergentheim -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('62391420','Volksbank Vorbach-Tauber','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63020130','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63020450','UniCredit Bank - HypoVereinsbank Ndl 274 Ulm','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63040053','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63050000','Sparkasse Ulm','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63050181','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63061486','VR-Bank Langenau-Ulmer Alb','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63070088','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63080015','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63090100','Volksbank Ulm-Biberach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63091010','Ehinger Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63091200','Volksbank Blaubeuren','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63091300','Volksbank Laichinger Alb','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63220090','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63240016','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63250030','Kreissparkasse Heidenheim','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63290110','Heidenheimer Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('63291210','Giengener Volksbank -alt-','19')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64020030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64020186','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64040033','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64040045','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64050000','Kreissparkasse Reutlingen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64050181','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64061854','VR Bank Steinlach-Wiesaz-Härten','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64070085','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64080014','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64090100','Volksbank Reutlingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64091200','Volksbank Metzingen-Bad Urach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64091300','Volksbank Münsingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64120030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64140036','Commerzbank Tübingen','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64150020','Kreissparkasse Tübingen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64150182','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64161397','Volksbank Ammerbuch','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64161608','Raiffeisenbank Härten -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64161956','Volksbank Mössingen -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64163225','Volksbank Hohenzollern','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64180014','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64190110','Volksbank Tübingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64191030','Volksbank Nagoldtal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64191210','Volksbank Altensteig -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64191700','Volksbank Horb -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64232000','Bankhaus J. Faißt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64240048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64240071','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64250040','Kreissparkasse Rottweil','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64251060','Kreissparkasse Freudenstadt','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64261363','Volksbank Baiersbronn Murgtal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64261626','Murgtalbank Mitteltal - Obertal -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64261853','Volksbank Nordschwarzwald','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64262408','Volksbank Dornstetten','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64290120','Volksbank Rottweil','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64291010','Volksbank Horb-Freudenstadt','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64291420','Volksbank Deißlingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64292020','Volksbank Schwarzwald-Neckar','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64292310','Volksbank Trossingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64350070','Kreissparkasse Tuttlingen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64361359','Raiffeisenbank Donau-Heuberg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64380011','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64390130','Volksbank Donau-Neckar','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64420030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('64450288','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65000000','Bundesbank eh Ravensburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65020030','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65020186','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65040073','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65050110','Kreissparkasse Ravensburg','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65050281','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65061219','Raiffeisenbank Aulendorf','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65062577','Raiffeisenbank Ravensburg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65062793','Raiffeisenbank Vorallgäu -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65063086','Raiffeisenbank Bad Saulgau','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65070084','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65080009','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65090100','Volksbank Ulm-Biberach -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65091040','Leutkircher Bank Raiffeisen- und Volksbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65091300','Bad Waldseer Bank -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65091600','Volksbank Weingarten','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65092010','Volksbank Allgäu-West','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65092200','Volksbank Altshausen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65093020','Volksbank Bad Saulgau','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65110200','Internationales Bankhaus Bodensee','71')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65120091','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65140072','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65161497','Genossenschaftsbank Meckenbeuren','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65162832','Raiffeisenbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65180005','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65190110','Volksbank Friedrichshafen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65191500','Volksbank Tettnang','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65300000','Bundesbank eh Albstadt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65310111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65340004','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65341204','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65350186','Baden-Württemb.Bank/Landesbank Baden-Württemb.','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65351050','Hohenz Landesbank Kreissparkasse Sigmaringen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65351260','Sparkasse Zollernalb','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65361469','Volksbank Heuberg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65361898','Winterlinger Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65361989','Onstmettinger Bank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65362499','Raiffeisenbank Geislingen-Rosenfeld','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65370024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65370075','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65380003','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65390120','Volksbank Ebingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65391210','Volksbank Balingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65392030','Volksbank Tailfingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65440087','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65450070','Kreissparkasse Biberach','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65461878','Raiffeisenbank Risstal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65462231','Raiffeisenbank Illertal','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65490130','Volksbank Ulm-Biberach','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65491320','Volksbank Laupheim','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('65491510','Volksbank-Raiffeisenbank Riedlingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66010075','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66010200','Deutsche Bausparkasse Badenia','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66010700','Landeskreditbank Baden-Württemberg Förderbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66020020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66020150','UniCredit Bank - HypoVereinsbank Ndl 145 Kruh','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66020286','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66030600','Isbank Fil Karlsruhe','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66040018','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66040026','Commerzbank/Kreditcenter Badenia','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66050000','Landesbank Baden-Württemberg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66050101','Sparkasse Karlsruhe Ettlingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66051220','Sparkasse Ettlingen -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66060000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66060300','Spar- und Kreditbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66060800','Evangelische Kreditgenossenschaft -Filiale Karlsruhe-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66061059','Volksbank Stutensee Hardt -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66061407','Spar- und Kreditbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66061724','Volksbank Stutensee-Weingarten','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66062138','Spar- und Kreditbank Hardt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66062366','Raiffeisenbank Hardt-Bruhrain','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66069103','Raiffeisenbank Elztal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66069104','Spar- und Kreditbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66069342','Volksbank Krautheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66069573','Raiffeisenbank Sexau -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66070004','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66080052','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66090621','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66090800','BBBank','B3')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66090900','PSD Bank Karlsruhe-Neustadt','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66091200','Volksbank Ettlingen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66190000','Volksbank Karlsruhe','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66200000','Bundesbank eh Baden-Baden','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66220020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66240002','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66250030','Sparkasse Baden-Baden Gaggenau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66251434','Sparkasse Bühl','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66261092','Spar- und Kreditbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66261416','Raiffeisenbank Altschweier','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66270001','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66280053','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66290000','Volksbank Baden-Baden Rastatt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66291300','Volksbank Achern','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66291400','Volksbank Bühl','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66340018','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66350036','Sparkasse Kraichgau Bruchsal-Bretten-Sinsheim','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66390000','Volksbank Bruchsal-Bretten -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66391200','Volksbank Bruchsal-Bretten','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66391600','Volksbank Bruhrain-Kraich-Hardt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66400000','Bundesbank eh Offenburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66420020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66432700','Bankhaus J. Faißt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66440084','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66450050','Sparkasse Offenburg/Ortenau','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66451346','Sparkasse Gengenbach','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66451548','Sparkasse Haslach-Zell','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66451862','Sparkasse Hanauerland','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66452776','Sparkasse Wolfach','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66470035','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66490000','Volksbank Offenburg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66491800','Volksbank Bühl Fil Kehl','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66492600','Volksbank Appenweier-Urloffen Appenweier -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66492700','Volksbank Kinzigtal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66550070','Sparkasse Rastatt-Gernsbach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66551290','Sparkasse Gaggenau-Kuppenheim -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66562053','Raiffeisenbank Südhardt Durmersheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66562300','VR-Bank in Mittelbaden','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66600000','Bundesbank eh Pforzheim','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66610111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66620020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66640035','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66650085','Sparkasse Pforzheim Calw','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66661244','Raiffeisenbank Bauschlott','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66661329','Raiffeisenbank Kieselbronn','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66661454','VR Bank im Enzkreis','42')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66662155','Raiffeisenbank Ersingen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66662220','Volksbank Stein Eisingen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66663439','Raiffeisen-Gebietsbank','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66670006','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66670024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66680013','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66690000','Volksbank Pforzheim','43')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66692300','Volksbank Wilferdingen-Keltern','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66762332','Raiffeisenbank Kraichgau','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('66762433','Raiffeisenbank Neudenau-Stein-Herbolzheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67000000','Bundesbank eh Mannheim','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67020020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67020190','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67020259','UniCredit Bank - HypoVereinsbank Ndl 681 Mnh','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67040031','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67040085','Commerzbank, Gf Web-K','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67050000','Landesbank Baden-Württemberg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67050505','Sparkasse Rhein Neckar Nord','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67051203','Sparkasse Hockenheim','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67060031','Volksbank Sandhofen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67070010','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67080050','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67089440','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67090000','VR Bank Rhein-Neckar','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67090617','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67091500','Volksbank Kurpfalz H+G Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67092300','Volksbank Weinheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67210111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67220020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67220286','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67220464','UniCredit Bank - HypoVereinsbank Ndl 488 Hd','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67230000','MLP Finanzdienstleistungen','92')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67230001','MLP Finanzdienstleistungen Zw CS','92')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67240039','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67250020','Sparkasse Heidelberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67262243','Raiffeisen Privatbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67262550','Volksbank Rot','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67270003','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67280051','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67290000','Heidelberger Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67290100','Volksbank Kurpfalz H+G Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67291500','Volksbank f d Angelbachtal -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67291700','Volksbank Neckartal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67291900','Volksbank Kraichgau -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67292200','Volksbank Kraichgau Wiesloch-Sinsheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67320020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67332551','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67352565','Sparkasse Tauberfranken','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67362560','Volksbank Tauber -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67390000','Volksbank Main-Tauber','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67450048','Sparkasse Neckartal-Odenwald','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67460041','Volksbank Mosbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67461424','Volksbank Franken','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67461733','Volksbank Kirnau','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67462368','Volksbank Limbach','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('67462480','Raiffeisenbank Schefflenz-Seckach -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68020020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68020186','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68020460','UniCredit Bank - HypoVereinsbank Ndl 405 Frb','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68030000','Bankhaus E. Mayer','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68040007','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68050000','Landesbank Baden-Württemberg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68050101','Sparkasse Freiburg-Nördlicher Breisgau','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68051004','Sparkasse Hochschwarzwald','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68051207','Sparkasse Bonndorf-Stühlingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68051310','Sparkasse Breisach -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68052230','Sparkasse St. Blasien','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68052328','Sparkasse Staufen-Breisach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68052863','Sparkasse Schönau-Todtnau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68061505','Volksbank Breisgau-Süd','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68062105','Raiffeisenbank Denzlingen-Sexau','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68062730','Raiffeisenbank Wyhl','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68063254','Spar- u Kreditbank Bad Krozingen-Heitersheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68063479','Raiffeisenbank Kaiserstuhl','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68064222','Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68070030','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68080030','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68080031','Commerzbank vormals Dresdner Bank Zw Münsterstraße','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68090000','Volksbank Freiburg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68090622','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68090900','PSD Bank RheinNeckarSaar','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68091900','Volksbank Müllheim','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68092000','Volksbank Breisgau Nord','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68092300','Volksbank Staufen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68270033','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68290000','Volksbank Lahr','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68300000','Bundesbank eh Lörrach','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68310111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68320020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68340058','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68350048','Sparkasse Lörrach-Rheinfelden','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68351557','Sparkasse Schopfheim-Zell','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68351865','Sparkasse Markgräflerland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68351976','Sparkasse Zell i W -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68361394','Raiffeisenbank Maulburg -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68370024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68370034','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68390000','Volksbank Dreiländereck','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68391500','VR Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68452290','Sparkasse Hochrhein','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68462427','Volksbank Klettgau-Wutöschingen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68490000','Volksbank Rhein-Wehra','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68491500','Volksbank Jestetten -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('68492200','Volksbank Hochrhein','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69000000','Bundesbank eh Konstanz','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69020020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69020190','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69040045','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69050001','Sparkasse Bodensee','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69051410','Bezirkssparkasse Reichenau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69051620','Sparkasse Pfullendorf-Meßkirch','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69051725','Sparkasse Salem-Heiligenberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69061800','Volksbank Überlingen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69070032','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69091200','Hagnauer Volksbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69091600','Volksbank Pfullendorf','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69220020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69220186','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69240075','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69250035','Sparkasse Singen-Radolfzell','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69251445','Sparkasse Engen-Gottmadingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69251755','Sparkasse Stockach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69270024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69270038','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69280035','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69290000','Volksbank Hegau -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69291000','Volksbank Konstanz','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69362032','Volksbank Meßkirch Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69400000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69421020','Baden-Württembergische Bank','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69440007','Commerzbank Villingen u Schwenningen','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69440060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69450065','Sparkasse Schwarzwald-Baar','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69451070','Sparkasse Donaueschingen -alt-','03')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69470024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69470039','Deutsche Bank Villingen u Schwenningen','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69490000','Volksbank Schwarzwald Baar Hegau','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('69491700','Volksbank Triberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70010080','Postbank (Giro)','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70010500','Deutsche Pfandbriefbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70010555','Deutsche Pfandbriefbank - Einlagengeschäfte','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70010570','Deutsche Pfandbriefbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011100','Deutsche Kontor Privatbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011110','Deutsche Kontor Privatbank Sofort Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011200','Bank Vontobel Europe','17')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011300','Autobank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011400','BfW - Bank für Wohnungswirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011500','SIEMENS BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011700','Bankhaus von der Heydt','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011900','InterCard','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011910','InterCard Cash Services 10','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70011920','InterCard Cash Services 20','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70012000','UniCredit Family Financing Bank, Ndl der UniCredit','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70012100','VEM Aktienbank','55')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70012200','Bank Sarasin','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70012300','V-Bank','17')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70012400','flatex alpha','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70012600','Südtiroler Sparkasse Niederlassung München','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70013000','European Bank for Financial Services','67')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70013010','European Bank for Financial Services','67')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70013100','net-m privatbank 1891','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70013155','net-m privatbank 1891 (Gf TRAXPAY)','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70013199','net-m privatbank 1891','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70013500','Bankhaus Herzogpark','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70015000','transact Elektronische Zahlungssysteme','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70015015','transact Elektronische Zahlungssysteme','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70015025','transact Elektronische Zahlungssysteme','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70015035','transact Elektronische Zahlungssysteme','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70017000','PayCenter','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70020001','UniCredit Bank - HypoVereinsbank Ndl 645 M','95')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70020270','UniCredit Bank - HypoVereinsbank','95')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70020300','Commerz Finanz','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70020800','INTESA SANPAOLO','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70021180','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70022200','Fidor Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70025175','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70030014','Fürst Fugger Privatbank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70030111','Bankhaus Max Flessa','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70030300','Bankhaus Reuschel & Co','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70030400','Merck Finck & Co','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70030800','Bethmann Bank','D9')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70031000','Bankhaus Ludwig Sperrer','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70032500','St. Galler Kantonalbank Deutschland','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70033100','Baader Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70035000','Oldenburgische Landesbank (vormals Allianz Bank)','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70040041','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70040048','Commerzbank GF-M48','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70040060','Commerzbank Gf 860','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70040061','Commerzbank Gf 861','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70040062','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70040063','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70040070','Commerzbank, CC SP','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70045050','Commerzbank Service-BZ','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70050000','Bayerische Landesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70051003','Sparkasse Freising','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70051540','Sparkasse Dachau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70051805','Kreissparkasse München Starnberg Ebersberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70051995','Kreis- und Stadtsparkasse Erding-Dorfen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70052060','Sparkasse Landsberg-Dießen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70053070','Sparkasse Fürstenfeldbruck','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70054306','Sparkasse Bad Tölz-Wolfratshausen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70070010','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70080056','Commerzbank vormals Dresdner Bank Zw 56','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70080057','Commerzbank vormals Dresdner Bank Gf ZW 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70080085','Commerzbank vormals Dresdner Bank Gf PCC DCC-ITGK 3','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 4','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70080087','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 5','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70080088','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 6','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70089470','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70089472','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70090100','Hausbank München','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70090124','Hausbank München','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70090500','Sparda-Bank München','81')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70090606','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70091500','Volksbank Raiffeisenbank Dachau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70091600','VR-Bank Landsberg-Ammersee','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70091900','VR-Bank Erding','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70093200','VR-Bank Starnberg-Herrsching-Landsberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70093400','Volksbank Raiffeisenbank Ismaning','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70110088','Postbank (Spar)','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70110500','Münchener Hypothekenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70110600','UBI BANCA INTERNATIONAL - Ndl München','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70120100','State Street Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70120400','DAB bank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70120500','CACEIS Bank Deutschland','D2')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70120600','Salzburg München Bank','30')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70120700','Oberbank Ndl Deutschland','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70120900','UniCredit Bank - HypoVereinsbank Ndl BACA','95')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70130700','Bankhaus August Lenz & Co','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70130799','Bankhaus August Lenz & Co Gf GAA','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70130800','Merkur Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70133300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70150000','Stadtsparkasse München','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70160000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70160300','Raiffeisenbank München -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70163370','Volksbank Raiffeisenbank Fürstenfeldbruck','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70166486','VR Bank München Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169132','Raiffeisenbank Griesstätt-Halfing','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169165','Raiffeisenbank Chiemgau-Nord - Obing','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169168','VR-Bank Chiemgau-Süd -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169186','Raiffeisenbank Pfaffenhofen a d Glonn','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169190','Raiffeisenbank Tattenh-Großkarolinenf','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169191','Raiffeisenbank Rupertiwinkel','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169195','Raiffeisenbank Trostberg-Traunreut','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169310','Raiffeisenbank Alxing-Bruck','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169331','Raiffeisenbank südöstl. Starnberger See','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169333','Raiffeisenbank Beuerberg-Eurasburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169351','Raiffeisenbank Nordkreis Landsberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169356','Raiffeisenbank Erding','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169382','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169383','Raiffeisenbank Gmund am Tegernsee','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169388','Raiffeisenbank Haag-Gars-Maitenbeth','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169402','Raiffeisenbank Höhenkirchen und Umgebung','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169410','Raiffeisenbank Holzkirchen-Otterfing','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169413','Raiffeisenbank Singoldtal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169433','Raiffeisenbank Königsdorf-Gelting','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169444','Raiffeisenbank im Isarwinkel -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169450','Raiffeisen-Volksbank Ebersberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169459','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169460','Raiffeisenbank Westkreis Fürstenfeldbruck','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169464','Genossenschaftsbank München','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169465','Raiffeisenbank München-Nord','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169466','Raiffeisenbank München-Süd','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169470','Raiffeisenbank München-Süd Gf GA','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169472','Raiffeisenbank Hallbergmoos-Neufahrn','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169474','Raiffbk Neumarkt-St. Veit - Niederbergkirchen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169476','Raiffeisenbank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169493','Raiffeisenbank Oberschleißheim -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169495','Raiffeisenbank Buchbach-Schwindegg -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169505','Raiffeisenbank Anzing-Forstern -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169509','Raiffeisenbank Pfaffenwinkel','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169521','Raiffeisenbank Raisting','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169524','Raiffeisenbank RSA','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169530','Raiffeisenbank Neumarkt-St. Veit - Reischach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169538','Raiffeisenbank St. Wolfgang-Schwindkirchen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169541','Raiffeisenbank Lech-Ammersee','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169543','Raiffeisenbank Isar-Loisachtal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169558','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169566','VR-Bank Taufkirchen-Dorfen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169568','Raiffeisenbank Taufkirchen-Oberneukirchen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169570','Raiffeisenbank Thalheim -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169571','Raiffeisenbank Tölzer Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169575','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169576','Raiffeisen-Volksbank Tüßling-Unterneukirchen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169585','Raiffeisenbank Unterschleißheim-Haimhn -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169596','Raiffeisenbank Walpertskirchen-Wörth-Hörlkofen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169598','Raiffeisenbank im Oberland','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169599','Raiffeisenbank Weil u Umgebung','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169602','Raiffeisenbank Weilheim -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169605','Raiffeisen-Volksbank Isen-Sempt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169614','Freisinger Bank Volksbank-Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169619','Raiffeisenbank Zorneding','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169653','Raiffeisenbank Aiglsbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70169693','Raiffeisenbank Hallertau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70190000','Münchner Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70220000','LfA Förderbank Bayern','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70220200','BHF-BANK','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70220300','BMW Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70220400','Hanseatic Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70220800','Vereinsbank Victoria Bauspar','07')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70220900','Wüstenrot Bausparkasse','61')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70230600','Isbank Fil München','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70250150','Kreissparkasse München Starnberg Ebersberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70300000','Bundesbank eh Garmisch-Partenkirchen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70320090','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70320305','UniCredit Bank - HypoVereinsbank Ndl 635 Gar','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70321194','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70322192','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70350000','Kreissparkasse Garmisch-Partenkirchen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70351030','Vereinigte Sparkassen im Landkreis Weilheim','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70362595','Raiffeisenbank Wallgau-Krün','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70380006','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70390000','VR-Bank Werdenfels','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('70391800','Volksbank-Raiffeisenbank Penzberg -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71000000','Bundesbank eh Bad Reichenhall','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71020072','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71021270','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71022182','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71023173','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71050000','Sparkasse Berchtesgadener Land','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71051010','Kreissparkasse Altötting-Burghausen -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71052050','Kreissparkasse Traunstein-Trostberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71061009','VR meine Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71062802','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71090000','Volksbank Raiffeisenbank Oberbayern Südost','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71100000','Bundesbank eh Rosenheim','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71120077','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71120078','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71121176','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71122183','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71140041','Commerzbank Rosenheim','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71141041','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71142041','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71150000','Sparkasse Rosenheim-Bad Aibling','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71151020','Sparkasse Altötting-Mühldorf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71151240','Kreissparkasse Bad Aibling -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71152570','Kreissparkasse Miesbach-Tegernsee','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71152680','Kreis- und Stadtsparkasse Wasserburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71160000','Volksbank Raiffeisenbank Rosenheim-Chiemsee','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71160161','VR Bank Rosenheim-Chiemsee','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71161964','Volksbank-Raiffeisenbank Chiemsee -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71162355','Raiffeisenbank Oberaudorf','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71162804','Raiffeisenbank Aschau-Samerberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71165150','Raiffeisenbank Mangfalltal -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71180005','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71190000','Volksbank Rosenheim -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('71191000','VR-Bank Burghausen-Mühldorf','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72012300','Bank für Tirol und Vorarlberg Deutschland','26')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72020070','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72020240','UniCredit Bank - HypoVereinsbank Ndl 677 Agsb','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72020700','Augsburger Aktienbank','23')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72021271','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72021876','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72030014','Fürst Fugger Privatbank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72030227','Bankhaus Anton Hafner','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72040046','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72050000','Stadtsparkasse Augsburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72050101','Kreissparkasse Augsburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72051210','Stadtsparkasse Aichach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72051840','Sparkasse Günzburg-Krumbach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72060300','Handels- und Gewerbebank Augsburg -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72062152','VR-Bank Handels- und Gewerbebank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069002','Raiffeisenbank Adelzhausen-Sielenbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069005','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069034','Raiffeisenbank Bissingen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069036','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069043','Raiffeisen-Volksbank Dillingen-Burgau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069081','Raiffeisenbank Gersthofen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069090','Raiffeisenbank Bibertal-Kötz','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069105','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069113','Raiffeisenbank Aschberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069114','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069119','Raiffeisenbank Ichenhausen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069123','Raiffeisenbank Jettingen-Scheppach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069126','Raiffeisenbank Bibertal-Kötz','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069132','Raiffeisenbank Krumbach/Schwaben','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069135','Raiffeisenbank Stauden','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069155','Raiffeisenbank Kissing-Mering','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069179','Raiffeisenbank Unteres Zusamtal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069181','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069193','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069209','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069220','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069235','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069263','Raiffeisenbank Wittislingen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069274','Raiffeisenbank Augsburger Land West','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069308','Raiffeisen-Volksbank Wemding','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069329','Raiffeisen-Volksbank Ries','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069736','Raiffeisenbank Iller-Roth-Günz','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72069789','Raiffeisenbank Pfaffenhausen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72070001','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72080001','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72090000','Augusta-Bank Raiffeisen-Volksbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72090500','Sparda-Bank Augsburg','84')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72090900','PSD Bank München','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72091800','Volksbank Günzburg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72100000','Bundesbank eh Ingolstadt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72120078','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72120079','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72120207','UniCredit Bank - HypoVereinsbank Ndl 648 Ing','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72122181','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72140052','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72150000','Sparkasse Ingolstadt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72151340','Sparkasse Eichstätt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72151650','Sparkasse Pfaffenhofen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72151880','Stadtsparkasse Schrobenhausen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72152070','Sparkasse Neuburg-Rain','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72160818','Volksbank Raiffeisenbank Bayern Mitte','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169013','Raiffeisenbank Aresing-Hörzhausen-Schiltberg -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169080','Raiffeisenbank Aresing-Gerolsbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169111','Raiffeisenbank Hohenwart -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169218','Schrobenhausener Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169246','Raiffeisenbank Schrobenhausener Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169380','Raiffeisenbank Beilngries','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169733','Raiffeisenbank Berg im Gau-Langenmosen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169745','Raiffeisenbank Ehekirchen-Oberhausen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169753','Raiffeisenbank Ober-Unterhausen-Sinning -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169756','Raiffeisen-Volksbank Neuburg/Donau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169764','Raiffeisenbank Donaumooser Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169812','Raiffeisenbank Gaimersheim-Buxheim','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72169831','Raiffeisenbank Riedenburg-Lobsing','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72170007','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72170024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72180002','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72191300','Volksbank Raiffeisenbank Eichstätt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72191600','Hallertauer Volksbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72191800','Volksbank Schrobenhausen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72220074','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72223182','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72250000','Sparkasse Nördlingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72250160','Sparkasse Donauwörth','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72251520','Kreis- und Stadtsparkasse Dillingen','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72261754','Raiffeisenbank Rain am Lech','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72262401','Raiffeisen-Volksbank Dillingen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72262901','Genossenschaftsbank Wertingen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('72290100','Raiffeisen-Volksbank Donauwörth','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73050000','Sparkasse Neu-Ulm-Illertissen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73061191','VR-Bank Neu-Ulm/Weißenhorn','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73090000','Volksbank Neu-Ulm','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73100000','Bundesbank eh Memmingen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73120075','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73140046','Commerzbank Memmingen','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73150000','Sparkasse Memmingen-Lindau-Mindelheim','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73160000','Genossenschaftsbank Unterallgäu','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73180011','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73190000','VR-Bank Memmingen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73191500','Volksbank Ulm-Biberach -alt-','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73300000','Bundesbank eh Kempten','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73311600','Vorarlberger Landes- und Hypothekenbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73320073','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73320442','UniCredit Bank - HypoVereinsbank Ndl 669 Kpt','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73321177','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73322380','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73331700','Gabler Saliter Bankgeschäft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73340046','Commerzbank Kempten Allgäu','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73350000','Sparkasse Allgäu','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73351635','Sparkasse Riezlern, Kleinwalsertal','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73351840','Dornbirner Sparkasse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73361592','Walser Privatbank','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73362421','Bankhaus Jungholz Zndl der Raiffeisenbank Reutte','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73362500','Raiffeisen-Landesbank Tirol','A1')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369264','Raiffeisenbank im Allgäuer Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369821','Raiffeisen-Bodenseebank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369823','Raiffeisenbank Westallgäu','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369826','Volksbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369851','Raiffeisenbank Aitrang-Ruderatshofen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369854','Raiffeisenbank Fuchstal-Denklingen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369859','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369871','Raiffeisenbank Baisweil-Eggenthal-Friesenried','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369878','Raiffeisenbank Füssen-Pfronten-Nesselwang -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369881','Raiffeisenbank Haldenwang','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369888','Raiffeisenbank Irsee-Pforzen-Rieden -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369902','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369915','Raiffeisenbank Obergermaringen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369918','Raiffeisenbank Kirchweihtal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369920','Raiffeisenbank Oberallgäu-Süd','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369933','Raiffeisenbank Südliches Ostallgäu','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369936','Raiffeisenbank Seeg -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73369954','Raiffeisenbank Wald-Görisried','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73370008','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73370024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73380004','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73390000','Allgäuer Volksbank Kempten-Sonthofen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73391600','Volksbank im Kleinwalsertal','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73392000','Volksbank Immenstadt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73392400','Volksbank Tirol Jungholz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73420071','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73420546','UniCredit Bank - HypoVereinsbank Ndl 693 Kaufb','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73421478','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73440048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73450000','Kreis- und Stadtsparkasse Kaufbeuren','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73451450','Kreissparkasse Schongau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73460046','VR Bank Kaufbeuren-Ostallgäu','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73480013','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('73491300','Volksbank Ostallgäu -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74000000','Bundesbank eh Passau','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74020074','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74020100','Raiffeisenlandesbank OÖ Zndl Süddeutschland','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74020150','Raiffeisenlandesbank OÖ Zndl Südde - für interne Zwecke','60')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74020414','UniCredit Bank - HypoVereinsbank Ndl 672 Pass','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74040082','Commerzbank Passau','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74050000','Sparkasse Passau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74051230','Sparkasse Freyung-Grafenau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74061101','Raiffeisenbank Am Goldenen Steig','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74061564','Raiffeisenbank Unteres Inntal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74061670','Raiffeisenbank Ortenburg-Kirchberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74061813','VR-Bank Rottal-Inn','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74062490','Raiffeisenbank Vilshofener Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74062786','Raiffeisenbank i Lkr Passau-Nord','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74064593','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74065782','Raiffeisenbank Salzweg-Thyrnau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74066749','Raiffeisenbank im Südl Bayerischen Wald','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74067000','Rottaler Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74069744','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74069752','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74069758','Raiffeisenbank Kirchberg v. Wald','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74069763','Raiffeisenbank Mauth','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74069768','Raiffeisenbank am Dreisessel','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74090000','VR-Bank Passau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74092400','Volksbank Vilshofen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74100000','Bundesbank eh Deggendorf','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74120071','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74120514','UniCredit Bank - HypoVereinsbank 674 Dgdf','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74131000','TEBA Kreditbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74140048','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74150000','Sparkasse Deggendorf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74151450','Sparkasse Regen-Viechtach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74160025','Raiffeisenbank Deggendorf-Plattling','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74161608','Raiffeisenbank Hengersberg-Schöllnach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74164149','VR-Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74165013','Raiffeisenbank Sonnenwald','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74180009','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74190000','GenoBank DonauWald','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74191000','VR-Bank Landau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74220075','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74221170','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74240062','Commerzbank Straubing','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74250000','Sparkasse Niederbayern-Mitte','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74251020','Sparkasse im Landkreis Cham','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74260110','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74261024','Raiffeisenbank Chamer Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74290000','Volksbank Straubing','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74290100','CB Bank','98')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74300000','Bundesbank eh Landshut','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74320073','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74320307','UniCredit Bank - HypoVereinsbank Ndl 601 Ldsht','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74340077','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74350000','Sparkasse Landshut','11')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74351310','Sparkasse Dingolfing-Landau -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74351430','Sparkasse Rottal-Inn','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74351740','Stadt- und Kreissparkasse Moosburg','10')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74361211','Raiffeisenbank Arnstorf','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74362663','Raiffeisenbank Altdorf-Ergolding','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74364689','Raiffeisenbank Pfeffenhausen-Rottenburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74366666','Raiffeisenbank Geisenhausen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369068','Raiffeisenbank Hofkirchen-Bayerbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369088','Raiffeisenbank Geiselhöring-Pfaffenberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369130','Raiffeisenbank Parkstetten','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369146','Raiffeisenbank Rattiszell-Konzell','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369656','Raiffeisenbank Essenbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369662','Raiffeisenbank Buch-Eching','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369704','Raiffeisenbank Mengkofen-Loiching','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74369709','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74380007','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74390000','VR-Bank Landshut','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74391300','Volksbank-Raiffeisenbank Dingolfing','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74391400','Rottaler Volksbank-Raiffeisenbank Eggenfelden','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('74392300','VR-Bank Vilsbiburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75020073','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75020314','UniCredit Bank - HypoVereinsbank Ndl 670 Rgsb','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75021174','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75040062','Commerzbank Regensburg','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75050000','Sparkasse Regensburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75051040','Sparkasse im Landkreis Schwandorf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75051565','Kreissparkasse Kelheim','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75060150','Raiffeisenbank Regensburg-Wenzenbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75061168','Raiffeisenbank Schwandorf-Nittenau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75061851','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75062026','Raiffeisenbank Oberpfalz Süd','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069014','Raiffeisenbank Bad Abbach-Saal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069015','Raiffeisenbank Bad Gögging','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069020','Raiffeisenbank Bruck','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069038','Raiffeisenbank Falkenstein-Wörth','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069043','Raiffeisen-Bank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069050','Raiffeisenbank Grafenwöhr-Kirchenthumbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069055','Raiffeisenbank Alteglofsheim-Hagelstadt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069061','Raiffeisenbank Hemau-Kallmünz','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069062','Raiffeisenbank Herrnwahlthann-Teugn-Dünzling -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069076','Raiffeisenbank Kallmünz -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069078','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069081','Raiffeisenbank Bad Kötzting','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069094','Raiffeisenbank Parsberg-Velburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069110','Raiffeisenbank Eschlkam-Lam-Lohberg-Neukirchen b Hl Blut','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75069171','Raiffeisenbank im Naabtal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75070013','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75080003','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75090000','Volksbank Regensburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75090300','LIGA Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75090500','Sparda-Bank Ostbayern','84')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75090629','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75090900','PSD Bank Niederbayern-Oberpfalz','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75091400','VR Bank Burglengenfeld','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75220070','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75240000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75250000','Sparkasse Amberg-Sulzbach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75261700','Raiffeisenbank Sulzbach-Rosenberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75290000','Volksbank-Raiffeisenbank Amberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75300000','Bundesbank eh Weiden Oberpf','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75320075','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75340090','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75350000','Sparkasse Oberpfalz Nord','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75351960','Vereinigte Sparkassen Eschenbach i d Opf','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75360011','Raiffeisenbank Weiden','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75362039','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75363189','Raiffeisenbank Neustadt-Vohenstrauß','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('75390000','Volksbank Nordoberpfalz','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76010085','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76020070','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76020099','UniCredit Bank - HypoVereinsbank Prepaid Card','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76020214','UniCredit Bank - HypoVereinsbank Ndl 156 Nbg','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76020600','Hanseatic Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76026000','norisbank','C7')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76030080','Cortal Consors Zndl Deutschland','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76030600','Isbank Fil Nürnberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76030800','BIW Bank für Investments und Wertpapiere','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76032000','TeamBank Nürnberg','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76032001','TeamBank Nürnberg GF Austria','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76035000','UmweltBank','55')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76040061','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76040062','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76050000','Bayerische Landesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76050101','Sparkasse Nürnberg','49')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76052080','Sparkasse Neumarkt i d OPf-Parsberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76060000','DZ BANK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76060561','Evangelische Kreditgenossenschaft - Filiale Nürnberg -','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76060618','Volksbank Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76061025','Raiffeisen Spar+Kreditbank Lauf a d Pegnitz','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76061482','Raiffeisenbank Hersbruck','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069369','Raiffeisenbank Auerbach-Freihung','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069372','Raiffeisenbank Bad Windsheim','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069378','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069404','Raiffeisenbank Uehlfeld-Dachsbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069409','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069410','Raiffeisenbank Dietersheim und Umgebung','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069440','Raiffeisenbank Altdorf-Feucht','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069441','VR-Bank Feuchtwangen-Limes','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069448','Raiffeisenbank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069449','Raiffeisenbank Berching-Freystadt-Mühlhausen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069462','Raiffeisenbank Greding - Thalmässing','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069468','Raiffeisenbank Weißenburg-Gunzenhausen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069483','Raiffeisenbank Herzogenaurach -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069486','Raiffeisenbank Hirschau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069512','Raiffeisenbank Knoblauchsland Nürnberg-Buch','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069549','Raiffeisenbank Münchaurach -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069552','Raiffeisenbank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069553','Raiffeisenbank Neumarkt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069559','VR-Bank Uffenheim-Neustadt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069564','Raiffeisenbank Oberferrieden-Burgthann','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069576','Raiffeisenbank Plankstetten','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069598','Raiffeisenbank Großhabersdorf-Roßtal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069601','VR-Bank Rothenburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069602','Raiffeisenbank Seebachgrund','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069611','Raiffeisenbank Unteres Vilstal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069635','Raiffeisenbank Ursensollen-Ammerthal-Hohenburg -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069663','Raiffeisenbank Heilsbronn-Windsbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76069669','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76070012','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76080040','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76080053','Commerzbank vormals Dresdner Bank Zw 53','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76080055','Commerzbank vormals Dresdner Bank Zw 55','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76089480','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76089482','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76090300','Bäcker-Bank Nürnberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76090400','Evenord-Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76090500','Sparda-Bank Nürnberg','81')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76090613','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76090900','PSD Bank','91')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76091000','Sparda-Bank Nürnberg Zw Sonnenstraße','81')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76211900','CVW - Privatbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76220073','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76230000','BSQ Bauspar','11')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76240011','Commerzbank Fürth Bayern','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76250000','Sparkasse Fürth','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76251020','Sparkasse i Landkreis Neustadt a d Aisch','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76260451','Raiffeisen-Volksbank Fürth','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76300000','Bundesbank eh Erlangen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76320072','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76330111','Bankhaus Max Flessa','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76340061','Commerzbank Erlangen','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76350000','Stadt- und Kreissparkasse Erlangen','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76351040','Sparkasse Forchheim','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76351560','Kreissparkasse Höchstadt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76360033','VR-Bank Erlangen-Höchstadt-Herzogenaurach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76391000','Volksbank Forchheim','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76420080','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76450000','Sparkasse Mittelfranken-Süd','A5')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76460015','Raiffeisenbank Roth-Schwabach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76461485','Raiffeisenbank am Rothsee','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76500000','Bundesbank eh Ansbach','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76520071','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76550000','Vereinigte Sparkassen Ansbach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76551020','Kreis- und Stadtsparkasse Dinkelsbühl','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76551540','Vereinigte Sparkassen Gunzenhausen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76551860','Stadt- und Kreissparkasse Rothenburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76560060','RaiffeisenVolksbank Gewerbebank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76561979','Raiffeisenbank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('76591000','VR Bank Dinkelsbühl','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77000000','Bundesbank eh Bamberg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77020070','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77030111','Bankhaus Max Flessa','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77040080','Commerzbank Bamberg','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77050000','Sparkasse Bamberg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77060100','VR Bank Bamberg Raiffeisen-Volksbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77061004','Raiffeisenbank Obermain Nord','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77061425','Raiffeisen-Volksbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77062014','Raiffeisenbank Burgebrach-Stegaurach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77062139','Raiffeisen-Volksbank Bad Staffelstein','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77065141','Raiffeisenbank Stegaurach -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069042','Raiffeisenbank Gößweinstein -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069044','Raiffeisenbank Küps-Mitwitz-Stockheim','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069051','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069052','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069091','Raiffeisenbank Ebrachgrund','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069110','Raiffeisenbank Pretzfeld -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069461','Vereinigte Raiffeisenbanken','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069556','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069739','Raiffeisenbank Thurnauer Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069746','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069764','Raiffeisenbank Kemnather Land - Steinwald','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069782','Raiffeisenbank am Kulm','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069836','Raiffeisenbank Berg-Bad Steben','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069868','Raiffeisenbank Oberland','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069870','Raiffeisenbank Hochfranken West','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069879','Raiffeisenbank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069906','Raiffeisenbank Wüstenselbitz','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77069908','Raiffeisenbank Sparneck-Stammbach-Zell -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77091800','Raiffeisen-Volksbank Lichtenfels-Itzgrund','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77120073','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77140061','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77150000','Sparkasse Kulmbach-Kronach','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77190000','Kulmbacher Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77300000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77320072','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77322200','Fondsdepot Bank','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77340076','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77350110','Sparkasse Bayreuth','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77361600','Raiffeisen-Volksbank Kronach-Ludwigsstadt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77363749','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77365792','Raiffeisenbank Hollfeld-Waischenfeld-Aufseß','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77390000','Volksbank-Raiffeisenbank Bayreuth','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77390500','Sparda-Bank Nürnberg','81')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('77390628','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78000000','Bundesbank eh Hof','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78020070','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78020429','UniCredit Bank - HypoVereinsbank Ndl 128 Hof','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78030080','Archon Capital Bank Deutschland','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78030081','Archon Capital Bank Deutschland Servicing','01')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78040081','Commerzbank Hof Saale','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78050000','Sparkasse Hochfranken','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78055050','Sparkasse Hochfranken -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78060896','VR Bank Hof','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78062488','Raiffeisenbank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78140000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78160069','VR-Bank Fichtelgebirge','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78161575','Raiffeisenbank im Stiftland','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78320076','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78330111','Bankhaus Max Flessa','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78340091','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78350000','Sparkasse Coburg-Lichtenfels','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('78360000','VR-Bank Coburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79020076','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79020325','UniCredit Bank - HypoVereinsbank Ndl 149 Wzb','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79020700','Hanseatic Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79030001','Fürstlich Castellsche Bank Credit-Casse','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79032038','Bank Schilling & Co','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79040047','Commerzbank Würzburg','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79050000','Sparkasse Mainfranken Würzburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79061000','Raiffeisenbank-alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79061153','Raiffeisenbank Lohr, Main -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79062106','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79063060','Raiffeisenbank Estenfeld-Bergtheim','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79063122','Raiffeisenbank Höchberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79065028','VR-Bank Bad Kissingen-Bad Brückenau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79065160','Raiffeisenbank Marktheidenfeld -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79066082','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069001','Raiffeisenbank Volkach-Wiesentheid','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069010','VR-Bank Schweinfurt','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069031','Raiffeisenbank Bütthard-Gaukönigshofen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069090','Raiffeisenbank Ulsenheim-Gollhofen -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069145','Raiffeisenbank Kreuzwertheim-Hasloch -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069150','Raiffeisenbank Main-Spessart','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069165','Genobank Rhön-Grabfeld','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069181','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069188','Raiffeisenbank im Grabfeld','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069192','Raiffeisenbank Obernbreit und Umgebung','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069213','Raiffeisenbank Maßbach','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79069271','Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79070016','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79080052','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79090000','Volksbank Raiffeisenbank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79090624','apoBank','A4')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79161058','Raiffeisenbank Fränkisches Weinland','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79161499','Raiffeisenbank Kitzinger Land','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79190000','VR Bank Kitzingen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79300000','Bundesbank eh Schweinfurt','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79320075','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79320432','UniCredit Bank - HypoVereinsbank Ndl 137 Schft','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79330111','Bankhaus Max Flessa','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79340054','Commerzbank Schweinfurt','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79350000','Städtische Sparkasse Schweinfurt -alt-','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79350101','Sparkasse Schweinfurt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79351010','Sparkasse Bad Kissingen','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79351730','Sparkasse Ostunterfranken','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79353090','Sparkasse Bad Neustadt a d Saale','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79362081','VR-Bank Gerolzhofen','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79363016','VR-Bank Rhön-Grabfeld','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79363151','Raiffeisen-Volksbank Haßberge','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79364069','Raiffeisenbank Frankenwinheim und Umgebung','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79364406','VR-Bank Schweinfurt Land -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79380051','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79500000','Bundesbank eh Aschaffenburg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79510111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79520070','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79520533','UniCredit Bank - HypoVereinsbank Ndl 125 Aschb','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79540049','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79550000','Sparkasse Aschaffenburg Alzenau','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79561348','Raiffeisenbank Bachgau -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79562514','Raiffeisenbank Aschaffenburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79565568','Raiffeisenbank Waldaschaff-Heigenbrücken','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79566545','Raiffeisenbank Heimbuchenthal -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79567531','VR-Bank','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79568518','Raiffeisenbank Haibach-Obernau','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79570024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79570051','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79580099','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79589402','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79590000','Volksbank Aschaffenburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79650000','Sparkasse Miltenberg-Obernburg','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79662558','Raiffeisenbank -alt-','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79665540','Raiffeisenbank Elsavatal','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79666548','Raiffeisenbank Großostheim-Obernburg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79668509','Raiffeisenbank Eichenbühl und Umgebung','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('79690000','Raiffeisen-Volksbank Miltenberg','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80000000','Bundesbank eh Halle','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80020087','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80020130','ZV Landesbank Baden-Württemberg','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80050500','Kreissparkasse Merseburg-Querfurt -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80053000','Sparkasse Burgenlandkreis','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80053552','Kreissparkasse Sangerhausen -alt-','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80053572','Stadtsparkasse Dessau','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80053622','Kreissparkasse Köthen -alt-','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80053722','Kreissparkasse Anhalt-Bitterfeld','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80053762','Saalesparkasse','B6')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80054000','Kreissparkasse Weißenfels -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80055008','Sparkasse Mansfeld-Südharz','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80055500','Salzlandsparkasse','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80062608','Volksbank Elsterland','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80063508','Ostharzer Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80063558','Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80063598','Volksbank Wittenberg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80063628','Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80063648','Volks- und Raiffeisenbank Saale-Unstrut','28')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80063678','VR-Bank Zeitz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80063718','Volks- und Raiffeisenbank Eisleben','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80093574','Volksbank Dessau-Anhalt','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80093784','Volksbank Halle, Saale','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80500000','Bundesbank eh Dessau','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80550101','Sparkasse Wittenberg','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('80550200','Kreissparkasse Anhalt-Zerbst -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81050000','Kreissparkasse Aschersleben-Staßfurt -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81050555','Kreissparkasse Stendal','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81051000','Bördesparkasse Oschersleben -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81052000','Harzsparkasse','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81053272','Stadtsparkasse Magdeburg','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81054000','Sparkasse Jerichower Land','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81055000','Kreissparkasse Börde','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81055555','Sparkasse Altmark West','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81063028','Raiffeisenbank Kalbe-Bismark','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81063238','Volksbank Jerichower Land','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81068106','Bank für Kirche und Diakonie - KD-Bank Gf Sonder-BLZ','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81069048','Volksbank Jerichower Land','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81069052','Volksbank Börde-Bernburg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81070000','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81093034','Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81093044','Volksbank Osterburg-Lüchow-Dannenberg -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81093054','Volksbank Stendal','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('81093274','Volksbank Magdeburg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82020087','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82020088','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82040085','Commerzbank, Gf Web-K','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82050000','Landesbank Hessen-Thür Girozentrale Erfurt','00')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82051000','Sparkasse Mittelthüringen','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82052020','Kreissparkasse Gotha','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82054052','Kreissparkasse Nordhausen','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82055000','Kyffhäusersparkasse','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82056060','Sparkasse Unstrut-Hainich','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82057070','Kreissparkasse Eichsfeld','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82060197','Pax-Bank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82060800','Evangelische Kreditgenossenschaft -Filiale Eisenach-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82064038','VR Bank Westthüringen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82064088','Volksbank und Raiffeisenbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82064168','Raiffeisenbank Gotha','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82064188','VR Bank Weimar','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82064228','Erfurter Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82070000','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82094004','Volksbank Heiligenstadt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('82094054','Nordthüringer Volksbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83000000','Bundesbank eh Gera','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83020087','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83020088','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83050000','Sparkasse Gera-Greiz','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83050200','Sparkasse Altenburger Land','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83050303','Kreissparkasse Saalfeld-Rudolstadt','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83050505','Kreissparkasse Saale-Orla','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83053030','Sparkasse Jena-Saale-Holzland','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83064488','Raiffeisen-Volksbank Hermsdorfer Kreuz','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83064568','Geraer Bank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83065408','VR-Bank Altenburger Land / Deutsche Skatbank','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83065410','Deutsche Skatbank Zndl VR Bank Altenburger Land','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83094444','Raiffeisen-Volksbank Saale-Orla','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83094454','Volksbank Saaletal','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83094494','Volksbank Eisenberg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('83094495','EthikBank, Zndl der Volksbank Eisenberg','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84000000','Bundesbank eh Meiningen','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84020087','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84030111','Bankhaus Max Flessa','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84050000','Rhön-Rennsteig-Sparkasse','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84051010','Sparkasse Arnstadt-Ilmenau','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84054040','Kreissparkasse Hildburghausen','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84054722','Sparkasse Sonneberg','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84055050','Wartburg-Sparkasse','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84064798','Genobank Rhön-Grabfeld','88')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84069065','Raiffeisenbank Schleusingen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84094754','VR-Bank Bad Salzungen Schmalkalden','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('84094814','VR Bank Südthüringen','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85010500','Sächsische Aufbaubank -Förderbank-','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85020030','ZV Landesbank Baden-Württemberg','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85020890','UniCredit Bank - HypoVereinsbank Ndl 536 Dre','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85050100','Sparkasse Oberlausitz-Niederschlesien','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85050200','Kreissparkasse Riesa-Großenhain -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85050300','Ostsächsische Sparkasse Dresden','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85050350','Ostsächsische Sparkasse Dresden Gf OSD.Net','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85055000','Sparkasse Meißen','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85060000','Volksbank Pirna','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85065028','Raiffeisenbank Neustadt, Sachs -alt-','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85080200','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85089270','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85090000','Dresdner Volksbank Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85094984','Volksbank Riesa','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85095004','Volksbank Raiffeisenbank Meißen Großenhain','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85095164','Landeskirchliche Kredit-Genossenschaft Sachsen -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85550000','Kreissparkasse Bautzen','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85590000','Volksbank Bautzen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85590100','Volksbank Löbau-Zittau','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85591000','Volksbank Raiffeisenbank Niederschlesien','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('85595500','Volksbank Westlausitz -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86010090','Postbank','24')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86010111','SEB','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86010424','Aareal Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86020030','ZV Landesbank Baden-Württemberg','65')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86020500','Bank für Sozialwirtschaft','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86020600','Hanseatic Bank','16')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86020880','UniCredit Bank - HypoVereinsbank Ndl 508 Lei','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86033300','Santander Consumer Bank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86040060','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86040061','Commerzbank CC','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86050000','ZV Landesbank Baden-Württemberg','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86050200','Sparkasse Muldental','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86050600','Kreissparkasse Torgau-Oschatz -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86055002','Sparkasse Delitzsch-Eilenburg -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86055462','Kreissparkasse Döbeln','C0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86055592','Stadt- und Kreissparkasse Leipzig','D0')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86065448','VR Bank Leipziger Land','32')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86065468','VR-Bank Mittelsachsen','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86065483','Raiffeisenbank Grimma','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86065548','Wurzener Bank (Raiffeisen-Volksbank) -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86069070','Raiffeisenbank','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86070000','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86080055','Commerzbank vormals Dresdner Bank Zw 55','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86080057','Commerzbank vormals Dresdner Bank Gf ZW 57','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86080085','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 1','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86080086','Commerzbank vormals Dresdner Bank, PCC DCC-ITGK 2','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86089280','Commerzbank vormals Dresdner Bank ITGK','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86095484','Volks- und Raiffeisenbank Muldental','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86095554','Volksbank Delitzsch','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('86095604','Volksbank Leipzig','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87000000','Bundesbank','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87020086','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87020087','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87020088','UniCredit Bank - HypoVereinsbank','99')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87040000','Commerzbank','13')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87050000','Sparkasse Chemnitz','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87051000','Sparkasse Mittelsachsen','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87052000','Sparkasse Mittelsachsen','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87053000','Sparkasse Mittleres Erzgebirge -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87054000','Erzgebirgssparkasse','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87055000','Sparkasse Zwickau','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87056000','Kreissparkasse Aue-Schwarzenberg -alt-','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87058000','Sparkasse Vogtland','20')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87065893','Volksbank Erzgebirge -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87065918','Raiffeisenbank Werdau-Zwickau -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87069075','Volksbank Mittleres Erzgebirge','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87069077','Vereinigte Raiffeisenbank Burgstädt','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87070000','Deutsche Bank','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87070024','Deutsche Bank Privat und Geschäftskunden','63')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87080000','Commerzbank vormals Dresdner Bank','76')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87095824','Volksbank Vogtland','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87095899','Volksbank Vogtland GAA','09')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87095934','Volksbank Zwickau','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87095974','Volksbank-Raiffeisenbank Glauchau','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87096034','Volksbank Erzgebirge -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87096074','Freiberger Bank -alt-','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87096124','Volksbank Mittweida','06')");
    xtc_db_query("INSERT INTO banktransfer_blz VALUES ('87096214','Volksbank Chemnitz','06')");
   
	
	
	}

    function remove() {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
        return array('MODULE_PAYMENT_SEPA_STATUS', 'MODULE_PAYMENT_SEPA_ALLOWED', 'MODULE_PAYMENT_SEPA_ZONE', 'MODULE_PAYMENT_SEPA_ORDER_STATUS_ID', 'MODULE_PAYMENT_SEPA_SORT_ORDER', 'MODULE_PAYMENT_SEPA_DATACHECK', 'MODULE_PAYMENT_SEPA_DATABASE_BLZ', 'MODULE_PAYMENT_SEPA_FAX_CONFIRMATION', 'MODULE_PAYMENT_SEPA_MIN_ORDER', 'MODULE_PAYMENT_SEPA_URL_NOTE');
    }

}
