<?php

/* -----------------------------------------------------------------
 * 	$Id: stock_mails.php 420 2013-06-19 18:04:39Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

function pdfinvoice() {

    if (MODULE_CUSTOMERS_PDF_INVOICE_STATUS == 'true') {
        $smarty = new Smarty();
        define(PDF_LIEFERSCHEIN, false);
        define('FPDF_FONTPATH', 'admin/pdf/font/');

        include_once(DIR_WS_CLASSES . 'class.order.php');

        require_once(DIR_FS_INC . 'cseo_get_pdf.inc.php');
        require_once(DIR_FS_INC . 'cseo_get_pdf_nr.inc.php');
        require_once(DIR_FS_INC . 'xtc_get_order_data.inc.php');
        require_once(DIR_FS_INC . 'xtc_get_attributes_model.inc.php');
        require_once(DIR_FS_INC . 'xtc_not_null.inc.php');
        require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
        require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
        $logo_query = xtc_db_fetch_array(xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'CURRENT_TEMPLATE';"));
        $pdf_invoice_query = xtc_db_query("SELECT order_id, orders_id FROM " . TABLE_ORDERS . " AS o LEFT JOIN " . TABLE_ORDERS_PDF . " AS op ON (o.orders_id = op.order_id) WHERE op.order_id IS NULL OR op.order_id <> o.orders_id;");
        $lang = STORE_COUNTRY;
        if ($lang == 81 || $lang == 14 || $lang == 204) {
            $languages_query = xtc_db_fetch_array(xtc_db_query("SELECT languages_id, code FROM languages WHERE status = '1' AND code = 'de';"));
            $lang_id = $languages_query['languages_id'];
        } else {
            $languages_query = xtc_db_query("SELECT languages_id, code FROM languages WHERE status = '1' AND code = 'en';");
            if (xtc_db_num_rows($languages_query) > 0) {
                $languages_query = xtc_db_fetch_array($languages_query);
                $lang_id = $languages_query['languages_id'];
            } else {
                $languages_query = xtc_db_fetch_array(xtc_db_query("SELECT languages_id, code FROM languages WHERE status = '1' AND code = 'de';"));
                $lang_id = $languages_query['languages_id'];
            }
        }

        $pdf_query = xtc_db_query("SELECT pdf_key, pdf_value FROM orders_pdf_profile WHERE languages_id = '" . $lang_id . "';");
        while ($pdf = xtc_db_fetch_array($pdf_query)) {
            define($pdf['pdf_key'], utf8_decode($pdf['pdf_value']));
        }

        $pdf_query = xtc_db_query("SELECT pdf_key, pdf_value FROM orders_pdf_profile WHERE languages_id = '0';");
        while ($pdf = xtc_db_fetch_array($pdf_query)) {
            define($pdf['pdf_key'], $pdf['pdf_value']);
        }

        $logo = DIR_FS_CATALOG . 'templates/' . $logo_query['configuration_value'] . '/img/' . LAYOUT_LOGO_FILE;

        while ($pdf_invoice = xtc_db_fetch_array($pdf_invoice_query)) {

            if (PDF_RECHNUNG_OID == 'true') {
                $pdf_invoice_nr = $pdf_invoice['orders_id'];
            } else {
                $pdf_nr = cseo_get_pdf_nr($pdf_invoice['orders_id'], false, true);
                $pdf_invoice_nr = $pdf_nr;
            }

            $pdf_save_query = xtc_db_fetch_array(xtc_db_query("SELECT pdf_key, pdf_value FROM orders_pdf_profile WHERE languages_id = '" . $lang_id . "' AND pdf_key = 'TEXT_PDF_FILE_NAME';"));

            $order = new order($pdf_invoice['orders_id']);

            $type = 'rechnung';

            $sprach_id = $lang_id;
            $sprache = $order->info['language'];

            require_once('admin/pdf/pdf_bill.php');
            $pdf = new PDF_Bill();

            $pdf->Init(($type == 'rechnung' ? FILENAME_BILL : FILENAME_PACKINSLIP));

// Kunden ID abfragen
            $order_check = xtc_db_fetch_array(xtc_db_query("SELECT customers_id FROM " . TABLE_ORDERS . " WHERE orders_id='" . $pdf_invoice['orders_id'] . "';"));
            $customers_id = $order_check['customers_id'];
            $customer_gender = xtc_db_fetch_array(xtc_db_query("SELECT customers_gender FROM " . TABLE_CUSTOMERS . " WHERE customers_id='" . $pdf_invoice['orders_id'] . "'"));
            $kundenadresse = xtc_address_format($order->customer['format_id'], $order->billing, 1, '', '<br>');

            $pdf->Adresse(utf8_decode(str_replace("<br>", "\n", $kundenadresse)), TEXT_PDF_SHOPADRESSEKLEIN);

            if (file_exists($logo)) {
                $pdf->Logo($logo);
            }

            if (PDF_RECHNUNG_DATE_ACT == 'true') {
                $date_purchased = time();
                $date_purchased = date("d.m.Y", $date_purchased);
            } else {
                $date_purchased = xtc_date_short($order->info['date_purchased']);
            }

            if ($order->info['payment_method'] != '' && $order->info['payment_method'] != 'no_payment') {
                include(DIR_FS_CATALOG . 'lang/' . $sprache . '/modules/payment/' . $order->info['payment_method'] . '.php');
                $payment_method = constant(strtoupper('MODULE_PAYMENT_' . $order->info['payment_method'] . '_TEXT_TITLE'));
                $payment_method = strip_tags($payment_method);
                $payment_method = html_entity_decode($payment_method);
                $payment_method = utf8_decode($payment_method);
            } else {
                $payment_method = '';
            }

            $pdf->Rechnungsdaten($order->customer['csID'], $pdf_invoice['orders_id'], $order->customer['vat_id'], $pdf_invoice_nr, $date_purchased, $payment_method, PDF_LIEFERSCHEIN);
            $pdf->RechnungStart($pdf_invoice_nr, $pdf_invoice['orders_id'], utf8_decode($order->customer['lastname']), $customer_gender['customers_gender'], PDF_LIEFERSCHEIN);
            $pdf->ListeKopf(PDF_LIEFERSCHEIN);

// Produktinfos
            $order_query = xtc_db_query("SELECT *  FROM " . TABLE_ORDERS_PRODUCTS . " WHERE orders_id='" . $pdf_invoice['orders_id'] . "'");

            $order_data = array();

// Ausgabe der Produkte
            while ($order_data_values = xtc_db_fetch_array($order_query)) {
                $attributes_query = xtc_db_query("SELECT
												products_options,
												products_options_values,
												price_prefix,
												options_values_price
											FROM
												" . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . "
											WHERE
												orders_products_id='" . $order_data_values['orders_products_id'] . "'
											ORDER BY orders_products_attributes_id ASC
												");

                $attributes_data = '';
                $attributes_model = '';

                while ($attributes_data_values = xtc_db_fetch_array($attributes_query)) {
                    $attributes_data .= $attributes_data_values['products_options'] . ': ' . $attributes_data_values['products_options_values'] . "\n";
                    $attributes_model .= xtc_get_attributes_model($order_data_values['products_id'], $attributes_data_values['products_options_values'], $attributes_data_values['products_options']) . "\n";
                }

                $orderinfosingleprice = str_replace('€', 'EUR', xtc_format_price_order($order_data_values['products_price'], 1, $order->info['currency']));
                $orderinfosingleprice = str_replace('&euro;', 'EUR', $orderinfosingleprice);
                $orderinfosumleprice = str_replace('€', 'EUR', xtc_format_price_order($order_data_values['final_price'], 1, $order->info['currency']));
                $orderinfosumleprice = str_replace('&euro;', 'EUR', $orderinfosumleprice);

                $orderinfocurreny = str_replace('&euro;', 'EUR', $orderinfocurreny);

                $pdf->ListeProduktHinzu($order_data_values['products_quantity'], utf8_decode(strip_tags($order_data_values['products_name'])), utf8_decode(trim($attributes_data)), $order_data_values['products_model'], trim($attributes_model, $type), $orderinfosingleprice, $orderinfosumleprice, $type);
            }


            $oder_total_query = xtc_db_query("SELECT
									  title,
									  text,
									  class,
									  value,
									  sort_order
								FROM
									" . TABLE_ORDERS_TOTAL . "
								WHERE
									orders_id='" . $pdf_invoice['orders_id'] . "'
								ORDER BY
									sort_order ASC");

            $order_data = array();

            while ($oder_total_values = xtc_db_fetch_array($oder_total_query)) {
                $ordervaluetext = str_replace('€', 'EUR', $oder_total_values['text']);
                $ordervaluetext = str_replace('&euro;', 'EUR', $ordervaluetext);
                $order_data[] = array('title' => utf8_decode(html_entity_decode($oder_total_values['title'])), 'class' => $oder_total_values['class'], 'value' => $oder_total_values['value'], 'text' => $ordervaluetext);
            }

            $pdf->Betrag($order_data, PDF_LIEFERSCHEIN);

            /** BEGIN BILLPAY CHANGED * */
            if ($order->info['payment_method'] == 'billpay' || $order->info['payment_method'] == 'billpaydebit' || $order->info['payment_method'] == 'billpaytransactioncredit') {
                require_once(DIR_FS_CATALOG . DIR_WS_INCLUDES . '/billpay/utils/billpay_display_pdf_data.php');
            }
            /** EOF BILLPAY CHANGED * */
            $pdf->RechnungEnde($order->customer['vat_id'], $order->info['shipping_method'], PDF_LIEFERSCHEIN);

            $lieferadresse = xtc_address_format($order->customer['format_id'], $order->delivery, 1, '', ', ');
            if ($order->info['payment_method'] == 'invoice' || $order->info['payment_method'] == 'moneyorder') {
                $invoiceinfo = TEXT_PDF_INVOICE_TEXT;
                $pdf->Invoice($invoiceinfo);
            }

            $pdf->LieferAdresse(utf8_decode($lieferadresse));

//Output PDF
            $name = str_replace('#bn#', $pdf_invoice['orders_id'], $pdf_save_query['pdf_value']);
            $name = str_replace('#rn#', $pdf_invoice_nr, $name);
            $name = str_replace('#vn#', $order->customer['firstname'], $name);
            $name = str_replace('#nn#', $order->customer['lastname'], $name);
            $name = str_replace('#d#', date("d-m-Y"), $name);
            $pfad = 'admin/pdf_rechnungen/' . $name;
            $pdf_name = $pfad . '.pdf';
            $pdf->Output($pdf_name, 'F');
//File in DB
            $pfad = 'pdf_rechnungen/' . $name;
            $pdf_name = $pfad . '.pdf';
            xtc_db_query("INSERT INTO " . TABLE_ORDERS_PDF . " (order_id, bill_name, pdf_bill_nr, pdf_generate_date) VALUES ('" . $pdf_invoice['orders_id'] . "', '" . $pdf_name . "', '" . $pdf_invoice_nr . "', NOW());");

            if (MODULE_CUSTOMERS_PDF_INVOICE_MAIL_STATUS == 'true') {
//Rechnung per Mail
                $smarty->assign('language', $order->info['language']);

                $smarty->caching = false;

                $check_status_query = xtc_db_query("SELECT
		    										o.customers_name, o.customers_email_address, o.orders_status, o.date_purchased, op.bill_name
		    									FROM
		    										orders AS o, 
													orders_pdf AS op
		    									WHERE
		    										o.orders_id = '" . $pdf_invoice['orders_id'] . "'
		    									AND
		    										op.order_id = '" . $pdf_invoice['orders_id'] . "'");
                $check_status = xtc_db_fetch_array($check_status_query);


                $smarty->assign('NAME', $check_status['customers_name']);
                $smarty->assign('ORDER_NR', cseo_get_pdf_nr($pdf_invoice['orders_id'], true));
                $smarty->assign('ORDER_LINK', xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $pdf_invoice['orders_id'], 'SSL'));
                $smarty->assign('ORDER_DATE', xtc_date_long($check_status['date_purchased']));
                $smarty->assign('NOTIFY_COMMENTS', $notify_comments);

                $smarty->assign('tpl_path', 'templates/' . $logo_query['configuration_value'] . '/');
                $smarty->assign('logo_path', HTTP_SERVER . DIR_WS_CATALOG . 'templates/' . $logo_query['configuration_value'] . '/img/');


                require_once(DIR_FS_INC . 'cseo_get_mail_body.inc.php');
                $html_mail = $smarty->fetch('html:pdf_mail');
                $html_mail .= $signatur_html;
                $txt_mail = $smarty->fetch('txt:pdf_mail');
                $txt_mail .= $signatur_text;
                require_once(DIR_FS_INC . 'cseo_get_mail_data.inc.php');
                $mail_data = cseo_get_mail_data('pdf_mail');

                $email_pdf_bill_subject = str_replace('{$date}', xtc_date_long($check_status['date_purchased']), $mail_data['EMAIL_SUBJECT']);
                $email_pdf_bill_subject = str_replace('{$renr}', $pdf_invoice['orders_id'], $email_pdf_bill_subject);
                $email_pdf_bill_name = str_replace('{$store_name}', STORE_NAME, $mail_data['EMAIL_ADDRESS_NAME']);

                $pdf_pfad = cseo_get_pdf($pdf_invoice['orders_id'], false, false, false, true);
                $pdf_pfad = 'admin/' . $pdf_pfad;
                $pdf_name = cseo_get_pdf($pdf_invoice['orders_id'], false, false, true);

                xtc_php_mail($mail_data['EMAIL_ADDRESS'], //  $from_email_address,
                        $email_pdf_bill_name, //  $from_email_name,
                        $check_status['customers_email_address'], //  $to_email_address,
                        $check_status['customers_name'], //  $to_name,
                        '', //  $forwarding_to,
                        $mail_data['EMAIL_REPLAY_ADDRESS'], $mail_data['EMAIL_REPLAY_ADDRESS_NAME'], //  $reply_address_name,
                        $pdf_pfad, //  $path_to_attachement,
                        $pdf_name, //  $name_of_attachment,
                        $email_pdf_bill_subject, //  $email_subject,
                        $html_mail, //  $message_body_html,
                        $txt_mail); //  $message_body_plain

                xtc_db_query("UPDATE orders_pdf SET notified_date = NOW(), customer_notified = '1' WHERE order_id = '" . $pdf_invoice['orders_id'] . "'");
            }
        }
    }
}
