<?php
/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */
require('includes/init.inc.php');
@ini_set('max_execution_time', '3600'); # 1h max runtine
@ini_set('memory_limit', '256M');       # 256 MB max ram
$target_db_host = DB_SERVER;
$target_db_user = DB_SERVER_USERNAME;
$target_db_password = DB_SERVER_PASSWORD;
$target_db_database = DB_DATABASE;
$_POST = $_SESSION['POST_ARRAY'];
$source_db = new DatabaseConnection($_SESSION['source_db_host'], $_SESSION['source_db_user'], $_SESSION['source_db_password'], $_SESSION['source_db_database']);
$target_db = new DatabaseConnection($target_db_host, $target_db_user, $target_db_password, $target_db_database);
$coo_sql_update = new SQLUpdateBuilder();
$coo_sql_export = new SQLExport();
?>
<!DOCTYPE html>
<html lang="de" class="no-js" dir="ltr">
    <head>
        <title>commerce:seo Import-Assistent v3</title>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link type="text/css" rel="stylesheet" href="../templates/base/css/bootstrap4.css" />
        <link type="text/css" rel="stylesheet" href="stylesheet.css" />
        <script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
    </head>
    <body>
		<div>
			<script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
			<script>
				var wait_timeout;
				var scroll_interval;
				scroll_interval = setInterval(update_view, 100);
				$(document).mouseenter(function () {
					clearInterval(scroll_interval);
					if (wait_timeout) {
						clearTimeout(wait_timeout);
					}
				});
				$(document).mouseleave(function () {
					clearInterval(scroll_interval);
					wait_timeout = setTimeout(function () {
						scroll_interval = setInterval(update_view, 100);
					}, 1000);
				});
				function update_view() {
					$(document).scrollTop($(document).height());
				}
			</script>

			<?php
			echo '<div id="messages">';
			echo 'Starte Import...<br>';
			$coo_sql_export->start_import($target_db, (isset($_GET['query_start']) ? (int) $_GET['query_start'] : 0));
			?>
			<p><b>&Uuml;bertragung abgeschlossen.</b></p>
			<p>Bereit: <a class="btn btn-success btn-sm" href="<?php echo HTTP_SERVER . DIR_WS_CATALOG ?>" target="_blank">Shop aufrufen</a></p>
		</div>
		</div>
    </body>
</html>
