<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

class ProductsOptionsStructGenerator {

    var $centralDB = false;
    var $source_products_options_id = 0;
    var $source_language_id = 0;
    var $include_products_options_values = true;
    var $esHelper = false;

    function __construct($centralDB) {
        $this->centralDB = $centralDB;
        $this->esHelper = new EntityStructHelper($this->centralDB);
    }

    function get_full_struct($source_products_options_id, $source_language_id = 0) {
        $this->source_products_options_id = $source_products_options_id;
        $this->source_language_id = $source_language_id;
        $sec_key_name = '';
        $sec_key_value = '';
        if ($this->source_language_id > 0) {
            $sec_key_name = 'language_id';
            $sec_key_value = $this->source_language_id;
        }
        $struct_products_option = $this->esHelper->create_entity_struct('products_options', 'products_options_id', $this->source_products_options_id, $sec_key_name, $sec_key_value);
        if ($this->include_products_options_values) {
            $pov2po_pack = $this->get_pack_pov2po($this->source_products_options_id);
            $struct_products_option->add_struct_pack($pov2po_pack);

            $pov_pack = $this->get_pack_pov($this->source_products_options_id);
            $struct_products_option->add_struct_pack($pov_pack);
        }
        return $struct_products_option;
    }

    function get_pack_pov2po($products_options_id) {
        $output_pack = array();
        $sql = '
			SELECT 
				products_options_values_to_products_options_id
			FROM 	products_options_values_to_products_options
			WHERE products_options_id = "' . $products_options_id . '"
		';
        $result = $this->centralDB->query($sql);
        while (($row = mysqli_fetch_array($result))) {
            $output_pack[] = $this->esHelper->create_entity_struct('products_options_values_to_products_options', 'products_options_values_to_products_options_id', $row['products_options_values_to_products_options_id']);
        }
        return $output_pack;
    }

    function get_pack_pov($products_options_id) {
        $output_pack = array();
        $sec_key_name = '';
        $sec_key_value = '';
        $sql = '
			SELECT pov.products_options_values_id AS products_options_values_id
			FROM products_options_values_to_products_options AS pov2po
			LEFT JOIN products_options_values AS pov USING (products_options_values_id)
			WHERE pov2po.products_options_id = "' . $products_options_id . '"
		';
        if ($this->source_language_id > 0) {
            $sql .= ' AND language_id = "' . $this->source_language_id . '" ';
            $sec_key_name = 'language_id';
            $sec_key_value = $this->source_language_id;
        }

        $result = $this->centralDB->query($sql);
        while (($row = mysqli_fetch_array($result))) {
            $output_pack[] = $this->esHelper->create_entity_struct('products_options_values', 'products_options_values_id', $row['products_options_values_id'], $sec_key_name, $sec_key_value);
        }
        return $output_pack;
    }
}
