<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

class JobAgent {

    var $syncDB = false;
    var $centralDB = false;
    var $shopConnectionMgr = false;

    function __construct($syncDB) {
        $this->shopConnectionMgr = new ShopConnectionManager($syncDB);
        $this->syncDB = $syncDB;
        $this->centralDB = $this->shopConnectionMgr->get_shop_connection('central');
    }

    function run_export($source_type = false) {
        $feature_sGenerator = new FeatureStructGenerator($this->centralDB);
        $pOption_sGenerator = new ProductsOptionsStructGenerator($this->centralDB);
        $product_sGenerator = new ProductsStructGenerator($this->centralDB);
        $product_sHandler = new ProductsStructHandler();
        $result = $this->syncDB->query('
			SELECT *
			FROM export_jobs
			WHERE
				date_executed = 0
		');
        while (($row = mysqli_fetch_array($result))) {
            $shopDB = $this->shopConnectionMgr->get_shop_connection($row['target_shop']);
            switch ($row['source_type']) {
                case 'products':
                    $full_struct = $product_sGenerator->get_full_struct($row['source_entity_id'], $row['source_language_id']);
                    $product_sHandler->set_shopDB($shopDB);
                    $product_sHandler->transfer_full_struct($full_struct);
                    break;

				case 'products_options':
                    $full_struct = $pOption_sGenerator->get_full_struct($row['source_entity_id'], $row['source_language_id']);
                    $esHelper = new EntityStructHelper($shopDB);
                    $esHelper->write_entity_struct($full_struct);
                    break;
                
				case 'feature':
                    $full_struct = $feature_sGenerator->get_full_struct($row['source_entity_id'], $row['source_language_id']);
                    $esHelper = new EntityStructHelper($shopDB);
                    $esHelper->write_entity_struct($full_struct);
                    break;
            }
        }
    }
}
