<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

class EntityStructHelper {

    var $db = false;

    function __construct($db_link) {
        $this->db = $db_link;
    }

    # PARAMETER CALL BY REFERENCE!!

    function write_entity_struct(&$entity_struct) {
        global $coo_sql_update;

        $table = $entity_struct->entity_name;
        if ($table === false) {
            return true;
		}

        $key_name = $entity_struct->key_name;
        $key_value = $entity_struct->key_value;
        $sec_key_name = $entity_struct->sec_key_name;
        $sec_key_value = $entity_struct->sec_key_value;
		
        $WHERE_part = ' WHERE ' . $key_name . '="' . $key_value . '" ';
        if ($sec_key_name != '') {
            $WHERE_part .= ' AND ' . $sec_key_name . '="' . $sec_key_value . '" ';
        }

        $result = $this->db->query('
			SELECT COUNT(*) AS cnt
			FROM ' . $table . ' ' . $WHERE_part . '
		');
        if ($this->mysqli_result($result, 0, 'cnt') == 0) {
            $this->insert_empty_record($table, $key_name, $key_value, $sec_key_name, $sec_key_value);
        }

        $keys = array($key_name => $key_value);
        if ($sec_key_name != '') {
            $keys = array_merge($keys, array($sec_key_name => $sec_key_value));
        }

        $sql = $coo_sql_update->get_sql($table, $entity_struct->data_content, $keys, $this->db);
        if (empty($sql) == false) {
            $this->db->query($sql);
            $GLOBALS['coo_sql_export']->write($sql);
        }

        for ($i = 0; $i < sizeof($entity_struct->struct_packs); $i++) {
            for ($h = 0; $h < sizeof($entity_struct->struct_packs[$i]); $h++) {
                $this->write_entity_struct($entity_struct->struct_packs[$i][$h]);
            }
        }
        return true;
    }

    function insert_empty_record($table, $key_name, $key_value, $sec_key_name = '', $sec_key_value = '') {
        $SET_part = ' SET ' . $key_name . '="' . $key_value . '"';
        if ($sec_key_name != '') {
            $SET_part .= ', ' . $sec_key_name . '="' . $sec_key_value . '"';
        }
        $sql = 'REPLACE INTO ' . $table . ' ' . $SET_part;
        $this->db->query($sql);
        $GLOBALS['coo_sql_export']->write($sql);
    }

    function create_entity_struct($table, $key_name, $key_value, $sec_key_name = '', $sec_key_value = '') {
        $struct = new EntityStruct($table, $key_name, $key_value, $sec_key_name, $sec_key_value);
        $sql = '
			SELECT *
			FROM ' . $table . '
			WHERE 
				' . $key_name . ' = "' . $key_value . '"
		';
        if ($sec_key_name != '') {
            $sql .= ' AND ' . $sec_key_name . ' = "' . $sec_key_value . '" ';
        }
        $result = $this->db->query($sql);
		
        $data = mysqli_fetch_array($result, MYSQLI_ASSOC);

        if (mysqli_num_rows($result) == 0) {
            $struct->entity_name = false;
        } else {
            $struct->store_array($data);
        }
        return $struct;
    }
	function mysqli_result($res, $row, $field=0) { 
		$res->data_seek($row); 
		$datarow = $res->fetch_array(); 
		return $datarow[$field]; 
	} 
}
