<?php

/* --------------------------------------------------------------
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2011 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

class CustomersStructGenerator {

    var $sourceDB = false;
    var $source_customers_id = 0;
    var $include_customers_info = true;
    var $include_address_book = true;
    var $esHelper = false;

    function __construct($sourceDB) {
        $this->sourceDB = $sourceDB;
        $this->esHelper = new EntityStructHelper($this->sourceDB);
    }

    function get_full_struct($customers_id) {
        $this->customers_id = $customers_id;
        $full_struct = $this->esHelper->create_entity_struct('customers', 'customers_id', $this->customers_id);
        //CUSTOMERS_INFO
        if ($this->include_customers_info) {
            $pack = $this->get_pack_customers_info($this->customers_id);
            $full_struct->add_struct_pack($pack);
        }
        //ADDRESS_BOOK
        if ($this->include_address_book) {
            $pack = $this->get_pack_address_book($this->customers_id);
            $full_struct->add_struct_pack($pack);
        }
        return $full_struct;
    }

    function get_pack_customers_info($customers_id) {
        $output_pack = array();
        $sql = '
			SELECT customers_info_id
			FROM 	customers_info
			WHERE customers_info_id = "' . $customers_id . '"
		';
        $result = $this->sourceDB->query($sql);
        while (($row = mysqli_fetch_array($result))) {
            $output_pack[] = $this->esHelper->create_entity_struct('customers_info', 'customers_info_id', $row['customers_info_id']);
        }
        return $output_pack;
    }

    function get_pack_address_book($customers_id) {
        $output_pack = array();
        $sql = '
			SELECT address_book_id
			FROM 	address_book
			WHERE customers_id = "' . $customers_id . '"
		';
        $result = $this->sourceDB->query($sql);
        while (($row = mysqli_fetch_array($result))) {
            $output_pack[] = $this->esHelper->create_entity_struct('address_book', 'address_book_id', $row['address_book_id']);
        }
        return $output_pack;
    }
}
