<?php
/* -----------------------------------------------------------------
 * 	$Id: blog_item_edit.php 606 2013-09-13 07:09:23Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */
defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

require_once(DIR_FS_INC . 'xtc_js_lang.php');
$languages = xtc_get_languages();

echo xtc_draw_form('item', FILENAME_BLOG, 'action=save_item', 'post') . "\n" . xtc_draw_hidden_field('categories_id', $_GET['cat']);
if ($_GET['action'] == 'new_item') {
    echo xtc_draw_hidden_field('action', 'insert');
} elseif ($_GET['action'] == 'edit_item') {
    echo xtc_draw_hidden_field('action', 'update');
    echo xtc_draw_hidden_field('item', $_GET['item']);
}

$status[] = array('id' => 1, 'text' => TABLE_FOOTER_STATUS_1);
$status[] = array('id' => 2, 'text' => TABLE_FOOTER_STATUS_2);

$categorie = xtc_db_fetch_array(xtc_db_query("SELECT
												titel
											FROM
												" . TABLE_BLOG_CATEGORIES . "
											WHERE
												categories_id = '" . (int) $_GET['cat'] . "'
											AND
												language_id = '" . (int) $_SESSION['languages_id'] . "'"));
?>
<table width="100%" border="0" cellspacing="0" cellpadding="4">
    <tr>
        <td class="uni_content" align="right">
            <?php echo '<input type="submit" class="button" value="' . BUTTON_SAVE . '" />'; ?>
            <a class="button" href="<?php echo xtc_href_link(FILENAME_BLOG, 'action=showitems&cat=' . $_GET['cat']); ?>"><?php echo BUTTON_CANCEL; ?></a>
        </td>
    </tr>
</table>
<div id="tabslang">
    <ul>
        <li><a href="#misc"><span><?php echo TABLE_HEADING_DEFAULT; ?></span></a></li>
        <?php for ($i = 0, $n = sizeof($languages); $i < $n; $i++) { ?>
            <li><a href="#language_<?php echo $languages[$i]['id']; ?>">
                    <span><?php echo xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image'], $languages[$i]['name']); ?> <?php echo $languages[$i]['name'] ?></span>
                </a>
            </li>
        <?php } ?>
    </ul>
    <div id="misc">
        <?php $items = xtc_db_fetch_array(xtc_db_query("SELECT lenght, position, status FROM blog_items WHERE language_id = '" . $_SESSION['languages_id'] . "' AND item_id = '" . $_GET['item'] . "' ")); ?>
        <table width="100%" cellspacing="0" cellpadding="0">
            <tr>
                <td class="main" width="25%"><nobr><?php echo TABLE_HEADING_CATEGORY; ?></nobr></td>
            <td class="main" width="75%"><?php echo $categorie['titel']; ?></td>
            </tr>
            <tr>
                <td class="main" width="25%"><nobr><?php echo TABLE_HEADING_NEWCATEGORIE_POSITION; ?></nobr></td>
            <td class="main" width="75%"><?php echo xtc_draw_input_field('position', $items['position'], 'size="4"'); ?></td>
            </tr>
            <tr>
                <td class="main" width="25%"><nobr><?php echo TABLE_HEADING_NEWITEM_LENGHT; ?></nobr></td>
            <td class="main" width="75%"><?php echo xtc_draw_input_field('lenght', $items['lenght'], 'size="4"'); ?></td>
            </tr>
            <tr>
                <td class="main" width="25%">Status:</td>
                <td class="main" width="75%"><?php echo xtc_draw_pull_down_menu('status', $status, $items['status'], 'style="width:100px;"') ?></td>
            </tr>
        </table>
    </div>
    <?php
    for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
        if ($_GET['action'] == 'edit_item') {
            $items_query = xtc_db_query("SELECT
												*
											FROM
												" . TABLE_BLOG_ITEMS . "
											WHERE
												language_id = '" . (int) $languages[$i]['id'] . "'
											AND
												item_id = '" . (int) $_GET['item'] . "' ");
            $items = xtc_db_fetch_array($items_query);
        }
        ?>
        <div id="language_<?php echo $languages[$i]['id'] ?>">
            <table width="100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td valign="top" colspan="2">
                        <table width="100%" border="0" cellpadding="3" cellspacing="1" align="center">
                            <tr>
                                <td width="20%" class="main"><?php echo TABLE_HEADING_NEWITEM_NAME; ?></td>
                                <td class="main"><?php echo xtc_draw_input_field('name[' . $languages[$i]['id'] . ']', $items['name'], 'style="width:60%"'); ?></td>
                            </tr>
                            <tr>
                                <td width="20%" class="main"><?php echo TABLE_HEADING_NEWITEM_TITLE; ?></td>
                                <td class="main"><?php echo xtc_draw_input_field('title[' . $languages[$i]['id'] . ']', $items['title'], 'style="width:60%"'); ?></td>
                            </tr>
                            <tr>
                                <td class="main"><?php echo TABLE_HEADING_META_TITLE; ?></td>
                                <td class="main"><?php echo xtc_draw_input_field('meta_title[' . $languages[$i]['id'] . ']', $items['meta_title'], 'style="width:60%"'); ?></td>
                            </tr>
                            <tr>
                                <td class="main"><?php echo TABLE_HEADING_META_DESCRIPTION; ?></td>
                                <td class="main"><?php echo xtc_draw_input_field('meta_description[' . $languages[$i]['id'] . ']', $items['meta_description'], 'style="width:60%"'); ?></td>
                            </tr>
                            <tr>
                                <td class="main"><?php echo TABLE_HEADING_META_KEYWORDS; ?></td>
                                <td class="main"><?php echo xtc_draw_input_field('meta_keywords[' . $languages[$i]['id'] . ']', $items['meta_keywords'], 'style="width:60%"'); ?></td>
                            </tr>
                            <tr>
                                <td class="main" colspan="2"><?php echo TABLE_BLOG_SHORT_DESC; ?></td>
                            </tr>
                            <tr>
                                <td class="main" colspan="2">
                                    <?php
                                    echo xtc_draw_textarea_field('shortdesc_' . $languages[$i]['id'], '', '100', '50', $items['shortdesc'], 'class="ckeditor" name="editor1"');
                                    if (file_exists('includes/editor/ckfinder/ckfinder.js') && USE_WYSIWYG == 'true') {
                                        ?>	
                                        <script type="text/javascript">
                                            var newCKEdit = CKEDITOR.replace('<?php echo 'shortdesc_' . $languages[$i]['id'] ?>');
                                            CKFinder.setupCKEditor(newCKEdit, 'includes/editor/ckfinder/');
                                        </script>
                                        <?php
                                    }
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main" colspan="2"><?php echo TABLE_BLOG_LONG_DESC; ?></td>
                            </tr>
                            <tr>
                                <td class="main" colspan="2">
                                    <?php
                                    echo xtc_draw_textarea_field('description_' . $languages[$i]['id'], '', '100', '50', $items['description'], 'class="ckeditor" name="editor1"');
                                    if (file_exists('includes/editor/ckfinder/ckfinder.js') && USE_WYSIWYG == 'true') {
                                        ?>	
                                        <script type="text/javascript">
                                            var newCKEdit = CKEDITOR.replace('<?php echo 'description_' . $languages[$i]['id'] ?>');
                                            CKFinder.setupCKEditor(newCKEdit, 'includes/editor/ckfinder/');
                                        </script>
                                        <?php
                                    }
                                    ?>
<?php
if (USE_WYSIWYG == 'false' && USE_CODEMIRROR == 'true') {
    ?>
    <script src="includes/javascript/code_editor/codemirror.js" type="text/javascript"></script>
    <script src="includes/javascript/code_editor/xml.js" type="text/javascript"></script>
    <script src="includes/javascript/code_editor/javascript.js" type="text/javascript"></script>
    <script src="includes/javascript/code_editor/css.js" type="text/javascript"></script>
    <script src="includes/javascript/code_editor/htmlmixed.js" type="text/javascript"></script>
    <link rel="stylesheet" href="includes/javascript/code_editor/codemirror.css" type="text/css" />
    <style type=text/css>
		.CodeMirror {
		font-family: monospace;
		min-height: 300px;
		border: 1px solid #999;
		max-width: 1900px;
        }
    </style>
	<script>
		var delay;
		var editor = CodeMirror.fromTextArea(document.getElementById('<?php echo 'description_' . $languages[$i]['id'] ?>'), {
			mode: 'text/html',
			tabMode: 'indent',
			lineNumbers: true,
		});
		var delay;
		var editor = CodeMirror.fromTextArea(document.getElementById('<?php echo 'shortdesc_' . $languages[$i]['id'] ?>'), {
			mode: 'text/html',
			tabMode: 'indent',
			lineNumbers: true,
		});

	</script>
    <?php
}
?>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>
    <?php } ?>
</div>
<table width="100%" border="0" cellspacing="0" cellpadding="4">
    <tr>
        <td class="uni_content" align="right">
            <?php echo '<input type="submit" class="button" value="' . BUTTON_SAVE . '" />'; ?>
            <a class="button" href="<?php echo xtc_href_link(FILENAME_BLOG, 'action=showitems&cat=' . $_GET['cat']); ?>"><?php echo BUTTON_CANCEL; ?></a>
        </td>
    </tr>
</table>
<br>
</form>
