<?php
/*******************************************************************************
 *  Copyright 2010 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at: http://aws.amazon.com/apache2.0
 *  This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 *  CONDITIONS OF ANY KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations under the License.
 * *****************************************************************************
 */


/**
 *  @see CheckoutByAmazon_Service_Interface
 */
require_once ('CheckoutByAmazon/Service/Interface.php'); 

/**

 */
class  CheckoutByAmazon_Service_Mock implements CheckoutByAmazon_Service_Interface
{
    // Public API ------------------------------------------------------------//

        
    /**
     * Create Purchase Contract 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_CreatePurchaseContract request or CheckoutByAmazon_Service_Model_CreatePurchaseContract object itself
     * @see CheckoutByAmazon_Service_Model_CreatePurchaseContract
     * @return CheckoutByAmazon_Service_Model_CreatePurchaseContractResponse CheckoutByAmazon_Service_Model_CreatePurchaseContractResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function createPurchaseContract($request) 
    {
        require_once ('CheckoutByAmazon/Service/Model/CreatePurchaseContractResponse.php');
        return CheckoutByAmazon_Service_Model_CreatePurchaseContractResponse::fromXML($this->_invoke('CreatePurchaseContract'));
    }


        
    /**
     * Get Purchase Contract 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_GetPurchaseContract request or CheckoutByAmazon_Service_Model_GetPurchaseContract object itself
     * @see CheckoutByAmazon_Service_Model_GetPurchaseContract
     * @return CheckoutByAmazon_Service_Model_GetPurchaseContractResponse CheckoutByAmazon_Service_Model_GetPurchaseContractResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function getPurchaseContract($request) 
    {
        require_once ('CheckoutByAmazon/Service/Model/GetPurchaseContractResponse.php');
        return CheckoutByAmazon_Service_Model_GetPurchaseContractResponse::fromXML($this->_invoke('GetPurchaseContract'));
    }


        
    /**
     * Set Purchase Items 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_SetPurchaseItems request or CheckoutByAmazon_Service_Model_SetPurchaseItems object itself
     * @see CheckoutByAmazon_Service_Model_SetPurchaseItems
     * @return CheckoutByAmazon_Service_Model_SetPurchaseItemsResponse CheckoutByAmazon_Service_Model_SetPurchaseItemsResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function setPurchaseItems($request) 
    {
        require_once ('CheckoutByAmazon/Service/Model/SetPurchaseItemsResponse.php');
        return CheckoutByAmazon_Service_Model_SetPurchaseItemsResponse::fromXML($this->_invoke('SetPurchaseItems'));
    }


        
    /**
     * Complete Purchase Contract 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_CompletePurchaseContract request or CheckoutByAmazon_Service_Model_CompletePurchaseContract object itself
     * @see CheckoutByAmazon_Service_Model_CompletePurchaseContract
     * @return CheckoutByAmazon_Service_Model_CompletePurchaseContractResponse CheckoutByAmazon_Service_Model_CompletePurchaseContractResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function completePurchaseContract($request) 
    {
        require_once ('CheckoutByAmazon/Service/Model/CompletePurchaseContractResponse.php');
        return CheckoutByAmazon_Service_Model_CompletePurchaseContractResponse::fromXML($this->_invoke('CompletePurchaseContract'));
    }


        
    /**
     * Set Contract Charges 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_SetContractCharges request or CheckoutByAmazon_Service_Model_SetContractCharges object itself
     * @see CheckoutByAmazon_Service_Model_SetContractCharges
     * @return CheckoutByAmazon_Service_Model_SetContractChargesResponse CheckoutByAmazon_Service_Model_SetContractChargesResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function setContractCharges($request) 
    {
        require_once ('CheckoutByAmazon/Service/Model/SetContractChargesResponse.php');
        return CheckoutByAmazon_Service_Model_SetContractChargesResponse::fromXML($this->_invoke('SetContractCharges'));
    }

    // Private API ------------------------------------------------------------//

    private function _invoke($actionName)
    {
        return $xml = file_get_contents('CheckoutByAmazon/Service/Mock/' . $actionName . 'Response.xml', /** search include path */ TRUE);
    }
}