<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */


/**
 * Order Acknowledgement Sample
 */

include_once ('.config.inc.php');

$feeds = new MarketplaceWebService_MWSFeedsClient();
$MWSProperties = new MarketplaceWebService_MWSProperties();

//Construct the OrderAcknowledgement Feed 

//Constructing the <Header>
$envelope = new SimpleXMLElement("<AmazonEnvelope></AmazonEnvelope>");
$envelope->Header->DocumentVersion = $MWSProperties->getDocumentVersion();
$envelope->Header->MerchantIdentifier = $MWSProperties->getMerchantToken();

//Assiging the MessageType
$envelope->MessageType = "OrderFulfillment";


//Fist <Message> block
$envelope->Message[0] ->MessageID = 1;
$envelope->Message[0] ->OrderFulfillment->AmazonOrderID = "105-8151474-6236244";
$envelope->Message[0] ->OrderFulfillment->MerchantFulfillmentID = "111111111";
$envelope->Message[0] ->OrderFulfillment->FulfillmentDate = "2011-08-11T00:00:00.000+05:30";
$envelope->Message[0] ->OrderFulfillment->FulfillmentData->CarrierCode = "FedEx";
$envelope->Message[0] ->OrderFulfillment->FulfillmentData->ShippingMethod = "SameDay";
$envelope->Message[0] ->OrderFulfillment->FulfillmentData->ShipperTrackingNumber = "122-222-22-2-2";


//Pass the constructed SimpleXML object to acknowledgeOrder function of MWSFeedsClient 
//alongwith the location of the directory where the feed has to be stored.Please note that the directory
//should exist with the relevant permissions.
$feedSubmissionId = $feeds->confirmShipment($envelope, "./tmp");

echo "The OrderFulfillment feed has been submitted with FeedSubmissionID: " . $feedSubmissionId . " !" .PHP_EOL;
?>
      
