<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */

/**
 * Get Feed Submission Result  Sample
 */

include_once ('.config.inc.php'); 

$feeds = new MarketplaceWebService_MWSFeedsClient();

echo "==========================================================================================================" . PHP_EOL;
echo "Downloading the processing report for the given FeedSubmissionID's!" . PHP_EOL;
echo "==========================================================================================================" . PHP_EOL;

//List of the ReportRequestId's that have finished processing
$feedSubmissionIdList = array();
array_push($feedSubmissionIdList,"4504604142");
array_push($feedSubmissionIdList,"4504604364");
array_push($feedSubmissionIdList,"4504605280");

//Set the path to the file where the processing status of the feeds is to be stored. Please note that the directory
//should exist with the relevant permissions.
$feedDirPath = "./tmp";

foreach ($feedSubmissionIdList as $feedSubmissionId)
{
	//Download the Processing Report for each feedsubmission id and store it in <FeedSubmissionID>_processing_report file
	//at $feedDirPath location
	$filePath = $feedDirPath . "/" . $feedSubmissionId . "_processing_report";
	$fileHandle = fopen($filePath,"w");
	$feeds->getFeedSubmissionResult($feedSubmissionId, $fileHandle);
	fclose($fileHandle);
}

echo "The Feed processing reports for the given FeedSubmissionID's have been downloaded to the given dir at " . $feedDirPath . " !". PHP_EOL;
?>