<?php
/*******************************************************************************
 *  Copyright 2010 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at: http://aws.amazon.com/apache2.0
 *  This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 *  CONDITIONS OF ANY KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations under the License.
 * *****************************************************************************
 */

/**

 */

interface  CheckoutByAmazon_Service_Interface 
{
    

        
    /**
     * Create Purchase Contract 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_CreatePurchaseContractRequest request
     * or CheckoutByAmazon_Service_Model_CreatePurchaseContractRequest object itself
     * @see CheckoutByAmazon_Service_Model_CreatePurchaseContractRequest
     * @return CheckoutByAmazon_Service_Model_CreatePurchaseContractResponse CheckoutByAmazon_Service_Model_CreatePurchaseContractResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function createPurchaseContract($request);


        
    /**
     * Get Purchase Contract 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_GetPurchaseContractRequest request
     * or CheckoutByAmazon_Service_Model_GetPurchaseContractRequest object itself
     * @see CheckoutByAmazon_Service_Model_GetPurchaseContractRequest
     * @return CheckoutByAmazon_Service_Model_GetPurchaseContractResponse CheckoutByAmazon_Service_Model_GetPurchaseContractResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function getPurchaseContract($request);


        
    /**
     * Set Purchase Items 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_SetPurchaseItemsRequest request
     * or CheckoutByAmazon_Service_Model_SetPurchaseItemsRequest object itself
     * @see CheckoutByAmazon_Service_Model_SetPurchaseItemsRequest
     * @return CheckoutByAmazon_Service_Model_SetPurchaseItemsResponse CheckoutByAmazon_Service_Model_SetPurchaseItemsResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function setPurchaseItems($request);


        
    /**
     * Complete Purchase Contract 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_CompletePurchaseContractRequest request
     * or CheckoutByAmazon_Service_Model_CompletePurchaseContractRequest object itself
     * @see CheckoutByAmazon_Service_Model_CompletePurchaseContractRequest
     * @return CheckoutByAmazon_Service_Model_CompletePurchaseContractResponse CheckoutByAmazon_Service_Model_CompletePurchaseContractResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function completePurchaseContract($request);


        
    /**
     * Set Contract Charges 
     * @param mixed $request array of parameters for CheckoutByAmazon_Service_Model_SetContractChargesRequest request
     * or CheckoutByAmazon_Service_Model_SetContractChargesRequest object itself
     * @see CheckoutByAmazon_Service_Model_SetContractChargesRequest
     * @return CheckoutByAmazon_Service_Model_SetContractChargesResponse CheckoutByAmazon_Service_Model_SetContractChargesResponse
     *
     * @throws CheckoutByAmazon_Service_Exception
     */
    public function setContractCharges($request);

}