<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */

/**
 * Get Report Request List Sample
 */

include_once ('.config.inc.php'); 

$reports = new MarketplaceWebService_MWSReportsClient();

$startDate = new DateTime("2011-08-01");
$endDate = new DateTime("2011-09-21");

$nextToken = "";

echo "==========================================================================================================" . PHP_EOL;
echo "Getting the list of reports that have finished processing!". PHP_EOL;
echo "==========================================================================================================". PHP_EOL;

//Checking for reports that have processing status as "_DONE_"
$reportProcessingStatusList = array('Status' => array());
array_push($reportProcessingStatusList['Status'],"_DONE_");

//Checking for reports of the type "_GET_ORDERS_DATA_"
$reportTypeList = array('Type' => array());
array_push($reportTypeList['Type'],MarketplaceWebService_Model_ReportType::_GET_ORDERS_DATA_);
array_push($reportTypeList['Type'],MarketplaceWebService_Model_ReportType::_GET_FLAT_FILE_ACTIONABLE_ORDER_DATA_);

//Making the GetReportRequestList API call
$getReportRequestListResult = $reports->getReportRequestList(null, $reportTypeList, 
		$reportProcessingStatusList, 0, $startDate, $endDate);
		
//Storing the results in to an ArrayList for further processing later
$reportRequestInfoList = array ();
$reportRequestInfoList = array_merge($reportRequestInfoList, $getReportRequestListResult->getReportRequestInfoList());

echo "Current Size: " . count($reportRequestInfoList) . PHP_EOL ;

//Checking if there are any further results, if so they are also downloaded and added to the results array.
if ($getReportRequestListResult->getHasNext())
{
	echo "in if". PHP_EOL;
	$nextToken =  $getReportRequestListResult->getNextToken();
	$getReportRequestListByNextTokenResult = null;
	do
	{
		echo "In do for count " . $count . PHP_EOL;
		echo "NextToken: " . $nextToken . PHP_EOL;
		$getReportRequestListByNextTokenResult = null;
		$getReportRequestListByNextTokenResult = $reports->getReportRequestListByNextToken($nextToken);
		$reportRequestInfoList = array_merge($reportRequestInfoList, $getReportRequestListByNextTokenResult->getReportRequestInfoList());

		$nextToken = $getReportRequestListByNextTokenResult->getNextToken();
		echo "Current Size: " . count($reportRequestInfoList) . PHP_EOL ;
	} while ($getReportRequestListByNextTokenResult->getHasNext());
}

echo "The total no. of results that matched is " . count($reportRequestInfoList) . PHP_EOL;
echo "The ReportRequestId's of the reports matching the criteria  are:" . PHP_EOL ;
foreach  ($reportRequestInfoList as $reportRequestInfo)
{
	echo $reportRequestInfo->getReportRequestId() . PHP_EOL;
}
		
?>
