<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     MarketplaceWebService
 *  @copyright   Copyright 2011 Amazon Technologies, Inc.
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2011-10-31
 */
/******************************************************************************* 
 * 
 */



class MarketplaceWebService_MWSProperties {

	private $accessKeyId = "";
	private $secretAccessKey = "";

	private $appName = "";
	private $appVersion = "";
	private $documentVersion = "";

	private $marketplaceId = "";
	private $merchantId = "";
	private $merchantToken = "";

	private $serviceUrl = "";

	/**
	 * Construct new MWSProperties and load the values from the MWSConfig.ini
	 */
	public function __construct() {
		
		$this -> merchantId = MODULE_PAYMENT_RMAMAZON_MERCHANTID;
		$this -> marketplaceId = MODULE_PAYMENT_RMAMAZON_MARKETPLACEID; 
		$this -> merchantToken = MODULE_PAYMENT_RMAMAZON_MERCHANTTOKEN; 
		$this -> accessKeyId = MODULE_PAYMENT_RMAMAZON_ACCESKEY;
		$this -> secretAccessKey = MODULE_PAYMENT_RMAMAZON_SECRETKEY;
		$this -> appName = base64_decode("QWxraW1fWFRDTW9kaWZpZWQ=");
		$this -> appVersion = "1.0.0";
		$this -> serviceUrl = 'https://mws.amazonservices.de';
		$this -> documentVersion = "1.01";
		
		/*
		$config_array = parse_ini_file("MWSConfig.ini");
		$this -> merchantId = $config_array['merchantId'];
		$this -> marketplaceId = $config_array['marketplaceId'];
		$this -> merchantToken = $config_array['merchantToken'];
		$this -> accessKeyId = $config_array['accessKeyId'];
		$this -> secretAccessKey = $config_array['secretAccessKey'];
		$this -> appName = $config_array['appName'];
		$this -> appVersion = $config_array['appVersion'];
		$this -> serviceUrl = $config_array['serviceUrl'];
		$this-> documentVersion = $config_array['documentVersion'];
		*/
	}

	/**
	 * @return the accessKeyId
	 */
	public function getAccessKeyId() {
		return $this->accessKeyId;
	}

	/**
	 * @param accessKeyId the accessKeyId to set
	 */
	public function setAccessKeyId($accessKeyId) {
		$this->accessKeyId = $accessKeyId;
	}

	/**
	 * @return the secretAccessKey
	 */
	public function getSecretAccessKey() {
		return $this->secretAccessKey;
	}

	/**
	 * @param secretAccessKey the secretAccessKey to set
	 */
	public function setSecretAccessKey($secretAccessKey) {
		$this->secretAccessKey = $secretAccessKey;
	}

	/**
	 * @return the appName
	 */
	public function getAppName() {
		return $this->appName;
	}

	/**
	 * @param appName the appName to set
	 */
	public function setAppName($appName) {
		$this->appName = $appName;
	}

	/**
	 * @return the appVersion
	 */
	public function getAppVersion() {
		return $this->appVersion;
	}

	/**
	 * @param appVersion the appVersion to set
	 */
	public function setAppVersion($appVersion) {
		$this->appVersion = $appVersion;
	}

	/**
	 * @return the marketplaceId
	 */
	public function getMarketplaceId() {
		return $this->marketplaceId;
	}

	/**
	 * @param marketplaceId the marketplaceId to set
	 */
	public function setMarketplaceId($marketplaceId) {
		$this->marketplaceId = $marketplaceId;
	}

	/**
	 * @return the merchantId
	 */
	public function getMerchantId() {
		return $this->merchantId;
	}

	/**
	 * @param merchantId the merchantId to set
	 */
	public function setMerchantId($merchantId) {
		$this->merchantId = $merchantId;
	}

	/**
	 * @return the merchantToken
	 */
	public function getMerchantToken() {
		return $this->merchantToken;
	}

	/**
	 * @param merchantToken the merchantToken to set
	 */
	public function setMerchantToken($merchantToken) {
		$this->merchantToken = $merchantToken;
	}

	/**
	 * @param serviceUrl the serviceUrl to set
	 */
	public function setServiceUrl($serviceUrl) {
		$this->serviceUrl = $serviceUrl;
	}

	/**
	 * @return the serviceUrl
	 */
	public function getServiceUrl() {
		return $this->serviceUrl;
	}
	
	/**
	 * @param documentVersion the documentVersion to set
	 */
	public function setDocumentVersion($documentVersion) {
		$this->documentVersion = $documentVersion;
	}

	/**
	 * @return the documentVersion
	 */
	public function getDocumentVersion() {
		return $this->documentVersion;
	}

}

?>