<?php

/* -----------------------------------------------------------------
 * 	$Id: preisroboter.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Preisroboter {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Preisroboter() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Preisroboter.de';
        $this->v_module_homepage = 'www.preisroboter.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'preisroboter.txt';
        $this->v_filename = 'preisroboter.php';
        $this->v_keyname = 'PREISROBOTER';
        $this->v_linkname = 'preisroboter';
        $this->v_delimiter = '|';
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, '.', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, '.', '');
        $p_products_array['products_description'] = trim(no_html($p_products_array['products_description']));
        $p_products_array['products_short_description'] = trim(no_html($p_products_array['products_short_description']));
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'Artikel-Nr.';
        $t_csv_fields_array['products_name'] = 'Artikelname';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_link'] = 'Deeplink';
        $t_csv_fields_array['products_image_1'] = 'Bild-URL';
        $t_csv_fields_array['products_short_description'] = 'Kurzbeschr.';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandk';
        $t_csv_fields_array['products_shippingtime'] = 'Lieferzt';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['products_PZN'] = 'PZN';
        $t_csv_fields_array['manufacturers_name'] = 'Hersteller';
        $t_csv_fields_array['products_model'] = 'Hersteller-ArtNr';
        return($t_csv_fields_array);
    }

}

?>