<?php

/* -----------------------------------------------------------------
 * 	$Id: wein.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Wein {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;
    var $v_category_file_path;
    var $v_shipping_availability_array = array();
    var $v_availability_array = array();

    function Wein() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Wein.cc';
        $this->v_module_homepage = 'www.wein.cc';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'wein.csv';
        $this->v_filename = 'wein.php';
        $this->v_keyname = 'WEIN';
        $this->v_linkname = 'wein';
        $this->v_delimiter = ";";
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = false;
        $this->v_field_shipping_costs_free = false;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        return '';
    }

    function formatResults($p_products_array) {
        $p_products_array['products_name'] = trim(str_replace(";", ',', no_html($p_products_array['products_name'])));
        $p_products_array['products_description'] = trim(str_replace(";", ',', no_html($p_products_array['products_description'])));
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, '.', '');

        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_model'] = 'Artikelnummer';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_name'] = 'Produktname';
        $t_csv_fields_array['products_categories_last'] = 'Kategorie';
        $t_csv_fields_array['products_tax'] = 'USt';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['products_link'] = 'ProduktURL';
        $t_csv_fields_array['products_image_1_small'] = 'BildURL';
        $t_csv_fields_array['products_description'] = 'Beschreibung';

        return($t_csv_fields_array);
    }

}

?>