<?php

/* -----------------------------------------------------------------
 * 	$Id: shopzilla.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Shopzilla {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Shopzilla() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'shopzilla.de';
        $this->v_module_homepage = 'www.shopzilla.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'shopzilla.csv';
        $this->v_filename = 'shopzilla.php';
        $this->v_keyname = 'SHOPZILLA';
        $this->v_linkname = 'shopzilla';
        $this->v_delimiter = ';';
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['retail_price'] = number_format((double) $p_products_array['retail_price'], 2, ',', '');
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        if ($p_products_array['retail_price'] != '0,00') {
            $p_products_array['special_price'] = $p_products_array['products_price'];
            $p_products_array['products_price'] = $p_products_array['retail_price'];
        }
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_description'] = no_html($p_products_array['products_description']);
        $p_products_array['products_page_id'] = $p_products_array['products_id'];
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_name'] = 'Titel';
        $t_csv_fields_array['products_description'] = 'Beschreibung';
        $t_csv_fields_array['products_categories'] = 'Kategorie in Pfadnavigation';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_link'] = 'Produkt URL';
        $t_csv_fields_array['products_image_1'] = 'Bild URL';
        $t_csv_fields_array['products_page_id'] = 'Page_ID';
        $t_csv_fields_array['products_stock'] = 'Lagerbestand';
        $t_csv_fields_array['products_id'] = 'SKU / MPID';
        $t_csv_fields_array['manufacturers_name'] = 'Hersteller / Marke';
        $t_csv_fields_array['products_ean'] = 'EAN/UPC';
        $t_csv_fields_array['products_isbn'] = 'ISBN';
        $t_csv_fields_array['products_condition'] = 'Zustand';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandkosten';
        $t_csv_fields_array['products_name'] = 'name';
        $t_csv_fields_array['products_bid'] = 'Bid';
        $t_csv_fields_array['products_advertising'] = 'Werbeaktion';
        $t_csv_fields_array['products_page_id_variant'] = 'page_id_variant';
        $t_csv_fields_array['retail_price'] = 'Empfohlener Verkaufspreis';
        return($t_csv_fields_array);
    }

}

?>