<?php

/* -----------------------------------------------------------------
 * 	$Id: shopping4sport.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Shopping4sport {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Shopping4sport() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Shopping4sport.de';
        $this->v_module_homepage = 'www.shopping4sport.de';
        $this->v_module_format = 'txt';
        $this->v_module_export_filename = 'shopping4sport.txt';
        $this->v_filename = 'shopping4sport.php';
        $this->v_keyname = 'SHOPPING4SPORT';
        $this->v_linkname = 'shopping4sport';
        $this->v_delimiter = '|';
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_description'] = strip_tags(no_html($p_products_array['products_description']));
        $p_products_array['products_description'] = str_replace("<br>", " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("<br />", " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = html_entity_decode($p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace(";", ", ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("'", ", ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("\n", " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("\r", " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("\t", " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("\v", " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("&quot,", " \"", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("&qout,", " \"", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("|", ",", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace(chr(13), " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = str_replace("  ", " ", $p_products_array['products_description']);
        $p_products_array['products_description'] = trim($p_products_array['products_description']);
        $p_products_array['products_description'] = substr($p_products_array['products_description'], 0, 200);
        $p_products_array['retail_price'] = number_format($p_products_array['retail_price'], 2, '.', '');
        $p_products_array['products_price'] = number_format($p_products_array['products_price'], 2, '.', '');
        if ($p_products_array['retail_price'] == '0.00') {
            $p_products_array['retail_price'] = $p_products_array['products_price'];
        }
        $p_products_array['products_shipping_costs'] = number_format($p_products_array['products_shipping_costs'], 2, '.', '');

        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'art_id';
        $t_csv_fields_array['products_name'] = 'label';
        $t_csv_fields_array['products_model'] = 'model';
        $t_csv_fields_array['products_description'] = 'desc';
        $t_csv_fields_array['products_image_1'] = 'image';
        $t_csv_fields_array['products_link'] = 'link';
        $t_csv_fields_array['retail_price'] = 'uvp';
        $t_csv_fields_array['products_price'] = 'price';
        $t_csv_fields_array['manufacturers_name'] = 'manufacturer';
        $t_csv_fields_array['products_shipping_costs'] = 'shipcharge';
        $t_csv_fields_array['products_shippingtime'] = 'delivertime';
        $t_csv_fields_array['products_categories'] = 'category';
        $t_csv_fields_array['products_ean'] = 'ean';
        return($t_csv_fields_array);
    }

}

?>